/*
 * Decompiled with CFR 0.152.
 */
package DaoOfModding.mlmanimator.Client.Poses;

import DaoOfModding.mlmanimator.Client.Poses.PlayerPose;
import java.util.ArrayList;
import java.util.Set;
import java.util.TreeSet;
import net.minecraft.world.phys.Vec3;

public class ArmPose
extends PlayerPose {
    public static String upperArm = "PoseUpperArm";
    public static String lowerArm = "PoseLowerArm";
    String upperArmLimb = "Right_Arm";
    String lowerArmLimb = "Lower_Right_Arm";
    Boolean mirror = false;
    Boolean holding = false;

    public void setUpperArm(String newUpper) {
        this.upperArmLimb = newUpper;
    }

    public void setLowerArm(String newLower) {
        this.lowerArmLimb = newLower;
    }

    public void setMirrored(boolean on) {
        this.mirror = on;
    }

    public void setHolding(boolean on) {
        this.holding = on;
    }

    protected String limbConvert(String limb) {
        if (limb.compareTo(this.upperArmLimb) == 0) {
            if (this.upperArmLimb.compareTo(this.lowerArmLimb) == 0 && !this.angles.containsKey(upperArm)) {
                return lowerArm;
            }
            return upperArm;
        }
        if (limb.compareTo(this.lowerArmLimb) == 0) {
            return lowerArm;
        }
        return limb;
    }

    @Override
    public float getAnimationSpeed(String limb, int frame) {
        return super.getAnimationSpeed(this.limbConvert(limb), frame);
    }

    @Override
    public boolean hasAngle(String limb) {
        return super.hasAngle(this.limbConvert(limb));
    }

    @Override
    public Vec3 getAngle(String limb, int frame) {
        Vec3 angle = super.getAngle(this.limbConvert(limb), frame);
        if (this.mirror.booleanValue()) {
            angle = angle.m_82542_(1.0, -1.0, -1.0);
        }
        return angle;
    }

    @Override
    public Vec3 getAngle(String limb) {
        return this.getAngle(this.limbConvert(limb), 0);
    }

    @Override
    public int getFrames(String limb) {
        return super.getFrames(this.limbConvert(limb));
    }

    @Override
    public int getPriority(String limb) {
        return super.getPriority(this.limbConvert(limb));
    }

    @Override
    public Set<String> getLimbs() {
        TreeSet<String> limbs = new TreeSet<String>();
        for (String limb : super.getLimbs()) {
            if (limb.compareTo(upperArm) == 0) {
                limbs.add(this.upperArmLimb);
                continue;
            }
            if (limb.compareTo(lowerArm) == 0) {
                limbs.add(this.lowerArmLimb);
                continue;
            }
            limbs.add(limb);
        }
        return limbs;
    }

    @Override
    public ArrayList<Vec3> getAngles(String limb) {
        if (!this.mirror.booleanValue()) {
            return super.getAngles(this.limbConvert(limb));
        }
        ArrayList mirroredAngles = (ArrayList)super.getAngles(this.limbConvert(limb)).clone();
        for (int i = 0; i < mirroredAngles.size(); ++i) {
            mirroredAngles.set(i, ((Vec3)mirroredAngles.get(i)).m_82542_(1.0, -1.0, -1.0));
        }
        return mirroredAngles;
    }

    @Override
    public ArrayList<Float> getSpeeds(String limb) {
        return super.getSpeeds(this.limbConvert(limb));
    }

    @Override
    public ArmPose clone() {
        ArmPose copyPose = new ArmPose();
        for (String limb : this.angles.keySet()) {
            copyPose.setAngles(limb, (ArrayList)((ArrayList)this.angles.get(limb)).clone(), (ArrayList)((ArrayList)this.speed.get(limb)).clone(), (Integer)this.priorities.get(limb), (Vec3)this.offset.get(limb), (Integer)this.aLock.get(limb));
        }
        for (String limb : this.sizes.keySet()) {
            copyPose.addSize(limb, (Vec3)this.sizes.get(limb), (Integer)this.sizePriorities.get(limb), ((Float)this.sizeSpeed.get(limb)).floatValue());
        }
        copyPose.disableHeadLook(this.disableHeadLook, this.disableHeadLookPriority);
        copyPose.setLowerArm(lowerArm);
        copyPose.setUpperArm(upperArm);
        copyPose.setMirrored(this.mirror);
        copyPose.setHolding(this.holding);
        return copyPose;
    }
}

