/*
 * Decompiled with CFR 0.152.
 */
package DaoOfModding.mlmanimator.Client.Poses;

import DaoOfModding.mlmanimator.Client.AnimationFramework.AnimationBuilder;
import DaoOfModding.mlmanimator.Client.Poses.ArmPose;
import DaoOfModding.mlmanimator.Client.Poses.PlayerPose;
import DaoOfModding.mlmanimator.Common.PlayerUtils;
import java.util.ArrayList;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;

public class GenericPoses {
    public static final int walkLegPriority = 100;
    public static final int walkArmPriority = 50;
    public static final int crouchPriority = 150;
    public static final int jumpLegPriority = 200;
    public static final int jumpArmPriority = 150;
    public static final int flyFallingPriority = 1000;
    public static final int armHoldPriority = 500;
    public static final int armAttackPriority = 1000;
    public static final int armBlockPriority = 500;
    public static final int swimBodyPriority = 1000;
    public static final int swimLegPriority = 200;
    public static final int sleepBodyPriority = 99;
    public static final int sitPriority = 250;
    public static final int crawlPriority = 300;
    public static final int spinPriority = 999;
    public static PlayerPose Idle = new PlayerPose();
    public static PlayerPose Walking = new PlayerPose();
    public static PlayerPose Jumping = new PlayerPose();
    public static PlayerPose Crouching = new PlayerPose();
    public static PlayerPose CrouchingWalk = new PlayerPose();
    public static PlayerPose Swimming = new PlayerPose();
    public static PlayerPose SwimmingMoving = new PlayerPose();
    public static PlayerPose FlyFalling = new PlayerPose();
    public static PlayerPose Sleeping = new PlayerPose();
    public static PlayerPose Sitting = new PlayerPose();
    public static PlayerPose Crawling = new PlayerPose();
    public static PlayerPose CrawlingWalk = new PlayerPose();
    public static PlayerPose SpinAttack = new PlayerPose();
    public static ArmPose Holding = new ArmPose();
    public static ArmPose slashing = new ArmPose();
    public static ArmPose block = new ArmPose();
    public static ArmPose bow = new ArmPose();
    public static ArmPose bowOff = new ArmPose();
    public static ArmPose spear = new ArmPose();
    public static ArmPose crossbow = new ArmPose();
    public static ArmPose crossbowOff = new ArmPose();
    public static ArmPose spyglass = new ArmPose();
    public static ArmPose horn = new ArmPose();
    public static ArmPose eat = new ArmPose();
    public static ArmPose drink = new ArmPose();
    protected static ArrayList<String> legs = new ArrayList();

    public static void init() {
        GenericPoses.setupIdle();
        GenericPoses.setupHolding();
        GenericPoses.setupWalking();
        GenericPoses.setupJumping();
        GenericPoses.setupFlyFalling();
        GenericPoses.setupCrouching();
        GenericPoses.setupCrouchingWalk();
        GenericPoses.setupSwimming();
        GenericPoses.setupSitting();
        GenericPoses.setupSleeping();
        GenericPoses.setupCrawling();
        GenericPoses.setupSpin();
        GenericPoses.setupAction();
        GenericPoses.addLeg("Left_Leg");
        GenericPoses.addLeg("Lower_Left_Leg");
        GenericPoses.addLeg("Right_Leg");
        GenericPoses.addLeg("Lower_Right_Leg");
    }

    public static void addLeg(String legname) {
        legs.add(legname);
    }

    public static ArrayList<String> getLegs() {
        return legs;
    }

    public static PlayerPose getWalkingPose(Player player) {
        PlayerPose speedAdjustedWalkPose = Walking.clone();
        double speed = PlayerUtils.getDelta(player).m_82542_(1.0, 0.0, 1.0).m_82553_();
        if ((speed /= 0.25) > 1.0) {
            speed = 1.0;
        } else if (speed <= 0.05) {
            return Idle;
        }
        speedAdjustedWalkPose.adjustAllSpeeds((float)speed);
        return speedAdjustedWalkPose;
    }

    public static void setupSwimming() {
        Swimming.addAngle("Body", new Vec3(Math.toRadians(90.0), 0.0, 0.0), 1000);
        SwimmingMoving.addAngle("Left_Leg", new Vec3(Math.toRadians(-30.0), 0.0, 0.0), 200, Float.valueOf(15.0f), 1);
        SwimmingMoving.addAngle("Left_Leg", new Vec3(Math.toRadians(30.0), 0.0, 0.0), 200, Float.valueOf(15.0f), 1);
        SwimmingMoving.addAngle("Right_Leg", new Vec3(Math.toRadians(30.0), 0.0, 0.0), 200, Float.valueOf(15.0f), 1);
        SwimmingMoving.addAngle("Right_Leg", new Vec3(Math.toRadians(-30.0), 0.0, 0.0), 200, Float.valueOf(15.0f), 1);
    }

    public static void setupSleeping() {
        Sleeping.addAngle("Body", new Vec3(0.0, 0.0, 0.0), 99);
    }

    public static void setupSitting() {
        Sitting.addAngle("Left_Leg", new Vec3(Math.toRadians(-90.0), Math.toRadians(-20.0), 0.0), 250);
        Sitting.addAngle("Right_Leg", new Vec3(Math.toRadians(-90.0), Math.toRadians(20.0), 0.0), 250);
    }

    public static void setupFlyFalling() {
        FlyFalling.addAngle("Left_Wing_Elytra", new Vec3(0.0, 0.0, Math.toRadians(-70.0)), 1000);
        FlyFalling.addAngle("Right_Wing_Elytra", new Vec3(0.0, 0.0, Math.toRadians(70.0)), 1000);
    }

    public static void setupCrouching() {
        Crouching.addAngle("Left_Leg", new Vec3(Math.toRadians(-70.0), 0.0, 0.0), 150);
        Crouching.addAngle("Right_Leg", new Vec3(Math.toRadians(-70.0), 0.0, 0.0), 150);
        Crouching.addAngle("Lower_Left_Leg", new Vec3(Math.toRadians(70.0), 0.0, 0.0), 150);
        Crouching.addAngle("Lower_Right_Leg", new Vec3(Math.toRadians(70.0), 0.0, 0.0), 150);
        Crouching.addAngle("Left_Wing_Elytra", new Vec3(0.0, 0.0, Math.toRadians(-40.0)), 150);
        Crouching.addAngle("Right_Wing_Elytra", new Vec3(0.0, 0.0, Math.toRadians(40.0)), 150);
    }

    public static void setupCrawling() {
        Crawling.addAngle("Body", new Vec3(Math.toRadians(90.0), 0.0, 0.0), 300);
        CrawlingWalk.addAngle("Body", new Vec3(Math.toRadians(90.0), 0.0, 0.0), 300);
    }

    public static void setupIdle() {
        Idle.addAngle("Body", new Vec3(0.0, 0.0, 0.0), 0);
        Idle.addAngle("Left_Arm", new Vec3(0.0, 0.0, 0.0), 0);
        Idle.addAngle("Right_Arm", new Vec3(0.0, 0.0, 0.0), 0);
        Idle.addAngle("Lower_Left_Arm", new Vec3(0.0, 0.0, 0.0), 0);
        Idle.addAngle("Lower_Right_Arm", new Vec3(0.0, 0.0, 0.0), 0);
        Idle.addAngle("Left_Leg", new Vec3(0.0, 0.0, 0.0), 0);
        Idle.addAngle("Right_Leg", new Vec3(0.0, 0.0, 0.0), 0);
        Idle.addAngle("Lower_Left_Leg", new Vec3(0.0, 0.0, 0.0), 0);
        Idle.addAngle("Lower_Right_Leg", new Vec3(0.0, 0.0, 0.0), 0);
        Idle.addAngle("Left_Wing_Elytra", new Vec3(0.0, 0.0, Math.toRadians(-10.0)), 0);
        Idle.addAngle("Right_Wing_Elytra", new Vec3(0.0, 0.0, Math.toRadians(10.0)), 0);
    }

    public static void addToIdle(PlayerPose toAdd) {
        Idle = Idle.combine(toAdd);
    }

    public static void addToWalking(PlayerPose toAdd) {
        Walking = Walking.combine(toAdd);
    }

    public static void addToJumping(PlayerPose toAdd) {
        Jumping = Jumping.combine(toAdd);
    }

    public static void addToSwimming(PlayerPose toAdd) {
        SwimmingMoving = SwimmingMoving.combine(toAdd);
    }

    public static void setupHolding() {
        Holding.addAngle(ArmPose.upperArm, new Vec3(Math.toRadians(-30.0), Math.toRadians(-5.0), 0.0), 500);
        Holding.addAngle(ArmPose.lowerArm, new Vec3(Math.toRadians(-35.0), 0.0, 0.0), 501);
        Holding.setHolding(true);
    }

    public static void setupSpin() {
        SpinAttack.addAngle("Body", new Vec3(Math.toRadians(90.0), 0.0, 0.0), 999, Float.valueOf(2.0f), -1);
        SpinAttack.addAngle("Body", new Vec3(Math.toRadians(90.0), 0.0, Math.toRadians(90.0)), 999, Float.valueOf(2.0f), -1);
        SpinAttack.addAngle("Body", new Vec3(Math.toRadians(90.0), 0.0, Math.toRadians(180.0)), 999, Float.valueOf(2.0f), -1);
        SpinAttack.addAngle("Body", new Vec3(Math.toRadians(90.0), 0.0, Math.toRadians(270.0)), 999, Float.valueOf(2.0f), -1);
    }

    public static void setupAction() {
        slashing.addAngle(ArmPose.lowerArm, new Vec3(Math.toRadians(-130.0), 0.0, 0.0), 1000, Float.valueOf(5.0f), -1);
        slashing.addAngle(ArmPose.lowerArm, new Vec3(Math.toRadians(-40.0), 0.0, 0.0), 1000, Float.valueOf(1.0f), -1);
        slashing.addAngle(ArmPose.lowerArm, new Vec3(Math.toRadians(-41.0), 0.0, 0.0), 1000, Float.valueOf(14.0f), -1);
        block.addAngle(ArmPose.upperArm, new Vec3(Math.toRadians(-45.0), Math.toRadians(-30.0), 0.0), 500);
        block.addAngle(ArmPose.lowerArm, new Vec3(0.0, 0.0, 0.0), 501);
        bow.addAngle(ArmPose.upperArm, new Vec3(Math.toRadians(-100.0), Math.toRadians(-10.0), 0.0), 500);
        bow.addAngle(ArmPose.lowerArm, new Vec3(0.0, 0.0, 0.0), 501);
        bow.setHolding(true);
        bowOff.addAngle(ArmPose.upperArm, new Vec3(Math.toRadians(-100.0), Math.toRadians(-35.0), 0.0), 500);
        bowOff.addAngle(ArmPose.lowerArm, new Vec3(0.0, 0.0, 0.0), 501);
        bowOff.setHolding(true);
        spear.addAngle(ArmPose.upperArm, new Vec3(Math.toRadians(-180.0), 0.0, 0.0), 500);
        spear.addAngle(ArmPose.lowerArm, new Vec3(0.0, 0.0, 0.0), 501);
        spyglass.addAngle(ArmPose.upperArm, new Vec3(Math.toRadians(-90.0), 0.0, Math.toRadians(25.0)), 500);
        spyglass.addAngle(ArmPose.lowerArm, new Vec3(Math.toRadians(-55.0), 0.0, 0.0), 501);
        spyglass.setHolding(true);
        horn.addAngle(ArmPose.upperArm, new Vec3(Math.toRadians(-80.0), 0.0, Math.toRadians(25.0)), 500);
        horn.addAngle(ArmPose.lowerArm, new Vec3(Math.toRadians(-45.0), 0.0, 0.0), 501);
        horn.setHolding(true);
        crossbow.addAngle(ArmPose.upperArm, new Vec3(Math.toRadians(-20.0), 0.0, Math.toRadians(-20.0)), 500);
        crossbow.addAngle(ArmPose.lowerArm, new Vec3(Math.toRadians(0.0), 0.0, 0.0), 501);
        crossbowOff.addAngle(ArmPose.upperArm, new Vec3(Math.toRadians(-30.0), 0.0, Math.toRadians(-40.0)), 500, Float.valueOf(5.0f), -1);
        crossbowOff.addAngle(ArmPose.upperArm, new Vec3(Math.toRadians(-30.0), 0.0, Math.toRadians(-50.0)), 500, Float.valueOf(70.0f), -1);
        crossbowOff.addAngle(ArmPose.lowerArm, new Vec3(Math.toRadians(0.0), 0.0, 0.0), 501);
        eat.addAngle(ArmPose.upperArm, new Vec3(Math.toRadians(-80.0), 0.0, Math.toRadians(40.0)), 500);
        eat.addAngle(ArmPose.lowerArm, new Vec3(Math.toRadians(-50.0), 0.0, 0.0), 501, Float.valueOf(5.0f), -1);
        eat.addAngle(ArmPose.lowerArm, new Vec3(Math.toRadians(-40.0), 0.0, 0.0), 501, Float.valueOf(5.0f), -1);
        drink.addAngle(ArmPose.upperArm, new Vec3(Math.toRadians(-80.0), 0.0, Math.toRadians(40.0)), 500);
        drink.addAngle(ArmPose.lowerArm, new Vec3(Math.toRadians(-40.0), 0.0, 0.0), 501);
    }

    public static void setupWalking() {
        Vec3[] walkAngle = new Vec3[]{new Vec3(Math.toRadians(-45.0), Math.toRadians(0.0), Math.toRadians(0.0)), new Vec3(Math.toRadians(-45.0), Math.toRadians(0.0), Math.toRadians(0.0)), new Vec3(Math.toRadians(0.0), Math.toRadians(0.0), Math.toRadians(0.0)), new Vec3(Math.toRadians(30.0), Math.toRadians(0.0), Math.toRadians(0.0)), new Vec3(Math.toRadians(30.0), Math.toRadians(0.0), Math.toRadians(0.0))};
        Walking = AnimationBuilder.generateRepeatingMirroredLimbs("Left_Leg", "Right_Leg", walkAngle, 100, 5.0f, 1);
        Vec3[] lowerWalkAngle = new Vec3[]{new Vec3(Math.toRadians(45.0), Math.toRadians(0.0), Math.toRadians(0.0)), new Vec3(Math.toRadians(0.0), Math.toRadians(0.0), Math.toRadians(0.0)), new Vec3(Math.toRadians(0.0), Math.toRadians(0.0), Math.toRadians(0.0)), new Vec3(Math.toRadians(0.0), Math.toRadians(0.0), Math.toRadians(0.0)), new Vec3(Math.toRadians(15.0), Math.toRadians(0.0), Math.toRadians(0.0))};
        Walking = Walking.combine(AnimationBuilder.generateRepeatingMirroredLimbs("Lower_Left_Leg", "Lower_Right_Leg", lowerWalkAngle, 100, 5.0f, 1));
        Walking.addAngle("Left_Arm", new Vec3(Math.toRadians(45.0), Math.toRadians(0.0), 0.0), 50);
        Walking.addAngle("Left_Arm", new Vec3(Math.toRadians(-45.0), Math.toRadians(0.0), 0.0), 50);
        Walking.addAngle("Right_Arm", new Vec3(Math.toRadians(-45.0), Math.toRadians(0.0), 0.0), 50);
        Walking.addAngle("Right_Arm", new Vec3(Math.toRadians(45.0), Math.toRadians(0.0), 0.0), 50);
    }

    public static void setupCrouchingWalk() {
        Vec3[] walkAngle = new Vec3[]{new Vec3(Math.toRadians(-95.0), Math.toRadians(0.0), Math.toRadians(0.0)), new Vec3(Math.toRadians(-95.0), Math.toRadians(0.0), Math.toRadians(0.0)), new Vec3(Math.toRadians(-70.0), Math.toRadians(0.0), Math.toRadians(0.0)), new Vec3(Math.toRadians(-30.0), Math.toRadians(0.0), Math.toRadians(0.0)), new Vec3(Math.toRadians(-30.0), Math.toRadians(0.0), Math.toRadians(0.0))};
        CrouchingWalk = AnimationBuilder.generateRepeatingMirroredLimbs("Left_Leg", "Right_Leg", walkAngle, 150, 5.0f, 1);
        Vec3[] lowerWalkAngle = new Vec3[]{new Vec3(Math.toRadians(95.0), Math.toRadians(0.0), Math.toRadians(0.0)), new Vec3(Math.toRadians(70.0), Math.toRadians(0.0), Math.toRadians(0.0)), new Vec3(Math.toRadians(70.0), Math.toRadians(0.0), Math.toRadians(0.0)), new Vec3(Math.toRadians(70.0), Math.toRadians(0.0), Math.toRadians(0.0)), new Vec3(Math.toRadians(85.0), Math.toRadians(0.0), Math.toRadians(0.0))};
        CrouchingWalk = CrouchingWalk.combine(AnimationBuilder.generateRepeatingMirroredLimbs("Lower_Left_Leg", "Lower_Right_Leg", lowerWalkAngle, 150, 5.0f, 1));
        CrouchingWalk.addAngle("Left_Wing_Elytra", new Vec3(0.0, 0.0, Math.toRadians(-30.0)), 150);
        CrouchingWalk.addAngle("Right_Wing_Elytra", new Vec3(0.0, 0.0, Math.toRadians(30.0)), 150);
    }

    public static void setupJumping() {
        Jumping.addAngle("Left_Arm", new Vec3(Math.toRadians(-180.0), Math.toRadians(0.0), Math.toRadians(30.0)), 150, Float.valueOf(5.0f), -1);
        Jumping.addAngle("Right_Arm", new Vec3(Math.toRadians(-180.0), Math.toRadians(0.0), Math.toRadians(-30.0)), 150, Float.valueOf(5.0f), -1);
        Jumping.addAngle("Left_Leg", new Vec3(Math.toRadians(0.0), Math.toRadians(0.0), 0.0), 200, Float.valueOf(1.0f), -1);
        Jumping.addAngle("Right_Leg", new Vec3(Math.toRadians(0.0), Math.toRadians(0.0), 0.0), 200, Float.valueOf(1.0f), -1);
        Jumping.addAngle("Lower_Left_Leg", new Vec3(Math.toRadians(0.0), Math.toRadians(0.0), 0.0), 200, Float.valueOf(1.0f), -1);
        Jumping.addAngle("Lower_Right_Leg", new Vec3(Math.toRadians(0.0), Math.toRadians(0.0), 0.0), 200, Float.valueOf(1.0f), -1);
    }
}

