/*
 * Decompiled with CFR 0.152.
 */
package DaoOfModding.mlmanimator.Client.Poses;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Set;
import net.minecraft.world.phys.Vec3;

public class PlayerPose {
    protected HashMap<String, Integer> priorities = new HashMap();
    protected HashMap<String, Integer> sizePriorities = new HashMap();
    protected HashMap<String, Float> sizeSpeed = new HashMap();
    protected HashMap<String, ArrayList<Vec3>> angles = new HashMap();
    protected HashMap<String, ArrayList<Float>> speed = new HashMap();
    protected HashMap<String, Vec3> offset = new HashMap();
    protected HashMap<String, Vec3> sizes = new HashMap();
    protected HashMap<String, Integer> aLock = new HashMap();
    protected boolean disableHeadLook = false;
    protected int disableHeadLookPriority = 0;
    public static final double oneEighty = Math.toRadians(180.0);
    public static final double threeSixty = Math.toRadians(360.0);

    public void setAngles(String limb, ArrayList<Vec3> newAngles, ArrayList<Float> newSpeeds, int priority, Vec3 off, int animationLock) {
        this.angles.put(limb, newAngles);
        this.speed.put(limb, newSpeeds);
        this.priorities.put(limb, priority);
        if (off != null) {
            this.offset.put(limb, off);
        }
        this.aLock.put(limb, animationLock);
    }

    public void addOffset(String limb, Vec3 offsetVector) {
        if (this.offset.containsKey(limb)) {
            offsetVector = this.offset.get(limb).m_82549_(offsetVector);
        }
        this.offset.put(limb, offsetVector);
    }

    public Vec3 getOffset(String limb) {
        if (this.offset.containsKey(limb)) {
            return this.offset.get(limb);
        }
        return new Vec3(0.0, 0.0, 0.0);
    }

    public void addSize(String limb, Vec3 size, int priority, float speed) {
        if (this.sizePriorities.containsKey(limb) && this.sizePriorities.get(limb) >= priority) {
            return;
        }
        this.sizePriorities.put(limb, priority);
        this.sizeSpeed.put(limb, Float.valueOf(speed));
        this.sizes.put(limb, size);
    }

    public Vec3 getSize(String limb) {
        if (this.sizes.containsKey(limb)) {
            return this.sizes.get(limb);
        }
        return null;
    }

    public int getSizePriority(String limb) {
        if (this.sizePriorities.containsKey(limb)) {
            return this.sizePriorities.get(limb);
        }
        return -1;
    }

    public float getSizeSpeed(String limb) {
        if (this.sizeSpeed.containsKey(limb)) {
            return this.sizeSpeed.get(limb).floatValue();
        }
        return -1.0f;
    }

    public HashMap<String, Vec3> getSizes() {
        return this.sizes;
    }

    public int getAnimationLock(String limb) {
        if (this.aLock.containsKey(limb)) {
            return this.aLock.get(limb);
        }
        return -1;
    }

    public void disableHeadLook(boolean disable, int priority) {
        if (priority > this.disableHeadLookPriority) {
            this.disableHeadLookPriority = priority;
            this.disableHeadLook = disable;
        }
    }

    public boolean isHeadLookDisabled() {
        return this.disableHeadLook;
    }

    public int getDisableHeadLookPriority() {
        return this.disableHeadLookPriority;
    }

    public Set<String> getLimbs() {
        return this.angles.keySet();
    }

    public ArrayList<Vec3> getAngles(String limb) {
        return this.angles.get(limb);
    }

    public void clearAngles(String limb) {
        this.angles.remove(limb);
        this.priorities.remove(limb);
        this.speed.remove(limb);
        this.aLock.remove(limb);
    }

    public ArrayList<Float> getSpeeds(String limb) {
        return this.speed.get(limb);
    }

    public void adjustAllSpeeds(float amount) {
        HashMap newSpeed = new HashMap();
        for (String limb : this.speed.keySet()) {
            ArrayList<Float> newSpeeds = new ArrayList<Float>();
            for (Float oldSpeed : this.speed.get(limb)) {
                newSpeeds.add(Float.valueOf(oldSpeed.floatValue() / amount));
            }
            newSpeed.put(limb, newSpeeds);
        }
        this.speed = newSpeed;
    }

    public void addAngle(String limb, Vec3 angle, int priority) {
        this.addAngle(limb, angle, priority, Float.valueOf(10.0f), -1);
    }

    public void addAngle(String limb, Vec3 angle, int priority, Float speedInTicks, int animationLock) {
        if (!this.angles.containsKey(limb)) {
            this.angles.put(limb, new ArrayList());
            this.speed.put(limb, new ArrayList());
        }
        this.angles.get(limb).add(angle);
        this.speed.get(limb).add(speedInTicks);
        this.priorities.put(limb, priority);
        this.aLock.put(limb, animationLock);
    }

    public float getAnimationSpeed(String limb, int frame) {
        return this.speed.get(limb).get(frame).floatValue();
    }

    public boolean hasAngle(String limb) {
        return this.angles.containsKey(limb);
    }

    public Vec3 getAngle(String limb, int frame) {
        return this.angles.get(limb).get(frame);
    }

    public Vec3 getAngle(String limb) {
        return this.getAngle(limb, 0);
    }

    public int getFrames(String limb) {
        return this.angles.get(limb).size();
    }

    public int getPriority(String limb) {
        return this.priorities.get(limb);
    }

    public PlayerPose combine(PlayerPose secondPose) {
        PlayerPose copy = secondPose.clone();
        for (String limb : this.angles.keySet()) {
            if (copy.hasAngle(limb) && copy.getPriority(limb) >= this.getPriority(limb)) continue;
            copy.setAngles(limb, this.getAngles(limb), this.getSpeeds(limb), this.getPriority(limb), this.getOffset(limb), this.getAnimationLock(limb));
        }
        for (String limb : this.sizes.keySet()) {
            copy.addSize(limb, this.sizes.get(limb), this.sizePriorities.get(limb), this.sizeSpeed.get(limb).floatValue());
        }
        copy.disableHeadLook(this.disableHeadLook, this.disableHeadLookPriority);
        return copy;
    }

    public PlayerPose clone() {
        PlayerPose copyPose = new PlayerPose();
        for (String limb : this.angles.keySet()) {
            copyPose.setAngles(limb, (ArrayList)this.angles.get(limb).clone(), (ArrayList)this.speed.get(limb).clone(), this.priorities.get(limb), this.offset.get(limb), this.aLock.get(limb));
        }
        for (String limb : this.sizes.keySet()) {
            copyPose.addSize(limb, this.sizes.get(limb), this.sizePriorities.get(limb), this.sizeSpeed.get(limb).floatValue());
        }
        copyPose.disableHeadLook(this.disableHeadLook, this.disableHeadLookPriority);
        return copyPose;
    }
}

