/*
 * Decompiled with CFR 0.152.
 */
package DaoOfModding.mlmanimator.Client.Poses;

import DaoOfModding.mlmanimator.Client.AnimationFramework.AnimationSpeedCalculator;
import DaoOfModding.mlmanimator.Client.Models.ExtendableModelRenderer;
import DaoOfModding.mlmanimator.Client.Models.MultiLimbedModel;
import DaoOfModding.mlmanimator.Client.MultiLimbedRenderer;
import DaoOfModding.mlmanimator.Client.Poses.Arm;
import DaoOfModding.mlmanimator.Client.Poses.ArmPose;
import DaoOfModding.mlmanimator.Client.Poses.GenericPoses;
import DaoOfModding.mlmanimator.Client.Poses.PlayerPose;
import DaoOfModding.mlmanimator.Network.PacketHandler;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CrossbowItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.phys.Vec3;

public class PlayerPoseHandler {
    UUID playerID;
    MultiLimbedModel model;
    PlayerPose currentPose = new PlayerPose();
    PlayerPose renderPose = new PlayerPose();
    PlayerPose oldRenderPose = new PlayerPose();
    PlayerPose animatingPose = new PlayerPose();
    PlayerPose backupPose = new PlayerPose();
    PlayerPose legLockPose = new PlayerPose();
    PlayerPose oldLegLockPose = new PlayerPose();
    boolean locked = false;
    boolean crawling = false;
    boolean crouching = false;
    int crouchingCooldown = 0;
    int forcedCrouchCooldown = 0;
    protected boolean isJumping = false;
    protected int jumpCooldown = 0;
    public boolean disableJumpingAnimationThisTick = false;
    protected HashMap<String, Integer> frame = new HashMap();
    protected HashMap<String, Float> animationTime = new HashMap();
    protected HashMap<Integer, Integer> aLockedFrame = new HashMap();
    public float fov = 1.0f;
    protected Vec3 oldPos = new Vec3(0.0, 0.0, 0.0);
    protected Vec3 delta = new Vec3(0.0, 0.0, 0.0);
    protected boolean slim = false;
    protected ArrayList<Arm> arms = new ArrayList();
    protected boolean attackCancel = false;
    protected Vec3 size = new Vec3(0.0, 0.0, 0.0);
    public static double oneEighty = Math.toRadians(180.0);
    public static double threeSixty = Math.toRadians(360.0);
    public boolean collision = false;

    public PlayerPoseHandler(Player player, PlayerModel playerModel) {
        Arm Off;
        Arm Main;
        this.playerID = player.m_20148_();
        this.slim = MultiLimbedRenderer.isSlim(playerModel);
        this.model = new MultiLimbedModel(playerModel);
        if (player.m_5737_() == HumanoidArm.LEFT) {
            Main = new Arm(InteractionHand.MAIN_HAND, "Left_Arm", "Lower_Left_Arm", true);
            Off = new Arm(InteractionHand.OFF_HAND, "Right_Arm", "Lower_Right_Arm", false);
        } else {
            Main = new Arm(InteractionHand.MAIN_HAND, "Right_Arm", "Lower_Right_Arm", false);
            Off = new Arm(InteractionHand.OFF_HAND, "Left_Arm", "Lower_Left_Arm", true);
        }
        this.arms.add(Main);
        this.arms.add(Off);
    }

    public void tick(AbstractClientPlayer player) {
        if (this.crouchingCooldown > 0) {
            --this.crouchingCooldown;
            if (this.crouchingCooldown == 0) {
                this.crouching = false;
            }
        }
        if (this.forcedCrouchCooldown > 0) {
            --this.forcedCrouchCooldown;
        }
        this.getPlayerModel().tick(player);
    }

    public void setForcedCrouch() {
        this.forcedCrouchCooldown = 10;
    }

    public boolean isForcedCrouch() {
        return this.forcedCrouchCooldown > 0;
    }

    public void setCrouching(boolean on) {
        if (on) {
            this.crouchingCooldown = 4;
            this.crouching = true;
        } else {
            this.crouching = false;
        }
    }

    public boolean wasCrouching() {
        return this.crouchingCooldown > 0;
    }

    public boolean isCrouching() {
        return this.crouching;
    }

    public void resize(Vec3 resize) {
        this.size = resize;
    }

    public void setCrawling(boolean on) {
        if (on == this.crawling) {
            return;
        }
        PacketHandler.sendCrawlingToServer(on);
        this.crawling = on;
    }

    public boolean isCrawling() {
        return this.crawling;
    }

    public void addArm(Arm newArm) {
        this.arms.add(newArm);
    }

    public void removeArm(Arm toRemove) {
        this.arms.remove(toRemove);
    }

    public void removeArms() {
        this.arms.clear();
    }

    public ArrayList<Arm> getArms() {
        return this.arms;
    }

    public MultiLimbedModel getPlayerModel() {
        return this.model;
    }

    public Vec3 getDeltaMovement() {
        return this.delta;
    }

    public void setPlayerModel(MultiLimbedModel newModel) {
        this.model = newModel;
    }

    public boolean isSlim() {
        return this.slim;
    }

    public UUID getID() {
        return this.playerID;
    }

    public void addPose(PlayerPose pose) {
        this.lock();
        for (String limb : pose.getLimbs()) {
            if (this.currentPose.hasAngle(limb) && this.currentPose.getPriority(limb) >= pose.getPriority(limb)) continue;
            this.currentPose.setAngles(limb, pose.getAngles(limb), pose.getSpeeds(limb), pose.getPriority(limb), pose.getOffset(limb), pose.getAnimationLock(limb));
        }
        for (String limb : pose.getSizes().keySet()) {
            this.currentPose.addSize(limb, pose.getSize(limb), pose.getSizePriority(limb), pose.getSizeSpeed(limb));
        }
        this.currentPose.disableHeadLook(pose.isHeadLookDisabled(), pose.getDisableHeadLookPriority());
        this.unlock();
    }

    public void cancelNextAttackAnimation() {
        this.attackCancel = true;
    }

    public boolean isHeadLookDisabled() {
        this.lock();
        boolean test = this.renderPose.isHeadLookDisabled();
        this.unlock();
        return test;
    }

    protected void updateHeadLook(boolean lookWithCamera) {
        for (String limb : this.model.getAllLimbs()) {
            ExtendableModelRenderer limbModel = this.model.getLimb(limb);
            if (limbModel == null) {
                limbModel = this.model.getFirstPersonLimb(limb);
            }
            if (!limbModel.isLooking().booleanValue()) continue;
            Vec3 angles = new Vec3(0.0, 0.0, 0.0);
            Vec3 notLooking = new Vec3(0.0, 0.0, 0.0);
            ExtendableModelRenderer baseModel = limbModel;
            while (limbModel.getParent() != null) {
                limbModel = limbModel.getParent();
                angles = angles.m_82492_((double)limbModel.getModelPart().f_104203_, (double)limbModel.getModelPart().f_104204_, (double)(-limbModel.getModelPart().f_104205_));
                notLooking = notLooking.m_82520_((double)limbModel.getModelPart().f_104203_, (double)limbModel.getModelPart().f_104204_, (double)(-limbModel.getModelPart().f_104205_));
            }
            if (lookWithCamera) {
                angles = angles.m_82520_(this.model.getLookVector().f_82479_, this.model.getLookVector().f_82480_, this.model.getLookVector().f_82481_);
                this.currentPose.addAngle(limb, angles, 0, Float.valueOf(1.0f), -1);
                baseModel.setNotLookingPitch(0.0f);
                continue;
            }
            baseModel.setNotLookingPitch((float)Math.toDegrees(notLooking.f_82479_));
        }
    }

    protected void updateJumping() {
        if (this.isJumping && this.jumpCooldown > 0) {
            --this.jumpCooldown;
        }
    }

    public boolean isJumping() {
        if (this.jumpCooldown > 0) {
            return true;
        }
        return this.isJumping;
    }

    public void updateRenderPose() {
        this.lock();
        this.oldRenderPose = this.renderPose;
        this.renderPose = this.currentPose;
        this.currentPose = new PlayerPose();
        this.updateHeadLook(!this.renderPose.isHeadLookDisabled());
        this.updateJumping();
        this.unlock();
    }

    public void setJumping(boolean jump) {
        if (!jump && this.jumpCooldown > 0) {
            return;
        }
        if (this.jumpCooldown <= 0 && jump) {
            this.jumpCooldown = 5;
        }
        this.isJumping = jump;
    }

    public void lock() {
        while (this.locked) {
        }
        this.locked = true;
    }

    public void unlock() {
        this.locked = false;
    }

    public void revertPose() {
        this.aLockedFrame = new HashMap();
        this.animatingPose = this.backupPose;
        this.currentPose = new PlayerPose();
        this.renderPose = this.oldRenderPose;
        this.lockLegPose(this.oldLegLockPose);
        this.resizeLimbs(this.animatingPose.getSizes());
        for (String limb : this.animatingPose.getLimbs()) {
            this.model.rotateLimb(limb, this.animatingPose.getAngle(limb).m_82549_(this.animatingPose.getOffset(limb)));
        }
    }

    public void doPose(float partialTicks) {
        this.aLockedFrame = new HashMap();
        this.animateLimbs(partialTicks);
        this.resizeLimbs(this.animatingPose.getSizes());
        for (String limb : this.animatingPose.getLimbs()) {
            this.model.rotateLimb(limb, this.animatingPose.getAngle(limb).m_82549_(this.animatingPose.getOffset(limb)));
        }
    }

    protected void resizeLimbs(HashMap<String, Vec3> sizes) {
        this.model.getBody().resetResize();
        for (ExtendableModelRenderer extendableModelRenderer : this.model.getFirstPersonLimbs().values()) {
            extendableModelRenderer.resetResize();
        }
        for (Map.Entry entry : sizes.entrySet()) {
            ExtendableModelRenderer limb = this.model.getLimb((String)entry.getKey());
            if (limb == null) continue;
            limb.resize((Vec3)entry.getValue());
        }
        this.model.getBody().addToResizeForThisAndChildren(this.size);
    }

    public void animateLimbs(float partialTicks) {
        this.lock();
        PlayerPose newRender = new PlayerPose();
        Set<String> limbs = this.model.getAllLimbs();
        for (String limb : limbs) {
            if (this.animationTime.containsKey(limb) && (!this.renderPose.hasAngle(limb) || !this.oldRenderPose.hasAngle(limb) || this.renderPose.getAngle(limb).equals((Object)this.oldRenderPose.getAngle(limb)))) continue;
            this.animationTime.put(limb, Float.valueOf(0.0f));
        }
        for (String limb : limbs) {
            if (!this.renderPose.hasAngle(limb)) continue;
            this.calculateAnimationLocks(limb, this.getLimbPos(limb), partialTicks);
        }
        for (String limb : limbs) {
            Vec3 angles = this.renderPose.hasAngle(limb) ? this.animateLimb(limb, this.getLimbPos(limb), partialTicks) : this.animateLimb(this.getLimbPos(limb), new Vec3(0.0, 0.0, 0.0), 0.05f, partialTicks);
            newRender.addAngle(limb, angles, 1);
            newRender.addOffset(limb, this.renderPose.getOffset(limb));
            newRender.addSize(limb, this.animateResize(this.getLimbSize(limb), new Vec3(1.0, 1.0, 1.0), 0.05f), 0, 1.0f);
        }
        for (String limb : this.renderPose.getSizes().keySet()) {
            newRender.addSize(limb, this.animateResize(this.getLimbSize(limb), this.renderPose.getSize(limb), this.renderPose.getSizeSpeed(limb)), 1, this.renderPose.getSizeSpeed(limb));
        }
        for (String limb : limbs) {
            this.animationTime.put(limb, Float.valueOf(this.animationTime.get(limb).floatValue() + partialTicks));
        }
        this.backupPose = this.animatingPose;
        this.animatingPose = newRender;
        this.unlock();
    }

    public Vec3 animateResize(Vec3 currentSize, Vec3 targetSize, float speed) {
        Vec3 direction = currentSize.m_82546_(targetSize);
        if (direction.m_82553_() == 0.0) {
            return currentSize;
        }
        if (direction.m_82553_() < (double)speed) {
            return targetSize;
        }
        direction = direction.m_82541_().m_82490_((double)(-speed));
        return currentSize.m_82549_(direction);
    }

    public Vec3 getLimbPos(String limb) {
        if (this.animatingPose.hasAngle(limb)) {
            return this.animatingPose.getAngle(limb, 0);
        }
        return this.modelFromLimb(limb);
    }

    protected Vec3 modelFromLimb(String limb) {
        ExtendableModelRenderer limbModel = this.model.getLimb(limb);
        if (limbModel == null) {
            limbModel = this.model.getFirstPersonLimb(limb);
        }
        return new Vec3((double)limbModel.getModelPart().f_104203_, (double)limbModel.getModelPart().f_104204_, (double)limbModel.getModelPart().f_104205_);
    }

    protected Vec3 getLimbSize(String limb) {
        ExtendableModelRenderer limbModel = this.model.getLimb(limb);
        if (limbModel == null) {
            limbModel = this.model.getFirstPersonLimb(limb);
        }
        return limbModel.getSize().m_82546_(this.size);
    }

    protected void calculateAnimationLocks(String limb, Vec3 current, float partialTicks) {
        if (!this.frame.containsKey(limb)) {
            this.frame.put(limb, 0);
        }
        if (this.renderPose.getFrames(limb) == 1) {
            return;
        }
        int aLock = this.renderPose.getAnimationLock(limb);
        if (aLock == -1) {
            return;
        }
        int currentFrame = this.frame.get(limb);
        if (this.renderPose.getAngles(limb).size() <= currentFrame) {
            currentFrame = 0;
        }
        Vec3 moveTo = this.renderPose.getAngle(limb, currentFrame);
        Vec3 toMove = new Vec3(current.f_82479_ - moveTo.f_82479_, current.f_82480_ - moveTo.f_82480_, current.f_82481_ - moveTo.f_82481_);
        double moveAmount = toMove.m_82553_();
        if (moveAmount == 0.0) {
            ++currentFrame;
        }
        if (currentFrame >= this.renderPose.getFrames(limb)) {
            currentFrame = 0;
        }
        if (this.aLockedFrame.containsKey(aLock)) {
            int lockedFrame = this.aLockedFrame.get(aLock);
            if (lockedFrame == currentFrame) {
                return;
            }
            if (currentFrame == 0 && lockedFrame > 1) {
                return;
            }
            if (lockedFrame == 0 && currentFrame > 1) {
                this.aLockedFrame.put(aLock, currentFrame);
                return;
            }
            if (lockedFrame > currentFrame) {
                this.aLockedFrame.put(aLock, currentFrame);
            }
        } else {
            this.aLockedFrame.put(aLock, currentFrame);
        }
    }

    protected Vec3 calculateMovement(Vec3 from, Vec3 to) {
        from = this.flattenVector(from);
        to = new Vec3(this.conditionalFlatten(from.f_82479_, to.f_82479_), this.conditionalFlatten(from.f_82480_, to.f_82480_), this.conditionalFlatten(from.f_82481_, to.f_82481_));
        return this.flattenVector(from.m_82546_(to));
    }

    protected double conditionalFlatten(double from, double to) {
        if (from > 0.0 && to < -oneEighty) {
            return to + threeSixty;
        }
        if (from < 0.0 && to > oneEighty) {
            return to - threeSixty;
        }
        return to;
    }

    protected Vec3 flattenVector(Vec3 vec) {
        return new Vec3(this.flattenAngle(vec.f_82479_), this.flattenAngle(vec.f_82480_), this.flattenAngle(vec.f_82481_));
    }

    protected double flattenAngle(double angle) {
        if (angle > oneEighty) {
            return angle - threeSixty;
        }
        if (angle < -oneEighty) {
            return angle + threeSixty;
        }
        return angle;
    }

    protected Vec3 animateLimb(String limb, Vec3 current, float partialTicks) {
        float TicksRemaining;
        if (!this.frame.containsKey(limb)) {
            this.frame.put(limb, 0);
            this.animationTime.put(limb, Float.valueOf(0.0f));
        } else if (this.frame.get(limb) >= this.renderPose.getFrames(limb)) {
            this.frame.put(limb, 0);
            this.animationTime.put(limb, Float.valueOf(0.0f));
        }
        int currentFrame = this.frame.get(limb);
        Vec3 moveTo = this.renderPose.getAngle(limb, currentFrame);
        Vec3 toMove = this.calculateMovement(current, moveTo);
        double moveAmount = toMove.m_82553_();
        if (moveAmount == 0.0) {
            if (this.renderPose.getFrames(limb) == 1) {
                return current;
            }
            int aLock = this.renderPose.getAnimationLock(limb);
            if (this.aLockedFrame.containsKey(aLock) && this.aLockedFrame.get(aLock) == currentFrame) {
                return current;
            }
            this.frame.put(limb, ++currentFrame);
            this.animationTime.put(limb, Float.valueOf(0.0f));
            return this.animateLimb(limb, current, partialTicks);
        }
        if (!this.animationTime.containsKey(limb)) {
            this.animationTime.put(limb, Float.valueOf(0.0f));
        }
        if ((TicksRemaining = this.renderPose.getAnimationSpeed(limb, currentFrame) - this.animationTime.get(limb).floatValue()) <= 0.0f) {
            return moveTo;
        }
        double aSpeed = AnimationSpeedCalculator.ticksToSpeed(current, moveTo, TicksRemaining) * (double)partialTicks;
        if (moveAmount <= aSpeed) {
            return moveTo;
        }
        toMove = toMove.m_82541_().m_82490_(aSpeed);
        return current.m_82546_(toMove);
    }

    protected Vec3 animateLimb(Vec3 current, Vec3 moveTo, double aSpeed, float partialTicks) {
        Vec3 toMove = new Vec3(current.f_82479_ - moveTo.f_82479_, current.f_82480_ - moveTo.f_82480_, current.f_82481_ - moveTo.f_82481_);
        double moveAmount = toMove.m_82553_();
        if (moveAmount == 0.0) {
            return current;
        }
        if (moveAmount > (aSpeed *= (double)partialTicks)) {
            toMove = toMove.m_82541_().m_82490_(aSpeed);
        }
        return this.calculateMovement(current, moveTo);
    }

    protected void calculateDelta(Player player) {
        this.delta = player.m_7578_() ? player.m_20184_() : player.m_20182_().m_82546_(this.oldPos);
        this.oldPos = player.m_20182_();
    }

    public void doDefaultPoses(Player player) {
        this.oldLegLockPose = this.legLockPose;
        this.legLockPose = null;
        this.calculateDelta(player);
        this.addPose(GenericPoses.Idle);
        this.lockLegPose(GenericPoses.Idle);
        if (player.m_20096_() || player.m_20069_()) {
            this.setJumping(false);
        } else if (!this.isJumping() && this.getDeltaMovement().f_82480_ > 0.0) {
            this.setJumping(true);
        }
        if (player.m_20159_()) {
            this.addPose(GenericPoses.Sitting);
            this.lockLegPose(GenericPoses.Sitting);
        }
        if (player.m_5803_()) {
            this.addPose(GenericPoses.Sleeping);
        } else if (player.m_21209_()) {
            this.addPose(GenericPoses.SpinAttack);
        } else if (this.isCrawling()) {
            if (this.getDeltaMovement().f_82479_ != 0.0 || this.getDeltaMovement().f_82481_ != 0.0) {
                this.addPose(GenericPoses.CrawlingWalk);
                this.lockLegPose(GenericPoses.Crawling);
            } else {
                this.addPose(GenericPoses.Crawling);
                this.lockLegPose(GenericPoses.Crawling);
            }
        } else if (player.m_6069_()) {
            if (this.getDeltaMovement().m_82553_() > 0.0) {
                PlayerPose swimPose = GenericPoses.SwimmingMoving.clone();
                this.rotateBody(swimPose, player, 1000);
                this.addPose(swimPose);
            } else {
                this.addPose(GenericPoses.Swimming);
            }
        } else if (player.m_21255_()) {
            PlayerPose flyFalling = GenericPoses.FlyFalling.clone();
            this.rotateBody(flyFalling, player, 1000);
            this.addPose(flyFalling);
        } else if (this.isJumping()) {
            if (this.disableJumpingAnimationThisTick) {
                this.disableJumpingAnimationThisTick = false;
            } else {
                this.addPose(GenericPoses.Jumping);
            }
        } else if ((player.m_20096_() || player.m_20069_()) && (this.getDeltaMovement().f_82479_ != 0.0 || this.getDeltaMovement().f_82481_ != 0.0)) {
            this.addPose(GenericPoses.getWalkingPose(player));
        }
        if (player.m_6047_() && !player.m_6069_() && (player.m_20096_() || !player.m_20069_())) {
            this.lockLegPose(GenericPoses.Crouching);
            if (this.getDeltaMovement().f_82479_ != 0.0 || this.getDeltaMovement().f_82481_ != 0.0) {
                this.addPose(GenericPoses.getWalkingPose(player));
                this.addPose(GenericPoses.CrouchingWalk);
            } else {
                this.addPose(GenericPoses.Crouching);
            }
        }
        for (Arm arm : this.arms) {
            this.doArmPose(player, arm);
        }
    }

    public void lockLegPose(PlayerPose pose) {
        this.legLockPose = pose;
        for (String leg : GenericPoses.getLegs()) {
            if (!this.model.hasLimb(leg)) continue;
            if (pose == null) {
                this.model.getLimb(leg).lockHitboxAnimation(null);
                continue;
            }
            if (!pose.hasAngle(leg)) continue;
            this.model.getLimb(leg).lockHitboxAnimation(pose.getAngles(leg).get(0));
        }
    }

    public ArmPose convertArmPose(Arm arm, ArmPose pose) {
        ArmPose newPose = pose.clone();
        newPose.setUpperArm(arm.upperLimb);
        newPose.setLowerArm(arm.lowerLimb);
        newPose.setMirrored(arm.mirrored);
        if (pose.holding.booleanValue()) {
            Vec3 holdingVector = this.model.getHoldingVector();
            if (newPose.mirror.booleanValue()) {
                holdingVector = holdingVector.m_82542_(1.0, -1.0, -1.0);
            }
            newPose.clearAngles(ArmPose.upperArm);
            for (Vec3 angle : pose.getAngles(ArmPose.upperArm)) {
                newPose.addAngle(ArmPose.upperArm, angle.m_82549_(holdingVector), pose.getPriority(ArmPose.upperArm));
            }
        }
        return newPose;
    }

    public void tryAttackPose(Player player, Arm arm) {
        if (this.attackCancel) {
            this.attackCancel = false;
            player.f_20911_ = false;
        } else {
            this.addPose(this.convertArmPose(arm, GenericPoses.slashing));
        }
    }

    public void doArmPose(Player player, Arm arm) {
        ItemStack itemstack = player.m_21120_(arm.hand);
        if (itemstack.m_41619_()) {
            if (player.f_20911_ && arm.hand == player.f_20912_) {
                this.tryAttackPose(player, arm);
            }
        } else if (player.m_21212_() > 0) {
            UseAnim useanim = itemstack.m_41780_();
            if (useanim == UseAnim.BLOCK) {
                this.addPose(this.convertArmPose(arm, GenericPoses.block));
            } else if (useanim == UseAnim.BOW) {
                this.addPose(this.convertArmPose(arm, GenericPoses.bow));
                for (Arm notArm : this.arms) {
                    if (arm == notArm) continue;
                    this.addPose(this.convertArmPose(notArm, GenericPoses.bowOff));
                }
            } else if (useanim == UseAnim.SPEAR) {
                this.addPose(this.convertArmPose(arm, GenericPoses.spear));
            } else if (useanim == UseAnim.CROSSBOW) {
                this.addPose(this.convertArmPose(arm, GenericPoses.crossbow));
                for (Arm notArm : this.arms) {
                    if (arm == notArm) continue;
                    this.addPose(this.convertArmPose(notArm, GenericPoses.crossbowOff));
                }
            } else if (useanim == UseAnim.SPYGLASS) {
                this.addPose(this.convertArmPose(arm, GenericPoses.spyglass));
            } else if (useanim == UseAnim.TOOT_HORN) {
                this.addPose(this.convertArmPose(arm, GenericPoses.horn));
            } else if (useanim == UseAnim.EAT) {
                this.addPose(this.convertArmPose(arm, GenericPoses.eat));
            } else if (useanim == UseAnim.DRINK) {
                this.addPose(this.convertArmPose(arm, GenericPoses.drink));
            }
        } else if (player.f_20911_ && arm.hand == player.f_20912_) {
            this.tryAttackPose(player, arm);
        } else if (itemstack.m_41720_() instanceof CrossbowItem && CrossbowItem.m_40932_((ItemStack)itemstack)) {
            this.addPose(this.convertArmPose(arm, GenericPoses.bow));
            for (Arm notArm : this.arms) {
                if (arm == notArm) continue;
                this.addPose(this.convertArmPose(notArm, GenericPoses.bowOff));
            }
        } else {
            this.addPose(this.convertArmPose(arm, GenericPoses.Holding));
        }
    }

    public void rotateBody(PlayerPose pose, Player player, int priority) {
        double yLook = 1.0 - this.getDeltaMovement().m_82541_().f_82480_;
        double xLook = 0.0;
        if (player.m_20096_()) {
            yLook = 1.1;
        }
        Vec3 vec3 = player.m_20154_();
        Vec3 vec31 = this.getDeltaMovement();
        double d0 = vec31.m_165925_();
        double d1 = vec3.m_165925_();
        if (d0 > 0.0 && d1 > 0.0) {
            double d2 = (vec31.f_82479_ * vec3.f_82479_ + vec31.f_82481_ * vec3.f_82481_) / Math.sqrt(d0 * d1);
            double d3 = vec31.f_82479_ * vec3.f_82481_ - vec31.f_82481_ * vec3.f_82479_;
            if (d2 > 1.0) {
                d2 = 1.0;
            }
            xLook = Math.signum(d3) * Math.acos(d2);
        }
        pose.addAngle("Body", new Vec3(Math.toRadians(90.0 * yLook), 0.0, -xLook), priority);
    }
}

