/*
 * Decompiled with CFR 0.152.
 */
package DaoOfModding.mlmanimator.Client.Poses;

import DaoOfModding.mlmanimator.Client.Poses.PlayerPose;
import DaoOfModding.mlmanimator.Client.Poses.PlayerPoseHandler;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Vector3f;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.renderer.entity.player.PlayerRenderer;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.player.Player;

public class PoseHandler {
    protected static List<PlayerPoseHandler> poses = new ArrayList<PlayerPoseHandler>();
    protected static boolean loaded = false;

    public static boolean setupPoseHandler(AbstractClientPlayer player) {
        for (PlayerPoseHandler handler : poses) {
            if (handler.getID() != player.m_20148_()) continue;
            return true;
        }
        if (!player.m_108559_()) {
            return false;
        }
        PlayerRenderer renderer = (PlayerRenderer)Minecraft.m_91087_().m_91290_().getSkinMap().get(player.m_108564_());
        PlayerPoseHandler newHandler = new PlayerPoseHandler((Player)player, (PlayerModel)renderer.m_7200_());
        poses.add(newHandler);
        loaded = true;
        return true;
    }

    public static void clear() {
        poses = new ArrayList<PlayerPoseHandler>();
        loaded = false;
    }

    public static boolean hasLoaded() {
        return loaded;
    }

    public static void addPoseHandler(PlayerPoseHandler handler) {
        poses.add(handler);
        loaded = true;
    }

    public static PlayerPoseHandler getPlayerPoseHandler(UUID playerID) {
        for (PlayerPoseHandler handler : poses) {
            if (handler.getID() != playerID) continue;
            return handler;
        }
        return null;
    }

    public static void applyRotations(Player entityLiving, PoseStack PoseStackIn, float rotationYaw, float partialTicks) {
        Pose pose = entityLiving.m_20089_();
        if (pose != Pose.SLEEPING) {
            PoseStackIn.m_85845_(Vector3f.f_122225_.m_122240_(180.0f - rotationYaw));
        }
        if (entityLiving.f_20919_ > 0) {
            float f = ((float)entityLiving.f_20919_ + partialTicks - 1.0f) / 20.0f * 1.6f;
            if ((f = Mth.m_14116_((float)f)) > 1.0f) {
                f = 1.0f;
            }
            PoseStackIn.m_85845_(Vector3f.f_122227_.m_122240_(f * 90.0f));
        } else if (pose == Pose.SLEEPING) {
            Direction direction = entityLiving.m_21259_();
            float f1 = direction != null ? PoseHandler.getFacingAngle(direction) : rotationYaw;
            PoseStackIn.m_85845_(Vector3f.f_122225_.m_122240_(f1));
            PoseStackIn.m_85845_(Vector3f.f_122227_.m_122240_(90.0f));
            PoseStackIn.m_85845_(Vector3f.f_122225_.m_122240_(270.0f));
        }
    }

    public static boolean isJumping(UUID playerID) {
        PlayerPoseHandler handler = PoseHandler.getPlayerPoseHandler(playerID);
        if (handler != null) {
            return handler.isJumping();
        }
        return false;
    }

    public static void doPose(UUID playerID, float partialTicks) {
        PlayerPoseHandler handler = PoseHandler.getPlayerPoseHandler(playerID);
        if (handler != null) {
            handler.doPose(partialTicks);
        }
    }

    public static void revertPose(UUID playerID) {
        PlayerPoseHandler handler = PoseHandler.getPlayerPoseHandler(playerID);
        if (handler != null) {
            handler.revertPose();
        }
    }

    public static void addPose(UUID PlayerID, PlayerPose pose) {
        PlayerPoseHandler handler = PoseHandler.getPlayerPoseHandler(PlayerID);
        if (handler != null) {
            handler.addPose(pose);
        }
    }

    public static boolean shouldSit(Player entityIn) {
        return entityIn.m_20159_() && entityIn.m_20202_().shouldRiderSit();
    }

    protected static float getFacingAngle(Direction facingIn) {
        switch (facingIn) {
            case SOUTH: {
                return 90.0f;
            }
            case WEST: {
                return 0.0f;
            }
            case NORTH: {
                return 270.0f;
            }
            case EAST: {
                return 180.0f;
            }
        }
        return 0.0f;
    }
}

