/*
 * Decompiled with CFR 0.152.
 */
package DaoOfModding.mlmanimator.Network.Packets;

import DaoOfModding.mlmanimator.Client.Models.MultiLimbedDimensions;
import DaoOfModding.mlmanimator.Network.Packets.Packet;
import DaoOfModding.mlmanimator.Server.ServerBoundingBoxHandler;
import DaoOfModding.mlmanimator.mlmanimator;
import com.mojang.math.Vector3f;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.network.NetworkEvent;

public class BoundingBoxPacket
extends Packet {
    Vector3f minSize;
    Vector3f maxSize;

    public BoundingBoxPacket(Vector3f min, Vector3f max) {
        this.minSize = min;
        this.maxSize = max;
    }

    @Override
    public void encode(FriendlyByteBuf buffer) {
        buffer.writeFloat(this.minSize.m_122239_());
        buffer.writeFloat(this.minSize.m_122260_());
        buffer.writeFloat(this.minSize.m_122269_());
        buffer.writeFloat(this.maxSize.m_122239_());
        buffer.writeFloat(this.maxSize.m_122260_());
        buffer.writeFloat(this.maxSize.m_122269_());
    }

    public static BoundingBoxPacket decode(FriendlyByteBuf buffer) {
        BoundingBoxPacket returnValue = new BoundingBoxPacket(null, null);
        try {
            Vector3f min = new Vector3f(buffer.readFloat(), buffer.readFloat(), buffer.readFloat());
            Vector3f max = new Vector3f(buffer.readFloat(), buffer.readFloat(), buffer.readFloat());
            return new BoundingBoxPacket(min, max);
        }
        catch (IllegalArgumentException | IndexOutOfBoundsException e) {
            mlmanimator.LOGGER.warn("Exception while reading BoundingBox message: " + e);
            return returnValue;
        }
    }

    @Override
    public void handle(Supplier<NetworkEvent.Context> ctxSupplier) {
        NetworkEvent.Context ctx = ctxSupplier.get();
        LogicalSide sideReceived = ctx.getDirection().getReceptionSide();
        ctx.setPacketHandled(true);
        if (sideReceived.isClient()) {
            mlmanimator.LOGGER.warn("BoundingBoxPacket was received by client - This should not happen");
            return;
        }
        if (this.minSize == null) {
            mlmanimator.LOGGER.warn("BoundingBoxPacket was invalid: " + this.toString());
            return;
        }
        ctx.enqueueWork(() -> this.processPacket(ctx.getSender()));
    }

    protected void processPacket(ServerPlayer sender) {
        MultiLimbedDimensions dimensions = new MultiLimbedDimensions(this.minSize, this.maxSize);
        ServerBoundingBoxHandler.setDimensions(sender.m_20148_(), dimensions);
    }
}

