/*
 * Decompiled with CFR 0.152.
 */
package DaoOfModding.mlmanimator.Network.Packets;

import DaoOfModding.mlmanimator.Network.Packets.Packet;
import DaoOfModding.mlmanimator.Server.ServerListeners;
import DaoOfModding.mlmanimator.mlmanimator;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.network.NetworkEvent;

public class CrawlingPacket
extends Packet {
    boolean crawling;

    public CrawlingPacket(boolean on) {
        this.crawling = on;
    }

    @Override
    public void encode(FriendlyByteBuf buffer) {
        buffer.writeBoolean(this.crawling);
    }

    public static CrawlingPacket decode(FriendlyByteBuf buffer) {
        CrawlingPacket returnValue = new CrawlingPacket(false);
        try {
            boolean crawl = buffer.readBoolean();
            return new CrawlingPacket(crawl);
        }
        catch (IllegalArgumentException | IndexOutOfBoundsException e) {
            mlmanimator.LOGGER.warn("Exception while reading Crawling message: " + e);
            return returnValue;
        }
    }

    @Override
    public void handle(Supplier<NetworkEvent.Context> ctxSupplier) {
        NetworkEvent.Context ctx = ctxSupplier.get();
        LogicalSide sideReceived = ctx.getDirection().getReceptionSide();
        ctx.setPacketHandled(true);
        if (sideReceived.isClient()) {
            mlmanimator.LOGGER.warn("CrawlingPacket was received by client - This should not happen");
            return;
        }
        ctx.enqueueWork(() -> this.processPacket(ctx.getSender()));
    }

    protected void processPacket(ServerPlayer sender) {
        ServerListeners.setCrawling(sender.m_20148_(), this.crawling);
    }
}

