/*
 * Decompiled with CFR 0.152.
 */
package DaoOfModding.mlmanimator.Network.Packets;

import DaoOfModding.mlmanimator.Network.Packets.Packet;
import DaoOfModding.mlmanimator.Server.ServerBoundingBoxHandler;
import DaoOfModding.mlmanimator.mlmanimator;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.network.NetworkEvent;

public class EyeHeightPacket
extends Packet {
    float eyeHeight;

    public EyeHeightPacket(float height) {
        this.eyeHeight = height;
    }

    @Override
    public void encode(FriendlyByteBuf buffer) {
        buffer.writeFloat(this.eyeHeight);
    }

    public static EyeHeightPacket decode(FriendlyByteBuf buffer) {
        EyeHeightPacket returnValue = new EyeHeightPacket(0.0f);
        try {
            float height = buffer.readFloat();
            return new EyeHeightPacket(height);
        }
        catch (IllegalArgumentException | IndexOutOfBoundsException e) {
            mlmanimator.LOGGER.warn("Exception while reading EyeHeight message: " + e);
            return returnValue;
        }
    }

    @Override
    public void handle(Supplier<NetworkEvent.Context> ctxSupplier) {
        NetworkEvent.Context ctx = ctxSupplier.get();
        LogicalSide sideReceived = ctx.getDirection().getReceptionSide();
        ctx.setPacketHandled(true);
        if (sideReceived.isClient()) {
            mlmanimator.LOGGER.warn("EyeHeightPacket was received by client - This should not happen");
            return;
        }
        ctx.enqueueWork(() -> this.processPacket(ctx.getSender()));
    }

    protected void processPacket(ServerPlayer sender) {
        ServerBoundingBoxHandler.setEyeHeight(sender.m_20148_(), this.eyeHeight);
    }
}

