/*
 * Decompiled with CFR 0.152.
 */
package DaoOfModding.Cultivationcraft.Client.Animations;

import DaoOfModding.Cultivationcraft.Client.Animations.GenericCultivatorTextureValues;
import DaoOfModding.Cultivationcraft.Client.Animations.QiResizers;
import DaoOfModding.Cultivationcraft.Client.Animations.QuadCollection;
import DaoOfModding.Cultivationcraft.Client.Textures.TextureList;
import DaoOfModding.mlmanimator.Client.AnimationFramework.resizeModule;
import DaoOfModding.mlmanimator.Client.Models.ExtendableModelRenderer;
import DaoOfModding.mlmanimator.Client.Models.GenericResizers;
import DaoOfModding.mlmanimator.Client.Models.GenericTextureValues;
import DaoOfModding.mlmanimator.Client.Models.ParticleEmitter;
import DaoOfModding.mlmanimator.Client.Models.Quads.Quad;
import DaoOfModding.mlmanimator.Client.Models.Quads.QuadLinkage;
import DaoOfModding.mlmanimator.Client.Models.defaultResizeModule;
import DaoOfModding.mlmanimator.Client.Poses.PoseHandler;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.UUID;
import net.minecraft.client.model.geom.builders.UVPair;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.world.phys.Vec3;

public class BodyPartModels {
    protected HashMap<String, ExtendableModelRenderer> models = new HashMap();
    protected HashMap<String, HashMap<String, ExtendableModelRenderer>> nonRenderingModels = new HashMap();
    protected HashMap<String, QuadCollection> quads = new HashMap();
    protected HashMap<String, ArrayList<QuadLinkage>> quadLinks = new HashMap();
    protected boolean slim = false;

    public BodyPartModels(UUID playerID) {
        this.slim = PoseHandler.getPlayerPoseHandler((UUID)playerID).isSlim();
        this.setupBodyModels();
        this.setupHeadModels();
        this.setupLegModels();
        this.setupArmModels();
        this.setupBackModels();
    }

    public ArrayList<QuadLinkage> getQuadLinks(String position) {
        if (!this.quadLinks.containsKey(position)) {
            this.quadLinks.put(position, new ArrayList());
        }
        return this.quadLinks.get(position);
    }

    protected void addQuadLink(String position, QuadLinkage link) {
        this.getQuadLinks(position).add(link);
    }

    public void transferQuadLinks(String position, ExtendableModelRenderer model) {
        for (QuadLinkage link : this.getQuadLinks(position)) {
            model.addQuadLinkage(link);
        }
    }

    protected void setupBodyModels() {
        ExtendableModelRenderer body = new ExtendableModelRenderer("Body");
        GenericCultivatorTextureValues.addGenericBodyLayers(body);
        body.setPos(0.0f, 0.0f, 0.0f);
        body.setRotationPoint(new Vec3(0.5, 0.5, 0.5));
        body.extend(GenericResizers.getBodyResizer());
        this.addModel("Body", body);
        ExtendableModelRenderer shortbody = new ExtendableModelRenderer("SHORT_BODY");
        GenericCultivatorTextureValues.addGenericBodyLayers(shortbody);
        shortbody.setPos(0.0f, 0.0f, 0.0f);
        shortbody.setRotationPoint(new Vec3(0.5, 0.5, 0.5));
        shortbody.setDefaultResize(new Vec3(1.0, 0.5, 1.0));
        shortbody.extend(GenericResizers.getBodyResizer());
        this.addModel("SHORT_BODY", shortbody);
    }

    protected void setupArmModels() {
        ExtendableModelRenderer rightArm = new ExtendableModelRenderer("Right_Arm");
        GenericCultivatorTextureValues.addGenericRightArmLayers(rightArm);
        rightArm.setRotationPoint(new Vec3(0.5, 0.66, 0.5));
        rightArm.setPos(0.0f, 0.0f, 0.5f);
        if (this.slim) {
            rightArm.setFixedPosAdjustment(-1.5f, 2.0f, 0.0f);
        } else {
            rightArm.setFixedPosAdjustment(-2.0f, 2.0f, 0.0f);
        }
        if (this.slim) {
            rightArm.extend(GenericResizers.getSlimArmResizer());
        } else {
            rightArm.extend(GenericResizers.getArmResizer());
        }
        rightArm.setHands(true);
        ((ExtendableModelRenderer)rightArm.getChildren().get(0)).setHands(true);
        ExtendableModelRenderer leftArm = new ExtendableModelRenderer("Left_Arm");
        GenericCultivatorTextureValues.addGenericLeftArmLayers(leftArm);
        leftArm.setRotationPoint(new Vec3(0.5, 0.66, 0.5));
        leftArm.setPos(1.0f, 0.0f, 0.5f);
        if (this.slim) {
            leftArm.setFixedPosAdjustment(1.5f, 2.0f, 0.0f);
        } else {
            leftArm.setFixedPosAdjustment(2.0f, 2.0f, 0.0f);
        }
        if (this.slim) {
            leftArm.extend(GenericResizers.getSlimArmResizer());
        } else {
            leftArm.extend(GenericResizers.getArmResizer());
        }
        leftArm.setHands(true);
        ((ExtendableModelRenderer)leftArm.getChildren().get(0)).setHands(true);
        leftArm.setHitbox(false);
        rightArm.setHitbox(false);
        this.addModel("Left_Arm", leftArm);
        this.addReference("Left_Arm", "Lower_Left_Arm", (ExtendableModelRenderer)leftArm.getChildren().get(0));
        this.addModel("Right_Arm", rightArm);
        this.addReference("Right_Arm", "Lower_Right_Arm", (ExtendableModelRenderer)rightArm.getChildren().get(0));
        ExtendableModelRenderer lFlipper = leftArm.clone();
        ExtendableModelRenderer rFlipper = rightArm.clone();
        lFlipper.setDefaultResize(new Vec3(0.1, 1.0, 1.0));
        rFlipper.setDefaultResize(new Vec3(0.1, 1.0, 1.0));
        ((ExtendableModelRenderer)lFlipper.getChildren().get(0)).setDefaultResize(new Vec3(0.1, 1.0, 1.0));
        ((ExtendableModelRenderer)rFlipper.getChildren().get(0)).setDefaultResize(new Vec3(0.1, 1.0, 1.0));
        lFlipper.setFixedPosAdjustment(0.0f, 2.0f, 0.0f);
        rFlipper.setFixedPosAdjustment(0.0f, 2.0f, 0.0f);
        lFlipper.generateCube();
        rFlipper.generateCube();
        lFlipper.setHands(true);
        ((ExtendableModelRenderer)lFlipper.getChildren().get(0)).setHands(true);
        rFlipper.setHands(true);
        ((ExtendableModelRenderer)rFlipper.getChildren().get(0)).setHands(true);
        lFlipper.setHitbox(false);
        rFlipper.setHitbox(false);
        this.addModel("FLIPPER_ARM_LEFT_MODEL", lFlipper);
        this.addReference("FLIPPER_ARM_LEFT_MODEL", "FLIPPER_ARM_LOWER_LEFT_MODEL", (ExtendableModelRenderer)lFlipper.getChildren().get(0));
        this.addModel("FLIPPER_ARM_RIGHT_MODEL", rFlipper);
        this.addReference("FLIPPER_ARM_RIGHT_MODEL", "FLIPPER_ARM_LOWER_RIGHT_MODEL", (ExtendableModelRenderer)rFlipper.getChildren().get(0));
        ExtendableModelRenderer leftLongArm = leftArm.clone();
        ExtendableModelRenderer rightLongArm = rightArm.clone();
        leftLongArm.setDefaultResize(new Vec3(1.0, 1.5, 1.0));
        rightLongArm.setDefaultResize(new Vec3(1.0, 1.5, 1.0));
        ((ExtendableModelRenderer)leftLongArm.getChildren().get(0)).setDefaultResize(new Vec3(1.0, 1.5, 1.0));
        ((ExtendableModelRenderer)rightLongArm.getChildren().get(0)).setDefaultResize(new Vec3(1.0, 1.5, 1.0));
        leftLongArm.setFixedPosAdjustment(2.0f, 2.0f, 0.0f);
        rightLongArm.setFixedPosAdjustment(-2.0f, 2.0f, 0.0f);
        leftLongArm.generateCube();
        rightLongArm.generateCube();
        leftLongArm.setHands(true);
        ((ExtendableModelRenderer)leftLongArm.getChildren().get(0)).setHands(true);
        rightLongArm.setHands(true);
        ((ExtendableModelRenderer)rightLongArm.getChildren().get(0)).setHands(true);
        leftLongArm.setHitbox(false);
        rightLongArm.setHitbox(false);
        this.addModel("LONG_ARM_LEFT_MODEL", leftLongArm);
        this.addReference("LONG_ARM_LEFT_MODEL", "LONG_ARM_LOWER_LEFT_MODEL", (ExtendableModelRenderer)leftLongArm.getChildren().get(0));
        this.addModel("LONG_ARM_RIGHT_MODEL", rightLongArm);
        this.addReference("LONG_ARM_RIGHT_MODEL", "LONG_ARM_LOWER_RIGHT_MODEL", (ExtendableModelRenderer)rightLongArm.getChildren().get(0));
        ExtendableModelRenderer leftBulkyArm = leftArm.clone();
        ExtendableModelRenderer rightBulkyArm = rightArm.clone();
        leftBulkyArm.setDefaultResize(new Vec3(1.5, 0.75, 1.5));
        rightBulkyArm.setDefaultResize(new Vec3(1.5, 0.75, 1.5));
        ((ExtendableModelRenderer)leftBulkyArm.getChildren().get(0)).setDefaultResize(new Vec3(1.5, 0.75, 1.5));
        ((ExtendableModelRenderer)rightBulkyArm.getChildren().get(0)).setDefaultResize(new Vec3(1.5, 0.75, 1.5));
        leftBulkyArm.setFixedPosAdjustment(2.0f, 2.0f, 0.0f);
        rightBulkyArm.setFixedPosAdjustment(-2.0f, 2.0f, 0.0f);
        leftBulkyArm.generateCube();
        rightBulkyArm.generateCube();
        leftBulkyArm.setHands(true);
        ((ExtendableModelRenderer)leftBulkyArm.getChildren().get(0)).setHands(true);
        rightBulkyArm.setHands(true);
        ((ExtendableModelRenderer)rightBulkyArm.getChildren().get(0)).setHands(true);
        leftBulkyArm.setHitbox(false);
        rightBulkyArm.setHitbox(false);
        this.addModel("BULKY_ARM_LEFT_MODEL", leftBulkyArm);
        this.addReference("BULKY_ARM_LEFT_MODEL", "BULKY_ARM_LOWER_LEFT_MODEL", (ExtendableModelRenderer)leftBulkyArm.getChildren().get(0));
        this.addModel("BULKY_ARM_RIGHT_MODEL", rightBulkyArm);
        this.addReference("BULKY_ARM_RIGHT_MODEL", "BULKY_ARM_LOWER_RIGHT_MODEL", (ExtendableModelRenderer)rightBulkyArm.getChildren().get(0));
        ExtendableModelRenderer shortRightArm = new ExtendableModelRenderer("SHORT_ARM_RIGHT_MODEL");
        GenericCultivatorTextureValues.addGenericRightArmLayers(shortRightArm);
        shortRightArm.setRotationPoint(new Vec3(0.5, 0.66, 0.5));
        shortRightArm.setPos(0.0f, 0.0f, 0.5f);
        shortRightArm.setDefaultResize(new Vec3(1.0, 0.5, 1.0));
        if (this.slim) {
            shortRightArm.setFixedPosAdjustment(-1.5f, 2.0f, 0.0f);
        } else {
            shortRightArm.setFixedPosAdjustment(-2.0f, 2.0f, 0.0f);
        }
        if (this.slim) {
            shortRightArm.extend((resizeModule)new defaultResizeModule(new Vec3(3.0, 12.0, 4.0)));
        } else {
            shortRightArm.extend((resizeModule)new defaultResizeModule(new Vec3(4.0, 12.0, 4.0)));
        }
        shortRightArm.setHands(true);
        ExtendableModelRenderer shortLeftArm = new ExtendableModelRenderer("SHORT_ARM_LEFT_MODEL");
        GenericCultivatorTextureValues.addGenericLeftArmLayers(shortLeftArm);
        shortLeftArm.setRotationPoint(new Vec3(0.5, 0.66, 0.5));
        shortLeftArm.setPos(1.0f, 0.0f, 0.5f);
        shortLeftArm.setDefaultResize(new Vec3(1.0, 0.5, 1.0));
        if (this.slim) {
            shortLeftArm.setFixedPosAdjustment(1.5f, 2.0f, 0.0f);
        } else {
            shortLeftArm.setFixedPosAdjustment(1.5f, 2.0f, 0.0f);
        }
        if (this.slim) {
            shortLeftArm.extend((resizeModule)new defaultResizeModule(new Vec3(3.0, 12.0, 4.0)));
        } else {
            shortLeftArm.extend((resizeModule)new defaultResizeModule(new Vec3(4.0, 12.0, 4.0)));
        }
        shortLeftArm.setHands(true);
        shortLeftArm.setHitbox(false);
        shortRightArm.setHitbox(false);
        this.addModel("SHORT_ARM_LEFT_MODEL", shortLeftArm);
        this.addModel("SHORT_ARM_RIGHT_MODEL", shortRightArm);
        Quad larmConnector = new Quad(new Vec3(0.0, 0.0, 0.0), new Vec3(0.0, 0.0, 0.0), new Vec3(0.0, 0.0, 0.0), new Vec3(0.0, 0.0, 0.0));
        Quad rarmConnector = new Quad(new Vec3(0.0, 0.0, 0.0), new Vec3(0.0, 0.0, 0.0), new Vec3(0.0, 0.0, 0.0), new Vec3(0.0, 0.0, 0.0));
        this.addQuadLink("BODY", new QuadLinkage(larmConnector, Quad.QuadVertex.TopLeft, new Vec3(1.0, 0.0, 0.5)));
        this.addQuadLink("BODY", new QuadLinkage(larmConnector, Quad.QuadVertex.TopRight, new Vec3(1.0, 1.0, 0.5)));
        this.addQuadLink("BODY", new QuadLinkage(rarmConnector, Quad.QuadVertex.TopLeft, new Vec3(0.0, 0.0, 0.5)));
        this.addQuadLink("BODY", new QuadLinkage(rarmConnector, Quad.QuadVertex.BottomLeft, new Vec3(0.0, 1.0, 0.5)));
        this.getModel("Left_Arm").addQuadLinkage(new QuadLinkage(larmConnector, Quad.QuadVertex.BottomLeft, new Vec3(0.0, 1.0, 0.5)));
        ((ExtendableModelRenderer)this.getModel("Left_Arm").getChildren().get(0)).addQuadLinkage(new QuadLinkage(larmConnector, Quad.QuadVertex.BottomRight, new Vec3(0.0, 0.5, 0.5)));
        this.getModel("Right_Arm").addQuadLinkage(new QuadLinkage(rarmConnector, Quad.QuadVertex.TopRight, new Vec3(1.0, 1.0, 0.5)));
        ((ExtendableModelRenderer)this.getModel("Right_Arm").getChildren().get(0)).addQuadLinkage(new QuadLinkage(rarmConnector, Quad.QuadVertex.BottomRight, new Vec3(1.0, 0.5, 0.5)));
        larmConnector.addLayer(new UVPair(0.0f, 0.0f), GenericTextureValues.skin_Size, 0.0f, "BLANK");
        larmConnector.addSmallLayer(new UVPair(0.0f, 0.0f), GenericTextureValues.skin_Size, 0.0f, "SKIN");
        rarmConnector.addLayer(new UVPair(0.0f, 0.0f), GenericTextureValues.skin_Size, 0.0f, "BLANK");
        rarmConnector.addSmallLayer(new UVPair(0.0f, 0.0f), GenericTextureValues.skin_Size, 0.0f, "SKIN");
        QuadCollection glidingArms = new QuadCollection();
        glidingArms.addQuad(larmConnector);
        glidingArms.addQuad(rarmConnector);
        this.addQuadCollection("ARM_GLIDING_QUADS", glidingArms);
        this.setupArmOptions();
    }

    protected void setupArmOptions() {
    }

    protected void setupHeadModels() {
        defaultResizeModule neckResizer = new defaultResizeModule(9, new Vec3(0.0, -1.0, 0.0), new Vec3(0.5, 1.0, 0.5), new Vec3(8.0, 8.0, 8.0), new Vec3(0.5, -1.0, 0.5));
        ExtendableModelRenderer neckPart = new ExtendableModelRenderer("LONG_NECK_MODEL");
        GenericCultivatorTextureValues.addGenericHeadLayers(neckPart, 0, 7);
        neckPart.setRotationPoint(new Vec3(0.5, 0.0, 0.5));
        neckPart.setPos(0.5f, 0.0f, 0.5f);
        neckPart.setDefaultResize(new Vec3(0.5, 1.0, 0.5));
        neckPart.extend((resizeModule)neckResizer);
        ExtendableModelRenderer neckExplorer = neckPart;
        while (neckExplorer.getChildren().size() > 0) {
            neckExplorer = (ExtendableModelRenderer)neckExplorer.getChildren().get(0);
            neckExplorer.setDefaultResize(new Vec3(0.5, 1.0, 0.5));
        }
        this.addModel("LONG_NECK_MODEL", neckPart);
        this.addReference("LONG_NECK_MODEL", "LONG_NECK_MODEL_END", neckExplorer);
        defaultResizeModule semiHeadResizer = new defaultResizeModule(new Vec3(8.0, 5.0, 8.0));
        defaultResizeModule jawResizer = new defaultResizeModule(new Vec3(8.0, 3.0, 8.0));
        ExtendableModelRenderer semiHeadPart = new ExtendableModelRenderer("JAW_MODEL1");
        GenericCultivatorTextureValues.addGenericHeadLayers(semiHeadPart);
        semiHeadPart.setRotationPoint(new Vec3(0.5, 0.0, 0.5));
        semiHeadPart.setPos(0.5f, 0.0f, 0.5f);
        semiHeadPart.setFixedPosAdjustment(0.0f, -3.0f, 0.0f);
        semiHeadPart.extend((resizeModule)semiHeadResizer);
        semiHeadPart.setLooking(true);
        semiHeadPart.setFirstPersonRender(false);
        semiHeadPart.setHitbox(false);
        ExtendableModelRenderer jawPart = new ExtendableModelRenderer("JAW_MODEL2");
        jawPart.addLayer(new UVPair(GenericTextureValues.head.m_171612_(), GenericTextureValues.head.m_171613_() + 5.0f), GenericTextureValues.skin_Size, 0.0f, "PLAYERSKIN");
        jawPart.addLayer(new UVPair(GenericTextureValues.hat.m_171612_(), GenericTextureValues.hat.m_171613_() + 5.0f), GenericTextureValues.skin_Size, 0.51f, "PLAYERSKIN", Direction.UP);
        jawPart.addLayer(new UVPair(GenericTextureValues.head.m_171612_(), GenericTextureValues.head.m_171613_() + 5.0f), GenericTextureValues.armor_Size, 1.01f, "HEADARMOR", Direction.UP);
        jawPart.addLayer(new UVPair(GenericTextureValues.head.m_171612_(), GenericTextureValues.head.m_171613_() + 5.0f), GenericTextureValues.skin_Size, 0.0f, "SKIN", false, 4.0f);
        jawPart.addLayer(new UVPair(GenericTextureValues.hat.m_171612_(), GenericTextureValues.hat.m_171613_() + 5.0f), GenericTextureValues.skin_Size, 0.5f, "SKIN", false, 4.0f, Direction.UP);
        jawPart.setRotationPoint(new Vec3(0.5, 1.0, 0.3));
        jawPart.setPos(0.5f, 1.0f, 0.7f);
        jawPart.extend((resizeModule)jawResizer);
        jawPart.setFirstPersonRender(false);
        jawPart.setUsedSize(new Vec3(0.0, 5.0, 0.0));
        jawPart.setHitbox(false);
        semiHeadPart.addChild(jawPart);
        this.addModel("JAW_MODEL", semiHeadPart);
        this.addReference("JAW_MODEL", "JAW_LOWER_MODEL", jawPart);
        this.setupTeethModels();
        semiHeadResizer = new defaultResizeModule(new Vec3(8.0, 5.0, 8.0));
        jawResizer = new defaultResizeModule(new Vec3(8.0, 3.0, 8.0));
        ExtendableModelRenderer FPsemiHeadPart = new ExtendableModelRenderer("FP_JAW_MODEL1");
        FPsemiHeadPart.addLayer(GenericTextureValues.head, GenericTextureValues.skin_Size, 0.0f, "PLAYERSKIN");
        FPsemiHeadPart.addLayer(GenericTextureValues.head, GenericTextureValues.skin_Size, 0.0f, "SKIN", false, 4.0f);
        FPsemiHeadPart.setRotationPoint(new Vec3(0.5, 0.0, 0.5));
        FPsemiHeadPart.setPos(0.0f, 0.0f, 0.5f);
        FPsemiHeadPart.setFixedPosAdjustment(0.0f, -0.5f, -1.25f);
        FPsemiHeadPart.extend((resizeModule)semiHeadResizer);
        FPsemiHeadPart.setLooking(true);
        FPsemiHeadPart.setHitbox(false);
        FPsemiHeadPart.setNoResize(Boolean.valueOf(true));
        ExtendableModelRenderer FPjawPart = new ExtendableModelRenderer("FP_JAW_MODEL2");
        FPjawPart.addLayer(new UVPair(GenericTextureValues.head.m_171612_(), GenericTextureValues.head.m_171613_() + 5.0f), GenericTextureValues.skin_Size, 0.01f, "PLAYERSKIN");
        FPjawPart.addLayer(new UVPair(GenericTextureValues.head.m_171612_(), GenericTextureValues.head.m_171613_() + 5.0f), GenericTextureValues.skin_Size, 0.0f, "SKIN", false, 4.0f);
        FPjawPart.setRotationPoint(new Vec3(0.5, 1.0, 0.0));
        FPjawPart.setPos(0.5f, 1.0f, 0.7f);
        FPjawPart.setFixedPosAdjustment(0.0f, -2.0f, 2.0f);
        FPjawPart.extend((resizeModule)jawResizer);
        FPjawPart.setUsedSize(new Vec3(0.0, 5.0, 0.0));
        FPjawPart.setHitbox(false);
        FPjawPart.setNoResize(Boolean.valueOf(true));
        FPsemiHeadPart.addChild(FPjawPart);
        this.addModel("FP_JAW_MODEL", FPsemiHeadPart);
        this.addReference("FP_JAW_MODEL", "FP_JAW_LOWER_MODEL", FPjawPart);
        this.setupHeadOptions();
    }

    protected void setupHeadOptions() {
        Quad finQuad = new Quad(new Vec3(0.0, 0.0, 0.0), new Vec3(0.0, 0.0, 0.0), new Vec3(0.0, 0.0, 0.0), new Vec3(0.0, 0.0, 0.0));
        this.addQuadLink("HEAD", new QuadLinkage(finQuad, Quad.QuadVertex.TopLeft, new Vec3(0.5, 0.0, 0.2)));
        this.addQuadLink("HEAD", new QuadLinkage(finQuad, Quad.QuadVertex.BottomLeft, new Vec3(0.5, 0.0, 0.8)));
        this.addQuadLink("HEAD", new QuadLinkage(finQuad, Quad.QuadVertex.BottomRight, new Vec3(0.5, 0.0, 0.8)));
        this.addQuadLink("HEAD", new QuadLinkage(finQuad, Quad.QuadVertex.TopRight, new Vec3(0.5, -2.0, 0.8)));
        finQuad.addLayer(new UVPair(0.0f, 0.0f), GenericTextureValues.skin_Size, 0.0f, "PLAYERSKIN", new UVPair(12.0f / GenericTextureValues.skin_Size.m_171612_(), 4.0f / GenericTextureValues.skin_Size.m_171613_()));
        finQuad.addSmallLayer(new UVPair(0.0f, 0.0f), GenericTextureValues.skin_Size, 0.0f, "SKIN");
        QuadCollection finQuads = new QuadCollection();
        finQuads.addQuad(finQuad);
        this.addQuadCollection("HEAD_FIN_QUAD", finQuads);
        ExtendableModelRenderer flowerPart = new ExtendableModelRenderer("HEAD_FLOWER_MODEL");
        flowerPart.addLayer(new UVPair(GenericTextureValues.head.m_171612_() + 12.0f, GenericTextureValues.head.m_171613_() + 4.0f), GenericTextureValues.skin_Size, 0.01f, "PLAYERSKIN");
        flowerPart.setRotationPoint(new Vec3(0.5, 1.0, 0.5));
        flowerPart.setPos(0.5f, 0.0f, 0.5f);
        flowerPart.extend((resizeModule)new defaultResizeModule(new Vec3(1.0, -0.5, 1.0)));
        flowerPart.setHitbox(false);
        flowerPart.setFirstPersonRender(false);
        QuadCollection flowerQuads = new QuadCollection();
        this.addPetals(2.5f, 6.0f, 2.0f, flowerQuads, flowerPart);
        this.addModel("HEAD_FLOWER_MODEL", flowerPart);
        this.addQuadCollection("HEAD_FLOWER_QUADS", flowerQuads);
    }

    protected void addPetals(float petalWidth, float petalLength, float petalLift, QuadCollection flowerQuads, ExtendableModelRenderer flowerPart) {
        this.addPetals(petalWidth, petalLength, petalLift, flowerQuads, flowerPart, 0.0f, 0.0f, 0.0f);
    }

    protected void addPetals(float petalWidth, float petalLength, float petalLift, QuadCollection flowerQuads, ExtendableModelRenderer flowerPart, float baseWidth, float baseLength, float baseLift) {
        petalLift = (float)((double)petalLift + 0.5);
        baseLift = (float)((double)baseLift + 0.5);
        float seperator = 0.25f;
        float zeroWidth = -baseWidth;
        float oneWidth = 1.0f + baseWidth;
        float zeroLength = -baseLength;
        float oneLength = 1.0f + baseLength;
        this.addPetal(new Vec3((double)(zeroWidth - (petalWidth -= seperator)), (double)petalLift, (double)(oneLength + (petalLength -= baseLength))), new Vec3((double)zeroWidth + 0.25, (double)baseLift, (double)oneLength), new Vec3((double)oneWidth - 0.25, (double)baseLift, (double)oneLength), new Vec3((double)(oneWidth + petalWidth), (double)petalLift, (double)(oneLength + petalLength)), flowerQuads, flowerPart);
        this.addPetal(new Vec3((double)(oneWidth + petalWidth), (double)petalLift, (double)(zeroLength - petalLength)), new Vec3((double)oneWidth - 0.25, (double)baseLift, (double)zeroLength), new Vec3((double)zeroWidth + 0.25, (double)baseLift, (double)zeroLength), new Vec3((double)(zeroWidth - petalWidth), (double)petalLift, (double)(zeroLength - petalLength)), flowerQuads, flowerPart);
        this.addPetal(new Vec3((double)(zeroLength - petalLength), (double)petalLift, (double)(zeroWidth - petalWidth)), new Vec3((double)zeroLength, (double)baseLift, (double)zeroWidth + 0.25), new Vec3((double)zeroLength, (double)baseLift, (double)oneWidth - 0.25), new Vec3((double)(zeroLength - petalLength), (double)petalLift, (double)(oneWidth + petalWidth)), flowerQuads, flowerPart);
        this.addPetal(new Vec3((double)(oneLength + petalLength), (double)petalLift, (double)(oneWidth + petalWidth)), new Vec3((double)oneLength, (double)baseLift, (double)oneWidth - 0.25), new Vec3((double)oneLength, (double)baseLift, (double)zeroWidth + 0.25), new Vec3((double)(oneLength + petalLength), (double)petalLift, (double)(zeroWidth - petalWidth)), flowerQuads, flowerPart);
        this.addPetal(new Vec3((double)(oneWidth + (petalWidth += seperator)), (double)petalLift, (double)(oneLength + petalLength)), new Vec3((double)oneWidth - 0.25, (double)baseLift, (double)oneLength), new Vec3((double)oneLength, (double)baseLift, (double)oneWidth - 0.25), new Vec3((double)(oneLength + petalLength), (double)petalLift, (double)(oneWidth + petalWidth)), flowerQuads, flowerPart);
        this.addPetal(new Vec3((double)(oneLength + petalLength), (double)petalLift, (double)(zeroWidth - petalWidth)), new Vec3((double)oneLength, (double)baseLift, (double)zeroWidth + 0.25), new Vec3((double)oneWidth - 0.25, (double)baseLift, (double)zeroLength), new Vec3((double)(oneWidth + petalWidth), (double)petalLift, (double)(zeroLength - petalLength)), flowerQuads, flowerPart);
        this.addPetal(new Vec3((double)(zeroLength - petalLength), (double)petalLift, (double)(oneWidth + petalWidth)), new Vec3((double)zeroLength, (double)baseLift, (double)oneWidth - 0.25), new Vec3((double)zeroWidth + 0.25, (double)baseLift, (double)oneLength), new Vec3((double)(zeroWidth - petalWidth), (double)petalLift, (double)(oneLength + petalLength)), flowerQuads, flowerPart);
        this.addPetal(new Vec3((double)(zeroWidth - petalWidth), (double)petalLift, (double)(zeroLength - petalLength)), new Vec3((double)zeroWidth + 0.25, (double)baseLift, (double)zeroLength), new Vec3((double)zeroLength, (double)baseLift, (double)zeroWidth + 0.25), new Vec3((double)(zeroLength - petalLength), (double)petalLift, (double)(zeroWidth - petalWidth)), flowerQuads, flowerPart);
    }

    protected void addPetal(Vec3 quad1, Vec3 quad2, Vec3 quad3, Vec3 quad4, QuadCollection collection, ExtendableModelRenderer flowerPart) {
        Quad flowerQuad = new Quad(new Vec3(0.0, 0.0, 0.0), new Vec3(0.0, 0.0, 0.0), new Vec3(0.0, 0.0, 0.0), new Vec3(0.0, 0.0, 0.0));
        flowerPart.addQuadLinkage(new QuadLinkage(flowerQuad, Quad.QuadVertex.TopLeft, quad1));
        flowerPart.addQuadLinkage(new QuadLinkage(flowerQuad, Quad.QuadVertex.BottomLeft, quad2));
        flowerPart.addQuadLinkage(new QuadLinkage(flowerQuad, Quad.QuadVertex.BottomRight, quad3));
        flowerPart.addQuadLinkage(new QuadLinkage(flowerQuad, Quad.QuadVertex.TopRight, quad4));
        flowerQuad.addLayer(new UVPair(0.0f, 0.0f), TextureList.petalSize, 0.0f, "PETAL");
        flowerQuad.setRenderFirstPerson(false);
        collection.addQuad(flowerQuad);
    }

    protected void setupBackModels() {
        this.setupWingModels();
        this.setupInsectWingModels();
        this.setupJetModels();
        this.setupFinModels();
    }

    protected void setupFinModels() {
        Quad finQuad = new Quad(new Vec3(0.0, 0.0, 0.0), new Vec3(0.0, 0.0, 0.0), new Vec3(0.0, 0.0, 0.0), new Vec3(0.0, 0.0, 0.0));
        this.addQuadLink("BODY", new QuadLinkage(finQuad, Quad.QuadVertex.TopLeft, new Vec3(0.5, 0.2, 1.0)));
        this.addQuadLink("BODY", new QuadLinkage(finQuad, Quad.QuadVertex.BottomLeft, new Vec3(0.5, 0.8, 1.0)));
        this.addQuadLink("BODY", new QuadLinkage(finQuad, Quad.QuadVertex.BottomRight, new Vec3(0.5, 0.8, 3.0)));
        this.addQuadLink("BODY", new QuadLinkage(finQuad, Quad.QuadVertex.TopRight, new Vec3(0.5, 0.8, 3.0)));
        finQuad.addLayer(new UVPair(0.0f, 0.0f), GenericTextureValues.skin_Size, 0.0f, "PLAYERSKIN", new UVPair(32.0f / GenericTextureValues.skin_Size.m_171612_(), 24.0f / GenericTextureValues.skin_Size.m_171613_()));
        finQuad.addSmallLayer(new UVPair(0.0f, 0.0f), GenericTextureValues.skin_Size, 0.0f, "SKIN");
        QuadCollection finQuads = new QuadCollection();
        finQuads.addQuad(finQuad);
        this.addQuadCollection("DORSAL_QUAD", finQuads);
    }

    protected void setupJetModels() {
        defaultResizeModule jet = new defaultResizeModule(new Vec3(0.1, 0.1, 4.0));
        ExtendableModelRenderer JetModel = new ExtendableModelRenderer("JET_LEFT");
        JetModel.addLayer(GenericTextureValues.chest, GenericTextureValues.skin_Size, 0.0f, "PLAYERSKIN");
        JetModel.setPos(0.25f, 0.25f, 1.0f);
        JetModel.setRotationPoint(new Vec3(0.5, 0.5, 1.0));
        JetModel.setDefaultResize(new Vec3(20.0, 5.0, 1.0));
        JetModel.extend((resizeModule)jet);
        jet = new defaultResizeModule(new Vec3(0.1, 0.1, 4.0));
        ExtendableModelRenderer JetModelRight = new ExtendableModelRenderer("JET_RIGHT");
        JetModelRight.addLayer(GenericTextureValues.chest, GenericTextureValues.skin_Size, 0.0f, "PLAYERSKIN");
        JetModelRight.setPos(1.0f, 1.0f, 0.0f);
        JetModelRight.setRotationPoint(new Vec3(0.0, 1.0, 1.0));
        JetModelRight.setDefaultResize(new Vec3(5.0, 10.0, 1.0));
        JetModelRight.extend((resizeModule)jet);
        jet = new defaultResizeModule(new Vec3(0.1, 0.1, 4.0));
        ExtendableModelRenderer JetModelBottom = new ExtendableModelRenderer("JET_LEFT2");
        JetModelBottom.addLayer(GenericTextureValues.chest, GenericTextureValues.skin_Size, 0.0f, "PLAYERSKIN");
        JetModelBottom.setPos(1.0f, 1.0f, 0.0f);
        JetModelBottom.setRotationPoint(new Vec3(0.0, 1.0, 1.0));
        JetModelBottom.setDefaultResize(new Vec3(20.0, 5.0, 1.0));
        JetModelBottom.extend((resizeModule)jet);
        jet = new defaultResizeModule(new Vec3(0.1, 0.1, 4.0));
        ExtendableModelRenderer JetModelLeft = new ExtendableModelRenderer("JET_RIGHT2");
        JetModelLeft.addLayer(GenericTextureValues.chest, GenericTextureValues.skin_Size, 0.0f, "PLAYERSKIN");
        JetModelLeft.setPos(0.0f, 0.0f, 0.0f);
        JetModelLeft.setRotationPoint(new Vec3(1.0, 0.0, 1.0));
        JetModelLeft.setDefaultResize(new Vec3(5.0, 10.0, 1.0));
        JetModelLeft.extend((resizeModule)jet);
        JetModelBottom.addChild(JetModelLeft);
        JetModelRight.addChild(JetModelBottom);
        JetModel.addChild(JetModelRight);
        ExtendableModelRenderer JetRight = JetModel.clone();
        JetRight.setPos(0.75f, 0.25f, 1.0f);
        ParticleEmitter jetSmoke = new ParticleEmitter((ParticleOptions)ParticleTypes.f_123762_, "JET_LEFT_SMOKE");
        jetSmoke.setInterval(20);
        jetSmoke.setVelocity(new Vec3(0.0, 0.0, 0.0));
        jetSmoke.setPos(0.5f, 2.0f, 1.0f);
        ParticleEmitter jetSmokeRight = new ParticleEmitter((ParticleOptions)ParticleTypes.f_123762_, "JET_RIGHT_SMOKE");
        jetSmokeRight.setInterval(20);
        jetSmokeRight.setVelocity(new Vec3(0.0, 0.0, 0.0));
        jetSmokeRight.setPos(0.5f, 2.0f, 1.0f);
        ParticleEmitter jetFlame = new ParticleEmitter((ParticleOptions)ParticleTypes.f_123744_, "JET_LEFT_FLAME");
        jetFlame.setInterval(1);
        jetFlame.setPos(0.5f, 2.0f, 1.0f);
        jetFlame.setVelocity(new Vec3(0.0, 0.0, (double)-0.4f));
        jetFlame.getModelPart().f_104207_ = false;
        ParticleEmitter jetFlameRight = new ParticleEmitter((ParticleOptions)ParticleTypes.f_123744_, "JET_RIGHT_FLAME");
        jetFlameRight.setInterval(1);
        jetFlameRight.setVelocity(new Vec3(0.0, 0.0, (double)-0.4f));
        jetFlameRight.setPos(0.5f, 2.0f, 1.0f);
        jetFlameRight.getModelPart().f_104207_ = false;
        JetModel.addChild((ExtendableModelRenderer)jetSmoke);
        JetRight.addChild((ExtendableModelRenderer)jetSmokeRight);
        JetModel.addChild((ExtendableModelRenderer)jetFlame);
        JetRight.addChild((ExtendableModelRenderer)jetFlameRight);
        this.addModel("JET_LEFT", JetModel);
        this.addModel("JET_RIGHT", JetRight);
        this.addReference("JET_LEFT", "JET_LEFT_SMOKE", (ExtendableModelRenderer)jetSmoke);
        this.addReference("JET_RIGHT", "JET_RIGHT_SMOKE", (ExtendableModelRenderer)jetSmokeRight);
        this.addReference("JET_LEFT", "JET_LEFT_FLAME", (ExtendableModelRenderer)jetFlame);
        this.addReference("JET_RIGHT", "JET_RIGHT_FLAME", (ExtendableModelRenderer)jetFlameRight);
    }

    protected void setupWingModels() {
        defaultResizeModule wingTop = new defaultResizeModule(new Vec3(16.0, 0.5, 1.0));
        defaultResizeModule lwingTop = new defaultResizeModule(new Vec3(-16.0, 0.5, 1.0));
        ExtendableModelRenderer wingTopModel = new ExtendableModelRenderer("RIGHT_WING_UPPER_ARM_MODEL");
        wingTopModel.addLayer(new UVPair(0.0f, 0.0f), TextureList.boneSize, 0.0f, "BONE");
        wingTopModel.setPos(0.5f, 0.25f, 1.0f);
        wingTopModel.setRotationPoint(new Vec3(1.0, 0.5, 0.0));
        wingTopModel.setHitbox(false);
        wingTopModel.extend((resizeModule)wingTop);
        ExtendableModelRenderer lwingTopModel = new ExtendableModelRenderer("LEFT_WING_UPPER_ARM_MODEL");
        lwingTopModel.addLayer(new UVPair(0.0f, 0.0f), TextureList.boneSize, 0.0f, "BONE");
        lwingTopModel.setPos(0.5f, 0.25f, 1.0f);
        lwingTopModel.setRotationPoint(new Vec3(1.0, 0.5, 0.0));
        lwingTopModel.setHitbox(false);
        lwingTopModel.extend((resizeModule)lwingTop);
        defaultResizeModule wingStrand = new defaultResizeModule(new Vec3(0.5, 16.0, 1.0));
        defaultResizeModule lwingStrand = new defaultResizeModule(new Vec3(0.5, 16.0, 1.0));
        ExtendableModelRenderer wingStrandModel = new ExtendableModelRenderer("RIGHT_WING_STRAND_1_MODEL");
        wingStrandModel.addLayer(new UVPair(0.0f, 0.0f), TextureList.boneSize, 0.0f, "BONE");
        wingStrandModel.setPos(1.0f, 1.0f, 0.5f);
        wingStrandModel.setRotationPoint(new Vec3(0.5, 1.0, 0.5));
        wingStrandModel.setHitbox(false);
        wingStrandModel.extend((resizeModule)wingStrand);
        ExtendableModelRenderer lwingStrandModel = new ExtendableModelRenderer("LEFT_WING_STRAND_1_MODEL");
        lwingStrandModel.addLayer(new UVPair(0.0f, 0.0f), TextureList.boneSize, 0.0f, "BONE");
        lwingStrandModel.setPos(1.0f, 1.0f, 0.5f);
        lwingStrandModel.setRotationPoint(new Vec3(0.5, 1.0, 0.5));
        lwingStrandModel.setHitbox(false);
        lwingStrandModel.extend((resizeModule)lwingStrand);
        ExtendableModelRenderer wingStrandModel2 = wingStrandModel.clone();
        ExtendableModelRenderer wingStrandModel3 = wingStrandModel.clone();
        ExtendableModelRenderer wingStrandModel4 = wingStrandModel.clone();
        ExtendableModelRenderer lwingStrandModel2 = lwingStrandModel.clone();
        ExtendableModelRenderer lwingStrandModel3 = lwingStrandModel.clone();
        ExtendableModelRenderer lwingStrandModel4 = lwingStrandModel.clone();
        wingTopModel.addChild(wingStrandModel);
        wingTopModel.addChild(wingStrandModel2);
        wingTopModel.addChild(wingStrandModel3);
        wingTopModel.addChild(wingStrandModel4);
        lwingTopModel.addChild(lwingStrandModel);
        lwingTopModel.addChild(lwingStrandModel2);
        lwingTopModel.addChild(lwingStrandModel3);
        lwingTopModel.addChild(lwingStrandModel4);
        Quad wing12Connector = new Quad(new Vec3(0.0, 0.0, 0.0), new Vec3(0.0, 0.0, 0.0), new Vec3(0.0, 0.0, 0.0), new Vec3(0.0, 0.0, 0.0));
        wingStrandModel.addQuadLinkage(new QuadLinkage(wing12Connector, Quad.QuadVertex.TopLeft, new Vec3(0.0, 0.0, 0.5)));
        wingStrandModel.addQuadLinkage(new QuadLinkage(wing12Connector, Quad.QuadVertex.BottomLeft, new Vec3(0.0, 0.95, 0.5)));
        wingStrandModel2.addQuadLinkage(new QuadLinkage(wing12Connector, Quad.QuadVertex.TopRight, new Vec3(1.0, 0.0, 0.5)));
        wingStrandModel2.addQuadLinkage(new QuadLinkage(wing12Connector, Quad.QuadVertex.BottomRight, new Vec3(1.0, 0.95, 0.5)));
        Quad wing23Connector = new Quad(new Vec3(0.0, 0.0, 0.0), new Vec3(0.0, 0.0, 0.0), new Vec3(0.0, 0.0, 0.0), new Vec3(0.0, 0.0, 0.0));
        wingStrandModel2.addQuadLinkage(new QuadLinkage(wing23Connector, Quad.QuadVertex.TopLeft, new Vec3(0.0, 0.0, 0.5)));
        wingStrandModel2.addQuadLinkage(new QuadLinkage(wing23Connector, Quad.QuadVertex.BottomLeft, new Vec3(0.0, 0.95, 0.5)));
        wingStrandModel3.addQuadLinkage(new QuadLinkage(wing23Connector, Quad.QuadVertex.TopRight, new Vec3(1.0, 0.0, 0.5)));
        wingStrandModel3.addQuadLinkage(new QuadLinkage(wing23Connector, Quad.QuadVertex.BottomRight, new Vec3(1.0, 0.95, 0.5)));
        Quad wing34Connector = new Quad(new Vec3(0.0, 0.0, 0.0), new Vec3(0.0, 0.0, 0.0), new Vec3(0.0, 0.0, 0.0), new Vec3(0.0, 0.0, 0.0));
        wingStrandModel3.addQuadLinkage(new QuadLinkage(wing34Connector, Quad.QuadVertex.TopLeft, new Vec3(0.0, 0.0, 0.5)));
        wingStrandModel3.addQuadLinkage(new QuadLinkage(wing34Connector, Quad.QuadVertex.BottomLeft, new Vec3(0.0, 0.95, 0.5)));
        wingStrandModel4.addQuadLinkage(new QuadLinkage(wing34Connector, Quad.QuadVertex.TopRight, new Vec3(1.0, 0.0, 0.5)));
        wingStrandModel4.addQuadLinkage(new QuadLinkage(wing34Connector, Quad.QuadVertex.BottomRight, new Vec3(1.0, 0.95, 0.5)));
        Quad wing45Connector = new Quad(new Vec3(0.0, 0.0, 0.0), new Vec3(0.0, 0.0, 0.0), new Vec3(0.0, 0.0, 0.0), new Vec3(0.0, 0.0, 0.0));
        wingStrandModel4.addQuadLinkage(new QuadLinkage(wing45Connector, Quad.QuadVertex.TopLeft, new Vec3(0.0, 0.0, 0.5)));
        wingStrandModel4.addQuadLinkage(new QuadLinkage(wing45Connector, Quad.QuadVertex.BottomLeft, new Vec3(0.0, 0.95, 0.5)));
        wingTopModel.addQuadLinkage(new QuadLinkage(wing45Connector, Quad.QuadVertex.TopRight, new Vec3(1.0, 0.0, 0.5)));
        wingTopModel.addQuadLinkage(new QuadLinkage(wing45Connector, Quad.QuadVertex.BottomRight, new Vec3(0.0, 0.0, 0.5)));
        Quad lwing12Connector = new Quad(new Vec3(0.0, 0.0, 0.0), new Vec3(0.0, 0.0, 0.0), new Vec3(0.0, 0.0, 0.0), new Vec3(0.0, 0.0, 0.0));
        lwingStrandModel.addQuadLinkage(new QuadLinkage(lwing12Connector, Quad.QuadVertex.TopLeft, new Vec3(0.0, 0.0, 0.5)));
        lwingStrandModel.addQuadLinkage(new QuadLinkage(lwing12Connector, Quad.QuadVertex.TopRight, new Vec3(0.0, 0.95, 0.5)));
        lwingStrandModel2.addQuadLinkage(new QuadLinkage(lwing12Connector, Quad.QuadVertex.BottomLeft, new Vec3(1.0, 0.0, 0.5)));
        lwingStrandModel2.addQuadLinkage(new QuadLinkage(lwing12Connector, Quad.QuadVertex.BottomRight, new Vec3(1.0, 0.95, 0.5)));
        Quad lwing23Connector = new Quad(new Vec3(0.0, 0.0, 0.0), new Vec3(0.0, 0.0, 0.0), new Vec3(0.0, 0.0, 0.0), new Vec3(0.0, 0.0, 0.0));
        lwingStrandModel2.addQuadLinkage(new QuadLinkage(lwing23Connector, Quad.QuadVertex.TopLeft, new Vec3(0.0, 0.0, 0.5)));
        lwingStrandModel2.addQuadLinkage(new QuadLinkage(lwing23Connector, Quad.QuadVertex.TopRight, new Vec3(0.0, 0.95, 0.5)));
        lwingStrandModel3.addQuadLinkage(new QuadLinkage(lwing23Connector, Quad.QuadVertex.BottomLeft, new Vec3(1.0, 0.0, 0.5)));
        lwingStrandModel3.addQuadLinkage(new QuadLinkage(lwing23Connector, Quad.QuadVertex.BottomRight, new Vec3(1.0, 0.95, 0.5)));
        Quad lwing34Connector = new Quad(new Vec3(0.0, 0.0, 0.0), new Vec3(0.0, 0.0, 0.0), new Vec3(0.0, 0.0, 0.0), new Vec3(0.0, 0.0, 0.0));
        lwingStrandModel3.addQuadLinkage(new QuadLinkage(lwing34Connector, Quad.QuadVertex.TopLeft, new Vec3(0.0, 0.0, 0.5)));
        lwingStrandModel3.addQuadLinkage(new QuadLinkage(lwing34Connector, Quad.QuadVertex.TopRight, new Vec3(0.0, 0.95, 0.5)));
        lwingStrandModel4.addQuadLinkage(new QuadLinkage(lwing34Connector, Quad.QuadVertex.BottomLeft, new Vec3(1.0, 0.0, 0.5)));
        lwingStrandModel4.addQuadLinkage(new QuadLinkage(lwing34Connector, Quad.QuadVertex.BottomRight, new Vec3(1.0, 0.95, 0.5)));
        Quad lwing45Connector = new Quad(new Vec3(0.0, 0.0, 0.0), new Vec3(0.0, 0.0, 0.0), new Vec3(0.0, 0.0, 0.0), new Vec3(0.0, 0.0, 0.0));
        lwingStrandModel4.addQuadLinkage(new QuadLinkage(lwing45Connector, Quad.QuadVertex.TopLeft, new Vec3(0.0, 0.0, 0.5)));
        lwingStrandModel4.addQuadLinkage(new QuadLinkage(lwing45Connector, Quad.QuadVertex.TopRight, new Vec3(0.0, 0.95, 0.5)));
        lwingTopModel.addQuadLinkage(new QuadLinkage(lwing45Connector, Quad.QuadVertex.BottomLeft, new Vec3(1.0, 0.0, 0.5)));
        lwingTopModel.addQuadLinkage(new QuadLinkage(lwing45Connector, Quad.QuadVertex.BottomRight, new Vec3(0.0, 0.0, 0.5)));
        QuadCollection wingQuads = new QuadCollection();
        wingQuads.addQuad(wing12Connector);
        wingQuads.addQuad(wing23Connector);
        wingQuads.addQuad(wing34Connector);
        wingQuads.addQuad(wing45Connector);
        wingQuads.addQuad(lwing12Connector);
        wingQuads.addQuad(lwing23Connector);
        wingQuads.addQuad(lwing34Connector);
        wingQuads.addQuad(lwing45Connector);
        wing12Connector.addLayer(new UVPair(0.0f, 0.0f), GenericTextureValues.skin_Size, 0.0f, "BLANK");
        wing23Connector.addLayer(new UVPair(0.0f, 0.0f), GenericTextureValues.skin_Size, 0.0f, "BLANK");
        wing34Connector.addLayer(new UVPair(0.0f, 0.0f), GenericTextureValues.skin_Size, 0.0f, "BLANK");
        wing45Connector.addLayer(new UVPair(0.0f, 0.0f), GenericTextureValues.skin_Size, 0.0f, "BLANK");
        wing12Connector.addLayer(new UVPair(0.0f, 0.0f), GenericTextureValues.skin_Size, 0.0f, "BLANK");
        lwing12Connector.addLayer(new UVPair(0.0f, 0.0f), GenericTextureValues.skin_Size, 0.0f, "BLANK");
        lwing23Connector.addLayer(new UVPair(0.0f, 0.0f), GenericTextureValues.skin_Size, 0.0f, "BLANK");
        lwing34Connector.addLayer(new UVPair(0.0f, 0.0f), GenericTextureValues.skin_Size, 0.0f, "BLANK");
        lwing45Connector.addLayer(new UVPair(0.0f, 0.0f), GenericTextureValues.skin_Size, 0.0f, "BLANK");
        wing12Connector.addSmallLayer(new UVPair(0.0f, 0.0f), GenericTextureValues.skin_Size, 0.0f, "SKIN");
        wing23Connector.addSmallLayer(new UVPair(0.0f, 0.0f), GenericTextureValues.skin_Size, 0.0f, "SKIN");
        wing34Connector.addSmallLayer(new UVPair(0.0f, 0.0f), GenericTextureValues.skin_Size, 0.0f, "SKIN");
        wing45Connector.addSmallLayer(new UVPair(0.0f, 0.0f), GenericTextureValues.skin_Size, 0.0f, "SKIN");
        lwing12Connector.addSmallLayer(new UVPair(0.0f, 0.0f), GenericTextureValues.skin_Size, 0.0f, "SKIN");
        lwing23Connector.addSmallLayer(new UVPair(0.0f, 0.0f), GenericTextureValues.skin_Size, 0.0f, "SKIN");
        lwing34Connector.addSmallLayer(new UVPair(0.0f, 0.0f), GenericTextureValues.skin_Size, 0.0f, "SKIN");
        lwing45Connector.addSmallLayer(new UVPair(0.0f, 0.0f), GenericTextureValues.skin_Size, 0.0f, "SKIN");
        this.addModel("RIGHT_WING_UPPER_ARM_MODEL", wingTopModel);
        this.addReference("RIGHT_WING_UPPER_ARM_MODEL", "RIGHT_WING_STRAND_1_MODEL", wingStrandModel);
        this.addReference("RIGHT_WING_UPPER_ARM_MODEL", "RIGHT_WING_STRAND_2_MODEL", wingStrandModel2);
        this.addReference("RIGHT_WING_UPPER_ARM_MODEL", "RIGHT_WING_STRAND_3_MODEL", wingStrandModel3);
        this.addReference("RIGHT_WING_UPPER_ARM_MODEL", "RIGHT_WING_STRAND_4_MODEL", wingStrandModel4);
        this.addModel("LEFT_WING_UPPER_ARM_MODEL", lwingTopModel);
        this.addReference("LEFT_WING_UPPER_ARM_MODEL", "LEFT_WING_STRAND_1_MODEL", lwingStrandModel);
        this.addReference("LEFT_WING_UPPER_ARM_MODEL", "LEFT_WING_STRAND_2_MODEL", lwingStrandModel2);
        this.addReference("LEFT_WING_UPPER_ARM_MODEL", "LEFT_WING_STRAND_3_MODEL", lwingStrandModel3);
        this.addReference("LEFT_WING_UPPER_ARM_MODEL", "LEFT_WING_STRAND_4_MODEL", lwingStrandModel4);
        this.addQuadCollection("WING_QUADS", wingQuads);
    }

    protected void setupInsectWingModels() {
        defaultResizeModule wingTop = new defaultResizeModule(new Vec3(16.0, 0.25, 0.25));
        defaultResizeModule lwingTop = new defaultResizeModule(new Vec3(-16.0, 0.25, 0.25));
        ExtendableModelRenderer wingTopModel = new ExtendableModelRenderer("RIGHT_INSECT_WING");
        wingTopModel.addLayer(new UVPair(0.0f, 0.0f), TextureList.boneSize, 0.0f, "BONE");
        wingTopModel.setPos(0.5f, 0.1f, 1.0f);
        wingTopModel.setRotationPoint(new Vec3(1.0, 0.5, 0.0));
        wingTopModel.setHitbox(false);
        wingTopModel.extend((resizeModule)wingTop);
        ExtendableModelRenderer lwingTopModel = new ExtendableModelRenderer("LEFT_INSECT_WING");
        lwingTopModel.addLayer(new UVPair(0.0f, 0.0f), TextureList.boneSize, 0.0f, "BONE");
        lwingTopModel.setPos(0.5f, 0.1f, 1.0f);
        lwingTopModel.setRotationPoint(new Vec3(1.0, 0.5, 0.0));
        lwingTopModel.setHitbox(false);
        lwingTopModel.extend((resizeModule)lwingTop);
        defaultResizeModule innerWingTop = new defaultResizeModule(new Vec3(-14.0, 0.25, 0.25));
        defaultResizeModule linnerWingTop = new defaultResizeModule(new Vec3(14.0, 0.25, 0.25));
        ExtendableModelRenderer innerWingModel = new ExtendableModelRenderer("RIGHT_INSECT_WING_INNER");
        innerWingModel.addLayer(new UVPair(0.0f, 0.0f), TextureList.boneSize, 0.0f, "BONE");
        innerWingModel.setPos(0.0f, 0.0f, 0.5f);
        innerWingModel.setRotationPoint(new Vec3(0.0, 1.0, 0.5));
        innerWingModel.setHitbox(false);
        innerWingModel.extend((resizeModule)innerWingTop);
        ExtendableModelRenderer linnerWingModel = new ExtendableModelRenderer("LEFT_INSECT_WING_INNER");
        linnerWingModel.addLayer(new UVPair(0.0f, 0.0f), TextureList.boneSize, 0.0f, "BONE");
        linnerWingModel.setPos(0.0f, 0.0f, 0.5f);
        linnerWingModel.setRotationPoint(new Vec3(0.0, 1.0, 0.5));
        linnerWingModel.setHitbox(false);
        linnerWingModel.extend((resizeModule)linnerWingTop);
        wingTopModel.addChild(innerWingModel);
        lwingTopModel.addChild(linnerWingModel);
        Quad lwingConnector = new Quad(new Vec3(0.0, 0.0, 0.0), new Vec3(0.0, 0.0, 0.0), new Vec3(0.0, 0.0, 0.0), new Vec3(0.0, 0.0, 0.0));
        lwingTopModel.addQuadLinkage(new QuadLinkage(lwingConnector, Quad.QuadVertex.TopLeft, new Vec3(0.0, 0.0, 0.5)));
        lwingTopModel.addQuadLinkage(new QuadLinkage(lwingConnector, Quad.QuadVertex.BottomLeft, new Vec3(1.0, 0.0, 0.5)));
        linnerWingModel.addQuadLinkage(new QuadLinkage(lwingConnector, Quad.QuadVertex.TopRight, new Vec3(1.0, 0.0, 0.5)));
        linnerWingModel.addQuadLinkage(new QuadLinkage(lwingConnector, Quad.QuadVertex.BottomRight, new Vec3(0.0, 0.0, 0.5)));
        lwingConnector.setAlpha(0.33f);
        lwingConnector.addLayer(new UVPair(0.0f, 0.0f), GenericTextureValues.skin_Size, 0.0f, "EBLANK");
        Quad rwingConnector = new Quad(new Vec3(0.0, 0.0, 0.0), new Vec3(0.0, 0.0, 0.0), new Vec3(0.0, 0.0, 0.0), new Vec3(0.0, 0.0, 0.0));
        wingTopModel.addQuadLinkage(new QuadLinkage(rwingConnector, Quad.QuadVertex.TopLeft, new Vec3(0.0, 0.0, 0.5)));
        wingTopModel.addQuadLinkage(new QuadLinkage(rwingConnector, Quad.QuadVertex.BottomLeft, new Vec3(1.0, 0.0, 0.5)));
        innerWingModel.addQuadLinkage(new QuadLinkage(rwingConnector, Quad.QuadVertex.TopRight, new Vec3(1.0, 0.0, 0.5)));
        innerWingModel.addQuadLinkage(new QuadLinkage(rwingConnector, Quad.QuadVertex.BottomRight, new Vec3(0.0, 0.0, 0.5)));
        rwingConnector.setAlpha(0.33f);
        rwingConnector.addLayer(new UVPair(0.0f, 0.0f), GenericTextureValues.skin_Size, 0.0f, "EBLANK");
        QuadCollection wingQuads = new QuadCollection();
        wingQuads.addQuad(lwingConnector);
        wingQuads.addQuad(rwingConnector);
        this.addModel("RIGHT_INSECT_WING", wingTopModel);
        this.addReference("RIGHT_INSECT_WING", "RIGHT_INSECT_WING_INNER", innerWingModel);
        this.addModel("LEFT_INSECT_WING", lwingTopModel);
        this.addReference("LEFT_INSECT_WING", "LEFT_INSECT_WING_INNER", linnerWingModel);
        this.addQuadCollection("INSECT_QUADS", wingQuads);
    }

    protected void setupTeethModels() {
        this.setupFlatTeethModels();
        this.setupSharpTeethModels();
    }

    protected void setupFlatTeethModels() {
        defaultResizeModule flatToothResizer = QiResizers.getTeethResizer(8, 8.0f, 1.0f, 0.1f);
        ExtendableModelRenderer flatToothPart = new ExtendableModelRenderer("FLAT_TOOTH_MODEL");
        flatToothPart.addLayer(new UVPair(0.0f, 0.0f), TextureList.boneSize, 0.0f, "BONE");
        flatToothPart.setPos(0.0f, 1.0f, 0.0f);
        flatToothPart.setFixedPosAdjustment(0.05f, 0.0f, 0.05f);
        flatToothPart.setRotationPoint(new Vec3(1.0, 1.0, 1.0));
        flatToothPart.extend((resizeModule)flatToothResizer);
        ExtendableModelRenderer lastTooth = flatToothPart;
        while (lastTooth.getChildren().size() > 0) {
            lastTooth = (ExtendableModelRenderer)lastTooth.getChildren().get(0);
        }
        flatToothResizer = QiResizers.getSideTeethResizer(6, 5.8f, 1.0f, 0.1f);
        ExtendableModelRenderer flatToothSidePart = new ExtendableModelRenderer("FLAT_TOOTH_MODEL_SIDE");
        flatToothSidePart.addLayer(new UVPair(0.0f, 0.0f), TextureList.boneSize, 0.0f, "BONE");
        flatToothSidePart.setPos(1.0f, 0.5f, 1.0f);
        flatToothSidePart.setFixedPosAdjustment(0.0f, 0.0f, 0.1f);
        flatToothSidePart.setRotationPoint(new Vec3(0.0, 0.5, 1.0));
        flatToothSidePart.extend((resizeModule)flatToothResizer);
        flatToothPart.addChild(flatToothSidePart);
        flatToothResizer = QiResizers.getSideTeethResizer(6, 5.8f, 1.0f, 0.1f);
        flatToothSidePart = new ExtendableModelRenderer("FLAT_TOOTH_MODEL_OTHER_SIDE");
        flatToothSidePart.addLayer(new UVPair(0.0f, 0.0f), TextureList.boneSize, 0.0f, "BONE");
        flatToothSidePart.setPos(1.0f, 0.5f, 1.0f);
        flatToothSidePart.setFixedPosAdjustment(0.0f, 0.0f, 0.1f);
        flatToothSidePart.setRotationPoint(new Vec3(0.0, 0.5, 1.0));
        flatToothSidePart.extend((resizeModule)flatToothResizer);
        lastTooth.addChild(flatToothSidePart);
        flatToothPart.setFirstPersonRenderForSelfAndChildren(false);
        flatToothPart.setHitbox(false);
        this.addModel("FLAT_TOOTH_MODEL", flatToothPart);
        ExtendableModelRenderer FPflatToothPart = flatToothPart.clone("FP");
        FPflatToothPart.setNoResizeForSelfAndChildren(Boolean.valueOf(true));
        FPflatToothPart.setName("FP_FLAT_TOOTH_MODEL");
        this.addModel("FP_FLAT_TOOTH_MODEL", FPflatToothPart);
        flatToothResizer = QiResizers.getTeethResizer(8, 7.8f, 1.0f, 0.1f);
        flatToothPart = new ExtendableModelRenderer("FLAT_TOOTH_LOWER_MODEL");
        flatToothPart.addLayer(new UVPair(0.0f, 0.0f), TextureList.boneSize, 0.0f, "BONE");
        flatToothPart.setPos(0.0f, 0.0f, 0.0f);
        flatToothPart.setFixedPosAdjustment(0.05f, 0.0f, 0.05f);
        flatToothPart.setRotationPoint(new Vec3(1.0, 0.0, 1.0));
        flatToothPart.extend((resizeModule)flatToothResizer);
        flatToothPart.setRotationOffset(new Vec3(Math.toRadians(-20.0), 0.0, 0.0));
        lastTooth = flatToothPart;
        while (lastTooth.getChildren().size() > 0) {
            lastTooth = (ExtendableModelRenderer)lastTooth.getChildren().get(0);
        }
        flatToothResizer = QiResizers.getSideTeethResizer(6, 5.8f, 1.0f, 0.1f);
        flatToothSidePart = new ExtendableModelRenderer("FLAT_TOOTH_LOWER_MODEL_SIDE");
        flatToothSidePart.addLayer(new UVPair(0.0f, 0.0f), TextureList.boneSize, 0.0f, "BONE");
        flatToothSidePart.setPos(1.0f, 0.5f, 1.0f);
        flatToothSidePart.setFixedPosAdjustment(0.0f, 0.0f, 0.1f);
        flatToothSidePart.setRotationPoint(new Vec3(0.0, 0.5, 1.0));
        flatToothSidePart.extend((resizeModule)flatToothResizer);
        flatToothPart.addChild(flatToothSidePart);
        flatToothResizer = QiResizers.getSideTeethResizer(6, 5.8f, 1.0f, 0.1f);
        flatToothSidePart = new ExtendableModelRenderer("FLAT_TOOTH_LOWER_MODEL_OTHER_SIDE");
        flatToothSidePart.addLayer(new UVPair(0.0f, 0.0f), TextureList.boneSize, 0.0f, "BONE");
        flatToothSidePart.setPos(1.0f, 0.5f, 1.0f);
        flatToothSidePart.setFixedPosAdjustment(0.0f, 0.0f, 0.1f);
        flatToothSidePart.setRotationPoint(new Vec3(0.0, 0.5, 1.0));
        flatToothSidePart.extend((resizeModule)flatToothResizer);
        lastTooth.addChild(flatToothSidePart);
        flatToothPart.setFirstPersonRenderForSelfAndChildren(false);
        flatToothPart.setHitbox(false);
        this.addModel("FLAT_TOOTH_LOWER_MODEL", flatToothPart);
        FPflatToothPart = flatToothPart.clone("FP");
        FPflatToothPart.setFirstPersonRenderForSelfAndChildren(true);
        FPflatToothPart.setNoResizeForSelfAndChildren(Boolean.valueOf(true));
        FPflatToothPart.setName("FP_FLAT_TOOTH_LOWER_MODEL");
        this.addModel("FP_FLAT_TOOTH_LOWER_MODEL", FPflatToothPart);
    }

    protected void setupSharpTeethModels() {
        defaultResizeModule ToothResizer = QiResizers.getTeethResizer(8, 7.9f, 0.5f, 0.1f);
        ExtendableModelRenderer ToothPart = new ExtendableModelRenderer("SHARP_TOOTH_MODEL");
        ToothPart.addLayer(new UVPair(0.0f, 0.0f), TextureList.boneSize, 0.0f, "BONE");
        ToothPart.setPos(0.0f, 1.0f, 0.0f);
        ToothPart.setFixedPosAdjustment(0.05f, 0.0f, 0.05f);
        ToothPart.setRotationPoint(new Vec3(1.0, 1.0, 1.0));
        ToothPart.extend((resizeModule)ToothResizer);
        ToothResizer = QiResizers.getTeethResizer(8, 7.9f, 0.5f, 0.3f);
        ExtendableModelRenderer LowerToothPart = new ExtendableModelRenderer("SHARP_TOOTH_MODEL1");
        LowerToothPart.addLayer(new UVPair(0.0f, 0.0f), TextureList.boneSize, 0.0f, "BONE");
        LowerToothPart.setPos(0.1f, 0.5f, 0.0f);
        LowerToothPart.extend((resizeModule)ToothResizer);
        ToothPart.addChild(LowerToothPart);
        ToothResizer = QiResizers.getTeethResizer(8, 7.9f, 0.5f, 0.5f);
        LowerToothPart = new ExtendableModelRenderer("SHARP_TOOTH_MODEL2");
        LowerToothPart.addLayer(new UVPair(0.0f, 0.0f), TextureList.boneSize, 0.0f, "BONE");
        LowerToothPart.setPos(0.2f, 1.0f, 0.0f);
        LowerToothPart.extend((resizeModule)ToothResizer);
        ToothPart.addChild(LowerToothPart);
        ToothResizer = QiResizers.getTeethResizer(8, 7.9f, 0.49f, 0.7f);
        LowerToothPart = new ExtendableModelRenderer("SHARP_TOOTH_MODEL3");
        LowerToothPart.addLayer(new UVPair(0.0f, 0.0f), TextureList.boneSize, 0.0f, "BONE");
        LowerToothPart.setPos(0.3f, 1.5f, 0.0f);
        LowerToothPart.extend((resizeModule)ToothResizer);
        ToothPart.addChild(LowerToothPart);
        ToothResizer = QiResizers.getSideTeethResizer(5, 4.8f, 0.5f, 0.1f);
        ExtendableModelRenderer ToothSidePart = new ExtendableModelRenderer("SHARP_TOOTH_MODEL4");
        ToothSidePart.addLayer(new UVPair(0.0f, 0.0f), TextureList.boneSize, 0.0f, "BONE");
        ToothSidePart.setPos(0.0f, 0.0f, 1.1f);
        ToothSidePart.extend((resizeModule)ToothResizer);
        ToothResizer = QiResizers.getSideTeethResizer(5, 4.8f, 0.5f, 0.3f);
        ExtendableModelRenderer LowerToothSidePart = new ExtendableModelRenderer("SHARP_TOOTH_MODEL5");
        LowerToothSidePart.addLayer(new UVPair(0.0f, 0.0f), TextureList.boneSize, 0.0f, "BONE");
        LowerToothSidePart.setPos(0.0f, 0.5f, 0.1f);
        LowerToothSidePart.extend((resizeModule)ToothResizer);
        ToothSidePart.addChild(LowerToothSidePart);
        ToothResizer = QiResizers.getSideTeethResizer(5, 4.8f, 0.5f, 0.5f);
        LowerToothSidePart = new ExtendableModelRenderer("SHARP_TOOTH_MODEL6");
        LowerToothSidePart.addLayer(new UVPair(0.0f, 0.0f), TextureList.boneSize, 0.0f, "BONE");
        LowerToothSidePart.setPos(0.0f, 1.0f, 0.2f);
        LowerToothSidePart.extend((resizeModule)ToothResizer);
        ToothSidePart.addChild(LowerToothSidePart);
        ToothResizer = QiResizers.getSideTeethResizer(5, 4.8f, 0.49f, 0.7f);
        LowerToothSidePart = new ExtendableModelRenderer("SHARP_TOOTH_MODEL7");
        LowerToothSidePart.addLayer(new UVPair(0.0f, 0.0f), TextureList.boneSize, 0.0f, "BONE");
        LowerToothSidePart.setPos(0.0f, 1.5f, 0.3f);
        LowerToothSidePart.extend((resizeModule)ToothResizer);
        ToothSidePart.addChild(LowerToothSidePart);
        ToothPart.addChild(ToothSidePart);
        ToothResizer = QiResizers.getSideTeethResizer(5, 4.8f, 0.5f, 0.1f);
        ToothSidePart = new ExtendableModelRenderer("SHARP_TOOTH_MODEL8");
        ToothSidePart.addLayer(new UVPair(0.0f, 0.0f), TextureList.boneSize, 0.0f, "BONE");
        ToothSidePart.setPos(7.8f, 0.0f, 1.1f);
        ToothSidePart.extend((resizeModule)ToothResizer);
        ToothResizer = QiResizers.getSideTeethResizer(5, 4.8f, 0.5f, 0.3f);
        LowerToothSidePart = new ExtendableModelRenderer("SHARP_TOOTH_MODEL9");
        LowerToothSidePart.addLayer(new UVPair(0.0f, 0.0f), TextureList.boneSize, 0.0f, "BONE");
        LowerToothSidePart.setPos(0.0f, 0.5f, 0.1f);
        LowerToothSidePart.extend((resizeModule)ToothResizer);
        ToothSidePart.addChild(LowerToothSidePart);
        ToothResizer = QiResizers.getSideTeethResizer(5, 4.8f, 0.5f, 0.5f);
        LowerToothSidePart = new ExtendableModelRenderer("SHARP_TOOTH_MODEL10");
        LowerToothSidePart.addLayer(new UVPair(0.0f, 0.0f), TextureList.boneSize, 0.0f, "BONE");
        LowerToothSidePart.setPos(0.0f, 1.0f, 0.2f);
        LowerToothSidePart.extend((resizeModule)ToothResizer);
        ToothSidePart.addChild(LowerToothSidePart);
        ToothResizer = QiResizers.getSideTeethResizer(5, 4.8f, 0.49f, 0.7f);
        LowerToothSidePart = new ExtendableModelRenderer("SHARP_TOOTH_MODEL11");
        LowerToothSidePart.addLayer(new UVPair(0.0f, 0.0f), TextureList.boneSize, 0.0f, "BONE");
        LowerToothSidePart.setPos(0.0f, 1.5f, 0.3f);
        LowerToothSidePart.extend((resizeModule)ToothResizer);
        ToothSidePart.addChild(LowerToothSidePart);
        ToothPart.addChild(ToothSidePart);
        ToothPart.setFirstPersonRenderForSelfAndChildren(false);
        ToothPart.setHitbox(false);
        this.addModel("SHARP_TOOTH_MODEL", ToothPart);
        ExtendableModelRenderer FPToothPart = ToothPart.clone();
        FPToothPart.setName("FP_SHARP_TOOTH_MODEL");
        FPToothPart.setNoResizeForSelfAndChildren(Boolean.valueOf(true));
        this.addModel("FP_SHARP_TOOTH_MODEL", FPToothPart);
        ToothResizer = QiResizers.getTeethResizer(7, 7.0f, 0.5f, 0.1f);
        ToothPart = new ExtendableModelRenderer("SHARP_TOOTH_LOWER_MODEL");
        ToothPart.addLayer(new UVPair(0.0f, 0.0f), TextureList.boneSize, 0.0f, "BONE");
        ToothPart.setPos(0.0f, 0.0f, 0.0f);
        ToothPart.setFixedPosAdjustment(0.55f, 0.0f, 0.1f);
        ToothPart.setRotationPoint(new Vec3(1.0, 0.0, 1.0));
        ToothPart.extend((resizeModule)ToothResizer);
        ToothPart.setRotationOffset(new Vec3(Math.toRadians(-20.0), 0.0, 0.0));
        ToothResizer = QiResizers.getTeethResizer(7, 7.0f, 0.5f, 0.3f);
        LowerToothPart = new ExtendableModelRenderer("SHARP_TOOTH_LOWER_MODEL1");
        LowerToothPart.addLayer(new UVPair(0.0f, 0.0f), TextureList.boneSize, 0.0f, "BONE");
        LowerToothPart.setPos(0.1f, -0.5f, 0.0f);
        LowerToothPart.extend((resizeModule)ToothResizer);
        ToothPart.addChild(LowerToothPart);
        ToothResizer = QiResizers.getTeethResizer(7, 7.0f, 0.5f, 0.5f);
        LowerToothPart = new ExtendableModelRenderer("SHARP_TOOTH_LOWER_MODEL2");
        LowerToothPart.addLayer(new UVPair(0.0f, 0.0f), TextureList.boneSize, 0.0f, "BONE");
        LowerToothPart.setPos(0.2f, -1.0f, 0.0f);
        LowerToothPart.extend((resizeModule)ToothResizer);
        ToothPart.addChild(LowerToothPart);
        ToothResizer = QiResizers.getTeethResizer(7, 7.0f, 0.49f, 0.7f);
        LowerToothPart = new ExtendableModelRenderer("SHARP_TOOTH_LOWER_MODEL3");
        LowerToothPart.addLayer(new UVPair(0.0f, 0.0f), TextureList.boneSize, 0.0f, "BONE");
        LowerToothPart.setPos(0.3f, -1.5f, 0.0f);
        LowerToothPart.extend((resizeModule)ToothResizer);
        ToothPart.addChild(LowerToothPart);
        float sideTeethLength = 3.7f;
        ToothResizer = QiResizers.getSideTeethResizer(4, sideTeethLength, 0.5f, 0.1f);
        ToothSidePart = new ExtendableModelRenderer("SHARP_TOOTH_LOWER_MODEL4");
        ToothSidePart.addLayer(new UVPair(0.0f, 0.0f), TextureList.boneSize, 0.0f, "BONE");
        ToothSidePart.setPos(-0.5f, 0.0f, 0.4f);
        ToothSidePart.extend((resizeModule)ToothResizer);
        ToothResizer = QiResizers.getSideTeethResizer(4, sideTeethLength, 0.5f, 0.3f);
        LowerToothSidePart = new ExtendableModelRenderer("SHARP_TOOTH_LOWER_MODEL5");
        LowerToothSidePart.addLayer(new UVPair(0.0f, 0.0f), TextureList.boneSize, 0.0f, "BONE");
        LowerToothSidePart.setPos(0.0f, -0.5f, 0.1f);
        LowerToothSidePart.extend((resizeModule)ToothResizer);
        ToothSidePart.addChild(LowerToothSidePart);
        ToothResizer = QiResizers.getSideTeethResizer(4, sideTeethLength, 0.5f, 0.5f);
        LowerToothSidePart = new ExtendableModelRenderer("SHARP_TOOTH_LOWER_MODEL6");
        LowerToothSidePart.addLayer(new UVPair(0.0f, 0.0f), TextureList.boneSize, 0.0f, "BONE");
        LowerToothSidePart.setPos(0.0f, -1.0f, 0.2f);
        LowerToothSidePart.extend((resizeModule)ToothResizer);
        ToothSidePart.addChild(LowerToothSidePart);
        ToothResizer = QiResizers.getSideTeethResizer(4, sideTeethLength, 0.49f, 0.7f);
        LowerToothSidePart = new ExtendableModelRenderer("SHARP_TOOTH_LOWER_MODEL7");
        LowerToothSidePart.addLayer(new UVPair(0.0f, 0.0f), TextureList.boneSize, 0.0f, "BONE");
        LowerToothSidePart.setPos(0.0f, -1.5f, 0.3f);
        LowerToothSidePart.extend((resizeModule)ToothResizer);
        ToothSidePart.addChild(LowerToothSidePart);
        ToothPart.addChild(ToothSidePart);
        ToothResizer = QiResizers.getSideTeethResizer(4, sideTeethLength, 0.5f, 0.1f);
        ToothSidePart = new ExtendableModelRenderer("SHARP_TOOTH_LOWER_MODEL8");
        ToothSidePart.addLayer(new UVPair(0.0f, 0.0f), TextureList.boneSize, 0.0f, "BONE");
        ToothSidePart.setPos(7.2f, 0.0f, 0.4f);
        ToothSidePart.extend((resizeModule)ToothResizer);
        ToothResizer = QiResizers.getSideTeethResizer(4, sideTeethLength, 0.5f, 0.3f);
        LowerToothSidePart = new ExtendableModelRenderer("SHARP_TOOTH_LOWER_MODEL9");
        LowerToothSidePart.addLayer(new UVPair(0.0f, 0.0f), TextureList.boneSize, 0.0f, "BONE");
        LowerToothSidePart.setPos(0.0f, -0.5f, 0.1f);
        LowerToothSidePart.extend((resizeModule)ToothResizer);
        ToothSidePart.addChild(LowerToothSidePart);
        ToothResizer = QiResizers.getSideTeethResizer(4, sideTeethLength, 0.5f, 0.5f);
        LowerToothSidePart = new ExtendableModelRenderer("SHARP_TOOTH_LOWER_MODEL10");
        LowerToothSidePart.addLayer(new UVPair(0.0f, 0.0f), TextureList.boneSize, 0.0f, "BONE");
        LowerToothSidePart.setPos(0.0f, -1.0f, 0.2f);
        LowerToothSidePart.extend((resizeModule)ToothResizer);
        ToothSidePart.addChild(LowerToothSidePart);
        ToothResizer = QiResizers.getSideTeethResizer(4, sideTeethLength, 0.49f, 0.7f);
        LowerToothSidePart = new ExtendableModelRenderer("SHARP_TOOTH_LOWER_MODEL11");
        LowerToothSidePart.addLayer(new UVPair(0.0f, 0.0f), TextureList.boneSize, 0.0f, "BONE");
        LowerToothSidePart.setPos(0.0f, -1.5f, 0.3f);
        LowerToothSidePart.extend((resizeModule)ToothResizer);
        ToothSidePart.addChild(LowerToothSidePart);
        ToothPart.addChild(ToothSidePart);
        ToothPart.setFirstPersonRenderForSelfAndChildren(false);
        ToothPart.setHitbox(false);
        this.addModel("SHARP_TOOTH_LOWER_MODEL", ToothPart);
        FPToothPart = ToothPart.clone();
        FPToothPart.setName("FP_SHARP_TOOTH_LOWER_MODEL");
        FPToothPart.setNoResizeForSelfAndChildren(Boolean.valueOf(true));
        this.addModel("FP_SHARP_TOOTH_LOWER_MODEL", FPToothPart);
    }

    protected void setupLegModels() {
        defaultResizeModule reverseJointResizer = new defaultResizeModule(2, new Vec3(0.0, 1.0, 0.0), new Vec3(0.5, 1.0, 1.0), new Vec3(3.98, 10.0, 3.98), new Vec3(0.5, 1.0, 0.0));
        defaultResizeModule footResizer = new defaultResizeModule(new Vec3(4.0, 2.0, 4.0));
        ExtendableModelRenderer leftReverseJoint = new ExtendableModelRenderer("RJL_LEFT_MODEL");
        GenericCultivatorTextureValues.addGenericLeftLegLayers(leftReverseJoint);
        leftReverseJoint.setPos(0.75f, 1.0f, 0.5f);
        leftReverseJoint.setRotationPoint(new Vec3(0.5, 1.0, 0.5));
        leftReverseJoint.setFixedPosAdjustment(0.0f, 0.0f, 0.0f);
        leftReverseJoint.extend((resizeModule)reverseJointResizer);
        ExtendableModelRenderer leftFoot = new ExtendableModelRenderer("RJL_LEFT_FOOT_MODEL");
        GenericCultivatorTextureValues.addGenericLeftLegLayers(leftFoot, 0, 10);
        leftFoot.setPos(0.5f, 1.0f, 0.0f);
        leftFoot.setRotationPoint(new Vec3(0.5, 1.0, 1.0));
        leftFoot.extend((resizeModule)footResizer);
        ((ExtendableModelRenderer)leftReverseJoint.getChildren().get(0)).addChild(leftFoot);
        reverseJointResizer = new defaultResizeModule(2, new Vec3(0.0, 1.0, 0.0), new Vec3(0.5, 1.0, 1.0), new Vec3(3.98, 10.0, 3.98), new Vec3(0.5, 1.0, 0.0));
        footResizer = new defaultResizeModule(new Vec3(4.0, 2.0, 4.0));
        ExtendableModelRenderer rightReverseJoint = new ExtendableModelRenderer("RJL_RIGHT_MODEL");
        GenericCultivatorTextureValues.addGenericRightLegLayers(rightReverseJoint);
        rightReverseJoint.setPos(0.25f, 1.0f, 0.5f);
        rightReverseJoint.setRotationPoint(new Vec3(0.5, 1.0, 0.5));
        rightReverseJoint.setFixedPosAdjustment(0.0f, 0.0f, 0.0f);
        rightReverseJoint.extend((resizeModule)reverseJointResizer);
        ExtendableModelRenderer rightFoot = new ExtendableModelRenderer("RJL_RIGHT_FOOT_MODEL");
        GenericCultivatorTextureValues.addGenericRightLegLayers(rightFoot, 0, 10);
        rightFoot.setPos(0.5f, 1.0f, 0.0f);
        rightFoot.setRotationPoint(new Vec3(0.5, 1.0, 1.0));
        rightFoot.extend((resizeModule)footResizer);
        ((ExtendableModelRenderer)rightReverseJoint.getChildren().get(0)).addChild(rightFoot);
        this.addModel("RJL_LEFT_MODEL", leftReverseJoint);
        this.addReference("RJL_LEFT_MODEL", "RJL_LEFT_LOWER_MODEL", (ExtendableModelRenderer)leftReverseJoint.getChildren().get(0));
        this.addReference("RJL_LEFT_MODEL", "RJL_LEFT_FOOT_MODEL", leftFoot);
        this.addModel("RJL_RIGHT_MODEL", rightReverseJoint);
        this.addReference("RJL_RIGHT_MODEL", "RJL_RIGHT_LOWER_MODEL", (ExtendableModelRenderer)rightReverseJoint.getChildren().get(0));
        this.addReference("RJL_RIGHT_MODEL", "RJL_RIGHT_FOOT_MODEL", rightFoot);
        footResizer = new defaultResizeModule(new Vec3(4.0, 2.0, 4.0));
        ExtendableModelRenderer leftFootModel = new ExtendableModelRenderer("FOOT_LEFT_MODEL");
        GenericCultivatorTextureValues.addGenericLeftLegLayers(leftFootModel, 0, 10);
        leftFootModel.setPos(0.75f, 1.0f, 0.5f);
        leftFootModel.setRotationPoint(new Vec3(0.5, 1.0, 0.5));
        leftFootModel.extend((resizeModule)footResizer);
        footResizer = new defaultResizeModule(new Vec3(4.0, 2.0, 4.0));
        ExtendableModelRenderer rightFootModel = new ExtendableModelRenderer("FOOT_RIGHT_MODEL");
        GenericCultivatorTextureValues.addGenericRightLegLayers(rightFootModel, 0, 10);
        rightFootModel.setPos(0.25f, 1.0f, 0.5f);
        rightFootModel.setRotationPoint(new Vec3(0.5, 1.0, 0.5));
        rightFootModel.extend((resizeModule)footResizer);
        this.addModel("FOOT_LEFT_MODEL", leftFootModel);
        this.addModel("FOOT_RIGHT_MODEL", rightFootModel);
        ExtendableModelRenderer singleLeg = new ExtendableModelRenderer("SINGLE_LEG_MODEL");
        GenericCultivatorTextureValues.addGenericLeftLegLayers(singleLeg);
        singleLeg.setPos(0.5f, 1.0f, 0.5f);
        singleLeg.setRotationPoint(new Vec3(0.5, 0.66, 0.5));
        singleLeg.setFixedPosAdjustment(0.0f, 2.0f, 0.0f);
        singleLeg.extend(GenericResizers.getLegResizer());
        this.addModel("SINGLE_LEG_MODEL", singleLeg);
        this.addReference("SINGLE_LEG_MODEL", "SINGLE_LEG_LOWER_MODEL", (ExtendableModelRenderer)singleLeg.getChildren().get(0));
        defaultResizeModule hexaResizer = new defaultResizeModule(2, new Vec3(0.0, 1.0, 0.0), new Vec3(0.5, 1.0, 0.5), new Vec3(4.0, 10.0, 4.0), new Vec3(0.5, 1.0, 0.5));
        ExtendableModelRenderer hexaLeft = new ExtendableModelRenderer("HEXA_LEFT_MODEL");
        GenericCultivatorTextureValues.addGenericLeftLegLayers(hexaLeft);
        hexaLeft.setPos(1.0f, 1.0f, 0.5f);
        hexaLeft.setRotationPoint(new Vec3(0.5, 1.0, 0.5));
        hexaLeft.extend((resizeModule)hexaResizer);
        hexaLeft.setDefaultResize(new Vec3(0.5, 1.5, 0.5));
        ((ExtendableModelRenderer)hexaLeft.getChildren().get(0)).setDefaultResize(new Vec3(0.5, 1.5, 0.5));
        ExtendableModelRenderer hexaLeftTwo = hexaLeft.clone();
        ExtendableModelRenderer hexaLeftThree = hexaLeft.clone();
        hexaResizer = new defaultResizeModule(2, new Vec3(0.0, 1.0, 0.0), new Vec3(0.5, 1.0, 0.5), new Vec3(4.0, 10.0, 4.0), new Vec3(0.5, 1.0, 0.5));
        ExtendableModelRenderer hexaRight = new ExtendableModelRenderer("HEXA_RIGHT_MODEL");
        GenericCultivatorTextureValues.addGenericRightLegLayers(hexaRight);
        hexaRight.setPos(0.0f, 1.0f, 0.5f);
        hexaRight.setRotationPoint(new Vec3(0.5, 1.0, 0.5));
        hexaRight.extend((resizeModule)hexaResizer);
        hexaRight.setDefaultResize(new Vec3(0.5, 1.5, 0.5));
        ((ExtendableModelRenderer)hexaRight.getChildren().get(0)).setDefaultResize(new Vec3(0.5, 1.5, 0.5));
        ExtendableModelRenderer hexaRightTwo = hexaRight.clone();
        ExtendableModelRenderer hexaRightThree = hexaRight.clone();
        this.addModel("HEXA_LEFT_MODEL", hexaLeft);
        this.addReference("HEXA_LEFT_MODEL", "HEXA_LEFT_LOWER_MODEL", (ExtendableModelRenderer)hexaLeft.getChildren().get(0));
        this.addModel("HEXA_LEFT_MODEL_TWO", hexaLeftTwo);
        this.addReference("HEXA_LEFT_MODEL_TWO", "HEXA_LEFT_LOWER_MODEL_TWO", (ExtendableModelRenderer)hexaLeftTwo.getChildren().get(0));
        this.addModel("HEXA_LEFT_MODEL_THREE", hexaLeftThree);
        this.addReference("HEXA_LEFT_MODEL_THREE", "HEXA_LEFT_LOWER_MODEL_THREE", (ExtendableModelRenderer)hexaLeftThree.getChildren().get(0));
        this.addModel("HEXA_RIGHT_MODEL", hexaRight);
        this.addReference("HEXA_RIGHT_MODEL", "HEXA_RIGHT_LOWER_MODEL", (ExtendableModelRenderer)hexaRight.getChildren().get(0));
        this.addModel("HEXA_RIGHT_MODEL_TWO", hexaRightTwo);
        this.addReference("HEXA_RIGHT_MODEL_TWO", "HEXA_RIGHT_LOWER_MODEL_TWO", (ExtendableModelRenderer)hexaRightTwo.getChildren().get(0));
        this.addModel("HEXA_RIGHT_MODEL_THREE", hexaRightThree);
        this.addReference("HEXA_RIGHT_MODEL_THREE", "HEXA_RIGHT_LOWER_MODEL_THREE", (ExtendableModelRenderer)hexaRightThree.getChildren().get(0));
        ExtendableModelRenderer jLeftLeg = new ExtendableModelRenderer("JET_LEG_LEFT_MODEL");
        GenericCultivatorTextureValues.addGenericLeftLegLayers(jLeftLeg);
        jLeftLeg.setPos(0.25f, 1.0f, 0.5f);
        jLeftLeg.setRotationPoint(new Vec3(0.5, 0.66, 0.5));
        jLeftLeg.setFixedPosAdjustment(0.0f, 2.0f, 0.0f);
        jLeftLeg.extend(GenericResizers.getLegResizer());
        ExtendableModelRenderer jRightLeg = new ExtendableModelRenderer("JET_LEG_RIGHT_MODEL");
        GenericCultivatorTextureValues.addGenericRightLegLayers(jRightLeg);
        jRightLeg.setPos(0.75f, 1.0f, 0.5f);
        jRightLeg.setRotationPoint(new Vec3(0.5, 0.66, 0.5));
        jRightLeg.setFixedPosAdjustment(0.0f, 2.0f, 0.0f);
        jRightLeg.extend(GenericResizers.getLegResizer());
        defaultResizeModule rightLegJetResizer = new defaultResizeModule(new Vec3(2.0, 0.5, -0.1));
        ExtendableModelRenderer rightLegJet = new ExtendableModelRenderer("JET_LEG_RIGHT_MODEL1");
        rightLegJet.addLayer(new UVPair(GenericTextureValues.rightLeg.m_171612_() + 1.0f, GenericTextureValues.rightLeg.m_171613_() + 6.0f), GenericTextureValues.skin_Size, 0.0f, "PLAYERSKIN");
        rightLegJet.setPos(0.75f, 0.0f, 1.0f);
        rightLegJet.setRotationPoint(new Vec3(0.0, 0.0, 0.0));
        rightLegJet.setDefaultResize(new Vec3(1.0, 1.0, 20.0));
        rightLegJet.extend((resizeModule)rightLegJetResizer);
        rightLegJetResizer = new defaultResizeModule(new Vec3(0.5, -4.0, -0.1));
        ExtendableModelRenderer rightLegJetLeft = new ExtendableModelRenderer("JET_LEG_RIGHT_MODEL2");
        rightLegJetLeft.addLayer(new UVPair(GenericTextureValues.rightLeg.m_171612_() + 1.0f, GenericTextureValues.rightLeg.m_171613_() + 10.0f), GenericTextureValues.skin_Size, 0.0f, "PLAYERSKIN");
        rightLegJetLeft.setPos(1.0f, 0.0f, 1.0f);
        rightLegJetLeft.setRotationPoint(new Vec3(0.0, 0.0, 0.0));
        rightLegJetLeft.setDefaultResize(new Vec3(1.0, 1.0, 20.0));
        rightLegJetLeft.extend((resizeModule)rightLegJetResizer);
        rightLegJetResizer = new defaultResizeModule(new Vec3(0.5, -4.0, -0.1));
        ExtendableModelRenderer rightLegJetRight = new ExtendableModelRenderer("JET_LEG_RIGHT_MODEL3");
        rightLegJetRight.addLayer(new UVPair(GenericTextureValues.rightLeg.m_171612_() + 3.0f, GenericTextureValues.rightLeg.m_171613_() + 10.0f), GenericTextureValues.skin_Size, 0.0f, "PLAYERSKIN");
        rightLegJetRight.setPos(0.0f, 0.0f, 1.0f);
        rightLegJetRight.setRotationPoint(new Vec3(1.0, 0.0, 0.0));
        rightLegJetRight.setDefaultResize(new Vec3(1.0, 1.0, 20.0));
        rightLegJetRight.extend((resizeModule)rightLegJetResizer);
        rightLegJetResizer = new defaultResizeModule(new Vec3(2.0, -4.0, -0.1));
        ExtendableModelRenderer rightLegJetFront = new ExtendableModelRenderer("JET_LEG_RIGHT_MODEL4");
        rightLegJetFront.addLayer(new UVPair(GenericTextureValues.rightLeg.m_171612_() + 1.0f, GenericTextureValues.rightLeg.m_171613_() + 10.0f), GenericTextureValues.skin_Size, 0.0f, "PLAYERSKIN");
        rightLegJetFront.setPos(1.0f, 0.0f, 0.0f);
        rightLegJetFront.setRotationPoint(new Vec3(0.0, 0.0, 1.0));
        rightLegJetFront.setDefaultResize(new Vec3(1.0, 1.0, 5.0));
        rightLegJetFront.extend((resizeModule)rightLegJetResizer);
        rightLegJet.addChild(rightLegJetLeft);
        rightLegJet.addChild(rightLegJetRight);
        rightLegJet.addChild(rightLegJetFront);
        ((ExtendableModelRenderer)jRightLeg.getChildren().get(0)).addChild(rightLegJet);
        defaultResizeModule leftLegJetResizer = new defaultResizeModule(new Vec3(2.0, 0.5, -0.1));
        ExtendableModelRenderer leftLegJet = new ExtendableModelRenderer("JET_LEG_LEFT_MODEL1");
        leftLegJet.addLayer(new UVPair(GenericTextureValues.leftLeg.m_171612_() + 1.0f, GenericTextureValues.leftLeg.m_171613_() + 6.0f), GenericTextureValues.skin_Size, 0.0f, "PLAYERSKIN");
        leftLegJet.setPos(0.75f, 0.0f, 1.0f);
        leftLegJet.setRotationPoint(new Vec3(0.0, 0.0, 0.0));
        leftLegJet.setDefaultResize(new Vec3(1.0, 1.0, 20.0));
        leftLegJet.extend((resizeModule)leftLegJetResizer);
        leftLegJetResizer = new defaultResizeModule(new Vec3(0.5, -4.0, -0.1));
        ExtendableModelRenderer leftLegJetLeft = new ExtendableModelRenderer("JET_LEG_LEFT_MODEL2");
        leftLegJetLeft.addLayer(new UVPair(GenericTextureValues.leftLeg.m_171612_() + 1.0f, GenericTextureValues.leftLeg.m_171613_() + 10.0f), GenericTextureValues.skin_Size, 0.0f, "PLAYERSKIN");
        leftLegJetLeft.setPos(1.0f, 0.0f, 1.0f);
        leftLegJetLeft.setRotationPoint(new Vec3(0.0, 0.0, 0.0));
        leftLegJetLeft.setDefaultResize(new Vec3(1.0, 1.0, 20.0));
        leftLegJetLeft.extend((resizeModule)leftLegJetResizer);
        leftLegJetResizer = new defaultResizeModule(new Vec3(0.5, -4.0, -0.1));
        ExtendableModelRenderer leftLegJetRight = new ExtendableModelRenderer("JET_LEG_LEFT_MODEL3");
        leftLegJetRight.addLayer(new UVPair(GenericTextureValues.leftLeg.m_171612_() + 3.0f, GenericTextureValues.leftLeg.m_171613_() + 10.0f), GenericTextureValues.skin_Size, 0.0f, "PLAYERSKIN");
        leftLegJetRight.setPos(0.0f, 0.0f, 1.0f);
        leftLegJetRight.setRotationPoint(new Vec3(1.0, 0.0, 0.0));
        leftLegJetRight.setDefaultResize(new Vec3(1.0, 1.0, 20.0));
        leftLegJetRight.extend((resizeModule)leftLegJetResizer);
        leftLegJetResizer = new defaultResizeModule(new Vec3(2.0, -4.0, -0.1));
        ExtendableModelRenderer leftLegJetFront = new ExtendableModelRenderer("JET_LEG_LEFT_MODEL4");
        leftLegJetFront.addLayer(new UVPair(GenericTextureValues.leftLeg.m_171612_() + 1.0f, GenericTextureValues.leftLeg.m_171613_() + 10.0f), GenericTextureValues.skin_Size, 0.0f, "PLAYERSKIN");
        leftLegJetFront.setPos(1.0f, 0.0f, 0.0f);
        leftLegJetFront.setRotationPoint(new Vec3(0.0, 0.0, 1.0));
        leftLegJetFront.setDefaultResize(new Vec3(1.0, 1.0, 5.0));
        leftLegJetFront.extend((resizeModule)leftLegJetResizer);
        leftLegJet.addChild(leftLegJetLeft);
        leftLegJet.addChild(leftLegJetRight);
        leftLegJet.addChild(leftLegJetFront);
        ((ExtendableModelRenderer)jLeftLeg.getChildren().get(0)).addChild(leftLegJet);
        ParticleEmitter leftLegEmitter = new ParticleEmitter((ParticleOptions)ParticleTypes.f_123744_, "JET_LEG_LEFT_EMITTER");
        leftLegEmitter.setPos(0.5f, 8.0f, 0.5f);
        leftLegEmitter.setVelocity(new Vec3(0.0, -0.5, 0.0));
        leftLegEmitter.setInterval(1);
        leftLegEmitter.getModelPart().f_104207_ = false;
        ParticleEmitter rightLegEmitter = new ParticleEmitter((ParticleOptions)ParticleTypes.f_123744_, "JET_LEG_RIGHT_EMITTER");
        rightLegEmitter.setPos(0.5f, 8.0f, 0.5f);
        rightLegEmitter.setVelocity(new Vec3(0.0, -0.5, 0.0));
        rightLegEmitter.setInterval(1);
        rightLegEmitter.getModelPart().f_104207_ = false;
        leftLegJet.addChild((ExtendableModelRenderer)leftLegEmitter);
        rightLegJet.addChild((ExtendableModelRenderer)rightLegEmitter);
        this.addModel("JET_LEG_LEFT_MODEL", jLeftLeg);
        this.addModel("JET_LEG_RIGHT_MODEL", jRightLeg);
        this.addReference("JET_LEG_LEFT_MODEL", "JET_LEG_LEFT_LOWER_MODEL", (ExtendableModelRenderer)jLeftLeg.getChildren().get(0));
        this.addReference("JET_LEG_RIGHT_MODEL", "JET_LEG_RIGHT_LOWER_MODEL", (ExtendableModelRenderer)jRightLeg.getChildren().get(0));
        this.addReference("JET_LEG_LEFT_MODEL", "JET_LEG_LEFT_EMITTER", (ExtendableModelRenderer)leftLegEmitter);
        this.addReference("JET_LEG_RIGHT_MODEL", "JET_LEG_RIGHT_EMITTER", (ExtendableModelRenderer)rightLegEmitter);
        ExtendableModelRenderer largeRightLeg = new ExtendableModelRenderer("LARGE_LEG_RIGHT_MODEL");
        GenericCultivatorTextureValues.addGenericRightLegLayers(largeRightLeg);
        largeRightLeg.setPos(0.0f, 0.25f, 0.5f);
        largeRightLeg.setRotationPoint(new Vec3(0.0, 0.75, 0.5));
        largeRightLeg.setDefaultResize(new Vec3(2.0, 2.0, 2.0));
        largeRightLeg.extend(GenericResizers.getLegResizer());
        ((ExtendableModelRenderer)largeRightLeg.getChildren().get(0)).setDefaultResize(new Vec3(2.0, 2.0, 2.0));
        ExtendableModelRenderer largeLeftLeg = new ExtendableModelRenderer("LARGE_LEG_LEFT_MODEL");
        GenericCultivatorTextureValues.addGenericLeftLegLayers(largeLeftLeg);
        largeLeftLeg.setPos(1.0f, 0.25f, 0.5f);
        largeLeftLeg.setRotationPoint(new Vec3(1.0, 0.75, 0.5));
        largeLeftLeg.setDefaultResize(new Vec3(2.0, 2.0, 2.0));
        largeLeftLeg.extend(GenericResizers.getLegResizer());
        ((ExtendableModelRenderer)largeLeftLeg.getChildren().get(0)).setDefaultResize(new Vec3(2.0, 2.0, 2.0));
        this.addModel("LARGE_LEG_LEFT_MODEL", largeLeftLeg);
        this.addModel("LARGE_LEG_RIGHT_MODEL", largeRightLeg);
        this.addReference("LARGE_LEG_LEFT_MODEL", "LARGE_LEG_LEFT_LOWER_MODEL", (ExtendableModelRenderer)largeLeftLeg.getChildren().get(0));
        this.addReference("LARGE_LEG_RIGHT_MODEL", "LARGE_LEG_RIGHT_LOWER_MODEL", (ExtendableModelRenderer)largeRightLeg.getChildren().get(0));
        ExtendableModelRenderer leftLongLeg = new ExtendableModelRenderer("LONG_LEG_LEFT_MODEL");
        GenericCultivatorTextureValues.addGenericLeftLegLayers(leftLongLeg);
        leftLongLeg.setPos(0.25f, 1.0f, 0.5f);
        leftLongLeg.setRotationPoint(new Vec3(0.5, 0.82, 0.5));
        leftLongLeg.setFixedPosAdjustment(0.0f, 1.0f, 0.0f);
        leftLongLeg.setDefaultResize(new Vec3(1.0, 1.5, 1.0));
        leftLongLeg.extend(GenericResizers.getLegResizer());
        ((ExtendableModelRenderer)leftLongLeg.getChildren().get(0)).setDefaultResize(new Vec3(1.0, 1.5, 1.0));
        ExtendableModelRenderer rightLongLeg = new ExtendableModelRenderer("LONG_LEG_RIGHT_MODEL");
        GenericCultivatorTextureValues.addGenericRightLegLayers(rightLongLeg);
        rightLongLeg.setPos(0.75f, 1.0f, 0.5f);
        rightLongLeg.setRotationPoint(new Vec3(0.5, 0.82, 0.5));
        rightLongLeg.setFixedPosAdjustment(0.0f, 1.0f, 0.0f);
        rightLongLeg.setDefaultResize(new Vec3(1.0, 1.5, 1.0));
        rightLongLeg.extend(GenericResizers.getLegResizer());
        ((ExtendableModelRenderer)rightLongLeg.getChildren().get(0)).setDefaultResize(new Vec3(1.0, 1.5, 1.0));
        this.addModel("LONG_LEG_LEFT_MODEL", leftLongLeg);
        this.addModel("LONG_LEG_RIGHT_MODEL", rightLongLeg);
        this.addReference("LONG_LEG_LEFT_MODEL", "LONG_LEG_LEFT_LOWER_MODEL", (ExtendableModelRenderer)leftLongLeg.getChildren().get(0));
        this.addReference("LONG_LEG_RIGHT_MODEL", "LONG_LEG_RIGHT_LOWER_MODEL", (ExtendableModelRenderer)rightLongLeg.getChildren().get(0));
        ExtendableModelRenderer defaultLeftLeg = new ExtendableModelRenderer("Left_Leg");
        GenericCultivatorTextureValues.addGenericLeftLegLayers(defaultLeftLeg);
        defaultLeftLeg.setPos(0.25f, 1.0f, 0.5f);
        defaultLeftLeg.setRotationPoint(new Vec3(0.5, 0.66, 0.5));
        defaultLeftLeg.setFixedPosAdjustment(0.0f, 2.0f, 0.0f);
        defaultLeftLeg.extend(GenericResizers.getLegResizer());
        ExtendableModelRenderer defaultRightLeg = new ExtendableModelRenderer("Right_Leg");
        GenericCultivatorTextureValues.addGenericRightLegLayers(defaultRightLeg);
        defaultRightLeg.setPos(0.75f, 1.0f, 0.5f);
        defaultRightLeg.setRotationPoint(new Vec3(0.5, 0.66, 0.5));
        defaultRightLeg.setFixedPosAdjustment(0.0f, 2.0f, 0.0f);
        defaultRightLeg.extend(GenericResizers.getLegResizer());
        this.addModel("Left_Leg", defaultLeftLeg);
        this.addModel("Right_Leg", defaultRightLeg);
        this.addReference("Left_Leg", "Lower_Left_Leg", (ExtendableModelRenderer)defaultLeftLeg.getChildren().get(0));
        this.addReference("Right_Leg", "Lower_Right_Leg", (ExtendableModelRenderer)defaultRightLeg.getChildren().get(0));
    }

    public void addQuadCollection(String ID, QuadCollection quad) {
        this.quads.put(ID, quad);
    }

    public void addModel(String ID, ExtendableModelRenderer model) {
        this.models.put(ID, model);
    }

    public void addReference(String ID, String referenceID, ExtendableModelRenderer model) {
        if (!this.nonRenderingModels.containsKey(ID)) {
            this.nonRenderingModels.put(ID, new HashMap());
        }
        this.nonRenderingModels.get(ID).put(referenceID, model);
    }

    public HashMap<String, ExtendableModelRenderer> getReferences(String ID) {
        if (!this.nonRenderingModels.containsKey(ID)) {
            this.nonRenderingModels.put(ID, new HashMap());
        }
        return this.nonRenderingModels.get(ID);
    }

    public ExtendableModelRenderer getModel(String ID) {
        return this.models.get(ID);
    }

    public ExtendableModelRenderer getModel(String ID, String position) {
        ExtendableModelRenderer model = this.models.get(ID);
        this.transferQuadLinks(position, model);
        return model;
    }

    public QuadCollection getQuadCollection(String ID) {
        return this.quads.get(ID);
    }
}

