/*
 * Decompiled with CFR 0.152.
 */
package DaoOfModding.Cultivationcraft.Client.Animations;

import DaoOfModding.Cultivationcraft.Client.Animations.BodyPartLocation;
import DaoOfModding.Cultivationcraft.Client.Animations.BodyPartModels;
import DaoOfModding.Cultivationcraft.Client.Animations.GenericCultivatorTextureValues;
import DaoOfModding.Cultivationcraft.Client.Animations.QuadCollection;
import DaoOfModding.Cultivationcraft.Client.Textures.TextureList;
import DaoOfModding.Cultivationcraft.Common.Capabilities.BodyModifications.BodyModifications;
import DaoOfModding.Cultivationcraft.Common.Capabilities.BodyModifications.IBodyModifications;
import DaoOfModding.Cultivationcraft.Common.Qi.BodyParts.BodyPart;
import DaoOfModding.Cultivationcraft.Common.Qi.BodyParts.BodyPartOption;
import DaoOfModding.Cultivationcraft.Common.Qi.Stats.BodyPartStatControl;
import DaoOfModding.Cultivationcraft.Common.Qi.Stats.PlayerStatModifications;
import DaoOfModding.Cultivationcraft.Common.Qi.Stats.StatIDs;
import DaoOfModding.mlmanimator.Client.Models.ExtendableModelRenderer;
import DaoOfModding.mlmanimator.Client.Models.GenericTextureValues;
import DaoOfModding.mlmanimator.Client.Models.MultiLimbedModel;
import DaoOfModding.mlmanimator.Client.Models.Quads.Quad;
import DaoOfModding.mlmanimator.Client.Poses.Arm;
import DaoOfModding.mlmanimator.Client.Poses.PlayerPose;
import DaoOfModding.mlmanimator.Client.Poses.PlayerPoseHandler;
import DaoOfModding.mlmanimator.Client.Poses.PoseHandler;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.model.geom.builders.UVPair;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.renderer.entity.player.PlayerRenderer;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;

public class CultivatorModelHandler {
    protected static HashMap<UUID, BodyPartModels> models = new HashMap();

    public static BodyPartModels getPlayerModels(UUID playerID) {
        if (!models.containsKey(playerID)) {
            models.put(playerID, new BodyPartModels(playerID));
        }
        return models.get(playerID);
    }

    public static void resetPlayerModels(UUID playerID) {
        models.put(playerID, new BodyPartModels(playerID));
    }

    public static void updateModifications(AbstractClientPlayer player) {
        IBodyModifications modifications = BodyModifications.getBodyModifications((Player)player);
        if (!modifications.hasUpdated()) {
            CultivatorModelHandler.updateModel(player, modifications);
        }
    }

    public static void updateModel(AbstractClientPlayer player, IBodyModifications modifications) {
        PlayerRenderer renderer = (PlayerRenderer)Minecraft.m_91087_().m_91290_().m_114382_((Entity)player);
        PlayerPoseHandler handler = PoseHandler.getPlayerPoseHandler((UUID)player.m_20148_());
        if (handler != null) {
            CultivatorModelHandler.resetPlayerModels(player.m_20148_());
            BodyPartModels models = CultivatorModelHandler.getPlayerModels(player.m_20148_());
            MultiLimbedModel newModel = new MultiLimbedModel((PlayerModel)renderer.m_7200_());
            newModel.setTextureHandler(handler.getPlayerModel().getTextureHandler());
            newModel.getTextureHandler().clearTextures();
            TextureList.updateTextures(newModel.getTextureHandler());
            Collection<BodyPart> parts = modifications.getModifications().values();
            HashMap<String, BodyPartLocation> partLocations = CultivatorModelHandler.getPartLocations(parts, modifications);
            CultivatorModelHandler.processParts(newModel, parts, models, modifications, partLocations, handler);
            PlayerPose defaultSize = new PlayerPose();
            for (BodyPart bodyPart : parts) {
                bodyPart.updateTextures(newModel.getTextureHandler());
            }
            for (HashMap hashMap : modifications.getModificationOptions().values()) {
                for (BodyPartOption option : hashMap.values()) {
                    option.updateTextures(newModel.getTextureHandler());
                }
            }
            PlayerStatModifications stats = BodyPartStatControl.getStats((Player)player);
            handler.lock();
            float f = stats.getStat(StatIDs.size);
            float width = stats.getStat(StatIDs.width);
            handler.resize(new Vec3((double)(f + width), (double)f, (double)(f + width)));
            newModel.getBody().addToResizeForThisAndChildren(new Vec3((double)(f + width), (double)f, (double)(f + width)));
            newModel.getViewPoint().getModelPart().f_104203_ = handler.getPlayerModel().getViewPoint().getModelPart().f_104203_;
            newModel.getViewPoint().getModelPart().f_104204_ = handler.getPlayerModel().getViewPoint().getModelPart().f_104204_;
            newModel.getViewPoint().getModelPart().f_104205_ = handler.getPlayerModel().getViewPoint().getModelPart().f_104205_;
            newModel.setupLookVector(handler.getPlayerModel().getLookVector());
            newModel.getLimb((String)"Left_Wing_Elytra").getModelPart().f_104207_ = handler.getPlayerModel().getLimb((String)"Left_Wing_Elytra").getModelPart().f_104207_;
            newModel.getLimb((String)"Right_Wing_Elytra").getModelPart().f_104207_ = handler.getPlayerModel().getLimb((String)"Right_Wing_Elytra").getModelPart().f_104207_;
            newModel.getLimb((String)"Cloak").getModelPart().f_104207_ = handler.getPlayerModel().getLimb((String)"Cloak").getModelPart().f_104207_;
            handler.setPlayerModel(newModel);
            handler.setCrawling(false);
            handler.unlock();
            modifications.setUpdated(true);
        }
    }

    public static HashMap<String, BodyPartLocation> getPartLocations(Collection<BodyPart> parts, IBodyModifications modifications) {
        ArrayList<BodyPartLocation> partLocations = new ArrayList<BodyPartLocation>();
        for (BodyPart part : parts) {
            if (part.hasConnection()) {
                partLocations.add(part.getConnection());
            }
            for (BodyPartOption option : modifications.getModificationOptions(part.getPosition()).values()) {
                if (!option.hasConnection()) continue;
                partLocations.add(option.getConnection());
            }
        }
        HashMap<String, BodyPartLocation> connectionList = new HashMap<String, BodyPartLocation>();
        for (BodyPart part : parts) {
            connectionList.put(part.getID(), CultivatorModelHandler.getPartConnection(part, partLocations, parts, modifications));
            for (BodyPartOption option : modifications.getModificationOptions(part.getPosition()).values()) {
                connectionList.put(option.getID(), CultivatorModelHandler.getPartConnection(option, partLocations, parts, modifications));
            }
        }
        return connectionList;
    }

    protected static BodyPart getPartAtLocation(Collection<BodyPart> parts, String position, String subPosition, IBodyModifications modifications) {
        if (subPosition.equalsIgnoreCase("BASE")) {
            for (BodyPart part : parts) {
                if (!part.getPosition().equalsIgnoreCase(position)) continue;
                return part;
            }
        }
        for (BodyPartOption option : modifications.getModificationOptions(position).values()) {
            if (!option.getSubPosition().equalsIgnoreCase(subPosition)) continue;
            return option;
        }
        return null;
    }

    protected static BodyPartLocation getPartConnection(BodyPart part, ArrayList<BodyPartLocation> partLocations, Collection<BodyPart> parts, IBodyModifications modifications) {
        BodyPartLocation location = CultivatorModelHandler.getLocation(part, partLocations);
        if (location != null) {
            if (location.modelID == null) {
                BodyPart connectedPart = CultivatorModelHandler.getPartAtLocation(parts, location.modelPositionID, location.modelPositionSubID, modifications);
                BodyPartLocation newLocation = new BodyPartLocation(null, null, connectedPart.getModelIDs().get(0));
                if (location.modelPositionID == "BODY") {
                    newLocation.modelID = "Body";
                }
                newLocation.adjustDepth(location.rotationDepth);
                newLocation.adjustPos(location.posOverride);
                newLocation.adjustRotationPoint(location.rotationpointOverride);
                newLocation.adjustFixedPos(location.fixedPosOverride);
                return newLocation;
            }
            return location;
        }
        return new BodyPartLocation(null, null, "Body");
    }

    public static BodyPartLocation getLocation(BodyPart part, ArrayList<BodyPartLocation> Locations) {
        String location = part.getPosition();
        String subLocation = "BASE";
        if (part instanceof BodyPartOption) {
            subLocation = ((BodyPartOption)part).getSubPosition();
        }
        for (BodyPartLocation BPLocation : Locations) {
            if (BPLocation.positionID != location || BPLocation.positionSubID != subLocation) continue;
            return BPLocation;
        }
        return null;
    }

    protected static void addCultivatorLayers(MultiLimbedModel model) {
        GenericCultivatorTextureValues.addCultivatorHeadLayers(model.getLimb("Head"), 0, 0);
        model.getLimb("Head").generateCube();
        GenericCultivatorTextureValues.addCultivatorBodyLayers(model.getLimb("Body"), 0, 0);
        model.getLimb("Body").generateCube();
        if (model.getLimb("Right_Arm") != null) {
            GenericCultivatorTextureValues.addCultivatorRightArmLayers(model.getLimb("Right_Arm"), 0, 0);
            model.getLimb("Right_Arm").generateCube();
        }
        if (model.getLimb("Left_Arm") != null) {
            GenericCultivatorTextureValues.addCultivatorLeftArmLayers(model.getLimb("Left_Arm"), 0, 0);
            model.getLimb("Left_Arm").generateCube();
        }
        if (model.getLimb("Lower_Left_Arm") != null) {
            model.getLimb("Lower_Left_Arm").addLayer(new UVPair(GenericTextureValues.leftArm.m_171612_(), GenericTextureValues.leftArm.m_171613_() + 6.0f), GenericTextureValues.skin_Size, 0.0f, "SKIN", false, 4.0f, Direction.UP);
            model.getLimb("Lower_Left_Arm").addLayer(new UVPair(GenericTextureValues.leftSleeve.m_171612_(), GenericTextureValues.leftSleeve.m_171613_() + 6.0f), GenericTextureValues.skin_Size, 0.5f, "SKIN", false, 4.0f, Direction.UP);
            model.getLimb("Lower_Left_Arm").generateCube();
        }
        if (model.getLimb("Lower_Right_Arm") != null) {
            model.getLimb("Lower_Right_Arm").addLayer(new UVPair(GenericTextureValues.rightArm.m_171612_(), GenericTextureValues.rightArm.m_171613_() + 6.0f), GenericTextureValues.skin_Size, 0.0f, "SKIN", false, 4.0f, Direction.UP);
            model.getLimb("Lower_Right_Arm").addLayer(new UVPair(GenericTextureValues.rightSleeve.m_171612_(), GenericTextureValues.rightSleeve.m_171613_() + 6.0f), GenericTextureValues.skin_Size, 0.5f, "SKIN", false, 4.0f, Direction.UP);
            model.getLimb("Lower_Right_Arm").generateCube();
        }
        if (model.getLimb("Right_Leg") != null) {
            GenericCultivatorTextureValues.addCultivatorRightLegLayers(model.getLimb("Right_Leg"), 0, 0);
            model.getLimb("Right_Leg").generateCube();
        }
        if (model.getLimb("Left_Leg") != null) {
            GenericCultivatorTextureValues.addCultivatorLeftLegLayers(model.getLimb("Left_Leg"), 0, 0);
            model.getLimb("Left_Leg").generateCube();
        }
        if (model.getLimb("Lower_Right_Leg") != null) {
            model.getLimb("Lower_Right_Leg").addLayer(new UVPair(GenericTextureValues.rightLeg.m_171612_(), GenericTextureValues.rightLeg.m_171613_() + 6.0f), GenericTextureValues.skin_Size, 0.0f, "SKIN", false, 4.0f);
            model.getLimb("Lower_Right_Leg").addLayer(new UVPair(GenericTextureValues.rightPants.m_171612_(), GenericTextureValues.rightPants.m_171613_() + 6.0f), GenericTextureValues.skin_Size, 0.5f, "SKIN", false, 4.0f);
            model.getLimb("Lower_Right_Leg").generateCube();
        }
        if (model.getLimb("Lower_Left_Leg") != null) {
            model.getLimb("Lower_Left_Leg").addLayer(new UVPair(GenericTextureValues.leftLeg.m_171612_(), GenericTextureValues.leftLeg.m_171613_() + 6.0f), GenericTextureValues.skin_Size, 0.0f, "SKIN", false, 4.0f);
            model.getLimb("Lower_Left_Leg").addLayer(new UVPair(GenericTextureValues.leftPants.m_171612_(), GenericTextureValues.leftPants.m_171613_() + 6.0f), GenericTextureValues.skin_Size, 0.5f, "SKIN", false, 4.0f);
            model.getLimb("Lower_Left_Leg").generateCube();
        }
    }

    protected static void processParts(MultiLimbedModel model, Collection<BodyPart> parts, BodyPartModels models, IBodyModifications modifications, HashMap<String, BodyPartLocation> partLocations, PlayerPoseHandler handler) {
        ArrayList<BodyPart> unprocessedParts = new ArrayList<BodyPart>();
        CultivatorModelHandler.addCultivatorLayers(model);
        for (BodyPart part : parts) {
            if (CultivatorModelHandler.processPart(model, part, models, modifications, partLocations.get(part.getID()), handler)) continue;
            unprocessedParts.add(part);
        }
        if (unprocessedParts.size() > 0) {
            CultivatorModelHandler.processParts(model, unprocessedParts, models, modifications, partLocations, handler);
        }
    }

    public static boolean processPart(MultiLimbedModel model, BodyPart part, BodyPartModels models, IBodyModifications modifications, BodyPartLocation connectTo, PlayerPoseHandler handler) {
        Object modelPart;
        if (!model.hasLimb(connectTo.modelID)) {
            return false;
        }
        if (part.getPosition().equalsIgnoreCase("ARM")) {
            model.removeLimb("Right_Arm");
            model.removeLimb("Left_Arm");
            model.removeLimb("Lower_Right_Arm");
            model.removeLimb("Lower_Left_Arm");
            model.setLeftShoulder(null);
            model.setRightShoulder(null);
            model.setHand(0, null);
            model.setHand(1, null);
            handler.removeArms();
        } else if (part.getPosition().equalsIgnoreCase("LEG")) {
            model.removeLimb("Right_Leg");
            model.removeLimb("Left_Leg");
            model.removeLimb("Lower_Right_Leg");
            model.removeLimb("Lower_Left_Leg");
        } else if (part.getPosition().equalsIgnoreCase("HEAD")) {
            model.removeLimb("Head");
        }
        for (String modelID : part.getModelIDs()) {
            modelPart = models.getModel(modelID, part.getPosition());
            if (connectTo.rotationDepth > 0) {
                modelPart.setRotationDepth(connectTo.rotationDepth);
            }
            if (connectTo.posOverride != null) {
                modelPart.setPos((float)connectTo.posOverride.f_82479_, (float)connectTo.posOverride.f_82480_, (float)connectTo.posOverride.f_82481_);
            }
            if (connectTo.rotationpointOverride != null) {
                modelPart.setRotationPoint(connectTo.rotationpointOverride);
            }
            if (connectTo.fixedPosOverride != null) {
                modelPart.setFixedPosAdjustment((float)connectTo.fixedPosOverride.f_82479_, (float)connectTo.fixedPosOverride.f_82480_, (float)connectTo.fixedPosOverride.f_82481_);
            }
            modelPart.generateCube();
            if (part.getPosition().equalsIgnoreCase("BODY")) {
                model.addBody((ExtendableModelRenderer)modelPart);
            } else {
                model.addLimb(modelID, (ExtendableModelRenderer)modelPart, connectTo.modelID);
            }
            for (Map.Entry<String, ExtendableModelRenderer> entry : models.getReferences(modelID).entrySet()) {
                model.addLimbReference(entry.getKey(), entry.getValue());
            }
            for (Arm arm : part.getArms()) {
                if (arm.hand == InteractionHand.MAIN_HAND && model.getHand(0) == null) {
                    model.setHand(0, model.getLimb(arm.lowerLimb));
                    model.setRightShoulder(model.getLimb(arm.upperLimb));
                } else if (arm.hand == InteractionHand.OFF_HAND && model.getHand(1) == null) {
                    model.setHand(1, model.getLimb(arm.lowerLimb));
                    model.setLeftShoulder(model.getLimb(arm.upperLimb));
                }
                handler.addArm(arm);
            }
            for (BodyPartOption option : modifications.getModificationOptions(part.getPosition()).values()) {
                for (String optionModels : option.getDefaultOptionModels()) {
                    if (part.getPosition().equalsIgnoreCase("BODY")) {
                        model.addLimb(optionModels, models.getModel(optionModels, option.getSubPosition()));
                    } else {
                        model.addLimb(optionModels, models.getModel(optionModels, option.getSubPosition()), modelID);
                    }
                    for (Map.Entry<String, ExtendableModelRenderer> entry : models.getReferences(optionModels).entrySet()) {
                        model.addLimbReference(entry.getKey(), entry.getValue());
                    }
                    for (Arm arm : option.getArms()) {
                        if (arm.hand == InteractionHand.MAIN_HAND && model.getHand(0) == null) {
                            model.setHand(0, model.getLimb(arm.lowerLimb));
                            model.setRightShoulder(model.getLimb(arm.upperLimb));
                        } else if (arm.hand == InteractionHand.OFF_HAND && model.getHand(1) == null) {
                            model.setHand(1, model.getLimb(arm.lowerLimb));
                            model.setLeftShoulder(model.getLimb(arm.upperLimb));
                        }
                        handler.addArm(arm);
                    }
                }
                for (String quadID : option.getQuadIDs()) {
                    QuadCollection collection = models.getQuadCollection(quadID);
                    for (Quad quad : collection.getQuads()) {
                        model.getBody().addQuad(quad);
                    }
                }
            }
        }
        for (String modelID : part.getFirstPersonModelIDs()) {
            modelPart = models.getModel(modelID);
            model.addFirstPersonLimb(modelID, (ExtendableModelRenderer)modelPart);
            for (Map.Entry<String, ExtendableModelRenderer> entry : models.getReferences(modelID).entrySet()) {
                model.addLimbReference(entry.getKey(), entry.getValue());
            }
        }
        for (BodyPartOption option : modifications.getModificationOptions(part.getPosition()).values()) {
            for (Map.Entry entry : option.getOptionModels().entrySet()) {
                String baseModelID = (String)entry.getKey();
                if (!model.hasLimb(baseModelID)) continue;
                for (String optionModels : (ArrayList)entry.getValue()) {
                    model.addLimb(optionModels, models.getModel(optionModels), baseModelID);
                    for (Map.Entry<String, ExtendableModelRenderer> entry2 : models.getReferences(optionModels).entrySet()) {
                        model.addLimbReference(entry2.getKey(), entry2.getValue());
                    }
                    for (Arm arm : option.getArms()) {
                        if (arm.hand == InteractionHand.MAIN_HAND && model.getHand(0) == null) {
                            model.setHand(0, model.getLimb(arm.lowerLimb));
                            model.setRightShoulder(model.getLimb(arm.upperLimb));
                        } else if (arm.hand == InteractionHand.OFF_HAND && model.getHand(1) == null) {
                            model.setHand(1, model.getLimb(arm.lowerLimb));
                            model.setLeftShoulder(model.getLimb(arm.upperLimb));
                        }
                        handler.addArm(arm);
                    }
                }
            }
        }
        for (String quadID : part.getQuadIDs()) {
            QuadCollection collection = models.getQuadCollection(quadID);
            for (Quad quad : collection.getQuads()) {
                model.getBody().addQuad(quad);
            }
        }
        if (part.getViewPoint() != null) {
            model.setViewPoint(model.getLimb(part.getViewPoint()));
        }
        return true;
    }

    public static void reset() {
        models = new HashMap();
    }
}

