/*
 * Decompiled with CFR 0.152.
 */
package DaoOfModding.Cultivationcraft.Client.GUI;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.awt.Color;
import java.util.LinkedHashMap;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.resources.ResourceLocation;

public class DropdownList {
    protected static final ResourceLocation TEXTURE = new ResourceLocation("cultivationcraft", "textures/gui/dropdownlist.png");
    public static final int width = 85;
    public static final int closedHeight = 11;
    public static final int openHeight = 71;
    public static final int scrollbarXStart = 75;
    public static final int scrollbarYDown = 60;
    public static final int scrollBarTop = 11;
    public static final int scrollBarBottom = 51;
    protected static final int scrollBarSize = 9;
    protected static final int MaxSize = 6;
    protected int scrollOffset = 0;
    protected LinkedHashMap<String, Object> items = new LinkedHashMap();
    protected String selected = null;
    boolean isOpen = false;

    public void addItem(String name, Object value) {
        this.items.put(name, value);
        if (this.selected == null) {
            this.selected = name;
        }
    }

    public void setOpen(boolean open) {
        this.isOpen = open;
    }

    public Object getSelected() {
        return this.items.get(this.selected);
    }

    public boolean mouseScroll(double mouseX, double mouseY, double direction) {
        if (!this.isOpen) {
            return false;
        }
        this.scroll((int)(-direction));
        return true;
    }

    public Object mouseClick(int mouseX, int mouseY, int buttonPressed) {
        if (this.isOpen) {
            return this.mouseClickOpen(mouseX, mouseY, buttonPressed);
        }
        this.mouseClickClosed(mouseX, mouseY, buttonPressed);
        return null;
    }

    public void mouseClickClosed(int mouseX, int mouseY, int buttonPressed) {
        if (buttonPressed != 0) {
            return;
        }
        if (mouseX >= 0 && mouseX <= 85 && mouseY >= 0 && mouseY <= 11) {
            this.setOpen(true);
        }
    }

    public Object mouseClickOpen(int mouseX, int mouseY, int buttonPressed) {
        if (buttonPressed != 0) {
            return null;
        }
        if (mouseX < 0 || mouseX > 85 || mouseY < 0 || mouseY > 71) {
            this.setOpen(false);
            return null;
        }
        if (mouseX >= 0 && mouseX < 75) {
            if (mouseY <= 11 || mouseY >= 71 || this.changeSelection((float)(mouseY - 11) / 60.0f)) {
                // empty if block
            }
            this.setOpen(false);
            return this.items.get(this.selected);
        }
        if (mouseX >= 75 && mouseX < 85) {
            if (mouseY >= 0 && mouseY < 11) {
                this.scroll(-1);
            } else if (mouseY >= 60 && mouseY < 71) {
                this.scroll(1);
            } else if (mouseY > 0 && mouseY < 71) {
                this.scrollTo((float)(mouseY - 11) / 49.0f);
            }
        }
        return null;
    }

    public void changeSelection(String selection) {
        this.selected = selection;
    }

    public boolean changeSelection(float percent) {
        int selection = (int)(percent * 6.0f);
        int i = 0;
        int count = 0;
        for (String name : this.items.keySet()) {
            if (name.contentEquals(this.selected)) continue;
            if (this.scrollOffset <= i) {
                if (count == selection) {
                    this.changeSelection(name);
                    return true;
                }
                ++count;
                continue;
            }
            ++i;
        }
        return false;
    }

    public void scrollTo(float percent) {
        this.scrollOffset = (int)((float)(this.items.size() - 6) * percent);
        if (this.scrollOffset > this.items.size() - 6 - 1) {
            this.scrollOffset = this.items.size() - 6 - 1;
        }
        if (this.scrollOffset < 0) {
            this.scrollOffset = 0;
        }
    }

    public void scroll(int amount) {
        this.scrollOffset += amount;
        if (this.scrollOffset > this.items.size() - 6 - 1) {
            this.scrollOffset = this.items.size() - 6 - 1;
        }
        if (this.scrollOffset < 0) {
            this.scrollOffset = 0;
        }
    }

    public void render(PoseStack PoseStack2, int xpos, int ypos, int mouseX, int mouseY, GuiComponent gui) {
        RenderSystem.m_157456_((int)0, (ResourceLocation)TEXTURE);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (this.isOpen) {
            GuiComponent.m_93143_((PoseStack)PoseStack2, (int)xpos, (int)ypos, (int)gui.m_93252_(), (float)86.0f, (float)0.0f, (int)85, (int)71, (int)255, (int)255);
            this.drawScrollBar(PoseStack2, xpos, ypos, mouseX, mouseY, gui);
        } else {
            GuiComponent.m_93143_((PoseStack)PoseStack2, (int)xpos, (int)ypos, (int)gui.m_93252_(), (float)0.0f, (float)0.0f, (int)85, (int)11, (int)255, (int)255);
        }
        Minecraft.m_91087_().f_91062_.m_92883_(PoseStack2, this.selected, (float)(xpos + 2), (float)(ypos + 2), Color.white.getRGB());
        if (this.isOpen) {
            this.renderListText(PoseStack2, xpos, ypos, gui);
        }
    }

    public void drawScrollBar(PoseStack PoseStack2, int xpos, int ypos, int mouseX, int mouseY, GuiComponent gui) {
        if (mouseX - xpos >= 75 && mouseX - xpos < 85) {
            if (mouseY - ypos >= 0 && mouseY - ypos < 11) {
                GuiComponent.m_93143_((PoseStack)PoseStack2, (int)(xpos + 75), (int)ypos, (int)gui.m_93252_(), (float)172.0f, (float)0.0f, (int)10, (int)11, (int)255, (int)255);
            } else if (mouseY - ypos >= 60 && mouseY - ypos < 71) {
                GuiComponent.m_93143_((PoseStack)PoseStack2, (int)(xpos + 75), (int)(ypos + 60), (int)gui.m_93252_(), (float)172.0f, (float)60.0f, (int)10, (int)11, (int)255, (int)255);
            }
        }
        float percent = (float)this.scrollOffset / ((float)this.items.size() - 6.0f - 1.0f);
        int scrollPosition = 11 + (int)(40.0f * percent);
        GuiComponent.m_93143_((PoseStack)PoseStack2, (int)(xpos + 75), (int)(ypos + scrollPosition), (int)gui.m_93252_(), (float)172.0f, (float)11.0f, (int)10, (int)9, (int)255, (int)255);
    }

    protected void renderListText(PoseStack PoseStack2, int xpos, int ypos, GuiComponent gui) {
        int i = 0;
        for (String name : this.items.keySet()) {
            if (name.contentEquals(this.selected)) continue;
            if (this.scrollOffset <= i) {
                Minecraft.m_91087_().f_91062_.m_92883_(PoseStack2, name, (float)(xpos + 2), (float)(ypos + 2 + (i + 1 - this.scrollOffset) * 10), Color.white.getRGB());
            }
            if (++i != 6 + this.scrollOffset) continue;
            break;
        }
    }
}

