/*
 * Decompiled with CFR 0.152.
 */
package DaoOfModding.Cultivationcraft.Client.GUI.Screens;

import DaoOfModding.Cultivationcraft.Client.GUI.BodyPartGUI;
import DaoOfModding.Cultivationcraft.Client.GUI.BodyPartGUIs;
import DaoOfModding.Cultivationcraft.Client.GUI.DropdownList;
import DaoOfModding.Cultivationcraft.Client.GUI.GUIButton;
import DaoOfModding.Cultivationcraft.Client.GUI.Screens.GenericTabScreen;
import DaoOfModding.Cultivationcraft.Client.GUI.TextField;
import DaoOfModding.Cultivationcraft.Client.genericClientFunctions;
import DaoOfModding.Cultivationcraft.Common.Capabilities.BodyModifications.BodyModifications;
import DaoOfModding.Cultivationcraft.Common.Capabilities.BodyModifications.IBodyModifications;
import DaoOfModding.Cultivationcraft.Common.Qi.BodyParts.BodyPart;
import DaoOfModding.Cultivationcraft.Common.Qi.BodyParts.BodyPartNames;
import DaoOfModding.Cultivationcraft.Common.Qi.BodyParts.BodyPartOption;
import DaoOfModding.Cultivationcraft.Common.Qi.BodyParts.Quests.Quest;
import DaoOfModding.Cultivationcraft.Common.Qi.BodyParts.Quests.QuestHandler;
import DaoOfModding.Cultivationcraft.Common.Qi.Stats.BodyPartStatControl;
import DaoOfModding.Cultivationcraft.Common.Qi.Stats.StatIDs;
import DaoOfModding.Cultivationcraft.Network.ClientPacketHandler;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Map;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;

public class BodyforgeScreen
extends GenericTabScreen {
    protected DropdownList bodyParts;
    protected DropdownList bodySubParts;
    protected DropdownList forgePart;
    protected GUIButton forge;
    protected GUIButton cancel;
    protected GUIButton description;
    protected GUIButton stats;
    protected final int bodyPartListXPos = 75;
    protected final int bodyPartListYPos = 50;
    protected final int bodySubPartListXPos = 75;
    protected final int bodySubPartListYPos = 75;
    protected final int forgeListYPos = 100;
    protected final int detailsMinXPos = 165;
    protected final int detailsMaxXPos = 245;
    protected final int detailsYPos = 50;
    protected final int detailsYHeight = 100;
    protected int cancelXPos = 118;
    protected final int cancelYPos = 110;
    protected int forgeXPos = 128;
    protected final int forgeYPos = 150;
    protected final int selectedTextXPos = 128;
    protected final int selectedTextYPos = 70;
    protected int oldMode = 0;
    protected int mode = 0;
    protected boolean descriptionMode = true;
    protected TextField partDescription = new TextField();

    public BodyforgeScreen() {
        super(2, (Component)Component.m_237115_((String)"cultivationcraft.gui.bodyforge"), new ResourceLocation("cultivationcraft", "textures/gui/bodyforge.png"));
        String Selection = BodyModifications.getBodyModifications(genericClientFunctions.getPlayer()).getSelection();
        this.updateBodyPartList();
        String forgeString = Component.m_237115_((String)"cultivationcraft.gui.forge").getString();
        this.forge = new GUIButton("FORGE", forgeString);
        String cancelString = Component.m_237115_((String)"cultivationcraft.gui.cancel").getString();
        this.cancel = new GUIButton("CANCEL", cancelString);
        this.forgeXPos -= Minecraft.m_91087_().f_91062_.m_92895_(forgeString) / 2;
        this.cancelXPos -= Minecraft.m_91087_().f_91062_.m_92895_(cancelString) / 2;
        this.description = new GUIButton("DESCRIPTION", Component.m_237115_((String)"cultivationcraft.gui.description").getString());
        this.description.select();
        this.stats = new GUIButton("STATS", Component.m_237115_((String)"cultivationcraft.gui.stats").getString());
    }

    protected void updateBodyPartList() {
        this.bodyParts = new DropdownList();
        Player player = genericClientFunctions.getPlayer();
        ArrayList<String> positions = new ArrayList<String>();
        for (BodyPart bodyPart : BodyPartNames.getParts()) {
            if (positions.contains(bodyPart.getPosition()) || !bodyPart.canBeForged(player)) continue;
            positions.add(bodyPart.getPosition());
        }
        for (BodyPartOption bodyPartOption : BodyPartNames.getOptions()) {
            if (positions.contains(bodyPartOption.getPosition()) || !bodyPartOption.canBeForged(player)) continue;
            positions.add(bodyPartOption.getPosition());
        }
        for (String string : positions) {
            this.bodyParts.addItem(BodyPartNames.getDisplayName(string), string);
        }
        if (positions.size() == 0) {
            this.bodyParts.addItem("", "");
        }
        this.updateBodySubPartList();
    }

    protected void updateBodySubPartList() {
        this.bodySubParts = new DropdownList();
        Player player = genericClientFunctions.getPlayer();
        ArrayList<String> positions = new ArrayList<String>();
        for (BodyPart bodyPart : BodyPartNames.getParts()) {
            if (!this.equalsSelectedPosition(bodyPart.getPosition()).booleanValue() || positions.contains("BASE") || !bodyPart.canBeForged(player)) continue;
            positions.add("BASE");
        }
        for (BodyPartOption bodyPartOption : BodyPartNames.getOptions()) {
            if (!this.equalsSelectedPosition(bodyPartOption.getPosition()).booleanValue() || positions.contains(bodyPartOption.getSubPosition()) || !bodyPartOption.canBeForged(player)) continue;
            positions.add(bodyPartOption.getSubPosition());
        }
        for (String string : positions) {
            this.bodySubParts.addItem(BodyPartNames.getDisplayName(this.getSelectedPosition(), string), string);
        }
        if (positions.size() == 0) {
            this.bodySubParts.addItem("", "");
        }
        this.updateButtons();
    }

    protected void updateButtons() {
        this.forgePart = new DropdownList();
        Player player = genericClientFunctions.getPlayer();
        if (this.getSelectedSubPosition().compareTo("BASE") == 0) {
            for (BodyPart part : BodyPartNames.getParts()) {
                if (!this.equalsSelectedPosition(part.getPosition()).booleanValue() || !part.canBeForged(player)) continue;
                this.forgePart.addItem(part.getDisplayName(), part.getID());
            }
        } else {
            for (BodyPartOption part : BodyPartNames.getOptions()) {
                if (!this.equalsSelectedPosition(part.getPosition()).booleanValue() || !this.equalsSelectedSubPosition(part.getSubPosition()).booleanValue() || !part.canBeForged(player)) continue;
                this.forgePart.addItem(part.getDisplayName(), part.getID());
            }
        }
    }

    @Override
    public boolean m_6375_(double mouseX, double mouseY, int buttonPressed) {
        Objects.requireNonNull(this);
        int edgeSpacingX = (this.f_96543_ - 256) / 2;
        Objects.requireNonNull(this);
        int edgeSpacingY = (this.f_96544_ - 178) / 2;
        if (super.m_6375_(mouseX, mouseY, buttonPressed)) {
            return true;
        }
        if (this.mode == 0) {
            String changed = (String)this.bodyParts.mouseClick((int)mouseX - (edgeSpacingX + 75), (int)mouseY - (edgeSpacingY + 50), buttonPressed);
            if (changed != null) {
                this.partDescription.resetScroll();
                this.updateBodySubPartList();
                return true;
            }
            if (this.bodySubParts.mouseClick((int)mouseX - (edgeSpacingX + 75), (int)mouseY - (edgeSpacingY + 75), buttonPressed) != null) {
                this.updateButtons();
                return true;
            }
            if (this.forgePart.mouseClick((int)mouseX - (edgeSpacingX + 75), (int)mouseY - (edgeSpacingY + 100), buttonPressed) != null) {
                this.partDescription.resetScroll();
                return true;
            }
            if (this.forge.mouseClick((int)mouseX, (int)mouseY, buttonPressed)) {
                if (this.forgePart.getSelected() != null) {
                    ClientPacketHandler.sendBodyForgeSelectionToServer(this.forgePart.getSelected().toString());
                }
                this.forge.unselect();
                return true;
            }
            if (this.description.mouseClick((int)mouseX, (int)mouseY, buttonPressed)) {
                this.description.select();
                this.stats.unselect();
                this.partDescription.resetScroll();
                this.descriptionMode = true;
            } else if (this.stats.mouseClick((int)mouseX, (int)mouseY, buttonPressed)) {
                this.stats.select();
                this.description.unselect();
                this.partDescription.resetScroll();
                this.descriptionMode = false;
            }
            if (mouseX > (double)(edgeSpacingX + 165) && mouseX < (double)(edgeSpacingX + 165 + 80) && mouseY > (double)(edgeSpacingY + 50) && mouseY < (double)(edgeSpacingY + 50 + 100)) {
                return this.partDescription.mouseClicked(mouseX - (double)(edgeSpacingX + 165), mouseY - (double)(edgeSpacingY + 50), buttonPressed);
            }
        }
        if (this.cancel.mouseClick((int)mouseX, (int)mouseY, buttonPressed)) {
            if (this.mode != 2) {
                ClientPacketHandler.sendBodyForgeSelectionToServer("");
            } else {
                ClientPacketHandler.sendQuestCancelToServer();
            }
            this.cancel.unselect();
            this.updateBodyPartList();
            return true;
        }
        return false;
    }

    public boolean m_6050_(double mouseX, double mouseY, double direction) {
        Objects.requireNonNull(this);
        int edgeSpacingX = (this.f_96543_ - 256) / 2;
        Objects.requireNonNull(this);
        int edgeSpacingY = (this.f_96544_ - 178) / 2;
        if (this.bodyParts.mouseScroll((int)mouseX - (edgeSpacingX + 75), (int)mouseY - (edgeSpacingY + 50), direction)) {
            return true;
        }
        if (this.bodySubParts.mouseScroll((int)mouseX - (edgeSpacingX + 75), (int)mouseY - (edgeSpacingY + 75), direction)) {
            return true;
        }
        if (this.mode == 0 && mouseX > (double)(edgeSpacingX + 165) && mouseX < (double)(edgeSpacingX + 165 + 80) && mouseY > (double)(edgeSpacingY + 50) && mouseY < (double)(edgeSpacingY + 50 + 100)) {
            return this.partDescription.mouseScrolled(direction);
        }
        return false;
    }

    @Override
    public void m_6305_(PoseStack PoseStack2, int mouseX, int mouseY, float partialTicks) {
        super.m_6305_(PoseStack2, mouseX, mouseY, partialTicks);
        this.drawGuiForgroundLayer(PoseStack2, partialTicks, mouseX, mouseY);
    }

    protected void drawGuiDetailsForgroundLayer(PoseStack PoseStack2, int mouseX, int mouseY) {
        if (this.forgePart.getSelected() == null) {
            return;
        }
        BodyPart part = BodyPartNames.getPart(this.forgePart.getSelected().toString());
        if (part == null) {
            part = BodyPartNames.getOption(this.forgePart.getSelected().toString());
        }
        Objects.requireNonNull(this);
        int edgeSpacingX = (this.f_96543_ - 256) / 2;
        Objects.requireNonNull(this);
        int edgeSpacingY = (this.f_96544_ - 178) / 2;
        this.partDescription.setPos(edgeSpacingX + 165, edgeSpacingY + 50);
        this.partDescription.setSize(80, 100);
        if (this.descriptionMode) {
            this.partDescription.setText(part.getDescription());
        } else {
            this.partDescription.setText(part.getStatChanges().toString());
        }
        this.partDescription.render(this, this.f_96547_, PoseStack2, mouseX, mouseY);
        this.description.setPos(edgeSpacingX + 165, edgeSpacingY + 50 - 20);
        this.description.render(PoseStack2, mouseX, mouseY, (GuiComponent)this);
        this.stats.setPos(edgeSpacingX + 245 - this.stats.width, edgeSpacingY + 50 - 20);
        this.stats.render(PoseStack2, mouseX, mouseY, (GuiComponent)this);
    }

    protected void drawGuiForgroundLayer(PoseStack PoseStack2, float partialTicks, int mouseX, int mouseY) {
        this.drawBody(PoseStack2);
        IBodyModifications modifications = BodyModifications.getBodyModifications(genericClientFunctions.getPlayer());
        String questPart = modifications.getLastForged();
        this.oldMode = this.mode;
        if (questPart.compareTo("") != 0) {
            BodyPart part = BodyPartNames.getPart(questPart);
            if (part == null) {
                part = BodyPartNames.getOption(questPart);
            }
            this.drawQuest(PoseStack2, part, mouseX, mouseY);
        } else {
            String Selection = modifications.getSelection();
            BodyPart part = BodyPartNames.getPart(Selection);
            if (part == null) {
                part = BodyPartNames.getOption(Selection);
            }
            if (part == null) {
                this.drawSelection(PoseStack2, mouseX, mouseY);
            } else {
                this.drawSelected(PoseStack2, part, mouseX, mouseY);
            }
        }
    }

    protected void drawSelection(PoseStack PoseStack2, int mouseX, int mouseY) {
        this.mode = 0;
        if (this.oldMode != this.mode) {
            this.updateBodyPartList();
        }
        Objects.requireNonNull(this);
        int edgeSpacingX = (this.f_96543_ - 256) / 2;
        Objects.requireNonNull(this);
        int edgeSpacingY = (this.f_96544_ - 178) / 2;
        this.forge.setPos(edgeSpacingX + this.forgeXPos, edgeSpacingY + 150);
        this.forge.render(PoseStack2, mouseX, mouseY, (GuiComponent)this);
        this.forgePart.render(PoseStack2, edgeSpacingX + 75, edgeSpacingY + 100, mouseX, mouseY, (GuiComponent)this);
        this.bodySubParts.render(PoseStack2, edgeSpacingX + 75, edgeSpacingY + 75, mouseX, mouseY, (GuiComponent)this);
        this.bodyParts.render(PoseStack2, edgeSpacingX + 75, edgeSpacingY + 50, mouseX, mouseY, (GuiComponent)this);
        this.drawGuiDetailsForgroundLayer(PoseStack2, mouseX, mouseY);
    }

    protected void drawSelected(PoseStack PoseStack2, BodyPart part, int mouseX, int mouseY) {
        this.mode = 1;
        Objects.requireNonNull(this);
        int edgeSpacingX = (this.f_96543_ - 256) / 2;
        Objects.requireNonNull(this);
        int edgeSpacingY = (this.f_96544_ - 178) / 2;
        String position = BodyPartNames.getDisplayName(part.getPosition());
        String subPosition = BodyPartNames.getDisplayName("BASE");
        if (part instanceof BodyPartOption) {
            subPosition = BodyPartNames.getDisplayName(part.getPosition(), ((BodyPartOption)part).getSubPosition());
        }
        this.f_96547_.m_92883_(PoseStack2, position, (float)(edgeSpacingX + 128 - this.f_96547_.m_92895_(position) / 2), (float)(edgeSpacingY + 70), Color.GRAY.getRGB());
        float f = edgeSpacingX + 128 - this.f_96547_.m_92895_(subPosition) / 2;
        Objects.requireNonNull(this.f_96547_);
        this.f_96547_.m_92883_(PoseStack2, subPosition, f, (float)(edgeSpacingY + 70 + 9), Color.GRAY.getRGB());
        String string = part.getDisplayName();
        float f2 = edgeSpacingX + 128 - this.f_96547_.m_92895_(part.getDisplayName()) / 2;
        Objects.requireNonNull(this.f_96547_);
        this.f_96547_.m_92883_(PoseStack2, string, f2, (float)(edgeSpacingY + 70 + 9 * 2), Color.BLACK.getRGB());
        IBodyModifications modifications = BodyModifications.getBodyModifications(genericClientFunctions.getPlayer());
        float progress = (float)modifications.getProgress() / BodyPartStatControl.getStats(genericClientFunctions.getPlayer()).getStat(StatIDs.qiCost);
        RenderSystem.m_157456_((int)0, (ResourceLocation)this.TEXTURE);
        int length = 238;
        this.m_93228_(PoseStack2, edgeSpacingX + 9, edgeSpacingY + 160, 0, 233, length, 6);
        this.m_93228_(PoseStack2, edgeSpacingX + 10, edgeSpacingY + 161, 1, 239, (int)((float)(length - 2) * progress), 4);
        this.cancel.setPos(edgeSpacingX + this.cancelXPos, edgeSpacingY + 110);
        this.cancel.render(PoseStack2, mouseX, mouseY, (GuiComponent)this);
    }

    protected void drawQuest(PoseStack PoseStack2, BodyPart part, int mouseX, int mouseY) {
        this.mode = 2;
        Quest quest = part.getQuest();
        double progress = QuestHandler.getQuestProgress((Player)Minecraft.m_91087_().f_91074_);
        Objects.requireNonNull(this);
        int edgeSpacingX = (this.f_96543_ - 256) / 2;
        Objects.requireNonNull(this);
        int edgeSpacingY = (this.f_96544_ - 178) / 2;
        String partName = part.getDisplayName();
        String position = BodyPartNames.getDisplayName(part.getPosition());
        String subPosition = BodyPartNames.getDisplayName("BASE");
        if (part instanceof BodyPartOption) {
            subPosition = BodyPartNames.getDisplayName(part.getPosition(), ((BodyPartOption)part).getSubPosition());
        }
        String stabilizing = Component.m_237115_((String)"cultivationcraft.gui.generic.stabilizing").getString();
        this.f_96547_.m_92883_(PoseStack2, stabilizing, (float)(edgeSpacingX + 75), (float)(edgeSpacingY + 30), Color.BLACK.getRGB());
        this.f_96547_.m_92883_(PoseStack2, position + "->" + subPosition + "->" + partName, (float)(edgeSpacingX + 75), (float)(edgeSpacingY + 45), Color.GRAY.getRGB());
        this.f_96547_.m_92883_(PoseStack2, quest.getDescription(), (float)(edgeSpacingX + 10), (float)(edgeSpacingY + 130), Color.GRAY.getRGB());
        this.f_96547_.m_92883_(PoseStack2, (int)progress + "/" + (int)quest.complete, (float)(edgeSpacingX + 75), (float)(edgeSpacingY + 145), Color.GRAY.getRGB());
        RenderSystem.m_157456_((int)0, (ResourceLocation)this.TEXTURE);
        int length = 238;
        this.m_93228_(PoseStack2, edgeSpacingX + 9, edgeSpacingY + 160, 0, 233, length, 6);
        this.m_93228_(PoseStack2, edgeSpacingX + 10, edgeSpacingY + 161, 1, 239, (int)((double)(length - 2) * (progress / quest.complete)), 4);
        this.cancel.setPos(edgeSpacingX + this.cancelXPos, edgeSpacingY + 110);
        this.cancel.render(PoseStack2, mouseX, mouseY, (GuiComponent)this);
    }

    protected void drawBody(PoseStack PoseStack2) {
        Objects.requireNonNull(this);
        int edgeSpacingX = (this.f_96543_ - 256) / 2;
        Objects.requireNonNull(this);
        int edgeSpacingY = (this.f_96544_ - 178) / 2;
        int bodyPosX = edgeSpacingX + 30;
        int bodyPosY = edgeSpacingY + 60;
        IBodyModifications modifications = BodyModifications.getBodyModifications(genericClientFunctions.getPlayer());
        BodyPartGUI base = BodyPartGUIs.getGUI("body").get(0);
        if (modifications.hasModification("BODY")) {
            base = BodyPartGUIs.getGUI(modifications.getModification("BODY").getID()).get(0);
        }
        boolean highlight = false;
        if (this.equalsSelectedPosition("BODY").booleanValue()) {
            highlight = true;
        }
        base.render(PoseStack2, bodyPosX, bodyPosY, highlight, (GuiComponent)this);
        highlight = false;
        if (!modifications.hasModification("HEAD")) {
            if (this.equalsSelectedPosition("HEAD").booleanValue()) {
                highlight = true;
            }
            BodyPartGUIs.getGUI("head").get(0).render(PoseStack2, bodyPosX, bodyPosY, highlight, (GuiComponent)this, base);
        }
        highlight = false;
        if (!modifications.hasModification("ARM")) {
            if (this.equalsSelectedPosition("ARM").booleanValue()) {
                highlight = true;
            }
            BodyPartGUIs.getGUI("armright").get(0).render(PoseStack2, bodyPosX, bodyPosY, highlight, (GuiComponent)this, base);
            BodyPartGUIs.getGUI("armleft").get(0).render(PoseStack2, bodyPosX, bodyPosY, highlight, (GuiComponent)this, base);
        }
        highlight = false;
        if (!modifications.hasModification("LEG")) {
            if (this.equalsSelectedPosition("LEG").booleanValue()) {
                highlight = true;
            }
            BodyPartGUIs.getGUI("legright").get(0).render(PoseStack2, bodyPosX, bodyPosY, highlight, (GuiComponent)this, base);
            BodyPartGUIs.getGUI("legleft").get(0).render(PoseStack2, bodyPosX, bodyPosY, highlight, (GuiComponent)this, base);
        }
        for (Map.Entry<String, BodyPart> entry : modifications.getModifications().entrySet()) {
            if (entry.getKey() == "BODY") continue;
            highlight = false;
            if (this.equalsSelectedPosition(entry.getValue().getPosition()).booleanValue()) {
                highlight = true;
            }
            ArrayList<BodyPartGUI> guis = BodyPartGUIs.getGUI(entry.getValue().getID());
            for (BodyPartGUI gui : guis) {
                if (gui == null) continue;
                gui.render(PoseStack2, bodyPosX, bodyPosY, highlight, (GuiComponent)this, base);
            }
        }
    }

    protected String getSelectedPosition() {
        BodyPart part;
        IBodyModifications modifications = BodyModifications.getBodyModifications(genericClientFunctions.getPlayer());
        String selected = (String)this.bodyParts.getSelected();
        String Selection = modifications.getSelection();
        if (this.mode == 2) {
            Selection = modifications.getLastForged();
        }
        if ((part = BodyPartNames.getPartOrOption(Selection)) != null) {
            selected = part.getPosition();
        }
        if (selected == null) {
            selected = "";
        }
        return selected;
    }

    protected String getSelectedSubPosition() {
        String selected = (String)this.bodySubParts.getSelected();
        if (selected == null) {
            selected = "";
        }
        return selected;
    }

    protected Boolean equalsSelectedPosition(String compare) {
        if (this.getSelectedPosition().compareTo(compare) == 0) {
            return true;
        }
        return false;
    }

    protected Boolean equalsSelectedSubPosition(String compare) {
        if (this.getSelectedSubPosition().compareTo(compare) == 0) {
            return true;
        }
        return false;
    }
}

