/*
 * Decompiled with CFR 0.152.
 */
package DaoOfModding.Cultivationcraft.Client.GUI.Screens;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Objects;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;

public class SelectableText {
    ResourceLocation texture = new ResourceLocation("cultivationcraft", "textures/gui/textfield.png");
    protected String selectableName;
    protected String selectableText;
    protected ArrayList<SelectableText> selectables = new ArrayList();
    protected boolean expanded = false;
    protected boolean selected = false;
    protected static final int tabbing = 10;
    public static final int yPadding = 2;
    protected static final Color highlightColor = new Color(140, 200, 140);
    protected int lineHeight = 0;
    protected String ID;
    protected MutableComponent name;
    protected MutableComponent text;

    public SelectableText(String name, String text) {
        this.selectableName = name;
        this.selectableText = text;
    }

    public SelectableText(String component) {
        this.ID = component;
        this.name = Component.m_237115_((String)component);
        this.text = Component.m_237115_((String)component.concat(".text"));
    }

    public String getID() {
        return this.ID;
    }

    public String getText() {
        if (this.text == null) {
            return this.selectableText;
        }
        return this.text.getString();
    }

    public String getName() {
        if (this.name == null) {
            return this.selectableName;
        }
        return this.name.getString();
    }

    public void unselectAll() {
        this.selected = false;
        for (SelectableText select : this.selectables) {
            select.unselectAll();
        }
    }

    public void select() {
        this.selected = true;
    }

    public void addItem(SelectableText item) {
        this.selectables.add(item);
    }

    public int height() {
        int height = this.lineHeight;
        if (this.expanded) {
            for (SelectableText selectable : this.selectables) {
                height += selectable.height();
            }
        }
        return height;
    }

    public SelectableText mouseClicked(double mouseX, double mouseY, int buttonPressed) {
        if (buttonPressed != 0) {
            return null;
        }
        int line = (int)(mouseY / (double)this.lineHeight);
        if (line == 0) {
            this.expanded = !this.expanded;
            return this;
        }
        if (this.expanded) {
            int entryLine = 0;
            int lineCheck = 0;
            for (SelectableText selectable : this.selectables) {
                if (line <= (lineCheck += selectable.height() / this.lineHeight)) {
                    return selectable.mouseClicked(mouseX, mouseY - (double)((entryLine + 1) * this.lineHeight), buttonPressed);
                }
                entryLine += selectable.height() / this.lineHeight;
            }
        }
        return null;
    }

    public void render(Screen screen, Font font, PoseStack poseStack, int color, int xPos, int yPos, int xEnd, int yStart, int yEnd) {
        Objects.requireNonNull(font);
        this.lineHeight = 9 + 2;
        if (yPos <= yEnd - this.lineHeight && yPos >= yStart) {
            if (this.selected) {
                RenderSystem.m_157456_((int)0, (ResourceLocation)this.texture);
                RenderSystem.m_157429_((float)((float)highlightColor.getRed() / 255.0f), (float)((float)highlightColor.getGreen() / 255.0f), (float)((float)highlightColor.getBlue() / 255.0f), (float)1.0f);
                Screen.m_93143_((PoseStack)poseStack, (int)(xPos - 2), (int)(yPos - 2), (int)screen.m_93252_(), (float)0.0f, (float)0.0f, (int)(xEnd - xPos + 4), (int)this.lineHeight, (int)(xEnd - xPos + 4), (int)this.lineHeight);
            }
            FormattedText formatedName = font.m_92854_(FormattedText.m_130775_((String)this.getName()), xEnd - xPos);
            font.m_92883_(poseStack, formatedName.getString(), (float)xPos, (float)yPos, color);
        }
        if (this.expanded) {
            xPos += 10;
            yPos += this.lineHeight;
            for (SelectableText select : this.selectables) {
                select.render(screen, font, poseStack, color, xPos, yPos, xEnd, yStart, yEnd);
                yPos += select.height();
            }
        }
    }
}

