/*
 * Decompiled with CFR 0.152.
 */
package DaoOfModding.Cultivationcraft.Client.GUI.Screens;

import DaoOfModding.Cultivationcraft.Client.GUI.GUIButton;
import DaoOfModding.Cultivationcraft.Client.GUI.Screens.GenericTabScreen;
import DaoOfModding.Cultivationcraft.Common.Capabilities.CultivatorStats.CultivatorStats;
import DaoOfModding.Cultivationcraft.Common.Qi.Cultivation.CultivationType;
import DaoOfModding.Cultivationcraft.Common.Qi.Techniques.Technique;
import DaoOfModding.Cultivationcraft.Common.Qi.Techniques.TechniqueStats.DefaultTechniqueStatIDs;
import DaoOfModding.Cultivationcraft.Common.Qi.Techniques.TechniqueStats.TechniqueStatModification;
import DaoOfModding.Cultivationcraft.Network.ClientPacketHandler;
import com.mojang.blaze3d.vertex.PoseStack;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;

public class TechniqueModifyScreen
extends GenericTabScreen {
    protected final int inspirationXPos = 30;
    protected final int inspirationYPos = 20;
    protected final int statXPos = 20;
    protected final int statYPos = 40;
    protected final int statYSpacing = 10;
    protected final int statXPosFromRight = 80;
    protected final int buttonXPosFromRight = 20;
    protected Technique selectedTech;
    protected ArrayList<ResourceLocation> stats = new ArrayList();
    protected GUIButton[] buttons;

    public TechniqueModifyScreen(Technique tech, int activeTab) {
        super(activeTab, (Component)Component.m_237115_((String)"cultivationcraft.gui.technique"), new ResourceLocation("cultivationcraft", "textures/gui/stats.png"));
        this.selectedTech = tech;
        this.updateStats();
    }

    protected void updateStats() {
        this.stats = new ArrayList();
        for (ResourceLocation stat : this.selectedTech.getTechniqueStats()) {
            this.stats.add(stat);
        }
        int buttonNumber = this.stats.size();
        this.buttons = new GUIButton[buttonNumber];
        for (int i = 0; i < buttonNumber; ++i) {
            this.buttons[i] = new GUIButton("TechStat" + i, " ");
        }
        ResourceLocation selected = CultivatorStats.getCultivatorStats((Player)Minecraft.m_91087_().f_91074_).getTechniqueFocus(this.selectedTech.getClass());
        this.buttons[this.resourceLocationToNumber(selected)].select();
    }

    protected int resourceLocationToNumber(ResourceLocation location) {
        if (location == null) {
            CultivatorStats.getCultivatorStats((Player)Minecraft.m_91087_().f_91074_).setTechniqueFocus(this.selectedTech.getClass().toString(), this.stats.get(0));
            return 0;
        }
        int number = 0;
        int i = 0;
        for (ResourceLocation check : this.stats) {
            if (check.compareTo(location) == 0) {
                return i;
            }
            ++i;
        }
        return number;
    }

    @Override
    public boolean m_6375_(double mouseX, double mouseY, int buttonPressed) {
        if (super.m_6375_(mouseX, mouseY, buttonPressed)) {
            return true;
        }
        for (int i = 0; i < this.buttons.length; ++i) {
            if (!this.buttons[i].mouseClick((int)mouseX, (int)mouseY, buttonPressed)) continue;
            for (int j = 0; j < this.buttons.length; ++j) {
                this.buttons[j].unselect();
            }
            this.buttons[i].select();
            ClientPacketHandler.sendTechStatToServer(this.selectedTech.getClass(), this.stats.get(i));
            return true;
        }
        return false;
    }

    @Override
    public void m_6305_(PoseStack PoseStack2, int mouseX, int mouseY, float partialTicks) {
        super.m_6305_(PoseStack2, mouseX, mouseY, partialTicks);
        this.drawGuiForgroundLayer(PoseStack2, partialTicks, mouseX, mouseY);
    }

    protected ResourceLocation updateFocus() {
        ResourceLocation focus = this.selectedTech.getFirstStatChange();
        CultivatorStats.getCultivatorStats((Player)Minecraft.m_91087_().f_91074_).setTechniqueFocus(this.selectedTech.getClass().toString(), focus);
        this.updateStats();
        return focus;
    }

    protected TechniqueStatModification getStatModification() {
        TechniqueStatModification modifications;
        ResourceLocation focus = CultivatorStats.getCultivatorStats((Player)Minecraft.m_91087_().f_91074_).getTechniqueFocus(this.selectedTech.getClass());
        if (focus == null) {
            focus = this.updateFocus();
        }
        if ((modifications = this.selectedTech.getStatChangesPerLevel(focus)) == null) {
            modifications = this.selectedTech.getStatChangesPerLevel(this.updateFocus());
        }
        return modifications;
    }

    protected void drawGuiForgroundLayer(PoseStack PoseStack2, float partialTicks, int mouseX, int mouseY) {
        Objects.requireNonNull(this);
        int edgeSpacingX = (this.f_96543_ - 256) / 2;
        Objects.requireNonNull(this);
        int edgeSpacingY = (this.f_96544_ - 178) / 2;
        CultivationType cultivation = CultivatorStats.getCultivatorStats((Player)Minecraft.m_91087_().f_91074_).getCultivation();
        int maxInspiration = cultivation.getMaxTechLevel();
        int currentInspiration = cultivation.getTechLevelProgress(this.selectedTech.getClass());
        String inspiration = currentInspiration + "/" + maxInspiration;
        Objects.requireNonNull(this);
        this.f_96547_.m_92883_(PoseStack2, inspiration, (float)(edgeSpacingX + 256 - 30 - this.f_96547_.m_92895_(inspiration)), (float)(edgeSpacingY + 20), Color.white.getRGB());
        this.drawStats(PoseStack2, mouseX, mouseY);
    }

    protected void drawStats(PoseStack PoseStack2, int mouseX, int mouseY) {
        TechniqueStatModification modifications = this.getStatModification();
        for (int stat = 0; stat < this.stats.size(); ++stat) {
            double statValue = this.selectedTech.getTechniqueStat(this.stats.get(stat), (Player)Minecraft.m_91087_().f_91074_);
            this.drawStat(PoseStack2, stat, this.stats.get(stat), statValue);
            double value = modifications.getStatChange(this.stats.get(stat));
            this.drawStatChanges(PoseStack2, stat, this.stats.get(stat), value);
            if (this.selectedTech.getStatChangesPerLevel(this.stats.get(stat)) == null) continue;
            this.drawButton(PoseStack2, stat, mouseX, mouseY);
        }
    }

    protected void drawStat(PoseStack PoseStack2, int pos, ResourceLocation stat, double statValue) {
        Objects.requireNonNull(this);
        int edgeSpacingX = (this.f_96543_ - 256) / 2;
        Objects.requireNonNull(this);
        int edgeSpacingY = (this.f_96544_ - 178) / 2;
        statValue = (double)((int)(statValue * 1000.0)) / 1000.0;
        this.f_96547_.m_92883_(PoseStack2, Component.m_237115_((String)stat.m_135815_()).getString(), (float)(edgeSpacingX + 20), (float)(edgeSpacingY + 40 + 10 * pos), Color.black.getRGB());
        String string = "" + statValue;
        Objects.requireNonNull(this);
        this.f_96547_.m_92883_(PoseStack2, string, (float)(edgeSpacingX + 256 - 80 - this.f_96547_.m_92895_("" + statValue)), (float)(edgeSpacingY + 40 + 10 * pos), Color.WHITE.getRGB());
    }

    protected void drawButton(PoseStack PoseStack2, int pos, int mouseX, int mouseY) {
        Objects.requireNonNull(this);
        int edgeSpacingX = (this.f_96543_ - 256) / 2;
        Objects.requireNonNull(this);
        int edgeSpacingY = (this.f_96544_ - 178) / 2;
        GUIButton gUIButton = this.buttons[pos];
        Objects.requireNonNull(this);
        gUIButton.setPos(edgeSpacingX + 256 - 20 - this.buttons[pos].width, edgeSpacingY + 40 + 10 * pos - 2);
        this.buttons[pos].render(PoseStack2, mouseX, mouseY, (GuiComponent)this);
    }

    protected void drawStatChanges(PoseStack PoseStack2, int pos, ResourceLocation stat, double value) {
        if (value != 0.0) {
            boolean reversed;
            Objects.requireNonNull(this);
            int edgeSpacingX = (this.f_96543_ - 256) / 2;
            Objects.requireNonNull(this);
            int edgeSpacingY = (this.f_96544_ - 178) / 2;
            Object amount = " (";
            Color col = Color.red;
            if (value > 0.0) {
                amount = (String)amount + "+";
            }
            if (!(reversed = DefaultTechniqueStatIDs.isReversedNegative(stat)) && value > 0.0 || reversed && value < 0.0) {
                col = Color.GREEN;
            }
            amount = (String)amount + value + ")";
            Objects.requireNonNull(this);
            this.f_96547_.m_92883_(PoseStack2, (String)amount, (float)(edgeSpacingX + 256 - 80), (float)(edgeSpacingY + 40 + 10 * pos), col.getRGB());
        }
    }
}

