/*
 * Decompiled with CFR 0.152.
 */
package DaoOfModding.Cultivationcraft.Client.GUI.Screens;

import DaoOfModding.Cultivationcraft.Client.GUI.DropdownList;
import DaoOfModding.Cultivationcraft.Client.GUI.GUIButton;
import DaoOfModding.Cultivationcraft.Client.GUI.Screens.GenericTabScreen;
import DaoOfModding.Cultivationcraft.Client.GUI.Screens.TechniqueModifyScreen;
import DaoOfModding.Cultivationcraft.Client.GUI.TechniqueIcons;
import DaoOfModding.Cultivationcraft.Client.GUI.TextField;
import DaoOfModding.Cultivationcraft.Client.genericClientFunctions;
import DaoOfModding.Cultivationcraft.Common.Capabilities.CultivatorTechniques.CultivatorTechniques;
import DaoOfModding.Cultivationcraft.Common.Capabilities.CultivatorTechniques.ICultivatorTechniques;
import DaoOfModding.Cultivationcraft.Common.Qi.TechniqueControl;
import DaoOfModding.Cultivationcraft.Common.Qi.Techniques.Technique;
import DaoOfModding.Cultivationcraft.Cultivationcraft;
import DaoOfModding.Cultivationcraft.Network.ClientPacketHandler;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;

public class TechniqueScreen
extends GenericTabScreen {
    protected DropdownList techniques;
    public static int selected = 0;
    protected final int techniqueXPos = 85;
    protected final int techniqueYPos = 30;
    protected GUIButton description;
    protected GUIButton stats;
    protected GUIButton modify;
    protected TextField partDescription = new TextField();

    public TechniqueScreen() {
        super(1, (Component)Component.m_237115_((String)"cultivationcraft.gui.technique"), new ResourceLocation("cultivationcraft", "textures/gui/technique.png"));
        this.updateTechniqueList();
        this.partDescription.setSize(196, 80);
        this.description = new GUIButton("DESCRIPTION", Component.m_237115_((String)"cultivationcraft.gui.description").getString());
        this.description.select();
        this.stats = new GUIButton("STATS", Component.m_237115_((String)"cultivationcraft.gui.stats").getString());
        this.modify = new GUIButton("MODIFY", Component.m_237115_((String)"cultivationcraft.gui.modify").getString());
    }

    protected void updateTechniqueList() {
        this.techniques = new DropdownList();
        this.techniques.addItem(Component.m_237115_((String)"cultivationcraft.gui.notechnique").getString(), Technique.class);
        ICultivatorTechniques techList = CultivatorTechniques.getCultivatorTechniques(genericClientFunctions.getPlayer());
        for (Class tech : TechniqueControl.getAvailableTechnics(genericClientFunctions.getPlayer())) {
            try {
                Technique technique = (Technique)tech.newInstance();
                if (!technique.isValid(genericClientFunctions.getPlayer()) || !technique.allowMultiple() && techList.techniqueExists(technique)) continue;
                this.techniques.addItem(technique.getName(), tech);
            }
            catch (Exception e) {
                Cultivationcraft.LOGGER.error(tech.getName() + " is not a Technique: " + e.getMessage());
            }
        }
        this.updateSelection();
    }

    protected void updateSelection() {
        Technique selectedTech = CultivatorTechniques.getCultivatorTechniques(genericClientFunctions.getPlayer()).getTechnique(selected);
        if (selectedTech != null) {
            this.techniques.changeSelection(selectedTech.getName());
        } else {
            this.techniques.changeSelection(Component.m_237115_((String)"cultivationcraft.gui.notechnique").getString());
        }
    }

    @Override
    public void m_6305_(PoseStack PoseStack2, int mouseX, int mouseY, float partialTicks) {
        super.m_6305_(PoseStack2, mouseX, mouseY, partialTicks);
        this.drawGuiForgroundLayer(PoseStack2, partialTicks, mouseX, mouseY);
    }

    public boolean m_6050_(double mouseX, double mouseY, double direction) {
        Objects.requireNonNull(this);
        int edgeSpacingX = (this.f_96543_ - 256) / 2;
        Objects.requireNonNull(this);
        int edgeSpacingY = (this.f_96544_ - 178) / 2;
        return this.techniques.mouseScroll((int)mouseX - (edgeSpacingX + 85), (int)mouseY - (edgeSpacingY + 30), direction);
    }

    public void changeTechnique(Class newTech) {
        ICultivatorTechniques techs = CultivatorTechniques.getCultivatorTechniques(genericClientFunctions.getPlayer());
        Technique newTechnique = null;
        try {
            if (newTech != Technique.class) {
                newTechnique = (Technique)newTech.newInstance();
            }
        }
        catch (Exception e) {
            Cultivationcraft.LOGGER.warn("Error assigning technique: " + e);
        }
        if (newTechnique != null && !newTechnique.allowMultiple() && techs.techniqueExists(newTechnique)) {
            Cultivationcraft.LOGGER.warn("Tried to assign technique that already exists");
            return;
        }
        if (techs.getTechnique(selected) != null && techs.getTechnique(selected).isActive()) {
            techs.getTechnique(selected).deactivate((Player)Minecraft.m_91087_().f_91074_);
        }
        techs.setTechnique(selected, newTechnique);
        this.updateTechniqueList();
        ClientPacketHandler.sendCultivatorTechniquesToServer();
    }

    @Override
    public boolean m_6375_(double mouseX, double mouseY, int buttonPressed) {
        int techniqueSelected;
        if (super.m_6375_(mouseX, mouseY, buttonPressed)) {
            return true;
        }
        if (this.partDescription.mouseClicked(mouseX, mouseY, buttonPressed)) {
            return true;
        }
        Objects.requireNonNull(this);
        int edgeSpacingX = (this.f_96543_ - 256) / 2;
        Objects.requireNonNull(this);
        int edgeSpacingY = (this.f_96544_ - 178) / 2;
        Class changed = (Class)this.techniques.mouseClick((int)mouseX - (edgeSpacingX + 85), (int)mouseY - (edgeSpacingY + 30), buttonPressed);
        if (changed != null) {
            this.changeTechnique(changed);
            return true;
        }
        if (buttonPressed == 0 && (techniqueSelected = TechniqueIcons.mouseOver(edgeSpacingX + 48, edgeSpacingY + 155, (int)mouseX, (int)mouseY, 18)) != -1) {
            this.changeSelection(techniqueSelected);
        }
        if (this.description.mouseClick((int)mouseX, (int)mouseY, buttonPressed)) {
            this.stats.unselect();
            this.description.select();
            return true;
        }
        if (this.stats.mouseClick((int)mouseX, (int)mouseY, buttonPressed)) {
            this.description.unselect();
            this.stats.select();
            return true;
        }
        Technique selectedTech = CultivatorTechniques.getCultivatorTechniques(genericClientFunctions.getPlayer()).getTechnique(selected);
        if (selectedTech != null && selectedTech.canLevel() && this.modify.mouseClick((int)mouseX, (int)mouseY, buttonPressed)) {
            Minecraft.m_91087_().m_91346_((Screen)new TechniqueModifyScreen(CultivatorTechniques.getCultivatorTechniques(genericClientFunctions.getPlayer()).getTechnique(selected), 1));
            return true;
        }
        return false;
    }

    public void changeSelection(int newSelection) {
        selected = newSelection;
        this.updateSelection();
    }

    protected void drawGuiForgroundLayer(PoseStack PoseStack2, float partialTicks, int mouseX, int mouseY) {
        Objects.requireNonNull(this);
        int edgeSpacingX = (this.f_96543_ - 256) / 2;
        Objects.requireNonNull(this);
        int edgeSpacingY = (this.f_96544_ - 178) / 2;
        TechniqueIcons.renderIcons(PoseStack2, edgeSpacingX + 48, edgeSpacingY + 155, (GuiComponent)this, 18);
        TechniqueIcons.mouseOverHighlight(PoseStack2, edgeSpacingX + 48, edgeSpacingY + 155, (GuiComponent)this, 18, mouseX, mouseY);
        TechniqueIcons.highlightIcon(PoseStack2, edgeSpacingX + 48, edgeSpacingY + 155, (GuiComponent)this, 18, selected);
        Technique selectedTech = CultivatorTechniques.getCultivatorTechniques(genericClientFunctions.getPlayer()).getTechnique(selected);
        if (selectedTech == null) {
            this.partDescription.setText("");
        } else if (this.description.isSelected()) {
            this.partDescription.setText(selectedTech.getDescription());
        } else if (this.stats.isSelected()) {
            this.partDescription.setText(selectedTech.getStats().toString() + selectedTech.getTechniqueStatString((Player)Minecraft.m_91087_().f_91074_));
        }
        this.description.setPos(edgeSpacingX + 127 - this.description.width - 10, edgeSpacingY + 30 + 15);
        this.description.render(PoseStack2, mouseX, mouseY, (GuiComponent)this);
        this.stats.setPos(edgeSpacingX + 127 + 10, edgeSpacingY + 30 + 15);
        this.stats.render(PoseStack2, mouseX, mouseY, (GuiComponent)this);
        if (selectedTech != null && selectedTech.canLevel()) {
            this.modify.setPos(edgeSpacingX + 127 + 20 + this.modify.width, edgeSpacingY + 30 + 15);
            this.modify.render(PoseStack2, mouseX, mouseY, (GuiComponent)this);
        }
        this.partDescription.setPos(edgeSpacingX + 30, edgeSpacingY + 30 + 30);
        this.partDescription.render(this, this.f_96547_, PoseStack2, mouseX, mouseY);
        this.techniques.render(PoseStack2, edgeSpacingX + 85, edgeSpacingY + 30, mouseX, mouseY, (GuiComponent)this);
    }
}

