/*
 * Decompiled with CFR 0.152.
 */
package DaoOfModding.Cultivationcraft.Client.GUI;

import DaoOfModding.Cultivationcraft.Client.GUI.Screens.SelectableText;
import DaoOfModding.Cultivationcraft.Client.GUI.Scrollbar;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Objects;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.resources.ResourceLocation;

public class SelectableTextField {
    ResourceLocation texture = new ResourceLocation("cultivationcraft", "textures/gui/textfield.png");
    protected final int xPadding = 5;
    protected final int yPadding = 5;
    int x = 0;
    int y = 0;
    int minWidth = 0;
    int maxWidth = 0;
    int width = 0;
    int height = 0;
    ArrayList<SelectableText> selectables = new ArrayList();
    SelectableText selected = null;
    Color textColor = Color.WHITE;
    Color backgroundColor = new Color(140, 140, 140);
    int totalHeight = 0;
    Scrollbar scroll = new Scrollbar();

    public SelectableTextField() {
        this.scroll.setScrollPosition(0);
    }

    public String getText() {
        if (this.selected == null) {
            return "";
        }
        return this.selected.getText();
    }

    public void setPos(int xPos, int yPos) {
        this.x = xPos;
        this.y = yPos;
    }

    public int getWidth() {
        return this.width;
    }

    public void setSize(int xSize, int ySize) {
        this.setSize(xSize, ySize, xSize);
    }

    public void setSize(int xSize, int ySize, int expandedXSize) {
        this.minWidth = xSize;
        this.maxWidth = expandedXSize;
        this.width = this.minWidth;
        this.height = ySize;
        this.scroll.setYHeight(ySize - 2);
    }

    public void addSelectable(SelectableText selectable) {
        this.selectables.add(selectable);
    }

    public SelectableText getSelected() {
        return this.selected;
    }

    public boolean mouseClicked(double mouseX, double mouseY, int buttonPressed) {
        if (buttonPressed != 0) {
            return false;
        }
        if (this.totalHeight > this.height && mouseX > (double)(this.width - 1 - this.scroll.buttonSize) && mouseX < (double)(this.width - 1) && mouseY > 0.0 && mouseY < (double)this.height) {
            return this.scroll.mouseClicked(mouseX - (double)this.width - 1.0 - (double)this.scroll.buttonSize, mouseY - 1.0, buttonPressed);
        }
        mouseY -= 5.0;
        mouseY += (double)this.scroll.scrollPosition;
        for (SelectableText selectable : this.selectables) {
            if (mouseY > (double)selectable.height()) {
                mouseY -= (double)selectable.height();
                continue;
            }
            SelectableText select = selectable.mouseClicked(mouseX, mouseY, buttonPressed);
            if (select == null) {
                return false;
            }
            for (SelectableText selectOff : this.selectables) {
                selectOff.unselectAll();
            }
            select.select();
            this.selected = select;
            return true;
        }
        return false;
    }

    public boolean mouseScrolled(double direction) {
        this.scroll.scroll((int)(-direction) * this.scroll.scrollInterval);
        return true;
    }

    protected void isMouseOver(int mouseX, int mouseY) {
        this.width = mouseX > this.x && mouseX < this.x + this.width && mouseY > this.y && mouseY < this.y + this.height ? this.maxWidth : this.minWidth;
        this.scroll.setPos(this.x + this.width - 1 - this.scroll.buttonSize, this.y + 1);
    }

    public void render(Screen screen, Font font, PoseStack poseStack, int mouseX, int mouseY) {
        this.isMouseOver(mouseX, mouseY);
        RenderSystem.m_157456_((int)0, (ResourceLocation)this.texture);
        RenderSystem.m_157429_((float)((float)this.backgroundColor.getRed() / 255.0f), (float)((float)this.backgroundColor.getGreen() / 255.0f), (float)((float)this.backgroundColor.getBlue() / 255.0f), (float)1.0f);
        Screen.m_93143_((PoseStack)poseStack, (int)this.x, (int)this.y, (int)screen.m_93252_(), (float)0.0f, (float)0.0f, (int)this.width, (int)this.height, (int)this.width, (int)this.height);
        RenderSystem.m_157429_((float)((float)(this.backgroundColor.getRed() - 100) / 255.0f), (float)((float)(this.backgroundColor.getGreen() - 100) / 255.0f), (float)((float)(this.backgroundColor.getBlue() - 100) / 255.0f), (float)1.0f);
        Screen.m_93143_((PoseStack)poseStack, (int)this.x, (int)this.y, (int)screen.m_93252_(), (float)0.0f, (float)0.0f, (int)1, (int)(this.height - 1), (int)1, (int)(this.height - 1));
        Screen.m_93143_((PoseStack)poseStack, (int)this.x, (int)this.y, (int)screen.m_93252_(), (float)0.0f, (float)0.0f, (int)(this.width - 1), (int)1, (int)(this.width - 1), (int)1);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        Screen.m_93143_((PoseStack)poseStack, (int)(this.x + this.width - 1), (int)(this.y + 1), (int)screen.m_93252_(), (float)0.0f, (float)0.0f, (int)1, (int)(this.height - 1), (int)1, (int)(this.height - 1));
        Screen.m_93143_((PoseStack)poseStack, (int)(this.x + 1), (int)(this.y + this.height - 1), (int)screen.m_93252_(), (float)0.0f, (float)0.0f, (int)(this.width - 1), (int)1, (int)(this.width - 1), (int)1);
        int yPos = this.y + 5 - this.scroll.scrollPosition;
        int xPos = this.x + 5;
        this.totalHeight = 0;
        for (SelectableText select : this.selectables) {
            select.render(screen, font, poseStack, this.textColor.getRGB(), xPos, yPos, xPos + this.width - 10, this.y + 5, this.y + this.height - 5);
            yPos += select.height();
            this.totalHeight += select.height();
        }
        if (this.totalHeight < this.height) {
            this.scroll.setScrollPosition(0);
        } else {
            Objects.requireNonNull(font);
            this.scroll.scrollInterval = 9 + 2;
            this.scroll.setSize(this.totalHeight - this.height + this.scroll.scrollInterval);
            this.scroll.render(screen, poseStack, mouseX, mouseY);
        }
    }
}

