/*
 * Decompiled with CFR 0.152.
 */
package DaoOfModding.Cultivationcraft.Common.Capabilities.BodyModifications;

import DaoOfModding.Cultivationcraft.Common.Capabilities.BodyModifications.BodyModificationsCapability;
import DaoOfModding.Cultivationcraft.Common.Capabilities.BodyModifications.IBodyModifications;
import DaoOfModding.Cultivationcraft.Common.Qi.BodyParts.BodyPart;
import DaoOfModding.Cultivationcraft.Common.Qi.BodyParts.BodyPartNames;
import DaoOfModding.Cultivationcraft.Common.Qi.BodyParts.BodyPartOption;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.entity.player.Player;

public class BodyModifications
implements IBodyModifications {
    String selected = "";
    HashMap<String, BodyPart> modifications = new HashMap();
    HashMap<String, HashMap<String, BodyPartOption>> options = new HashMap();
    ArrayList<String> tags = new ArrayList();
    boolean hasUpdated = false;
    int progress = 0;
    String lastForged = "";
    double questProgress = 0.0;
    float health = 0.0f;

    @Override
    public void setHealth(float hp) {
        this.health = hp;
    }

    @Override
    public float getHealth() {
        return this.health;
    }

    @Override
    public String getSelection() {
        return this.selected;
    }

    @Override
    public void setSelection(String selection) {
        this.selected = selection;
        if (selection.compareTo("") == 0) {
            this.setProgress(0);
        }
    }

    @Override
    public String getLastForged() {
        return this.lastForged;
    }

    @Override
    public void setLastForged(String last) {
        this.lastForged = last;
    }

    @Override
    public double getQuestProgress() {
        return this.questProgress;
    }

    @Override
    public void setQuestProgress(double newProgress) {
        this.questProgress = newProgress;
    }

    @Override
    public void setProgress(int number) {
        this.progress = number;
    }

    @Override
    public void addProgress(int number) {
        this.progress += number;
    }

    @Override
    public int getProgress() {
        return this.progress;
    }

    @Override
    public boolean hasModification(String limb) {
        return this.modifications.containsKey(limb);
    }

    @Override
    public boolean hasModification(String limb, String modificationID) {
        return this.modifications.containsKey(limb) && this.modifications.get(limb).getID().compareTo(modificationID) == 0;
    }

    @Override
    public boolean hasOption(String limb, String subPosition) {
        return this.options.containsKey(limb) && this.options.get(limb).containsKey(subPosition);
    }

    @Override
    public boolean hasOption(String limb, String subPosition, String modificationID) {
        return this.options.containsKey(limb) && this.options.get(limb).containsKey(subPosition) && this.options.get(limb).get(subPosition).getID().compareTo(modificationID) == 0;
    }

    @Override
    public BodyPart getModification(String limb) {
        return this.modifications.get(limb);
    }

    @Override
    public BodyPartOption getOption(String limb, String subPosition) {
        return this.options.get(limb).get(subPosition);
    }

    @Override
    public ArrayList<BodyPart> getBodyPartsOfType(Class type) {
        ArrayList<BodyPart> parts = new ArrayList<BodyPart>();
        for (BodyPart bodyPart : this.modifications.values()) {
            if (bodyPart.getClass() != type) continue;
            parts.add(bodyPart);
        }
        for (HashMap hashMap : this.options.values()) {
            for (BodyPart part : hashMap.values()) {
                if (part.getClass() != type) continue;
                parts.add(part);
            }
        }
        return parts;
    }

    @Override
    public void setModification(BodyPart part) {
        this.modifications.put(part.getPosition(), part);
        this.addTags(part);
        this.setUpdated(false);
    }

    @Override
    public void setOption(BodyPartOption option) {
        if (!this.options.containsKey(option.getPosition())) {
            this.options.put(option.getPosition(), new HashMap());
        }
        this.options.get(option.getPosition()).put(option.getSubPosition(), option);
        this.addTags(option);
        this.setUpdated(false);
    }

    @Override
    public void removeModification(BodyPart part) {
        if (!this.hasModification(part.getPosition(), part.getID())) {
            return;
        }
        this.modifications.remove(part.getPosition(), part);
        this.removeTags(part);
        this.setUpdated(false);
    }

    @Override
    public void removeOption(BodyPartOption option) {
        if (!this.options.containsKey(option.getPosition())) {
            return;
        }
        if (!this.hasOption(option.getPosition(), option.getSubPosition(), option.getID())) {
            return;
        }
        this.options.get(option.getPosition()).remove(option.getSubPosition(), option);
        this.removeTags(option);
        this.setUpdated(false);
    }

    protected void addTags(BodyPart part) {
        for (String tag : part.getUniqueTags()) {
            this.tags.add(tag);
        }
    }

    protected void removeTags(BodyPart part) {
        for (String tag : part.getUniqueTags()) {
            this.tags.remove(tag);
        }
    }

    @Override
    public ArrayList<String> getTags() {
        return this.tags;
    }

    @Override
    public HashMap<String, BodyPart> getModifications() {
        return this.modifications;
    }

    @Override
    public HashMap<String, BodyPartOption> getModificationOptions(String limb) {
        if (!this.options.containsKey(limb)) {
            this.options.put(limb, new HashMap());
        }
        return this.options.get(limb);
    }

    @Override
    public HashMap<String, HashMap<String, BodyPartOption>> getModificationOptions() {
        return this.options;
    }

    @Override
    public boolean hasUpdated() {
        return this.hasUpdated;
    }

    @Override
    public void setUpdated(boolean updated) {
        this.hasUpdated = updated;
    }

    @Override
    public void clearModifications() {
        this.modifications.clear();
        this.options.clear();
        this.tags.clear();
        this.progress = 0;
        this.lastForged = "";
        this.selected = "";
        this.setUpdated(false);
    }

    @Override
    public void read(CompoundTag NBT) {
        this.clearModifications();
        this.setHealth(NBT.m_128457_("health"));
        this.setSelection(NBT.m_128461_("selection"));
        this.setLastForged(NBT.m_128461_("last"));
        this.setProgress(NBT.m_128451_("progress"));
        this.setQuestProgress(NBT.m_128459_("questprogress"));
        CompoundTag modifications = NBT.m_128469_("modifications");
        for (String limb : modifications.m_128431_()) {
            BodyPart part = BodyPartNames.getPart(modifications.m_128461_(limb));
            this.setModification(part);
            this.addTags(part);
        }
        CompoundTag options = NBT.m_128469_("options");
        for (String limb : options.m_128431_()) {
            CompoundTag option = options.m_128469_(limb);
            for (String part : option.m_128431_()) {
                BodyPartOption optionPart = BodyPartNames.getOption(option.m_128461_(part));
                this.setOption(optionPart);
                this.addTags(optionPart);
            }
        }
        this.setUpdated(false);
    }

    @Override
    public CompoundTag write() {
        CompoundTag nbt = new CompoundTag();
        nbt.m_128350_("health", this.health);
        nbt.m_128359_("selection", this.getSelection());
        nbt.m_128359_("last", this.getLastForged());
        nbt.m_128405_("progress", this.getProgress());
        nbt.m_128347_("questprogress", this.getQuestProgress());
        CompoundTag modifications = new CompoundTag();
        for (Map.Entry<String, BodyPart> entry : this.getModifications().entrySet()) {
            modifications.m_128359_(entry.getKey(), entry.getValue().getID());
        }
        nbt.m_128365_("modifications", (Tag)modifications);
        CompoundTag options = new CompoundTag();
        for (Map.Entry<String, HashMap<String, BodyPartOption>> entry : this.getModificationOptions().entrySet()) {
            CompoundTag subOptions = new CompoundTag();
            for (Map.Entry<String, BodyPartOption> entry2 : entry.getValue().entrySet()) {
                subOptions.m_128359_(entry2.getKey(), entry2.getValue().getID());
            }
            options.m_128365_(entry.getKey(), (Tag)subOptions);
        }
        nbt.m_128365_("options", (Tag)options);
        return nbt;
    }

    @Override
    public void copy(IBodyModifications mod) {
        this.setSelection(mod.getSelection());
        this.modifications = (HashMap)mod.getModifications().clone();
        this.options = (HashMap)mod.getModificationOptions().clone();
        this.tags = (ArrayList)mod.getTags().clone();
        this.lastForged = mod.getLastForged();
        this.progress = mod.getProgress();
        this.questProgress = mod.getQuestProgress();
        this.health = mod.getHealth();
        this.setUpdated(false);
    }

    public static IBodyModifications getBodyModifications(Player player) {
        return (IBodyModifications)player.getCapability(BodyModificationsCapability.INSTANCE).orElseThrow(() -> new IllegalArgumentException("getting player body modifications"));
    }
}

