/*
 * Decompiled with CFR 0.152.
 */
package DaoOfModding.Cultivationcraft.Common.Capabilities.ChunkQiSources;

import DaoOfModding.Cultivationcraft.Common.Capabilities.ChunkQiSources.ChunkQiSourcesCapability;
import DaoOfModding.Cultivationcraft.Common.Capabilities.ChunkQiSources.IChunkQiSources;
import DaoOfModding.Cultivationcraft.Common.Qi.Elements.BlockElements;
import DaoOfModding.Cultivationcraft.Common.Qi.Elements.Elements;
import DaoOfModding.Cultivationcraft.Common.Qi.QiSource;
import DaoOfModding.Cultivationcraft.Common.Qi.QiSourceConfig;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.phys.Vec3;

public class ChunkQiSources
implements IChunkQiSources {
    ResourceLocation dimension;
    ChunkPos ChunkPos;
    List<QiSource> QiSources = new ArrayList<QiSource>();
    HashMap<Vec3, Integer> pendingQiSource = new HashMap();

    @Override
    public void setChunkPos(ChunkPos position) {
        this.ChunkPos = position;
    }

    @Override
    public void setDimension(ResourceLocation dim) {
        this.dimension = dim;
    }

    @Override
    public ResourceLocation getDimension() {
        return this.dimension;
    }

    @Override
    public ChunkPos getChunkPos() {
        return this.ChunkPos;
    }

    @Override
    public List<QiSource> getQiSources() {
        return this.QiSources;
    }

    @Override
    public int countQiSources() {
        return this.QiSources.size() + this.pendingQiSource.size();
    }

    @Override
    public void setQiSources(List<QiSource> sources) {
        this.QiSources = sources;
    }

    @Override
    public void generateQiSources(Level level) {
        int number = QiSourceConfig.getQiSourceInLevelChunk((ResourceKey<Level>)level.m_46472_());
        for (int i = 0; i < number; ++i) {
            this.generateQiSource((LevelAccessor)level);
        }
    }

    @Override
    public boolean tick(Level level) {
        boolean updated = false;
        for (QiSource source : this.getQiSources()) {
            if (!source.tick(level)) continue;
            updated = true;
        }
        if (this.pendingQiSource.size() > 0) {
            ArrayList<Vec3> toRemove = new ArrayList<Vec3>();
            for (Map.Entry<Vec3, Integer> qiSource : this.pendingQiSource.entrySet()) {
                if (!this.canCreate(level, qiSource.getKey(), qiSource.getValue())) continue;
                this.createQiSource(level, qiSource.getKey(), qiSource.getValue());
                toRemove.add(qiSource.getKey());
                updated = true;
            }
            for (Vec3 pos : toRemove) {
                this.pendingQiSource.remove(pos);
            }
        }
        return updated;
    }

    protected boolean canCreate(Level level, Vec3 pos, int range) {
        for (int x = -range; x <= range; x += 16) {
            for (int z = -range; z <= range; z += 16) {
                ChunkPos chunkPos = new ChunkPos(new BlockPos(pos.f_82479_ + (double)x, pos.f_82480_, pos.f_82481_ + (double)z));
                if (level.m_7232_(chunkPos.f_45578_, chunkPos.f_45579_)) continue;
                return false;
            }
        }
        return true;
    }

    protected void createQiSource(Level level, Vec3 pos, int size) {
        ResourceLocation element = this.getElement(level, pos, size);
        element = Elements.getElement(element).getMutation().getResourceLocation();
        QiSource newSource = new QiSource(new BlockPos(pos), size, element, QiSourceConfig.generateRandomQiStorage(), QiSourceConfig.generateRandomQiRegen());
        this.QiSources.add(newSource);
    }

    protected ResourceLocation getElement(Level level, Vec3 pos, int range) {
        int count = 0;
        HashMap<ResourceLocation, Integer> elements = new HashMap<ResourceLocation, Integer>();
        ArrayList<ResourceLocation> rules = Elements.getDimensionRules((ResourceKey<Level>)level.m_46472_());
        if (rules.size() == 1) {
            return rules.get(0);
        }
        for (ResourceLocation element : rules) {
            elements.put(element, 0);
        }
        for (int x = -range; x <= range; ++x) {
            for (int y = -range; y <= range; ++y) {
                for (int z = -range; z <= range; ++z) {
                    ResourceLocation element;
                    Vec3 vec3 = new Vec3((double)x, (double)y, (double)z);
                    if (!(vec3.m_82553_() < (double)range) || !rules.contains(element = BlockElements.getMaterialElement(level.m_8055_(new BlockPos(pos.m_82520_((double)x, (double)y, (double)z))).m_60767_()))) continue;
                    elements.put(element, (Integer)elements.get(element) + 1);
                    ++count;
                }
            }
        }
        ResourceLocation foundElement = rules.get(0);
        for (ResourceLocation element : rules) {
            if (element == rules.get(0) || !((double)((Integer)elements.get(element)).intValue() > Elements.getElement((ResourceLocation)element).density * (double)count) || foundElement != rules.get(0) && !(Math.random() > 0.5)) continue;
            foundElement = element;
        }
        return foundElement;
    }

    protected void generateQiSource(LevelAccessor level) {
        int xPos = (int)(Math.random() * 15.0) + (this.ChunkPos.f_45578_ << 4);
        int zPos = (int)(Math.random() * 15.0) + (this.ChunkPos.f_45579_ << 4);
        double x = Math.random();
        int yPos = (int)((4.0 * Math.pow(x, 3.0) - 5.28 * Math.pow(x, 2.0) + 2.28 * x) * (double)level.m_6042_().f_63865_()) + level.m_6042_().f_156647_();
        int size = QiSourceConfig.generateRandomSize();
        this.pendingQiSource.put(new Vec3((double)xPos, (double)yPos, (double)zPos), size);
    }

    @Override
    public CompoundTag writeNBT() {
        CompoundTag nbt = new CompoundTag();
        if (this.getChunkPos() != null) {
            nbt.m_128356_("QiSource", this.getChunkPos().m_45588_());
            nbt.m_128359_("Dimension", this.dimension.toString());
            int count = 0;
            for (QiSource qiSource : this.getQiSources()) {
                nbt.m_128365_("QiSource" + count, (Tag)qiSource.SerializeNBT());
                ++count;
            }
            count = 0;
            for (Map.Entry entry : this.pendingQiSource.entrySet()) {
                nbt.m_128405_("PQiSourceX" + count, (int)((Vec3)entry.getKey()).f_82479_);
                nbt.m_128405_("PQiSourceY" + count, (int)((Vec3)entry.getKey()).f_82480_);
                nbt.m_128405_("PQiSourceZ" + count, (int)((Vec3)entry.getKey()).f_82481_);
                nbt.m_128405_("PQiSourceS" + count, ((Integer)entry.getValue()).intValue());
                ++count;
            }
        }
        return nbt;
    }

    @Override
    public void readNBT(CompoundTag nbt) {
        if (nbt.m_128441_("QiSource")) {
            this.setChunkPos(new ChunkPos(nbt.m_128454_("QiSource")));
            this.dimension = new ResourceLocation(nbt.m_128461_("Dimension"));
            ArrayList<QiSource> sourceList = new ArrayList<QiSource>();
            this.pendingQiSource.clear();
            int count = 0;
            while (nbt.m_128441_("QiSource" + count)) {
                QiSource source = QiSource.DeserializeNBT((CompoundTag)nbt.m_128423_("QiSource" + count));
                sourceList.add(source);
                ++count;
            }
            count = 0;
            while (nbt.m_128441_("PQiSourceX" + count)) {
                int x = nbt.m_128451_("PQiSourceX" + count);
                int y = nbt.m_128451_("PQiSourceY" + count);
                int z = nbt.m_128451_("PQiSourceZ" + count);
                int s = nbt.m_128451_("PQiSourceS" + count);
                this.pendingQiSource.put(new Vec3((double)x, (double)y, (double)z), s);
                ++count;
            }
            this.setQiSources(sourceList);
        }
    }

    public static IChunkQiSources getChunkQiSources(LevelChunk LevelChunk2) {
        return (IChunkQiSources)LevelChunk2.getCapability(ChunkQiSourcesCapability.INSTANCE).orElseThrow(() -> new IllegalArgumentException("getting LevelChunk Qi sources"));
    }

    public static List<QiSource> getQiSourcesInRange(Level level, Vec3 position, int range) {
        ArrayList<QiSource> sources = new ArrayList<QiSource>();
        int searchRange = (range + 64) / 16 + 1;
        ChunkPos test = new ChunkPos(new BlockPos(position));
        for (int x = -searchRange; x <= searchRange; ++x) {
            for (int z = -searchRange; z <= searchRange; ++z) {
                List<QiSource> possibleSources = ChunkQiSources.getChunkQiSources(level.m_6325_(test.f_45578_ + x, test.f_45579_ + z)).getQiSources();
                for (QiSource source : possibleSources) {
                    double distance = position.m_82492_((double)source.getPos().m_123341_(), (double)source.getPos().m_123342_(), (double)source.getPos().m_123343_()).m_82553_();
                    if (!(distance < (double)(range + source.getSize()))) continue;
                    sources.add(source);
                }
            }
        }
        return sources;
    }
}

