/*
 * Decompiled with CFR 0.152.
 */
package DaoOfModding.Cultivationcraft.Common.Capabilities.CultivatorStats;

import DaoOfModding.Cultivationcraft.Common.Capabilities.CultivatorStats.CultivatorStatsCapability;
import DaoOfModding.Cultivationcraft.Common.Capabilities.CultivatorStats.ICultivatorStats;
import DaoOfModding.Cultivationcraft.Common.Qi.Cultivation.CultivationType;
import DaoOfModding.Cultivationcraft.Common.Qi.Cultivation.NoCultivation;
import DaoOfModding.Cultivationcraft.Common.Qi.ExternalCultivationHandler;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;

public class CultivatorStats
implements ICultivatorStats {
    protected int cultivationType = -1;
    protected CultivationType cultivation = new NoCultivation();
    protected HashMap<String, ResourceLocation> techFocus = new HashMap();
    protected boolean disconnected = false;

    @Override
    public int getCultivationType() {
        return this.cultivationType;
    }

    @Override
    public void setCultivationType(int newType) {
        this.cultivationType = newType;
    }

    @Override
    public CultivationType getCultivation() {
        return this.cultivation;
    }

    @Override
    public void setCultivation(CultivationType newCultivation) {
        this.cultivation = newCultivation;
    }

    @Override
    public ResourceLocation getTechniqueFocus(Class tech) {
        return this.techFocus.get(tech.toString());
    }

    @Override
    public void setTechniqueFocus(String tech, ResourceLocation focus) {
        this.techFocus.put(tech, focus);
    }

    @Override
    public void setDisconnected(boolean value) {
        this.disconnected = value;
    }

    @Override
    public boolean isDisconnected() {
        return this.disconnected;
    }

    @Override
    public void reset() {
        this.cultivationType = -1;
        this.cultivation = new NoCultivation();
        this.techFocus = new HashMap();
    }

    @Override
    public CompoundTag writeNBT() {
        CompoundTag nbt = new CompoundTag();
        nbt.m_128405_("TYPE", this.cultivationType);
        nbt.m_128359_("CULTIVATIONID", this.cultivation.getClass().toString());
        nbt.m_128365_("CULTIVATION", (Tag)this.cultivation.writeNBT());
        int i = 0;
        for (Map.Entry<String, ResourceLocation> techEntry : this.techFocus.entrySet()) {
            nbt.m_128359_("TECH" + i + "NAME", techEntry.getKey());
            nbt.m_128359_("TECH" + i + "VALUE", techEntry.getValue().toString());
            ++i;
        }
        return nbt;
    }

    @Override
    public void readNBT(CompoundTag nbt) {
        this.setCultivationType(nbt.m_128451_("TYPE"));
        CultivationType newCultivation = ExternalCultivationHandler.getCultivation(nbt.m_128461_("CULTIVATIONID"));
        newCultivation.readNBT(nbt.m_128469_("CULTIVATION"));
        HashMap<String, ResourceLocation> newTechFocus = new HashMap<String, ResourceLocation>();
        int i = 0;
        while (nbt.m_128441_("TECH" + i + "NAME")) {
            newTechFocus.put(nbt.m_128461_("TECH" + i + "NAME"), new ResourceLocation(nbt.m_128461_("TECH" + i + "VALUE")));
            ++i;
        }
        this.techFocus = newTechFocus;
        this.cultivation = newCultivation;
    }

    public static boolean isCultivator(Player player) {
        ICultivatorStats stats = CultivatorStats.getCultivatorStats(player);
        return stats.getCultivationType() != -1;
    }

    public static ICultivatorStats getCultivatorStats(Player player) {
        return (ICultivatorStats)player.getCapability(CultivatorStatsCapability.INSTANCE).orElseThrow(() -> new IllegalArgumentException("getting cultivator stats"));
    }
}

