/*
 * Decompiled with CFR 0.152.
 */
package DaoOfModding.Cultivationcraft.Common.Capabilities.CultivatorTechniques;

import DaoOfModding.Cultivationcraft.Common.Capabilities.CultivatorTechniques.CultivatorTechniquesCapability;
import DaoOfModding.Cultivationcraft.Common.Capabilities.CultivatorTechniques.ICultivatorTechniques;
import DaoOfModding.Cultivationcraft.Common.Qi.TechniqueControl;
import DaoOfModding.Cultivationcraft.Common.Qi.Techniques.PassiveTechniques.PassiveTechnique;
import DaoOfModding.Cultivationcraft.Common.Qi.Techniques.Technique;
import DaoOfModding.Cultivationcraft.Cultivationcraft;
import java.util.ArrayList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.entity.player.Player;

public class CultivatorTechniques
implements ICultivatorTechniques {
    public static final int numberOfTechniques = 9;
    protected Technique[] techniques = new Technique[9];
    protected ArrayList<PassiveTechnique> passives = new ArrayList();

    @Override
    public Technique getTechnique(int slot) {
        return this.techniques[slot];
    }

    @Override
    public void setTechnique(int slot, Technique tech) {
        this.techniques[slot] = tech;
    }

    @Override
    public boolean canBreath(Player player) {
        for (int i = 0; i < 9; ++i) {
            Technique tech = this.getTechnique(i);
            if (tech == null || !tech.isValid(player) || !tech.isActive() || !tech.disableBreathing()) continue;
            return false;
        }
        for (PassiveTechnique passive : this.getPassives()) {
            if (!passive.isValid(player) || !passive.isActive() || !passive.disableBreathing()) continue;
            return false;
        }
        return true;
    }

    @Override
    public void determinePassives(Player player) {
        this.passives.clear();
        ArrayList<Class> passiveList = TechniqueControl.getPassiveTechniques(player);
        for (Class pTech : passiveList) {
            try {
                PassiveTechnique passive = (PassiveTechnique)pTech.newInstance();
                this.passives.add(passive);
            }
            catch (Exception e) {
                Cultivationcraft.LOGGER.error(pTech.getName() + " is not a Passive Technique: " + e.getMessage());
            }
        }
    }

    @Override
    public ArrayList<PassiveTechnique> getPassives() {
        return this.passives;
    }

    @Override
    public boolean techniqueExists(Technique exist) {
        for (Technique tech : this.techniques) {
            if (tech == null || tech.getClass() != exist.getClass()) continue;
            return true;
        }
        return false;
    }

    @Override
    public Technique getTechniqueByName(String name) {
        for (int i = 0; i < 9; ++i) {
            if (this.techniques[i] == null || !this.techniques[i].isCalled(name)) continue;
            return this.techniques[i];
        }
        for (PassiveTechnique passive : this.passives) {
            if (!passive.isCalled(name)) continue;
            return passive;
        }
        return null;
    }

    public static ICultivatorTechniques getCultivatorTechniques(Player player) {
        return (ICultivatorTechniques)player.getCapability(CultivatorTechniquesCapability.INSTANCE).orElseThrow(() -> new IllegalArgumentException("getting cultivator techniques"));
    }

    @Override
    public CompoundTag writeNBT() {
        CompoundTag nbt = new CompoundTag();
        for (int i = 0; i < 9; ++i) {
            Technique sending = this.getTechnique(i);
            if (sending == null) continue;
            nbt.m_128365_(Integer.toString(i), (Tag)sending.writeNBT());
        }
        return nbt;
    }

    @Override
    public void readNBT(CompoundTag nbt) {
        for (int i = 0; i < 9; ++i) {
            if (!nbt.m_128441_(Integer.toString(i))) continue;
            this.setTechnique(i, Technique.readNBT(nbt.m_128469_(Integer.toString(i))));
        }
    }
}

