/*
 * Decompiled with CFR 0.152.
 */
package DaoOfModding.Cultivationcraft.Common.Commands;

import DaoOfModding.Cultivationcraft.Common.Capabilities.BodyModifications.BodyModifications;
import DaoOfModding.Cultivationcraft.Common.Capabilities.CultivatorStats.CultivatorStats;
import DaoOfModding.Cultivationcraft.Common.Capabilities.CultivatorStats.ICultivatorStats;
import DaoOfModding.Cultivationcraft.Common.Qi.BodyParts.FoodStats.QiFoodStats;
import DaoOfModding.Cultivationcraft.Common.Qi.Elements.Elements;
import DaoOfModding.Cultivationcraft.Common.Qi.Stats.BodyPartStatControl;
import DaoOfModding.Cultivationcraft.Common.Qi.Stats.StatIDs;
import DaoOfModding.Cultivationcraft.Common.Qi.TechniqueControl;
import DaoOfModding.Cultivationcraft.Common.Qi.Techniques.Technique;
import DaoOfModding.Cultivationcraft.Cultivationcraft;
import DaoOfModding.Cultivationcraft.Network.PacketHandler;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.Collection;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;

public class BodyforgeCommand {
    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        LiteralArgumentBuilder command = (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"cultivation").requires(commandSource -> commandSource.m_6761_(2))).then(Commands.m_82127_((String)"reset").then(Commands.m_82129_((String)"players", (ArgumentType)EntityArgument.m_91470_()).executes(commandContext -> BodyforgeCommand.reset((CommandSourceStack)commandContext.getSource(), EntityArgument.m_91477_((CommandContext)commandContext, (String)"players")))))).then(Commands.m_82127_((String)"completeQuest").then(Commands.m_82129_((String)"players", (ArgumentType)EntityArgument.m_91470_()).executes(commandContext -> BodyforgeCommand.completeQuest((CommandSourceStack)commandContext.getSource(), EntityArgument.m_91477_((CommandContext)commandContext, (String)"players")))))).then(Commands.m_82127_((String)"completeCultivation").then(Commands.m_82129_((String)"players", (ArgumentType)EntityArgument.m_91470_()).executes(commandContext -> BodyforgeCommand.completeProgress((CommandSourceStack)commandContext.getSource(), EntityArgument.m_91477_((CommandContext)commandContext, (String)"players")))))).then(Commands.m_82127_((String)"levelSkills").then(Commands.m_82129_((String)"players", (ArgumentType)EntityArgument.m_91470_()).executes(commandContext -> BodyforgeCommand.levelSkills((CommandSourceStack)commandContext.getSource(), EntityArgument.m_91477_((CommandContext)commandContext, (String)"players")))))).then(Commands.m_82127_((String)"fillQi").then(Commands.m_82129_((String)"players", (ArgumentType)EntityArgument.m_91470_()).executes(commandContext -> BodyforgeCommand.fillQi((CommandSourceStack)commandContext.getSource(), EntityArgument.m_91477_((CommandContext)commandContext, (String)"players")))));
        dispatcher.register(command);
    }

    protected static int completeProgress(CommandSourceStack commandSourceStack, Collection<ServerPlayer> players) {
        for (ServerPlayer serverplayer : players) {
            ICultivatorStats stats = CultivatorStats.getCultivatorStats((Player)serverplayer);
            if (stats.getCultivationType() == 0) {
                stats.getCultivation().progressCultivation((Player)serverplayer, 2.1474836E9f, Elements.anyElement);
                PacketHandler.sendCultivatorStatsToClient((Player)serverplayer);
                continue;
            }
            if (stats.getCultivationType() != 1) continue;
            BodyModifications.getBodyModifications((Player)serverplayer).setProgress((int)BodyPartStatControl.getStats((Player)serverplayer).getStat(StatIDs.qiCost));
            PacketHandler.sendBodyModificationsToClient((Player)serverplayer);
        }
        if (players.size() == 1) {
            commandSourceStack.m_81354_((Component)Component.m_237110_((String)"cultivationcraft.commands.completeprogress.single", (Object[])new Object[]{players.iterator().next().m_5446_()}), true);
        } else {
            commandSourceStack.m_81354_((Component)Component.m_237110_((String)"cultivationcraft.commands.completeprogress.multiple", (Object[])new Object[]{players.size()}), true);
        }
        return players.size();
    }

    protected static int completeQuest(CommandSourceStack commandSourceStack, Collection<ServerPlayer> players) {
        for (ServerPlayer serverplayer : players) {
            BodyModifications.getBodyModifications((Player)serverplayer).setLastForged("");
            PacketHandler.sendBodyModificationsToClient((Player)serverplayer);
        }
        if (players.size() == 1) {
            commandSourceStack.m_81354_((Component)Component.m_237110_((String)"cultivationcraft.commands.completequest.single", (Object[])new Object[]{players.iterator().next().m_5446_()}), true);
        } else {
            commandSourceStack.m_81354_((Component)Component.m_237110_((String)"cultivationcraft.commands.completequest.multiple", (Object[])new Object[]{players.size()}), true);
        }
        return players.size();
    }

    protected static int levelSkills(CommandSourceStack commandSourceStack, Collection<ServerPlayer> players) {
        for (ServerPlayer serverplayer : players) {
            double amount = CultivatorStats.getCultivatorStats((Player)serverplayer).getCultivation().getMaxTechLevel();
            for (Class tech : TechniqueControl.getAvailableTechnics((Player)serverplayer)) {
                try {
                    Technique technique = (Technique)tech.newInstance();
                    if (!technique.isValid((Player)serverplayer) || !technique.canLevel()) continue;
                    technique.levelUp((Player)serverplayer, amount);
                }
                catch (Exception e) {
                    Cultivationcraft.LOGGER.error(tech.getName() + " is not a Technique: " + e.getMessage());
                }
            }
        }
        if (players.size() == 1) {
            commandSourceStack.m_81354_((Component)Component.m_237110_((String)"cultivationcraft.commands.levelskills.single", (Object[])new Object[]{players.iterator().next().m_5446_()}), true);
        } else {
            commandSourceStack.m_81354_((Component)Component.m_237110_((String)"cultivationcraft.commands.levelskills.multiple", (Object[])new Object[]{players.size()}), true);
        }
        return players.size();
    }

    protected static int fillQi(CommandSourceStack commandSourceStack, Collection<ServerPlayer> players) {
        for (ServerPlayer serverplayer : players) {
            if (!(serverplayer.m_36324_() instanceof QiFoodStats)) continue;
            serverplayer.m_36324_().m_38705_(((QiFoodStats)serverplayer.m_36324_()).getMaxFood());
        }
        if (players.size() == 1) {
            commandSourceStack.m_81354_((Component)Component.m_237110_((String)"cultivationcraft.commands.fillqi.single", (Object[])new Object[]{players.iterator().next().m_5446_()}), true);
        } else {
            commandSourceStack.m_81354_((Component)Component.m_237110_((String)"cultivationcraft.commands.fillqi.multiple", (Object[])new Object[]{players.size()}), true);
        }
        return players.size();
    }

    protected static int reset(CommandSourceStack commandSourceStack, Collection<ServerPlayer> players) {
        for (ServerPlayer serverplayer : players) {
            BodyModifications.getBodyModifications((Player)serverplayer).clearModifications();
            PacketHandler.sendBodyModificationsToClient((Player)serverplayer);
            CultivatorStats.getCultivatorStats((Player)serverplayer).reset();
            PacketHandler.sendCultivatorStatsToClient((Player)serverplayer);
        }
        if (players.size() == 1) {
            commandSourceStack.m_81354_((Component)Component.m_237110_((String)"cultivationcraft.commands.reset.single", (Object[])new Object[]{players.iterator().next().m_5446_()}), true);
        } else {
            commandSourceStack.m_81354_((Component)Component.m_237110_((String)"cultivationcraft.commands.reset.multiple", (Object[])new Object[]{players.size()}), true);
        }
        return players.size();
    }
}

