/*
 * Decompiled with CFR 0.152.
 */
package DaoOfModding.Cultivationcraft.Common;

import DaoOfModding.Cultivationcraft.Client.ClientItemControl;
import DaoOfModding.Cultivationcraft.Client.ClientListeners;
import DaoOfModding.Cultivationcraft.Client.GUI.SkillHotbarOverlay;
import DaoOfModding.Cultivationcraft.Client.Physics;
import DaoOfModding.Cultivationcraft.Common.Capabilities.BodyModifications.BodyModifications;
import DaoOfModding.Cultivationcraft.Common.Capabilities.ChunkQiSources.ChunkQiSources;
import DaoOfModding.Cultivationcraft.Common.Capabilities.ChunkQiSources.IChunkQiSources;
import DaoOfModding.Cultivationcraft.Common.Capabilities.CultivatorStats.CultivatorStats;
import DaoOfModding.Cultivationcraft.Common.Capabilities.CultivatorStats.ICultivatorStats;
import DaoOfModding.Cultivationcraft.Common.Capabilities.CultivatorTechniques.CultivatorTechniques;
import DaoOfModding.Cultivationcraft.Common.Commands.BodyforgeCommand;
import DaoOfModding.Cultivationcraft.Common.Qi.BodyParts.BodyPart;
import DaoOfModding.Cultivationcraft.Common.Qi.BodyParts.BodyPartOption;
import DaoOfModding.Cultivationcraft.Common.Qi.BodyParts.FoodStats.QiFoodStats;
import DaoOfModding.Cultivationcraft.Common.Qi.BodyParts.Lungs.Lung.Lung;
import DaoOfModding.Cultivationcraft.Common.Qi.BodyParts.Lungs.Lungs;
import DaoOfModding.Cultivationcraft.Common.Qi.BodyParts.PlayerHealthManager;
import DaoOfModding.Cultivationcraft.Common.Qi.BodyParts.Quests.Quest;
import DaoOfModding.Cultivationcraft.Common.Qi.BodyParts.Quests.QuestHandler;
import DaoOfModding.Cultivationcraft.Common.Qi.Effects.Wind;
import DaoOfModding.Cultivationcraft.Common.Qi.Elements.Elements;
import DaoOfModding.Cultivationcraft.Common.Qi.Stats.BodyPartStatControl;
import DaoOfModding.Cultivationcraft.Common.Qi.Stats.PlayerStatModifications;
import DaoOfModding.Cultivationcraft.Common.Qi.Stats.StatIDs;
import DaoOfModding.Cultivationcraft.Network.PacketHandler;
import DaoOfModding.Cultivationcraft.Server.ServerItemControl;
import DaoOfModding.Cultivationcraft.Server.ServerListeners;
import DaoOfModding.Cultivationcraft.Server.SkillHotbarServer;
import com.mojang.brigadier.CommandDispatcher;
import java.util.ArrayList;
import java.util.HashMap;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingFallEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.level.ChunkEvent;
import net.minecraftforge.event.level.ChunkWatchEvent;
import net.minecraftforge.event.level.LevelEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class CommonListeners {
    public static ArrayList<IChunkQiSources> tickingQiSources = new ArrayList();

    @SubscribeEvent
    public static void playerTick(TickEvent.PlayerTickEvent event) {
        if (!event.player.m_6084_()) {
            return;
        }
        if (event.player.m_20193_().m_5776_()) {
            ClientListeners.playerTick(event);
            if (event.player.m_20096_()) {
                Vec3 movement = new Vec3(event.player.m_20184_().f_82479_, 0.0, event.player.m_20184_().f_82481_);
                QuestHandler.progressQuest(event.player, Quest.WALK, movement.m_82553_());
            }
            if (event.player.m_6069_()) {
                QuestHandler.progressQuest(event.player, Quest.SWIM, event.player.m_20184_().m_82553_());
            }
        } else {
            ServerListeners.playerTick(event);
        }
        CommonListeners.clearStatus(event.player);
    }

    @SubscribeEvent
    public static void entityTick(LivingEvent.LivingTickEvent event) {
        Wind.tick((Entity)event.getEntity());
    }

    public static void clearStatus(Player player) {
        if (!player.m_6060_()) {
            return;
        }
        PlayerStatModifications stats = BodyPartStatControl.getStats(player);
        float fireResistance = stats.getElementalStat(StatIDs.resistanceModifier, Elements.fireElement);
        if (fireResistance >= 100.0f) {
            player.m_20095_();
            player.m_146868_(false);
        }
    }

    @SubscribeEvent
    public static void onRegisterCommandEvent(RegisterCommandsEvent event) {
        CommandDispatcher commandDispatcher = event.getDispatcher();
        BodyforgeCommand.register((CommandDispatcher<CommandSourceStack>)commandDispatcher);
    }

    @SubscribeEvent
    public static void LevelTick(TickEvent.LevelTickEvent event) {
        if (event.phase == TickEvent.Phase.START && event.side == LogicalSide.SERVER) {
            ArrayList ticking = (ArrayList)tickingQiSources.clone();
            for (IChunkQiSources sources : ticking) {
                if (sources == null) {
                    return;
                }
                if (sources.getDimension().compareTo(event.level.m_46472_().m_135782_()) != 0) continue;
                boolean update = false;
                if (sources.tick(event.level)) {
                    update = true;
                }
                if (!update) continue;
                LevelChunk chunk = event.level.m_6325_(sources.getChunkPos().f_45578_, sources.getChunkPos().f_45579_);
                chunk.m_8092_(true);
                PacketHandler.sendChunkQiSourcesToClient(chunk);
            }
        }
    }

    @SubscribeEvent
    public static void worldLoad(LevelEvent.Load event) {
        if (event.getLevel().m_5776_()) {
            ClientItemControl.hasLoaded = true;
        } else {
            ServerItemControl.loaded = true;
        }
    }

    @SubscribeEvent
    public static void playerJump(LivingEvent.LivingJumpEvent event) {
        if (event.getEntity() instanceof Player) {
            Physics.applyJump((Player)event.getEntity());
        }
    }

    @SubscribeEvent
    public static void useItem(PlayerInteractEvent.RightClickItem event) {
        if (event.getItemStack().m_41614_() && event.getEntity().m_36324_() instanceof QiFoodStats && !((QiFoodStats)event.getEntity().m_36324_()).isEdible(event.getItemStack())) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void playerFall(LivingFallEvent event) {
        if (event.getEntity() instanceof Player) {
            event.setDistance(Physics.reduceFallDistance((Player)event.getEntity(), event.getDistance()));
        }
    }

    @SubscribeEvent
    public static void LevelChunkLoad(ChunkEvent.Load event) {
        IChunkQiSources sources = ChunkQiSources.getChunkQiSources((LevelChunk)event.getChunk());
        if (!event.getLevel().m_5776_() && sources.getChunkPos() == null) {
            sources.setChunkPos(event.getChunk().m_7697_());
            sources.setDimension(((LevelChunk)event.getChunk()).m_62953_().m_46472_().m_135782_());
            sources.generateQiSources(((LevelChunk)event.getChunk()).m_62953_());
            event.getChunk().m_8092_(true);
            PacketHandler.sendChunkQiSourcesToClient((LevelChunk)event.getChunk());
        }
        CommonListeners.checkQiSourceIsTicking(sources);
    }

    public static void checkQiSourceIsTicking(IChunkQiSources source) {
        if (source.countQiSources() > 0 && !tickingQiSources.contains(source)) {
            tickingQiSources.add(source);
        }
    }

    @SubscribeEvent
    public static void LevelChunkUnload(ChunkEvent.Unload event) {
        IChunkQiSources sources = ChunkQiSources.getChunkQiSources((LevelChunk)event.getChunk());
        tickingQiSources.remove(sources);
    }

    @SubscribeEvent
    public static void playerJoinsWorld(PlayerEvent.PlayerLoggedInEvent event) {
        event.getEntity().f_20916_ = 100;
        CultivatorStats.getCultivatorStats(event.getEntity()).setDisconnected(false);
        CultivatorTechniques.getCultivatorTechniques(event.getEntity()).determinePassives(event.getEntity());
        if (!event.getEntity().m_20193_().m_5776_()) {
            for (Player sendPlayer : event.getEntity().m_20193_().m_6907_()) {
                ServerItemControl.sendPlayerStats(sendPlayer, event.getEntity());
                for (BodyPart bodyPart : BodyModifications.getBodyModifications(sendPlayer).getModifications().values()) {
                    bodyPart.onJoin(event.getEntity());
                }
                for (HashMap hashMap : BodyModifications.getBodyModifications(sendPlayer).getModificationOptions().values()) {
                    for (BodyPartOption option : hashMap.values()) {
                        option.onJoin(event.getEntity());
                    }
                }
            }
            SkillHotbarServer.addPlayer(event.getEntity().m_20148_());
            BodyPartStatControl.updateStats(event.getEntity());
            float hp = BodyModifications.getBodyModifications(event.getEntity()).getHealth();
            if (hp > 0.0f) {
                event.getEntity().m_21153_(hp);
            }
        }
    }

    @SubscribeEvent
    public static void playerRespawns(PlayerEvent.PlayerRespawnEvent event) {
        if (!event.isEndConquered()) {
            QuestHandler.resetQuest(event.getEntity(), Quest.LIVE);
        }
        CultivatorStats.getCultivatorStats(event.getEntity()).setDisconnected(false);
        CultivatorTechniques.getCultivatorTechniques(event.getEntity()).determinePassives(event.getEntity());
        BodyPartStatControl.updateStats(event.getEntity());
        Wind.clearWindEffect(event.getEntity().m_20148_());
        Lungs lung = PlayerHealthManager.getLungs(event.getEntity());
        for (int i = 0; i < lung.getLungAmount(); ++i) {
            Lung currentLung = lung.getConnection(i).getLung();
            currentLung.setCurrent(currentLung.getCapacity());
        }
        if (!event.getEntity().m_20193_().m_5776_()) {
            ServerItemControl.sendPlayerStats(event.getEntity(), event.getEntity());
        }
    }

    @SubscribeEvent
    public static void playerChangesDimension(PlayerEvent.PlayerChangedDimensionEvent event) {
        CultivatorStats.getCultivatorStats(event.getEntity()).setDisconnected(false);
        if (!event.getEntity().m_20193_().m_5776_()) {
            ServerItemControl.sendPlayerStats(event.getEntity(), event.getEntity());
        }
    }

    @SubscribeEvent
    public static void playerStartsTracking(PlayerEvent.StartTracking event) {
        if (!event.getEntity().m_20193_().m_5776_() && event.getTarget() instanceof Player) {
            ServerItemControl.sendPlayerStats(event.getEntity(), (Player)event.getTarget());
        }
    }

    @SubscribeEvent
    public static void onLevelChunkWatch(ChunkWatchEvent.Watch event) {
        if (!event.getLevel().m_5776_()) {
            PacketHandler.sendChunkQiSourcesToClient(event.getLevel().m_6325_(event.getPos().f_45578_, event.getPos().f_45579_), event.getPlayer());
        }
    }

    @SubscribeEvent
    public static void playerDisconnects(PlayerEvent.PlayerLoggedOutEvent event) {
        ICultivatorStats stats;
        if (!event.getEntity().m_21224_() && (stats = CultivatorStats.getCultivatorStats(event.getEntity())) != null) {
            stats.setDisconnected(true);
        }
        if (!event.getEntity().m_20193_().m_5776_()) {
            SkillHotbarServer.removePlayer(event.getEntity().m_20148_());
        }
    }

    @SubscribeEvent
    public static void onPlayerDeath(PlayerEvent.Clone event) {
        event.getOriginal().reviveCaps();
        CultivatorStats.getCultivatorStats(event.getEntity()).readNBT(CultivatorStats.getCultivatorStats(event.getOriginal()).writeNBT());
        BodyModifications.getBodyModifications(event.getEntity()).read(BodyModifications.getBodyModifications(event.getOriginal()).write());
        CultivatorTechniques.getCultivatorTechniques(event.getEntity()).readNBT(CultivatorTechniques.getCultivatorTechniques(event.getOriginal()).writeNBT());
        event.getOriginal().invalidateCaps();
        if (event.isWasDeath()) {
            QuestHandler.resetQuest(event.getEntity(), Quest.LIVE);
            if (CultivatorStats.getCultivatorStats(event.getEntity()).getCultivationType() == 0 && CultivatorStats.getCultivatorStats(event.getEntity()).getCultivation().isTribulating()) {
                CultivatorStats.getCultivatorStats(event.getEntity()).setCultivation(CultivatorStats.getCultivatorStats(event.getEntity()).getCultivation().getPreviousCultivation());
            }
        }
    }

    @SubscribeEvent
    public static void playerInteract(PlayerInteractEvent.RightClickBlock event) {
        CommonListeners.cancelPlacement((PlayerInteractEvent)event);
    }

    @SubscribeEvent
    public static void playerInteract(PlayerInteractEvent.RightClickItem event) {
        CommonListeners.cancelPlacement((PlayerInteractEvent)event);
    }

    protected static void cancelPlacement(PlayerInteractEvent event) {
        if (event.getLevel().m_5776_()) {
            if (SkillHotbarOverlay.isActive()) {
                event.setCanceled(true);
            }
        } else if (SkillHotbarServer.isActive(event.getEntity().m_20148_())) {
            event.setCanceled(true);
        }
    }
}

