/*
 * Decompiled with CFR 0.152.
 */
package DaoOfModding.Cultivationcraft.Common;

import DaoOfModding.Cultivationcraft.Client.Renderers.QiGlowRenderer;
import DaoOfModding.Cultivationcraft.Common.Capabilities.CultivatorStats.CultivatorStats;
import DaoOfModding.Cultivationcraft.Common.Capabilities.CultivatorStats.ICultivatorStats;
import DaoOfModding.Cultivationcraft.Common.Capabilities.CultivatorTechniques.CultivatorTechniques;
import DaoOfModding.Cultivationcraft.Common.Capabilities.CultivatorTechniques.ICultivatorTechniques;
import DaoOfModding.Cultivationcraft.Common.Misc;
import DaoOfModding.Cultivationcraft.Common.Qi.Elements.Elements;
import DaoOfModding.Cultivationcraft.Common.Qi.Techniques.QiCondenserTechniques.FlyingSwordFormationTechnique;
import DaoOfModding.Cultivationcraft.Common.Qi.Techniques.TechniqueStats.DefaultTechniqueStatIDs;
import DaoOfModding.Cultivationcraft.Common.Register;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSetEntityMotionPacket;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.stats.Stats;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.EntityDamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.boss.EnderDragonPart;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.network.NetworkHooks;

public class FlyingSwordEntity
extends ItemEntity {
    protected static final EntityDataAccessor<ItemStack> ITEM = SynchedEntityData.m_135353_(FlyingSwordEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135033_);
    protected static final EntityDataAccessor<Float> decaySpeed = SynchedEntityData.m_135353_(FlyingSwordEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    protected static final EntityDataAccessor<Float> movementX = SynchedEntityData.m_135353_(FlyingSwordEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    protected static final EntityDataAccessor<Float> movementY = SynchedEntityData.m_135353_(FlyingSwordEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    protected static final EntityDataAccessor<Float> movementZ = SynchedEntityData.m_135353_(FlyingSwordEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    protected final double idleDistance = 3.0;
    protected int f_31985_ = 0;
    public Vec3 direction = new Vec3(1.0, 0.0, 0.0);
    public Vec3 movement = new Vec3(0.0, 0.0, 0.0);
    protected Player f_31982_ = null;
    protected ICultivatorStats stats = null;
    protected FlyingSwordFormationTechnique formation = null;
    protected boolean recall = false;
    private final float defaultspeed = 0.02f;
    private final float defaultmaxSpeed = 1.0f;
    private final double defaultTurnSpeed = 0.2;
    private final float defaultdamage = 0.25f;
    private final float defaultRange = 10.0f;
    private boolean canPickup = false;
    protected boolean orbit = false;

    public FlyingSwordEntity(EntityType<? extends ItemEntity> type, Level worldIn) {
        super(type, worldIn);
        this.init();
    }

    public FlyingSwordEntity(Level worldIn, double x, double y, double z, ItemStack stack) {
        super(worldIn, x, y, z, stack);
        this.init();
    }

    protected void init() {
        this.m_32062_();
        this.m_20331_(true);
        if (Misc.enableHarvest) {
            this.f_19794_ = true;
        }
        this.generateDecay();
    }

    public float getControlRange() {
        if (this.formation != null) {
            return (float)this.formation.getTechniqueStat(DefaultTechniqueStatIDs.range, this.f_31982_);
        }
        return 10.0f;
    }

    public double getTurnSpeed() {
        if (this.formation != null) {
            return this.formation.getTechniqueStat(FlyingSwordFormationTechnique.flyingswordturnspeed, this.f_31982_);
        }
        return 0.2;
    }

    public float getSpeed() {
        if (this.formation != null) {
            return (float)this.formation.getTechniqueStat(FlyingSwordFormationTechnique.flyingswordspeed, this.f_31982_) / 100.0f;
        }
        return 0.02f;
    }

    public float getDamageModifier() {
        if (this.formation != null) {
            return (float)this.formation.getTechniqueStat(DefaultTechniqueStatIDs.damage, this.f_31982_);
        }
        return 0.25f;
    }

    public float getMaxSpeed() {
        if (this.formation != null) {
            return (float)this.formation.getTechniqueStat(FlyingSwordFormationTechnique.flyingswordmaxspeed, this.f_31982_) / 100.0f;
        }
        return 1.0f;
    }

    public boolean m_6128_() {
        return true;
    }

    protected void generateDecay() {
        if (!this.f_19853_.f_46443_) {
            Random test = new Random();
            test.setSeed(this.m_32055_().hashCode());
            this.m_20088_().m_135381_(decaySpeed, (Object)Float.valueOf(test.nextFloat() * 0.1f));
        }
    }

    protected void updateOwner() {
        UUID ownerID;
        if (this.f_31982_ != null && this.stats != null && (this.stats.isDisconnected() || !this.f_31982_.m_6084_())) {
            this.f_31982_ = null;
        }
        if (this.f_31982_ == null && (ownerID = this.m_32055_().m_41783_().m_128342_("Owner")) != null) {
            this.f_31982_ = this.f_19853_.m_46003_(ownerID);
            if (this.f_31982_ != null) {
                this.movement = this.f_31982_.m_20154_().m_82541_();
                this.direction = this.f_31982_.m_20154_().m_82541_();
                this.stats = CultivatorStats.getCultivatorStats(this.f_31982_);
                this.storeMovement();
            }
        }
        if (this.f_31982_ != null) {
            ICultivatorTechniques techs = CultivatorTechniques.getCultivatorTechniques(this.f_31982_);
            if (this.formation == null) {
                for (int i = 0; i < 9; ++i) {
                    if (techs.getTechnique(i) == null || !techs.getTechnique(i).isActive() || !(techs.getTechnique(i) instanceof FlyingSwordFormationTechnique)) continue;
                    this.formation = (FlyingSwordFormationTechnique)techs.getTechnique(i);
                    return;
                }
            } else {
                for (int i = 0; i < 9; ++i) {
                    if (techs.getTechnique(i) == this.formation) continue;
                    return;
                }
                this.formation = null;
            }
        }
    }

    public void clearOwner() {
        this.f_31982_ = null;
    }

    protected void calculatePitchAndYaw() {
        this.f_19860_ = this.m_146909_();
        this.f_19859_ = this.m_146908_();
        this.m_146926_((float)Math.asin(this.direction.f_82480_) - 0.7853982f);
        this.m_146922_((float)Math.atan2(this.direction.f_82479_, this.direction.f_82481_) - 1.5707964f);
    }

    protected void turnTowards(Vec3 newDirection) {
        Double angle = Math.asin(this.direction.m_82537_(newDirection).m_82553_());
        if (angle != 0.0) {
            double theta = this.getTurnSpeed();
            if (theta > Math.abs(angle)) {
                theta = angle;
            }
            Vec3 u = this.direction.m_82537_(newDirection).m_82541_();
            double cosTheta = Math.cos(theta);
            double sinTheta = Math.sin(theta);
            Vec3 rotatedDirection = u.m_82490_(u.m_82526_(this.direction));
            rotatedDirection = rotatedDirection.m_82549_(u.m_82537_(this.direction).m_82537_(u).m_82490_(cosTheta));
            if ((rotatedDirection = rotatedDirection.m_82549_(u.m_82537_(this.direction).m_82490_(sinTheta))).m_82553_() != 0.0) {
                this.direction = rotatedDirection;
            }
        }
    }

    protected void moveDecay() {
        this.movement = this.movement.m_82490_(0.85 + (double)this.getDecaySpeed());
    }

    protected void moveForwards() {
        Vec3 toMove = this.movement.m_82549_(this.direction.m_82490_((double)this.getSpeed()));
        if (toMove.m_82553_() > (double)this.getMaxSpeed()) {
            toMove = toMove.m_82541_().m_82490_((double)this.getMaxSpeed());
        }
        this.movement = toMove;
    }

    protected void moveToTarget() {
        Vec3 targetPos = this.formation.getTarget().m_20182_();
        double distX = this.m_20185_() - targetPos.f_82479_;
        double distY = this.m_20186_() - targetPos.f_82480_;
        double distZ = this.m_20189_() - targetPos.f_82481_;
        Vec3 targetDir = new Vec3(-distX, -distY, -distZ);
        targetDir = targetDir.m_82541_();
        this.turnTowards(targetDir);
        if (!this.orbit) {
            this.moveForwards();
        }
    }

    protected void moveToOwner() {
        double oPosX = this.f_31982_.m_20185_();
        double oPosY = this.f_31982_.m_20186_() + (double)this.f_31982_.m_20206_() / 2.0;
        double oPosZ = this.f_31982_.m_20189_();
        double distX = this.m_20185_() - oPosX;
        double distY = this.m_20186_() - oPosY;
        double distZ = this.m_20189_() - oPosZ;
        double distance = Math.abs(distX) + Math.abs(distY) + Math.abs(distZ);
        if (distance > 3.0 || this.recall) {
            Vec3 ownerDir = new Vec3(-distX, -distY, -distZ);
            ownerDir = ownerDir.m_82541_();
            this.turnTowards(ownerDir);
            if (!this.orbit) {
                this.moveForwards();
            }
        }
    }

    protected void updateMotion() {
        this.m_20256_(this.movement);
    }

    protected void handleCollisions() {
        this.handleEntityCollisions();
        if (Misc.enableHarvest) {
            this.handleBlockCollisions();
        }
    }

    protected void handleEntityCollisions() {
        List collisionEntities = this.f_19853_.m_45933_((Entity)this, this.m_20191_());
        if (!collisionEntities.isEmpty()) {
            boolean realHit = false;
            for (Entity collisionsEntity : collisionEntities) {
                if (!this.collideWithEntity(collisionsEntity)) continue;
                realHit = true;
            }
            if (realHit) {
                this.bumpBackwards(0.5);
            }
        }
    }

    protected boolean collideWithEntity(Entity collisionEntity) {
        if (collisionEntity == this.f_31982_) {
            return false;
        }
        if (collisionEntity instanceof LivingEntity) {
            this.attackTargetEntity(collisionEntity);
            return true;
        }
        return false;
    }

    protected void handleBlockCollisions() {
        BlockPos blockPosition = new BlockPos(this.m_20182_());
        BlockState collisionBlock = this.f_31982_.m_20193_().m_8055_(blockPosition);
        if (Misc.blockExists(collisionBlock.m_60734_())) {
            this.tryHarvestBlock(blockPosition);
            this.bumpBackwards(0.4, Misc.getVec3FromBlockPos(blockPosition));
        }
    }

    protected void bumpBackwards(double power, Vec3 fromPos) {
        double distX = this.m_20185_() - fromPos.f_82479_;
        double distY = this.m_20186_() - fromPos.f_82480_;
        double distZ = this.m_20189_() - fromPos.f_82481_;
        Vec3 targetDir = new Vec3(distX, distY, distZ);
        targetDir = targetDir.m_82541_();
        this.movement = targetDir.m_82490_((double)this.getMaxSpeed() * power);
    }

    protected void bumpBackwards(double power) {
        this.movement = this.direction.m_82490_((double)this.getMaxSpeed() * -power);
    }

    public boolean isInRange() {
        return this.f_31982_ != null && this.f_31982_.m_6084_() && this.m_20270_((Entity)this.f_31982_) < this.getControlRange();
    }

    protected boolean isInRange(Vec3 pos) {
        return this.m_20182_().m_82554_(pos) < (double)this.getControlRange();
    }

    protected void fall() {
        this.canPickup = true;
        this.direction = new Vec3(0.0, -1.0, 0.0);
        this.movement = this.movement.m_82549_(this.direction.m_82490_(0.2));
    }

    public boolean canControl() {
        return this.stats != null && this.formation != null && this.isInRange();
    }

    public void m_8119_() {
        if (this.m_32055_().onEntityItemUpdate((ItemEntity)this)) {
            return;
        }
        if (this.m_32055_().m_41619_()) {
            this.m_142687_(Entity.RemovalReason.DISCARDED);
        } else {
            this.updateOwner();
            this.retrieveMovement();
            this.moveDecay();
            if (this.canControl() && CultivatorStats.getCultivatorStats(this.f_31982_).getCultivation().consumeQi(this.f_31982_, this.formation.getTechniqueStat(DefaultTechniqueStatIDs.qiCost, this.f_31982_) / 20.0)) {
                this.canPickup = false;
                this.m_6075_();
                this.f_19790_ = this.m_20185_();
                this.f_19791_ = this.m_20186_();
                this.f_19792_ = this.m_20189_();
                if (!this.formation.isActive()) {
                    this.recall = true;
                }
                if (this.formation.getTarget() != null && this.isInRange(this.formation.getTarget().m_20182_()) && !this.recall) {
                    this.moveToTarget();
                } else {
                    this.moveToOwner();
                }
                if (this.orbit) {
                    this.moveForwards();
                }
                this.handleCollisions();
                if (this.f_19853_.f_46443_) {
                    QiGlowRenderer.setQiVisible((Entity)this, Elements.getElement(this.formation.getElement()));
                }
            } else {
                this.fall();
            }
            this.updateMotion();
            if (this.f_19853_.m_5776_()) {
                this.calculatePitchAndYaw();
            }
            this.m_6478_(MoverType.SELF, this.m_20184_());
            if (this.f_31985_ != Short.MIN_VALUE) {
                ++this.f_31985_;
            }
            if (this.f_31985_ >= 400) {
                this.f_31985_ = 200;
            }
            if (this.m_32055_().m_41619_()) {
                this.m_142687_(Entity.RemovalReason.DISCARDED);
            }
            this.storeMovement();
        }
    }

    public void m_183634_() {
        super.m_183634_();
        if (!this.canControl()) {
            this.movement = new Vec3(0.0, this.movement.f_82480_, 0.0);
        }
    }

    protected void storeMovement() {
        this.m_20088_().m_135381_(movementX, (Object)Float.valueOf((float)this.movement.f_82479_));
        this.m_20088_().m_135381_(movementY, (Object)Float.valueOf((float)this.movement.f_82480_));
        this.m_20088_().m_135381_(movementZ, (Object)Float.valueOf((float)this.movement.f_82481_));
    }

    protected void retrieveMovement() {
        this.movement = new Vec3((double)((Float)this.m_20088_().m_135370_(movementX)).floatValue(), (double)((Float)this.m_20088_().m_135370_(movementY)).floatValue(), (double)((Float)this.m_20088_().m_135370_(movementZ)).floatValue());
    }

    public void m_8097_() {
        this.m_20088_().m_135372_(ITEM, (Object)ItemStack.f_41583_);
        this.m_20088_().m_135372_(decaySpeed, (Object)Float.valueOf(0.5f));
        this.m_20088_().m_135372_(movementX, (Object)Float.valueOf(0.0f));
        this.m_20088_().m_135372_(movementY, (Object)Float.valueOf(0.0f));
        this.m_20088_().m_135372_(movementZ, (Object)Float.valueOf(0.0f));
    }

    public void m_32045_(ItemStack stack) {
        this.m_20088_().m_135381_(ITEM, (Object)stack);
    }

    protected float getDecaySpeed() {
        return ((Float)this.m_20088_().m_135370_(decaySpeed)).floatValue();
    }

    public int m_32059_() {
        return this.f_31985_;
    }

    public ItemStack m_32055_() {
        return (ItemStack)this.m_20088_().m_135370_(ITEM);
    }

    public EntityType<?> m_6095_() {
        return (EntityType)Register.FLYINGSWORD.get();
    }

    public Packet<?> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public void m_6123_(Player entityIn) {
        if (!(this.m_32059_() > 20 && this.canPickup || entityIn == this.f_31982_ && this.recall)) {
            return;
        }
        if (!this.f_19853_.f_46443_) {
            ItemStack itemstack = this.m_32055_();
            Item item = itemstack.m_41720_();
            int i = itemstack.m_41613_();
            int hook = ForgeEventFactory.onItemPickup((ItemEntity)this, (Player)entityIn);
            if (hook < 0) {
                return;
            }
            ItemStack copy = itemstack.m_41777_();
            if (hook == 1 || i <= 0 || entityIn.m_150109_().m_36054_(itemstack)) {
                copy.m_41764_(copy.m_41613_() - this.m_32055_().m_41613_());
                ForgeEventFactory.firePlayerItemPickupEvent((Player)entityIn, (ItemEntity)this, (ItemStack)copy);
                if (itemstack.m_41619_()) {
                    this.m_142687_(Entity.RemovalReason.DISCARDED);
                    itemstack.m_41764_(i);
                }
                entityIn.m_6278_(Stats.f_12984_.m_12902_((Object)item), i);
                entityIn.m_21053_((ItemEntity)this);
            }
        }
    }

    public boolean tryHarvestBlock(BlockPos pos) {
        return false;
    }

    public void attackTargetEntity(Entity targetEntity) {
        if (targetEntity.m_6097_() && !targetEntity.m_7313_((Entity)this)) {
            float f = 1.0f;
            if (this.m_32055_().m_41720_() instanceof SwordItem) {
                f = ((SwordItem)this.m_32055_().m_41720_()).m_43299_();
            }
            f *= this.getDamageModifier();
            float f1 = targetEntity instanceof LivingEntity ? EnchantmentHelper.m_44833_((ItemStack)this.m_32055_(), (MobType)((LivingEntity)targetEntity).m_6336_()) : EnchantmentHelper.m_44833_((ItemStack)this.m_32055_(), (MobType)MobType.f_21640_);
            int i = EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44980_, (ItemStack)this.m_32055_());
            this.f_31982_.f_19853_.m_6263_((Player)null, this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_12314_, this.f_31982_.m_5720_(), 1.0f, 1.0f);
            ++i;
            Vec3 Vec32 = targetEntity.m_20184_();
            boolean flag5 = targetEntity.m_6469_((DamageSource)new EntityDamageSource("player", (Entity)this), f += f1);
            this.formation.levelUp(this.f_31982_, f);
            if (flag5) {
                if (targetEntity instanceof LivingEntity) {
                    ((LivingEntity)targetEntity).m_147240_((double)((float)i * 0.5f), (double)Mth.m_14031_((float)(this.m_146908_() * ((float)Math.PI / 180))), (double)(-Mth.m_14089_((float)(this.m_146908_() * ((float)Math.PI / 180)))));
                } else {
                    targetEntity.m_5997_((double)(-Mth.m_14031_((float)(this.m_146908_() * ((float)Math.PI / 180))) * (float)i * 0.5f), 0.1, (double)(Mth.m_14089_((float)(this.m_146908_() * ((float)Math.PI / 180))) * (float)i * 0.5f));
                }
                if (targetEntity instanceof ServerPlayer && targetEntity.f_19864_) {
                    ((ServerPlayer)targetEntity).f_8906_.m_9829_((Packet)new ClientboundSetEntityMotionPacket(targetEntity));
                    targetEntity.f_19864_ = false;
                    targetEntity.m_20256_(Vec32);
                }
                this.f_31982_.f_19853_.m_6263_((Player)null, this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_12316_, this.f_31982_.m_5720_(), 1.0f, 1.0f);
                if (f1 > 0.0f) {
                    this.f_31982_.m_5700_(targetEntity);
                }
                this.f_31982_.m_21335_(targetEntity);
                Entity entity = targetEntity;
                if (targetEntity instanceof EnderDragonPart) {
                    entity = ((EnderDragonPart)targetEntity).f_31010_;
                }
                if (targetEntity instanceof LivingEntity) {
                    float f5 = 0.0f - ((LivingEntity)targetEntity).m_21223_();
                    this.f_31982_.m_36222_(Stats.f_12928_, Math.round(f5 * 10.0f));
                    if (this.f_31982_.f_19853_ instanceof ServerLevel && f5 > 2.0f) {
                        int k = (int)((double)f5 * 0.5);
                        ((ServerLevel)this.f_31982_.f_19853_).m_8767_((ParticleOptions)ParticleTypes.f_123798_, targetEntity.m_20185_(), targetEntity.m_20227_(0.5), targetEntity.m_20189_(), k, 0.1, 0.0, 0.1, 0.2);
                    }
                }
            }
        }
    }
}

