/*
 * Decompiled with CFR 0.152.
 */
package DaoOfModding.Cultivationcraft.Common.Qi.BodyParts.Blood;

import DaoOfModding.Cultivationcraft.Client.Particles.Blood.BloodParticleData;
import DaoOfModding.Cultivationcraft.Client.Renderers.BloodRenderer;
import DaoOfModding.Cultivationcraft.Common.Qi.BodyParts.Blood.Blood;
import DaoOfModding.Cultivationcraft.Common.Qi.BodyParts.FoodStats.QiFoodStats;
import DaoOfModding.Cultivationcraft.Common.Qi.BodyParts.Quests.Quest;
import DaoOfModding.Cultivationcraft.Common.Qi.BodyParts.Quests.QuestHandler;
import DaoOfModding.Cultivationcraft.Common.Qi.Stats.BodyPartStatControl;
import DaoOfModding.Cultivationcraft.Common.Qi.Stats.StatIDs;
import DaoOfModding.Cultivationcraft.Network.PacketHandler;
import DaoOfModding.mlmanimator.Client.Poses.PoseHandler;
import java.util.UUID;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.phys.Vec3;

public class CultivatorBlood
extends Blood {
    protected int maxBloodSpawn = 200;
    protected double maxSpeed = 1.0;

    public CultivatorBlood() {
        this.staminaHealingModifier = 4.0f;
    }

    @Override
    public void naturalHealing(Player player) {
        boolean flag = player.f_19853_.m_46469_().m_46207_(GameRules.f_46139_);
        QiFoodStats food = (QiFoodStats)player.m_36324_();
        if (flag && food.m_38702_() > 0 && player.m_36325_()) {
            float regen = BodyPartStatControl.getStats(player).getStat(StatIDs.healthRegen) / 20.0f;
            if (!player.f_19853_.f_46443_) {
                QuestHandler.progressQuest(player, Quest.HEAL, regen);
            }
            player.m_5634_(regen);
            food.m_38703_(regen * BodyPartStatControl.getStats(player).getStat(StatIDs.healthStaminaConversion) * 4.0f);
        }
    }

    @Override
    public void onHit(Player player, Vec3 source, double amount) {
        if (!player.f_19853_.f_46443_) {
            PacketHandler.sendBloodSpawnToClient(player.m_20148_(), source, amount);
            return;
        }
        ParticleOptions particle = this.getParticle(player);
        if (particle == null) {
            return;
        }
        double percent = amount / (double)player.m_21233_();
        int toSpawn = (int)(percent * (double)this.maxBloodSpawn);
        for (int i = 0; i < toSpawn; ++i) {
            Vec3 direction = BloodRenderer.getBloodDirection(player, source);
            double speed = percent * this.maxSpeed * (Math.random() * 0.5 + 0.5);
            direction = direction.m_82490_(speed);
            float height = PoseHandler.getPlayerPoseHandler((UUID)player.m_20148_()).getPlayerModel().getHeightAdjustment();
            player.f_19853_.m_7106_(particle, player.m_20185_(), player.m_20186_() + (double)height, player.m_20189_(), direction.f_82479_, direction.f_82480_, direction.f_82481_);
        }
    }

    public ParticleOptions getParticle(Player player) {
        return new BloodParticleData(player);
    }
}

