/*
 * Decompiled with CFR 0.152.
 */
package DaoOfModding.Cultivationcraft.Common.Qi.BodyParts.Blood;

import DaoOfModding.Cultivationcraft.Client.Particles.Blood.GaseousBloodParticleData;
import DaoOfModding.Cultivationcraft.Client.Renderers.BloodRenderer;
import DaoOfModding.Cultivationcraft.Common.Qi.BodyParts.Blood.CultivatorBlood;
import DaoOfModding.Cultivationcraft.Common.Qi.Effects.Wind;
import DaoOfModding.Cultivationcraft.Common.Qi.Effects.WindInstance;
import DaoOfModding.Cultivationcraft.Common.Qi.Elements.Elements;
import DaoOfModding.Cultivationcraft.Network.PacketHandler;
import DaoOfModding.mlmanimator.Client.Poses.PoseHandler;
import com.mojang.math.Vector3f;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;

public class GaseousBlood
extends CultivatorBlood {
    public GaseousBlood() {
        this.colour = new Vector3f(0.6f, 1.0f, 0.8f);
        this.life = 20;
        this.staminaHealingModifier = 2.0f;
        this.maxSpeed = 3.0;
        this.maxBloodSpawn = 50;
    }

    @Override
    public void regen(Player player) {
        if (!(player.m_20069_() || player.m_20096_() || this.staminaHealing(player))) {
            this.naturalHealing(player);
        }
    }

    @Override
    public void onHit(Player player, Vec3 source, double amount) {
        if (!player.f_19853_.f_46443_) {
            PacketHandler.sendBloodSpawnToClient(player.m_20148_(), source, amount);
            if (source != null) {
                Vec3 direction = player.m_20182_().m_82546_(source).m_82541_();
                Wind.addWindEffect((Entity)player, new WindInstance(direction, (float)amount * 0.025f, (float)amount / 5.0f));
            }
            return;
        }
        ParticleOptions particle = this.getParticle(player);
        if (particle == null) {
            return;
        }
        double percent = amount / (double)player.m_21233_();
        int toSpawn = (int)(percent * (double)this.maxBloodSpawn);
        for (int i = 0; i < toSpawn; ++i) {
            Vec3 direction = BloodRenderer.getBloodDirection(player, source).m_82490_(-1.0);
            double speed = percent * this.maxSpeed * (Math.random() * 0.5 + 0.5);
            direction = direction.m_82490_(speed);
            float height = PoseHandler.getPlayerPoseHandler((UUID)player.m_20148_()).getPlayerModel().getHeightAdjustment();
            player.f_19853_.m_7106_(particle, player.m_20185_(), player.m_20186_() + (double)height, player.m_20189_(), direction.f_82479_, direction.f_82480_, direction.f_82481_);
        }
    }

    @Override
    public boolean canHeal(ResourceLocation element, @Nullable Player player) {
        return element == Elements.windElement && (player == null || player.f_20916_ == 0);
    }

    @Override
    public ParticleOptions getParticle(Player player) {
        return new GaseousBloodParticleData(player);
    }
}

