/*
 * Decompiled with CFR 0.152.
 */
package DaoOfModding.Cultivationcraft.Common.Qi.BodyParts.Blood;

import DaoOfModding.Cultivationcraft.Client.Renderers.BloodRenderer;
import DaoOfModding.Cultivationcraft.Common.Qi.BodyParts.Blood.CultivatorBlood;
import DaoOfModding.Cultivationcraft.Common.Qi.Elements.Elements;
import com.mojang.math.Vector3f;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;

public class WaterBlood
extends CultivatorBlood {
    public WaterBlood() {
        this.colour = new Vector3f(0.0f, 0.3f, 0.8f);
        this.life = 200;
        this.staminaHealingModifier = 3.0f;
    }

    @Override
    public void regen(Player player) {
        BlockPos blockpos = new BlockPos(player.m_20182_());
        if (player.f_19853_.m_8055_(blockpos).m_60713_(Blocks.f_49990_) && !this.staminaHealing(player)) {
            this.naturalHealing(player);
        }
    }

    @Override
    public boolean canHeal(ResourceLocation element, @Nullable Player player) {
        return element == Elements.waterElement && (player == null || player.f_20916_ == 0);
    }

    @Override
    public void onHit(Player player, Vec3 source, double amount) {
        if (player.f_19853_.f_46443_) {
            return;
        }
        int waterLevel = (int)(amount / 5.0);
        if (waterLevel > 7) {
            waterLevel = 7;
        }
        if (waterLevel < 2) {
            waterLevel = 2;
        }
        BlockPos blockpos = new BlockPos(player.m_20182_());
        this.placeWater(player.f_19853_, blockpos, waterLevel);
        Vec3 dir = BloodRenderer.getBloodDirection(player, source);
        int x = 0;
        int z = 0;
        if (dir.f_82479_ >= 0.25) {
            x = 1;
        } else if (dir.f_82479_ <= -0.25) {
            x = -1;
        }
        if (dir.f_82481_ >= 0.25) {
            z = 1;
        } else if (dir.f_82481_ <= -0.25) {
            z = -1;
        }
        BlockPos addWaterSpawn = new BlockPos(player.m_20182_().f_82479_ + (double)x, player.m_20182_().f_82480_, player.m_20182_().f_82481_ + (double)z);
        this.placeWater(player.f_19853_, addWaterSpawn, waterLevel - 1);
        if (x != 0 && z != 0) {
            addWaterSpawn = new BlockPos(player.m_20182_().f_82479_, player.m_20182_().f_82480_, player.m_20182_().f_82481_ + (double)z);
            this.placeWater(player.f_19853_, addWaterSpawn, waterLevel - 1);
            addWaterSpawn = new BlockPos(player.m_20182_().f_82479_ + (double)x, player.m_20182_().f_82480_, player.m_20182_().f_82481_);
            this.placeWater(player.f_19853_, addWaterSpawn, waterLevel - 1);
        }
    }

    protected void placeWater(Level level, BlockPos blockpos, int waterLevel) {
        if (level.m_8055_(blockpos).m_60713_(Blocks.f_49990_)) {
            int height = (Integer)level.m_8055_(blockpos).m_61143_((Property)LiquidBlock.f_54688_) + waterLevel;
            if (height > 15) {
                height = 15;
            }
            BlockState state = (BlockState)Blocks.f_49990_.m_49966_().m_61124_((Property)LiquidBlock.f_54688_, (Comparable)Integer.valueOf(height));
            level.m_7731_(blockpos, state, 2);
            level.m_7260_(blockpos, state, state, 1);
        } else if (level.m_8055_(blockpos).m_60795_()) {
            BlockState state = (BlockState)Blocks.f_49990_.m_49966_().m_61124_((Property)LiquidBlock.f_54688_, (Comparable)Integer.valueOf(waterLevel));
            level.m_7731_(blockpos, state, 2);
            level.m_7260_(blockpos, state, state, 1);
        }
    }
}

