/*
 * Decompiled with CFR 0.152.
 */
package DaoOfModding.Cultivationcraft.Common.Qi.BodyParts;

import DaoOfModding.Cultivationcraft.Client.Animations.BodyPartLocation;
import DaoOfModding.Cultivationcraft.Client.genericClientFunctions;
import DaoOfModding.Cultivationcraft.Common.Capabilities.BodyModifications.BodyModifications;
import DaoOfModding.Cultivationcraft.Common.Capabilities.BodyModifications.IBodyModifications;
import DaoOfModding.Cultivationcraft.Common.Capabilities.ChunkQiSources.ChunkQiSources;
import DaoOfModding.Cultivationcraft.Common.Capabilities.CultivatorStats.CultivatorStats;
import DaoOfModding.Cultivationcraft.Common.Capabilities.CultivatorStats.ICultivatorStats;
import DaoOfModding.Cultivationcraft.Common.Qi.BodyParts.BodyPartNames;
import DaoOfModding.Cultivationcraft.Common.Qi.BodyParts.BodyPartOption;
import DaoOfModding.Cultivationcraft.Common.Qi.BodyParts.Quests.Quest;
import DaoOfModding.Cultivationcraft.Common.Qi.QiSource;
import DaoOfModding.Cultivationcraft.Common.Qi.Stats.BodyPartStatControl;
import DaoOfModding.Cultivationcraft.Common.Qi.Stats.PlayerStatModifications;
import DaoOfModding.Cultivationcraft.Common.Qi.Stats.StatIDs;
import DaoOfModding.Cultivationcraft.Network.ClientPacketHandler;
import DaoOfModding.mlmanimator.Client.Models.TextureHandler;
import DaoOfModding.mlmanimator.Client.Poses.Arm;
import com.mojang.datafixers.util.Pair;
import java.awt.Color;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;

public class BodyPart {
    protected String ID;
    protected ArrayList<String> modelIDs = new ArrayList();
    protected ArrayList<String> quadIDs = new ArrayList();
    protected ArrayList<String> firstPersonModelIDs = new ArrayList();
    protected String limbPosition;
    protected String displayNamePosition;
    protected PlayerStatModifications stats = new PlayerStatModifications();
    protected String textureID = "SKIN";
    protected Quest quest;
    protected BodyPartLocation connection = null;
    protected String viewPoint;
    protected ArrayList<String> neededToForge = new ArrayList();
    protected ArrayList<String> neededNotToForge = new ArrayList();
    protected ArrayList<Pair<String, String>> neededPositionToForge = new ArrayList();
    protected ArrayList<Pair<String, String>> needNotPositionToForge = new ArrayList();
    protected ArrayList<String> neededTags = new ArrayList();
    protected ArrayList<String> neededNotTags = new ArrayList();
    protected ArrayList<String> uniqueTags = new ArrayList();
    protected HashMap<String, Integer> hands = new HashMap();
    protected ArrayList<Arm> arms = new ArrayList();
    protected HashMap<String, ResourceLocation> textureChanges = new HashMap();
    protected HashMap<String, Vec3> textureColorChanges = new HashMap();
    protected ResourceLocation element = null;

    public BodyPart(String partID, String position, String displayNamePos) {
        this.ID = partID;
        this.limbPosition = position;
        this.displayNamePosition = displayNamePos;
        this.quest = new Quest(Quest.TIME_ALIVE, 0.0);
    }

    public void setQuest(Quest newQuest) {
        this.quest = newQuest;
    }

    public void setElement(ResourceLocation newElement) {
        this.element = newElement;
    }

    public ResourceLocation getElement() {
        return this.element;
    }

    public Quest getQuest() {
        return this.quest;
    }

    public void setConnection(BodyPartLocation newConnection) {
        this.connection = newConnection;
    }

    public BodyPartLocation getConnection() {
        return this.connection;
    }

    public boolean hasConnection() {
        return this.connection != null;
    }

    public void setViewPoint(String viewPoint) {
        this.viewPoint = viewPoint;
    }

    public String getViewPoint() {
        return this.viewPoint;
    }

    public void addModel(String modelID) {
        this.modelIDs.add(modelID);
    }

    public void addArm(Arm newArm) {
        this.arms.add(newArm);
    }

    public ArrayList<Arm> getArms() {
        return this.arms;
    }

    public void addQuad(String quadID) {
        this.quadIDs.add(quadID);
    }

    public void addFirstPersonModel(String modelID) {
        this.firstPersonModelIDs.add(modelID);
    }

    public void setTexture(String ID) {
        this.textureID = ID;
    }

    public String getTextureID() {
        return this.textureID;
    }

    public void addTextureChange(String textureID, ResourceLocation textureLocation) {
        this.textureChanges.put(textureID, textureLocation);
    }

    public void addTextureColorChange(String textureID, Vec3 textureColor) {
        this.textureColorChanges.put(textureID, textureColor);
    }

    public void addTextureColorChange(String textureID, Color color) {
        this.textureColorChanges.put(textureID, new Vec3((double)(color.getRed() * 255), (double)(color.getGreen() * 255), (double)(color.getBlue() * 255)));
    }

    public PlayerStatModifications getStatChanges() {
        return this.stats;
    }

    public String getDisplayName() {
        return Component.m_237115_((String)this.displayNamePosition).getString();
    }

    public String getDescription() {
        return Component.m_237115_((String)(this.displayNamePosition + ".description")).getString();
    }

    public String getID() {
        return this.ID;
    }

    public String getPosition() {
        return this.limbPosition;
    }

    public ArrayList<String> getModelIDs() {
        return this.modelIDs;
    }

    public ArrayList<String> getQuadIDs() {
        return this.quadIDs;
    }

    public ArrayList<String> getFirstPersonModelIDs() {
        return this.firstPersonModelIDs;
    }

    public void addNeededPart(String partID) {
        this.neededToForge.add(partID);
    }

    public void addNotNeededPart(String partID) {
        this.neededNotToForge.add(partID);
    }

    public void addNeededPosition(String positionID, String subpositionID) {
        this.neededPositionToForge.add((Pair<String, String>)new Pair((Object)positionID, (Object)subpositionID));
    }

    public void addNeedNotPosition(String positionID, String subpositionID) {
        this.needNotPositionToForge.add((Pair<String, String>)new Pair((Object)positionID, (Object)subpositionID));
    }

    public void addNeededTags(String tag) {
        this.neededTags.add(tag);
    }

    public void addNeedNotTags(String tag) {
        this.neededNotTags.add(tag);
    }

    public void addUniqueTag(String tag) {
        this.uniqueTags.add(tag);
    }

    public ArrayList<String> getUniqueTags() {
        return this.uniqueTags;
    }

    public void onLoad(UUID playerID) {
    }

    public void updateTextures(TextureHandler handler) {
        for (Map.Entry<String, ResourceLocation> entry : this.textureChanges.entrySet()) {
            handler.addTexture(entry.getKey(), entry.getValue());
        }
        for (Map.Entry<String, ResourceLocation> entry : this.textureColorChanges.entrySet()) {
            handler.addColor(entry.getKey(), (Vec3)entry.getValue());
        }
    }

    public void onClientTick(Player player) {
    }

    public void onServerTick(Player player) {
    }

    public boolean canBeForged(Player player) {
        ICultivatorStats stats = CultivatorStats.getCultivatorStats(player);
        if (stats.getCultivationType() != 1) {
            return false;
        }
        IBodyModifications modifications = BodyModifications.getBodyModifications(player);
        if (modifications == null) {
            return false;
        }
        if (!this.hasNeededPositions(modifications)) {
            return false;
        }
        if (this.hasNotNeededPositions(modifications)) {
            return false;
        }
        if (!this.hasNeededParts(modifications)) {
            return false;
        }
        if (this.hasNotNeededParts(modifications)) {
            return false;
        }
        if (this.hasDuplicateTags(modifications)) {
            return false;
        }
        if (!this.hasNeededTags(modifications)) {
            return false;
        }
        if (this.hasNotNeededTags(modifications)) {
            return false;
        }
        for (BodyPart part : modifications.getModifications().values()) {
            if (part.getPosition().compareTo(this.limbPosition) != 0) continue;
            return false;
        }
        return this.isInCorrectElement(player) || player.m_7500_();
    }

    protected boolean isInCorrectElement(Player player) {
        if (this.element == null) {
            return true;
        }
        List<QiSource> sources = ChunkQiSources.getQiSourcesInRange(player.f_19853_, player.m_20182_(), (int)BodyPartStatControl.getPlayerStatControl(player).getStats().getStat(StatIDs.qiAbsorbRange));
        for (QiSource source : sources) {
            if (source.getElement().compareTo(this.element) != 0) continue;
            return true;
        }
        return false;
    }

    protected boolean hasDuplicateTags(IBodyModifications modifications) {
        for (String tag : this.uniqueTags) {
            if (!modifications.getTags().contains(tag)) continue;
            return true;
        }
        return false;
    }

    protected boolean hasNeededTags(IBodyModifications modifications) {
        for (String tag : this.neededTags) {
            if (modifications.getTags().contains(tag)) continue;
            return false;
        }
        return true;
    }

    protected boolean hasNotNeededTags(IBodyModifications modifications) {
        for (String tag : this.neededNotTags) {
            if (!modifications.getTags().contains(tag)) continue;
            return true;
        }
        return false;
    }

    protected boolean hasNeededPositions(IBodyModifications modifications) {
        for (Pair<String, String> position : this.neededPositionToForge) {
            if (!(((String)position.getSecond()).compareTo("BASE") == 0 ? !modifications.hasModification((String)position.getFirst()) : !modifications.hasOption((String)position.getFirst(), (String)position.getSecond()))) continue;
            return false;
        }
        return true;
    }

    protected boolean hasNotNeededPositions(IBodyModifications modifications) {
        for (Pair<String, String> position : this.needNotPositionToForge) {
            if (!(((String)position.getSecond()).compareTo("BASE") == 0 ? modifications.hasModification((String)position.getFirst()) : modifications.hasOption((String)position.getFirst(), (String)position.getSecond()))) continue;
            return true;
        }
        return false;
    }

    protected boolean hasNeededParts(IBodyModifications modifications) {
        for (String testPart : this.neededToForge) {
            BodyPart test = BodyPartNames.getPart(testPart);
            if (!(test == null ? !modifications.hasOption((test = BodyPartNames.getOption(testPart)).getPosition(), ((BodyPartOption)test).getSubPosition(), test.ID) : !modifications.hasModification(test.getPosition(), test.ID))) continue;
            return false;
        }
        return true;
    }

    protected boolean hasNotNeededParts(IBodyModifications modifications) {
        for (String testPart : this.neededNotToForge) {
            BodyPart test = BodyPartNames.getPart(testPart);
            if (!(test != null ? modifications.hasModification(test.limbPosition, test.ID) : modifications.hasOption((test = BodyPartNames.getOption(testPart)).getPosition(), ((BodyPartOption)test).getSubPosition(), test.ID))) continue;
            return true;
        }
        return false;
    }

    public void sendInfo(int info) {
        ClientPacketHandler.sendPartInfoToServer(genericClientFunctions.getPlayer().m_20148_(), info, "", this.limbPosition);
    }

    public void processInfo(Player player, int info) {
    }

    public void onJoin(Player player) {
    }
}

