/*
 * Decompiled with CFR 0.152.
 */
package DaoOfModding.Cultivationcraft.Common.Qi.BodyParts.Lungs;

import DaoOfModding.Cultivationcraft.Common.Capabilities.CultivatorTechniques.CultivatorTechniques;
import DaoOfModding.Cultivationcraft.Common.Capabilities.CultivatorTechniques.ICultivatorTechniques;
import DaoOfModding.Cultivationcraft.Common.Qi.BodyParts.Lungs.Breath.Breath;
import java.util.HashMap;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.fluids.FluidType;

public class BreathingHandler {
    protected static HashMap<FluidType, Breath> fluidBreaths = new HashMap();
    protected static HashMap<BlockState, Breath> blockBreaths = new HashMap();

    public static void init() {
        BreathingHandler.addBlockBreaths(Fluids.f_76193_.getFluidType(), Breath.WATER);
        BreathingHandler.addBlockBreaths(Fluids.f_76195_.getFluidType(), Breath.FIRE);
        BreathingHandler.addBlockBreaths(Blocks.f_50083_.m_49966_(), Breath.FIRE);
        BreathingHandler.addBlockBreaths(Blocks.f_50084_.m_49966_(), Breath.FIRE);
    }

    public static void addBlockBreaths(FluidType fluid, Breath breath) {
        fluidBreaths.put(fluid, breath);
    }

    public static void addBlockBreaths(BlockState block, Breath breath) {
        blockBreaths.put(block, breath);
    }

    public static Breath getBreath(Player player) {
        ICultivatorTechniques techs = CultivatorTechniques.getCultivatorTechniques(player);
        if (techs != null && !techs.canBreath(player)) {
            return Breath.NONE;
        }
        if (fluidBreaths.containsKey(player.getEyeInFluidType())) {
            return fluidBreaths.get(player.getEyeInFluidType());
        }
        if (blockBreaths.containsKey(player.f_19853_.m_8055_(player.m_20183_()))) {
            return blockBreaths.get(player.f_19853_.m_8055_(player.m_20183_()));
        }
        if (player.m_6060_()) {
            return Breath.FIRE;
        }
        if (player.getEyeInFluidType().isAir() && !player.f_19853_.m_8055_(new BlockPos(player.m_20185_(), player.m_20188_(), player.m_20189_())).m_60713_(Blocks.f_50628_)) {
            return Breath.AIR;
        }
        return Breath.NONE;
    }
}

