/*
 * Decompiled with CFR 0.152.
 */
package DaoOfModding.Cultivationcraft.Common.Qi.BodyParts;

import DaoOfModding.Cultivationcraft.Common.Capabilities.BodyModifications.BodyModifications;
import DaoOfModding.Cultivationcraft.Common.Capabilities.BodyModifications.IBodyModifications;
import DaoOfModding.Cultivationcraft.Common.Capabilities.CultivatorStats.CultivatorStats;
import DaoOfModding.Cultivationcraft.Common.Qi.BodyParts.Blood.Blood;
import DaoOfModding.Cultivationcraft.Common.Qi.BodyParts.BodyForgeParts.BloodPart;
import DaoOfModding.Cultivationcraft.Common.Qi.BodyParts.BodyForgeParts.LungPart;
import DaoOfModding.Cultivationcraft.Common.Qi.BodyParts.BodyForgeParts.StomachPart;
import DaoOfModding.Cultivationcraft.Common.Qi.BodyParts.BodyPart;
import DaoOfModding.Cultivationcraft.Common.Qi.BodyParts.FoodStats.QiFoodStats;
import DaoOfModding.Cultivationcraft.Common.Qi.BodyParts.FoodStats.QiNotFoodStats;
import DaoOfModding.Cultivationcraft.Common.Qi.BodyParts.Lungs.Lung.Lung;
import DaoOfModding.Cultivationcraft.Common.Qi.BodyParts.Lungs.Lungs;
import DaoOfModding.Cultivationcraft.Common.Qi.Stats.BodyPartStatControl;
import DaoOfModding.Cultivationcraft.Common.Qi.Stats.StatIDs;
import DaoOfModding.Cultivationcraft.Common.Qi.Techniques.TechniqueStats.DefaultCultivationStatIDs;
import DaoOfModding.Cultivationcraft.Common.Reflection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.UUID;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodData;

public class PlayerHealthManager {
    static Blood defaultBlood = new Blood();
    protected static HashMap<UUID, Lungs> lungs = new HashMap();

    public static float getStaminaUse(Player player) {
        float staminaUse = BodyPartStatControl.getStats(player).getStat(StatIDs.staminaUse);
        float weight = BodyPartStatControl.getStats(player).getStat(StatIDs.weight);
        return staminaUse * weight;
    }

    public static Blood getBlood(Player player) {
        if (CultivatorStats.getCultivatorStats(player).getCultivationType() != 1) {
            return defaultBlood;
        }
        IBodyModifications modifications = BodyModifications.getBodyModifications(player);
        if (!modifications.hasOption("BODY", "BLOOD")) {
            return defaultBlood;
        }
        return ((BloodPart)modifications.getOption("BODY", "BLOOD")).getBloodType();
    }

    public static void updateLungs(Player player) {
        IBodyModifications modifications;
        Lungs lung = new Lungs();
        lung = lung.copy(player);
        if (CultivatorStats.getCultivatorStats(player).getCultivationType() == 1 && (modifications = BodyModifications.getBodyModifications(player)).hasOption("BODY", "LUNG")) {
            LungPart part = (LungPart)modifications.getOption("BODY", "LUNG");
            lung = part.getLungType();
            ArrayList<BodyPart> lungParts = modifications.getBodyPartsOfType(LungPart.class);
            for (int i = 0; i < lung.getLungAmount(); ++i) {
                ResourceLocation location = lung.getConnection(i).getLocation();
                for (BodyPart testLung : lungParts) {
                    Lung lungConnection = ((LungPart)testLung).getLung(location);
                    if (lungConnection == null) continue;
                    lung.setLung(i, lungConnection);
                }
            }
            lung = lung.copy(player);
        }
        lungs.put(player.m_20148_(), lung);
    }

    public static Lungs getLungs(Player player) {
        if (!lungs.containsKey(player.m_20148_())) {
            lungs.put(player.m_20148_(), new Lungs());
        }
        return lungs.get(player.m_20148_());
    }

    public static void updateFoodStats(Player player) {
        if (CultivatorStats.getCultivatorStats(player).getCultivationType() == 0) {
            QiNotFoodStats food = new QiNotFoodStats();
            food.setMaxFood((int)CultivatorStats.getCultivatorStats(player).getCultivation().getCultivationStat(player, DefaultCultivationStatIDs.maxQi));
            PlayerHealthManager.setFoodStats(player, food);
        } else if (CultivatorStats.getCultivatorStats(player).getCultivationType() == 1) {
            QiFoodStats food = new QiFoodStats();
            IBodyModifications modifications = BodyModifications.getBodyModifications(player);
            ArrayList<BodyPart> stomach = modifications.getBodyPartsOfType(StomachPart.class);
            if (stomach.size() > 0) {
                food = ((StomachPart)stomach.get(0)).getFoodStats().clone();
            }
            food.setMaxFood((int)BodyPartStatControl.getStats(player).getStat(StatIDs.maxStamina));
            PlayerHealthManager.setFoodStats(player, food);
        }
    }

    protected static void setFoodStats(Player player, QiFoodStats newFood) {
        FoodData oldFood = player.m_36324_();
        if (oldFood instanceof QiFoodStats) {
            PlayerHealthManager.updateQiFoodStats((QiFoodStats)oldFood, newFood);
        } else {
            PlayerHealthManager.updateOldFoodStats(oldFood, newFood);
        }
        Reflection.setFoodStats(player, newFood);
    }

    protected static void updateQiFoodStats(QiFoodStats oldFoodStats, QiFoodStats newFoodStats) {
        newFoodStats.setFoodLevel(oldFoodStats.getTrueFoodLevel());
        newFoodStats.m_150378_(oldFoodStats.m_150380_());
        newFoodStats.m_38717_(oldFoodStats.m_38722_());
    }

    protected static void updateOldFoodStats(FoodData oldFoodStats, QiFoodStats newFoodStats) {
        newFoodStats.m_38705_(oldFoodStats.m_38702_());
        newFoodStats.m_38717_(oldFoodStats.m_38722_());
    }
}

