/*
 * Decompiled with CFR 0.152.
 */
package DaoOfModding.Cultivationcraft.Common.Qi.BodyParts.Quests;

import DaoOfModding.Cultivationcraft.Common.Capabilities.BodyModifications.BodyModifications;
import DaoOfModding.Cultivationcraft.Common.Capabilities.BodyModifications.IBodyModifications;
import DaoOfModding.Cultivationcraft.Common.Capabilities.CultivatorStats.CultivatorStats;
import DaoOfModding.Cultivationcraft.Common.Capabilities.CultivatorStats.ICultivatorStats;
import DaoOfModding.Cultivationcraft.Common.PlayerUtils;
import DaoOfModding.Cultivationcraft.Common.Qi.BodyParts.BodyPart;
import DaoOfModding.Cultivationcraft.Common.Qi.BodyParts.BodyPartNames;
import DaoOfModding.Cultivationcraft.Common.Qi.BodyParts.Quests.Quest;
import DaoOfModding.Cultivationcraft.Common.Qi.Damage.QiDamageSource;
import DaoOfModding.Cultivationcraft.Network.ClientPacketHandler;
import DaoOfModding.Cultivationcraft.Network.PacketHandler;
import DaoOfModding.Cultivationcraft.debug;
import java.util.HashMap;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;

public class QuestHandler {
    protected static HashMap<String, ResourceLocation> damageQuests = new HashMap();

    public static void addDamageQuest(String damageSource, ResourceLocation quest) {
        damageQuests.put(damageSource, quest);
    }

    public static ResourceLocation getDamageQuest(String damageSource) {
        return damageQuests.get(damageSource);
    }

    public static void damageProgress(Player player, QiDamageSource source, float amount) {
        ResourceLocation quest = QuestHandler.getDamageQuest(source.m_19385_());
        if (quest == null) {
            return;
        }
        QuestHandler.progressQuest(player, quest, amount);
    }

    public static double getQuestProgress(Player player) {
        IBodyModifications modifications = BodyModifications.getBodyModifications(player);
        return modifications.getQuestProgress();
    }

    public static void resetQuest(Player player, ResourceLocation mode) {
        if (player.f_19853_.f_46443_ && !PlayerUtils.isClientPlayerCharacter(player)) {
            return;
        }
        ICultivatorStats stats = CultivatorStats.getCultivatorStats(player);
        if (stats.getCultivationType() != 1) {
            return;
        }
        IBodyModifications modifications = BodyModifications.getBodyModifications(player);
        if (modifications.getLastForged().compareTo("") == 0) {
            return;
        }
        BodyPart part = BodyPartNames.getPartOrOption(modifications.getLastForged());
        if (part.getQuest().mode.compareTo(mode) == 0) {
            QuestHandler.progressQuest(player, mode, modifications.getQuestProgress() * -1.0);
        }
    }

    public static void progressQuest(Player player, ResourceLocation mode, double amount) {
        if (player.f_19853_.f_46443_ && !PlayerUtils.isClientPlayerCharacter(player)) {
            return;
        }
        amount *= debug.questProgressSpeed;
        ICultivatorStats stats = CultivatorStats.getCultivatorStats(player);
        if (stats.getCultivationType() != 1) {
            return;
        }
        IBodyModifications modifications = BodyModifications.getBodyModifications(player);
        if (modifications.getLastForged().compareTo("") == 0) {
            return;
        }
        BodyPart part = BodyPartNames.getPartOrOption(modifications.getLastForged());
        Quest quest = part.getQuest();
        if (quest == null) {
            modifications.setLastForged("");
            return;
        }
        double progress = quest.progress(mode, amount);
        if (progress == 0.0 && !debug.skipQuest) {
            return;
        }
        if (PlayerUtils.isClientPlayerCharacter(player)) {
            ClientPacketHandler.sendQuestProgressToServer(player.m_20148_(), progress);
        } else if (!player.f_19853_.f_46443_) {
            PacketHandler.sendQuestProgressToClient(player.m_20148_(), progress);
        }
        QuestHandler.progressQuest(player, progress);
    }

    public static void progressQuest(Player player, double progress) {
        IBodyModifications modifications = BodyModifications.getBodyModifications(player);
        if (PlayerUtils.isClientPlayerCharacter(player)) {
            modifications.setQuestProgress(modifications.getQuestProgress() + progress);
            return;
        }
        if (!debug.skipQuest) {
            BodyPart part = BodyPartNames.getPartOrOption(modifications.getLastForged());
            Quest quest = part.getQuest();
            if (progress < 0.0) {
                progress = 0.0;
            }
            if ((progress = modifications.getQuestProgress() + progress) < quest.complete) {
                modifications.setQuestProgress(progress);
                return;
            }
        }
        modifications.setLastForged("");
        modifications.setQuestProgress(0.0);
        PacketHandler.sendBodyModificationsToClient(player);
    }
}

