/*
 * Decompiled with CFR 0.152.
 */
package DaoOfModding.Cultivationcraft.Common.Qi.Cultivation;

import DaoOfModding.Cultivationcraft.Client.GUI.Screens.CultivationTypeScreens.CultivationTypeScreen;
import DaoOfModding.Cultivationcraft.Common.Capabilities.ChunkQiSources.ChunkQiSources;
import DaoOfModding.Cultivationcraft.Common.Capabilities.CultivatorStats.CultivatorStats;
import DaoOfModding.Cultivationcraft.Common.Qi.BodyParts.FoodStats.QiFoodStats;
import DaoOfModding.Cultivationcraft.Common.Qi.Cultivation.Tribulation;
import DaoOfModding.Cultivationcraft.Common.Qi.ExternalCultivationHandler;
import DaoOfModding.Cultivationcraft.Common.Qi.QiSource;
import DaoOfModding.Cultivationcraft.Common.Qi.Techniques.PassiveTechniques.PassiveTechnique;
import DaoOfModding.Cultivationcraft.Common.Qi.Techniques.Technique;
import DaoOfModding.Cultivationcraft.Common.Qi.Techniques.TechniqueStats.DefaultCultivationStatIDs;
import DaoOfModding.Cultivationcraft.Cultivationcraft;
import DaoOfModding.Cultivationcraft.Network.PacketHandler;
import DaoOfModding.Cultivationcraft.StaminaHandler;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;

public class CultivationType {
    protected String ID = "cultivationcraft.cultivation.default";
    protected int techLevel = 0;
    protected int maxedTechsToBreakthrough = 0;
    protected int stage = 1;
    protected int maxStage = 1;
    protected CultivationType previousCultivation = null;
    protected Tribulation tribulation = new Tribulation(this.maxStage, 100, 1.0f);
    protected boolean isTribulating = false;
    protected boolean hasTribulated = false;
    protected HashMap<String, HashMap<ResourceLocation, Double>> statLevels = new HashMap();
    protected PassiveTechnique passive = new PassiveTechnique();
    protected CultivationTypeScreen screen = new CultivationTypeScreen();
    protected ArrayList<CultivationType> advancements = new ArrayList();

    public CultivationType(int currentStage) {
        this.stage = currentStage;
        this.stageCalculations();
    }

    public void stageCalculations() {
    }

    public String getName() {
        return Component.m_237115_((String)this.ID).getString();
    }

    public String getID() {
        return this.ID;
    }

    public boolean canCultivate(ResourceLocation element) {
        return true;
    }

    public boolean consumeQi(Player player, double qiToConsume) {
        return StaminaHandler.consumeStamina(player, (float)qiToConsume);
    }

    public boolean canBreakthrough(Player player) {
        return this.getTechLevelProgressWithoutPrevious(this.passive.getClass().toString()) >= this.techLevel && this.getMaxedTechs() >= this.maxedTechsToBreakthrough;
    }

    public ArrayList<CultivationType> getAdvancements() {
        return this.advancements;
    }

    public void advance(Player player, String advancement) {
        CultivationType advanceTo = null;
        for (CultivationType advance : this.advancements) {
            if (advance.getID().compareTo(advancement) != 0) continue;
            advanceTo = advance;
        }
        if (advanceTo == null) {
            Cultivationcraft.LOGGER.error("Tried to advance to unavailable cultivation type " + advancement);
            return;
        }
        advanceTo.setPreviousCultivation(this);
        CultivatorStats.getCultivatorStats(player).setCultivation(advanceTo);
        this.tribulation.reset();
    }

    public boolean hasTribulated() {
        return this.hasTribulated;
    }

    public boolean hasTribulation(Player player) {
        return this.stage == this.maxStage && this.canBreakthrough(player);
    }

    public void tick(Player player) {
        ((QiFoodStats)player.m_36324_()).setFoodLevel(((QiFoodStats)player.m_36324_()).getTrueFoodLevel() + (float)(this.getCultivationStat(player, DefaultCultivationStatIDs.qiPassiveSpeed) / 20.0));
        if (player.f_19853_.f_46443_) {
            return;
        }
        if (this.isTribulating() && player.m_6084_() && this.tribulation.tick(player)) {
            this.isTribulating = false;
            this.tribulationComplete(player);
            PacketHandler.sendCultivatorStatsToClient(player);
        }
    }

    public int getStage() {
        return this.stage;
    }

    public int getMaxStage() {
        return this.maxStage;
    }

    public void startTribulation() {
        this.isTribulating = true;
    }

    public boolean isTribulating() {
        return this.isTribulating;
    }

    public void breakthrough(Player player) {
    }

    public void tribulationComplete(Player player) {
        this.hasTribulated = true;
    }

    public CultivationTypeScreen getScreen() {
        return this.screen;
    }

    public String breakthroughProgress(Player player) {
        String progress = Component.m_237115_((String)"cultivationcraft.gui.cultivationprogress").getString() + ": " + this.getTechLevelProgressWithoutPrevious(this.passive.getClass().toString()) + "/" + this.techLevel;
        if (this.maxedTechsToBreakthrough > 0) {
            progress = progress + "\n" + Component.m_237115_((String)"cultivationcraft.gui.completedtech").getString() + ": " + this.getMaxedTechs() + "/" + this.maxedTechsToBreakthrough;
        }
        if (this.hasTribulation(player)) {
            progress = progress + "\n" + Component.m_237115_((String)"cultivationcraft.gui.tribulationpending").getString();
        }
        return progress;
    }

    public int getMaxedTechs() {
        int i = 0;
        for (String tech : this.statLevels.keySet()) {
            if (this.passive.getClass().toString().compareTo(tech) == 0 || this.getTechLevelProgress(tech) < this.getMaxTechLevel()) continue;
            ++i;
        }
        return i;
    }

    public PassiveTechnique getPassive() {
        return this.passive;
    }

    public double getCultivationStat(Player player, ResourceLocation stat) {
        double amount = 0.0;
        if (this.getPassive().hasTechniqueStat(stat)) {
            amount += this.getPassive().getTechniqueStat(stat, player);
        }
        return amount;
    }

    public void reset(Player player) {
        this.statLevels = new HashMap();
    }

    public double absorbFromQiSource(double amount, Player player) {
        List<QiSource> sources = ChunkQiSources.getQiSourcesInRange(player.f_19853_, player.m_20182_(), (int)this.getCultivationStat(player, DefaultCultivationStatIDs.qiAbsorbRange));
        double remaining = amount;
        float toAbsorb = 0.0f;
        for (QiSource source : sources) {
            if (!this.canCultivate(source.getElement()) || !(remaining > 0.0)) continue;
            double absorbed = source.absorbQi(remaining, player);
            remaining -= absorbed;
            toAbsorb = (float)((double)toAbsorb + absorbed);
        }
        if ((double)toAbsorb > amount) {
            return amount;
        }
        if (toAbsorb < 0.0f) {
            return 0.0;
        }
        return toAbsorb;
    }

    public double absorbFromQiSource(int amount, Player player, QiSource source) {
        double toAbsorb = 0.0;
        toAbsorb = 0.0;
        if (this.canCultivate(source.getElement())) {
            toAbsorb = source.absorbQi(amount, player);
        }
        if (toAbsorb > (double)amount) {
            return amount;
        }
        if (toAbsorb < 0.0) {
            return 0.0;
        }
        return toAbsorb;
    }

    public float progressCultivation(Player player, float Qi, ResourceLocation element) {
        if (!this.canCultivate(element)) {
            return Qi;
        }
        if (Qi < 0.0f) {
            return 0.0f;
        }
        int currentLevel = this.getTechLevelProgressWithoutPrevious(this.getPassive().getClass().toString());
        if (currentLevel >= this.techLevel) {
            return Qi;
        }
        float remains = (float)currentLevel + Qi - (float)this.techLevel;
        if (remains > 0.0f) {
            this.getPassive().levelUp(player, remains);
            return Qi - remains;
        }
        this.getPassive().levelUp(player, Qi);
        return 0.0f;
    }

    public CultivationType getPreviousCultivation() {
        return this.previousCultivation;
    }

    public Double getStatLevelWithoutPrevious(Class tech, ResourceLocation stat) {
        Double level = 0.0;
        if (this.statLevels.containsKey(tech.toString()) && this.statLevels.get(tech.toString()).containsKey(stat)) {
            level = level + this.statLevels.get(tech.toString()).get(stat);
        }
        return level;
    }

    public Double getStatLevel(Class tech, ResourceLocation stat) {
        if (tech.toString().compareTo(this.passive.getClass().toString()) == 0) {
            return this.getPassiveStatLevel(stat);
        }
        Double level = 0.0;
        if (this.statLevels.containsKey(tech.toString()) && this.statLevels.get(tech.toString()).containsKey(stat)) {
            level = level + this.statLevels.get(tech.toString()).get(stat);
        }
        if (this.previousCultivation != null) {
            level = level + this.previousCultivation.getStatLevel(tech, stat);
        }
        return level;
    }

    public Double getPassiveStatLevel(ResourceLocation stat) {
        Double level = 0.0;
        String passiveString = this.getPassive().getClass().toString();
        if (this.statLevels.containsKey(passiveString) && this.statLevels.get(passiveString).containsKey(stat)) {
            level = level + this.statLevels.get(passiveString).get(stat);
        }
        if (this.previousCultivation != null) {
            level = level + this.previousCultivation.getPassiveStatLevel(stat);
        }
        return level;
    }

    public int getMaxTechLevelWithoutPrevious() {
        return this.techLevel;
    }

    public int getMaxTechLevel() {
        int level = this.techLevel;
        if (this.previousCultivation != null) {
            level += this.getPreviousCultivation().getMaxTechLevel();
        }
        return level;
    }

    public int getTechLevelProgress(Class tech) {
        return this.getTechLevelProgress(tech.toString());
    }

    public int getTechLevelProgressWithoutPrevious(String tech) {
        int progress = 0;
        if (this.statLevels.containsKey(tech)) {
            for (double value : this.statLevels.get(tech).values()) {
                progress += (int)value;
            }
        }
        return progress;
    }

    public int getTechLevelProgress(String tech) {
        if (tech.compareTo(this.passive.getClass().toString()) == 0) {
            return this.getPassiveTechLevelProgress();
        }
        int progress = 0;
        if (this.statLevels.containsKey(tech)) {
            for (double value : this.statLevels.get(tech).values()) {
                progress += (int)value;
            }
        }
        if (this.previousCultivation != null) {
            progress += this.previousCultivation.getTechLevelProgress(tech);
        }
        return progress;
    }

    public int getPassiveTechLevelProgress() {
        int progress = 0;
        String tech = this.getPassive().getClass().toString();
        if (this.statLevels.containsKey(tech)) {
            for (double value : this.statLevels.get(tech).values()) {
                progress += (int)value;
            }
        }
        if (this.previousCultivation != null) {
            progress += this.previousCultivation.getPassiveTechLevelProgress();
        }
        return progress;
    }

    public void levelTech(Technique tech, double amount, Player player) {
        ResourceLocation toLevel;
        int current;
        int max = this.getMaxTechLevel();
        if (max == (current = this.getTechLevelProgress(tech.getClass()))) {
            return;
        }
        double amountToLevel = max - current;
        if (amount > amountToLevel) {
            amount = amountToLevel;
        }
        if ((toLevel = CultivatorStats.getCultivatorStats(player).getTechniqueFocus(tech.getClass())) == null) {
            toLevel = (ResourceLocation)tech.getTechniqueStats().toArray()[0];
        }
        double currentLevel = amount;
        if (!this.statLevels.containsKey(tech.getClass().toString())) {
            this.statLevels.put(tech.getClass().toString(), new HashMap());
        }
        if (this.statLevels.get(tech.getClass().toString()).containsKey(toLevel)) {
            currentLevel += this.statLevels.get(tech.getClass().toString()).get(toLevel).doubleValue();
        }
        this.statLevels.get(tech.getClass().toString()).put(toLevel, currentLevel);
        PacketHandler.sendCultivatorStatsToClient(player);
    }

    public void setPreviousCultivation(CultivationType previous) {
        this.previousCultivation = previous;
    }

    public CompoundTag writeNBT() {
        CompoundTag nbt = new CompoundTag();
        if (this.getPreviousCultivation() != null) {
            nbt.m_128359_("PREVIOUSCULTNAME", this.getPreviousCultivation().getClass().toString());
            nbt.m_128365_("PREVIOUSCULT", (Tag)this.getPreviousCultivation().writeNBT());
        }
        nbt.m_128405_("STAGE", this.getStage());
        nbt.m_128379_("TRIBULATING", this.isTribulating);
        nbt.m_128379_("TRIBULATED", this.hasTribulated);
        int i = 0;
        for (Map.Entry<String, HashMap<ResourceLocation, Double>> tech : this.statLevels.entrySet()) {
            nbt.m_128359_("TECH" + i + "CLASS", tech.getKey());
            int j = 0;
            for (Map.Entry<ResourceLocation, Double> techEntry : tech.getValue().entrySet()) {
                nbt.m_128359_("TECH" + i + "ENTRY" + j + "NAME", techEntry.getKey().toString());
                nbt.m_128347_("TECH" + i + "ENTRY" + j + "VALUE", techEntry.getValue().doubleValue());
                ++j;
            }
            ++i;
        }
        return nbt;
    }

    public void readNBT(CompoundTag nbt) {
        if (nbt.m_128441_("PREVIOUSCULTNAME")) {
            CultivationType newCultivation = ExternalCultivationHandler.getCultivation(nbt.m_128461_("PREVIOUSCULTNAME"));
            newCultivation.readNBT(nbt.m_128469_("PREVIOUSCULT"));
            this.previousCultivation = newCultivation;
        }
        this.stage = nbt.m_128451_("STAGE");
        this.stageCalculations();
        this.isTribulating = nbt.m_128471_("TRIBULATING");
        this.hasTribulated = nbt.m_128471_("TRIBULATED");
        HashMap newTechLevels = new HashMap();
        int i = 0;
        while (nbt.m_128441_("TECH" + i + "CLASS")) {
            int j = 0;
            HashMap<ResourceLocation, Double> values = new HashMap<ResourceLocation, Double>();
            while (nbt.m_128441_("TECH" + i + "ENTRY" + j + "NAME")) {
                values.put(new ResourceLocation(nbt.m_128461_("TECH" + i + "ENTRY" + j + "NAME")), nbt.m_128459_("TECH" + i + "ENTRY" + j + "VALUE"));
                ++j;
            }
            newTechLevels.put(nbt.m_128461_("TECH" + i + "CLASS"), values);
            ++i;
        }
        this.statLevels = newTechLevels;
    }
}

