/*
 * Decompiled with CFR 0.152.
 */
package DaoOfModding.Cultivationcraft.Common.Qi.Cultivation;

import DaoOfModding.Cultivationcraft.Client.GUI.Screens.CultivationTypeScreens.QiCondenserScreen;
import DaoOfModding.Cultivationcraft.Common.Capabilities.CultivatorStats.CultivatorStats;
import DaoOfModding.Cultivationcraft.Common.Qi.Cultivation.CultivationType;
import DaoOfModding.Cultivationcraft.Common.Qi.Cultivation.Tribulation;
import DaoOfModding.Cultivationcraft.Common.Qi.Elements.Elements;
import DaoOfModding.Cultivationcraft.Common.Qi.Techniques.PassiveTechniques.CultivationPassives.QiCondenserPassive;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;

public class QiCondenserCultivation
extends CultivationType {
    protected HashMap<ResourceLocation, Float> elementProgression = new HashMap();

    public QiCondenserCultivation() {
        this(1);
    }

    public QiCondenserCultivation(int cultivationStage) {
        super(cultivationStage);
        this.passive = new QiCondenserPassive();
        this.maxedTechsToBreakthrough = 3;
        this.maxStage = 8;
        this.screen = new QiCondenserScreen();
        this.tribulation = new Tribulation(this.maxStage, 50, 0.4f);
        this.ID = "cultivationcraft.cultivation.qicondensation";
    }

    @Override
    public void stageCalculations() {
        this.techLevel = 200 + 100 * this.stage;
    }

    @Override
    public boolean canBreakthrough(Player player) {
        if (this.stage == this.maxStage) {
            return false;
        }
        return super.canBreakthrough(player);
    }

    @Override
    public void breakthrough(Player player) {
        if (this.stage < this.maxStage) {
            QiCondenserCultivation newCultivation = new QiCondenserCultivation(this.stage + 1);
            newCultivation.setPreviousCultivation(this);
            CultivatorStats.getCultivatorStats(player).setCultivation(newCultivation);
        }
    }

    @Override
    public float progressCultivation(Player player, float Qi, ResourceLocation element) {
        if (Qi == 0.0f) {
            return 0.0f;
        }
        float changedQi = super.progressCultivation(player, Qi, element);
        float usedQi = Qi - changedQi;
        if (!this.elementProgression.containsKey(element)) {
            this.elementProgression.put(element, Float.valueOf(usedQi));
        } else {
            this.elementProgression.put(element, Float.valueOf(this.elementProgression.get(element).floatValue() + usedQi));
        }
        return changedQi;
    }

    @Override
    public void reset(Player player) {
        super.reset(player);
        this.elementProgression = new HashMap();
    }

    public float getElementFocusAmountRaw(ResourceLocation element) {
        float progress = this.getTechLevelProgressWithoutPrevious(this.passive.getClass().toString());
        float amount = 1.0f;
        if (progress > 0.0f) {
            amount = 0.0f;
            if (this.elementProgression.containsKey(element)) {
                amount = this.elementProgression.get(element).floatValue();
            }
            if (element.compareTo(Elements.anyElement) != 0 && this.elementProgression.containsKey(Elements.anyElement)) {
                amount += this.elementProgression.get(Elements.anyElement).floatValue();
            }
            if (amount != 0.0f) {
                amount /= progress;
            }
        }
        if (amount > 1.0f) {
            amount = 1.0f;
        }
        amount *= (float)this.getTechLevelProgressWithoutPrevious(this.passive.getClass().toString()) / (float)this.getMaxTechLevelWithoutPrevious();
        if (this.getPreviousCultivation() instanceof QiCondenserCultivation) {
            amount += ((QiCondenserCultivation)this.getPreviousCultivation()).getElementFocusAmountRaw(element);
        }
        return amount;
    }

    public float getElementFocusAmount(ResourceLocation element) {
        float amount = this.getElementFocusAmountRaw(element);
        if ((amount /= (float)this.stage - (1.0f - (float)this.getTechLevelProgressWithoutPrevious(this.passive.getClass().toString()) / (float)this.getMaxTechLevelWithoutPrevious())) > 1.0f) {
            return 1.0f;
        }
        return amount;
    }

    public ResourceLocation getCurrentElementFocus() {
        float amount = 0.0f;
        ResourceLocation currentElement = Elements.noElement;
        HashMap<ResourceLocation, Float> combinedElements = this.getCombinedElements();
        for (ResourceLocation element : combinedElements.keySet()) {
            if (element.compareTo(Elements.anyElement) == 0 || !(combinedElements.get(element).floatValue() > amount)) continue;
            amount = combinedElements.get(element).floatValue();
            currentElement = element;
        }
        return currentElement;
    }

    protected HashMap<ResourceLocation, Float> getCombinedElements() {
        if (this.getPreviousCultivation() instanceof QiCondenserCultivation) {
            return this.combine(this.elementProgression, ((QiCondenserCultivation)this.getPreviousCultivation()).getCombinedElements());
        }
        return this.elementProgression;
    }

    protected HashMap<ResourceLocation, Float> combine(HashMap<ResourceLocation, Float> set1, HashMap<ResourceLocation, Float> set2) {
        HashMap<ResourceLocation, Float> output = new HashMap<ResourceLocation, Float>();
        for (ResourceLocation element : set1.keySet()) {
            output.put(element, set1.get(element));
        }
        for (ResourceLocation element : set2.keySet()) {
            float value = 0.0f;
            if (output.containsKey(element)) {
                value = output.get(element).floatValue();
            }
            output.put(element, Float.valueOf(value + set2.get(element).floatValue()));
        }
        return output;
    }

    @Override
    public CompoundTag writeNBT() {
        CompoundTag nbt = super.writeNBT();
        int i = 0;
        for (Map.Entry<ResourceLocation, Float> elementEntry : this.elementProgression.entrySet()) {
            nbt.m_128359_("ELEMENT" + i + "NAME", elementEntry.getKey().toString());
            nbt.m_128350_("ELEMENT" + i + "VALUE", elementEntry.getValue().floatValue());
            ++i;
        }
        return nbt;
    }

    @Override
    public void readNBT(CompoundTag nbt) {
        super.readNBT(nbt);
        int i = 0;
        HashMap<ResourceLocation, Float> values = new HashMap<ResourceLocation, Float>();
        while (nbt.m_128441_("ELEMENT" + i + "NAME")) {
            values.put(new ResourceLocation(nbt.m_128461_("ELEMENT" + i + "NAME")), Float.valueOf(nbt.m_128457_("ELEMENT" + i + "VALUE")));
            ++i;
        }
        this.elementProgression = values;
    }
}

