/*
 * Decompiled with CFR 0.152.
 */
package DaoOfModding.Cultivationcraft.Common.Qi.Cultivation;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;

public class Tribulation {
    protected int tick = 0;
    protected int lightningStrikes = 0;
    protected int lightningPower = 0;
    protected float lightningPowerModifier = 0.0f;
    protected final int targetStrikes;

    public Tribulation(int numberOfLightningStrikes, int lightningStrength, float lightningStrengthGrowth) {
        this.targetStrikes = numberOfLightningStrikes;
        this.lightningPower = lightningStrength;
        this.lightningPowerModifier = lightningStrengthGrowth;
    }

    public void reset() {
        this.tick = 0;
        this.lightningStrikes = 0;
    }

    public boolean tick(Player player) {
        if (player.f_19853_.m_6042_().f_63856_() || !player.f_19853_.m_6042_().f_223549_()) {
            this.reset();
            return false;
        }
        if (this.targetStrikes == this.lightningStrikes) {
            return true;
        }
        ++this.tick;
        player.f_19853_.m_46707_(1.0f);
        if (player.f_19853_.f_46443_) {
            return false;
        }
        if (this.tick % 200 == 0) {
            int strength = (int)((float)this.lightningPower * (1.0f + (float)this.lightningStrikes * this.lightningPowerModifier));
            this.lightning(player.m_20183_(), strength, (ServerLevel)player.f_19853_);
        }
        return false;
    }

    public void lightning(BlockPos targetPos, float power, ServerLevel level) {
        if (!level.m_45527_(targetPos)) {
            for (int y = level.m_151558_(); power > 0.0f && y > targetPos.m_123342_(); --y) {
                BlockPos blockpos = new BlockPos(targetPos.m_123341_(), y, targetPos.m_123343_());
                BlockState block = level.m_8055_(blockpos);
                if (block.m_60795_() || block.m_60767_().m_76332_()) continue;
                float strength = Math.min(block.m_60800_((BlockGetter)level, blockpos), 2.0f) * 0.5f;
                if (strength > power) {
                    this.spawnLightning(level, blockpos, power);
                    return;
                }
                power -= strength;
                level.m_46961_(blockpos, true);
            }
        }
        this.spawnLightning(level, targetPos, power);
    }

    public void spawnLightning(ServerLevel level, BlockPos pos, float power) {
        ++this.lightningStrikes;
        LightningBolt lightningbolt = (LightningBolt)EntityType.f_20465_.m_20615_((Level)level);
        lightningbolt.m_20219_(Vec3.m_82539_((Vec3i)pos));
        lightningbolt.setDamage(power);
        level.m_7967_((Entity)lightningbolt);
    }
}

