/*
 * Decompiled with CFR 0.152.
 */
package DaoOfModding.Cultivationcraft.Common.Qi.Damage;

import DaoOfModding.Cultivationcraft.Common.Capabilities.CultivatorTechniques.CultivatorTechniques;
import DaoOfModding.Cultivationcraft.Common.Capabilities.CultivatorTechniques.ICultivatorTechniques;
import DaoOfModding.Cultivationcraft.Common.Qi.BodyParts.PlayerHealthManager;
import DaoOfModding.Cultivationcraft.Common.Qi.BodyParts.Quests.Quest;
import DaoOfModding.Cultivationcraft.Common.Qi.BodyParts.Quests.QuestHandler;
import DaoOfModding.Cultivationcraft.Common.Qi.Damage.QiDamageSource;
import DaoOfModding.Cultivationcraft.Common.Qi.Elements.Elements;
import DaoOfModding.Cultivationcraft.Common.Qi.Stats.BodyPartStatControl;
import DaoOfModding.Cultivationcraft.Common.Qi.Stats.PlayerStatModifications;
import DaoOfModding.Cultivationcraft.Common.Qi.Stats.StatIDs;
import DaoOfModding.Cultivationcraft.Common.Qi.Techniques.PassiveTechniques.PassiveTechnique;
import DaoOfModding.Cultivationcraft.Common.Qi.Techniques.Technique;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.damagesource.CombatRules;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;

public class Damage {
    public static float damage(LivingHurtEvent event) {
        QiDamageSource source = Damage.damageSourceToQiDamageSource(event.getSource());
        float amount = Damage.resistDamage(event.getAmount(), source.damageElement, (Player)event.getEntity());
        amount = Damage.doTechniqueResistances(source, amount, (Player)event.getEntity());
        if (source.getElement().compareTo(Elements.lightningElement) == 0) {
            event.getEntity().f_20916_ = event.getEntity().f_20917_ * 2;
        }
        return amount;
    }

    public static float doTechniqueResistances(QiDamageSource source, float amount, Player player) {
        ICultivatorTechniques techs = CultivatorTechniques.getCultivatorTechniques(player);
        for (int i = 0; i < 9; ++i) {
            Technique tech = techs.getTechnique(i);
            if (tech == null || !tech.isValid(player) || !tech.isActive()) continue;
            amount = tech.onDamage(source, amount, player);
        }
        for (PassiveTechnique passive : techs.getPassives()) {
            if (!passive.isValid(player) || !passive.isActive()) continue;
            amount = passive.onDamage(source, amount, player);
        }
        return amount;
    }

    public static float resistDamage(float damage, ResourceLocation element, Player player) {
        PlayerStatModifications stats = BodyPartStatControl.getStats(player);
        float multiplier = 1.0f - stats.getElementalStat(StatIDs.resistanceModifier, element) / 100.0f;
        if (multiplier < 0.0f && !PlayerHealthManager.getBlood(player).canHeal(element, player)) {
            multiplier = 0.0f;
        }
        return damage * multiplier;
    }

    public static void applyStatusEffects(LivingHurtEvent event) {
        QiDamageSource source = Damage.damageSourceToQiDamageSource(event.getSource());
        if (source.getElement() != null && source.doStatusEffect()) {
            Elements.getElement(source.getElement()).applyStatusEffect(source, (Entity)event.getEntity(), event.getAmount());
        }
    }

    public static float damageEntity(LivingHurtEvent event) {
        float damage = event.getAmount();
        if (event.getSource().m_7639_() != null && event.getSource().m_7639_() instanceof ServerPlayer) {
            QuestHandler.damageProgress((Player)event.getSource().m_7639_(), Damage.damageSourceToQiDamageSource(event.getSource()), damage);
        }
        return damage;
    }

    public static boolean shouldCancel(LivingAttackEvent event) {
        Vec3 position;
        QiDamageSource source = Damage.damageSourceToQiDamageSource(event.getSource());
        float damage = Damage.armorAbsorption((Player)event.getEntity(), source, event.getAmount());
        float resistedDamage = Damage.resistDamage(damage, source.damageElement, (Player)event.getEntity());
        if (source.getElement() != null && source.getElement().compareTo(Elements.fireElement) == 0 && event.getEntity().m_5825_() && resistedDamage > 0.0f) {
            resistedDamage = 0.0f;
        }
        if (resistedDamage <= 0.0f) {
            QuestHandler.progressQuest((Player)event.getEntity(), Quest.DAMAGE_RESISTED, event.getAmount());
            float heal = resistedDamage * -1.0f;
            if (event.getSource().m_19385_().compareTo(DamageSource.f_19308_.m_19385_()) == 0 && heal > 0.2f) {
                heal = 0.2f;
            }
            event.getEntity().m_5634_(heal);
            return true;
        }
        if (event.getEntity().f_20916_ == 0 && event.getEntity().m_6084_()) {
            QuestHandler.progressQuest((Player)event.getEntity(), Quest.DAMAGE_TAKEN, resistedDamage);
            QuestHandler.progressQuest((Player)event.getEntity(), Quest.DAMAGE_RESISTED, event.getAmount() - resistedDamage);
        }
        if (event.getSource().m_7639_() != null && event.getSource().m_7639_() instanceof ServerPlayer) {
            QuestHandler.damageProgress((Player)event.getSource().m_7639_(), Damage.damageSourceToQiDamageSource(event.getSource()), resistedDamage);
        }
        if ((position = source.m_7270_()) == null && source.m_7639_() != null) {
            position = source.m_7639_().m_20182_();
        }
        if (!source.isInternal()) {
            PlayerHealthManager.getBlood((Player)event.getEntity()).onHit((Player)event.getEntity(), position, event.getAmount());
        }
        return false;
    }

    protected static float armorAbsorption(Player player, QiDamageSource source, float amount) {
        if (!source.m_19376_()) {
            amount = CombatRules.m_19272_((float)amount, (float)player.m_21230_(), (float)((float)player.m_21133_(Attributes.f_22285_)));
        }
        if (!source.m_19379_()) {
            int k;
            if (player.m_21023_(MobEffects.f_19606_) && source != DamageSource.f_19317_) {
                int i = (player.m_21124_(MobEffects.f_19606_).m_19564_() + 1) * 5;
                int j = 25 - i;
                float f = amount * (float)j;
                float f1 = amount;
                amount = Math.max(f / 25.0f, 0.0f);
                float f2 = f1 - amount;
            }
            if (!source.m_238340_() && (k = EnchantmentHelper.m_44856_((Iterable)player.m_6168_(), (DamageSource)source)) > 0) {
                amount = CombatRules.m_19269_((float)amount, (float)k);
            }
        }
        if (amount < 0.0f) {
            amount = 0.0f;
        }
        return Math.max(amount - player.m_6103_(), 0.0f);
    }

    protected static QiDamageSource damageSourceToQiDamageSource(DamageSource damage) {
        if (damage instanceof QiDamageSource) {
            return (QiDamageSource)damage;
        }
        return new QiDamageSource(damage);
    }
}

