/*
 * Decompiled with CFR 0.152.
 */
package DaoOfModding.Cultivationcraft.Common.Qi;

import DaoOfModding.Cultivationcraft.Common.Config;
import DaoOfModding.Cultivationcraft.Common.Qi.Elements.Element;
import DaoOfModding.Cultivationcraft.Common.Qi.Elements.Elements;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class QiSource {
    protected BlockPos pos;
    protected int range;
    protected ResourceLocation Element;
    protected double qiMax;
    protected double qiCurrent;
    protected int qiRegen;
    protected double previousCurrent = 0.0;
    protected boolean toUpdate = true;
    public static final int minSpawnTime = 30;
    public static final int maxSpawnTime = 10;
    public int spawnedTick = 0;
    protected HashMap<UUID, Double> currentAbsorbing = new HashMap();
    protected HashMap<UUID, Double> absorbing = new HashMap();

    public QiSource(BlockPos position, int size, ResourceLocation element, double qi, int regen) {
        this(position, size, element, qi, 1.0, regen);
    }

    public QiSource(BlockPos position, int size, ResourceLocation element, double qi, double current, int regen) {
        this.pos = position;
        this.range = size;
        this.Element = element;
        this.qiMax = qi;
        this.qiCurrent = current;
        this.qiRegen = regen;
    }

    public BlockPos getPos() {
        return this.pos;
    }

    public int getSize() {
        return this.range;
    }

    public ResourceLocation getElement() {
        return this.Element;
    }

    public int getQiCurrent() {
        return (int)(this.qiCurrent * (double)this.getQiMax());
    }

    public int getSpawnTick() {
        return (int)((1.0 - this.qiCurrent) * 30.0);
    }

    public int getQiMax() {
        return (int)(this.qiMax * 9.9E7) + 1000000;
    }

    public HashMap<UUID, Double> getAbsorbingPlayers() {
        return this.currentAbsorbing;
    }

    public BlockPos getRandomPos() {
        Vec3 randomPos;
        while ((randomPos = new Vec3(Math.random() * (double)this.getSize() * 2.0 - (double)this.getSize(), Math.random() * (double)this.getSize() * 2.0 - (double)this.getSize(), Math.random() * (double)this.getSize() * 2.0 - (double)this.getSize())).m_82553_() > (double)this.getSize()) {
        }
        return new BlockPos((double)this.pos.m_123341_() + randomPos.f_82479_, (double)this.pos.m_123342_() + randomPos.f_82480_, (double)this.pos.m_123343_() + randomPos.f_82481_);
    }

    public void effectAllBlocks(Level level) {
        Element element = Elements.getElement(this.getElement());
        for (int x = -this.range; x <= this.range; ++x) {
            for (int y = -this.range; y <= this.range; ++y) {
                for (int z = -this.range; z <= this.range; ++z) {
                    Vec3 vec3 = new Vec3((double)x, (double)y, (double)z);
                    if (!(vec3.m_82553_() <= (double)this.range)) continue;
                    element.effectBlock(level, new BlockPos(this.pos.m_123341_() + x, this.pos.m_123342_() + y, this.pos.m_123343_() + z));
                }
            }
        }
    }

    public boolean tick(Level level) {
        Element element = Elements.getElement(this.getElement());
        if (!level.f_46443_ && element.shouldDoBlockEffect() && Config.Server.qiSourceElementalEffectsOn()) {
            element.effectBlock(level, this.getRandomPos());
        }
        boolean update = this.toUpdate;
        this.toUpdate = false;
        this.currentAbsorbing = this.absorbing;
        this.absorbing = new HashMap();
        this.qiCurrent += 1.0 / (double)this.qiRegen;
        if (this.qiCurrent > 1.0) {
            this.qiCurrent = 1.0;
        }
        if (this.previousCurrent != this.qiCurrent) {
            update = true;
        }
        this.previousCurrent = this.qiCurrent;
        return update;
    }

    public double absorbQi(double toAbsorb, Player player) {
        if (toAbsorb > (double)this.getQiCurrent()) {
            toAbsorb = this.getQiCurrent();
        }
        this.subtractQi(toAbsorb);
        if (toAbsorb > 0.0) {
            this.absorbing.put(player.m_20148_(), toAbsorb);
            this.toUpdate = true;
        }
        return toAbsorb;
    }

    public void subtractQi(double toSubtract) {
        this.qiCurrent -= toSubtract / (double)this.getQiMax();
        if (this.qiCurrent < 0.0) {
            this.qiCurrent = 0.0;
        }
    }

    public CompoundTag SerializeNBT() {
        CompoundTag nbt = new CompoundTag();
        nbt.m_128356_("pos", this.pos.m_121878_());
        nbt.m_128405_("range", this.range);
        nbt.m_128359_("element", this.Element.toString());
        nbt.m_128347_("qimax", this.qiMax);
        nbt.m_128347_("qicurrent", this.qiCurrent);
        nbt.m_128347_("qiregen", (double)this.qiRegen);
        int i = 0;
        for (Map.Entry<UUID, Double> player : this.currentAbsorbing.entrySet()) {
            nbt.m_128362_("player" + i, player.getKey());
            nbt.m_128347_("amount" + i, player.getValue().doubleValue());
            ++i;
        }
        return nbt;
    }

    public void WriteBuffer(FriendlyByteBuf buffer) {
        buffer.m_130079_(this.SerializeNBT());
    }

    public static QiSource DeserializeNBT(CompoundTag nbt) {
        BlockPos newPos = BlockPos.m_122022_((long)nbt.m_128454_("pos"));
        int size = nbt.m_128451_("range");
        ResourceLocation element = new ResourceLocation(nbt.m_128461_("element"));
        double qiMax = nbt.m_128459_("qimax");
        double qiCurrent = nbt.m_128459_("qicurrent");
        int qiRegen = nbt.m_128451_("qiregen");
        HashMap<UUID, Double> absorbing = new HashMap<UUID, Double>();
        int i = 0;
        while (nbt.m_128403_("player" + i)) {
            absorbing.put(nbt.m_128342_("player" + i), nbt.m_128459_("amount" + i));
            ++i;
        }
        QiSource newSource = new QiSource(newPos, size, element, qiMax, qiCurrent, qiRegen);
        newSource.currentAbsorbing = absorbing;
        return newSource;
    }

    public static QiSource ReadBuffer(FriendlyByteBuf buffer) {
        return QiSource.DeserializeNBT(buffer.m_130260_());
    }

    public static int getDefaultQi() {
        return 10;
    }
}

