/*
 * Decompiled with CFR 0.152.
 */
package DaoOfModding.Cultivationcraft.Common.Qi.Stats;

import DaoOfModding.Cultivationcraft.Common.Capabilities.BodyModifications.BodyModifications;
import DaoOfModding.Cultivationcraft.Common.Capabilities.CultivatorTechniques.CultivatorTechniques;
import DaoOfModding.Cultivationcraft.Common.Capabilities.CultivatorTechniques.ICultivatorTechniques;
import DaoOfModding.Cultivationcraft.Common.Qi.BodyParts.BodyPart;
import DaoOfModding.Cultivationcraft.Common.Qi.BodyParts.BodyPartOption;
import DaoOfModding.Cultivationcraft.Common.Qi.BodyParts.PlayerHealthManager;
import DaoOfModding.Cultivationcraft.Common.Qi.Elements.Elements;
import DaoOfModding.Cultivationcraft.Common.Qi.Stats.BodyPartQiCostController;
import DaoOfModding.Cultivationcraft.Common.Qi.Stats.BodyPartStatControl;
import DaoOfModding.Cultivationcraft.Common.Qi.Stats.PlayerStatModifications;
import DaoOfModding.Cultivationcraft.Common.Qi.Stats.StatIDs;
import DaoOfModding.Cultivationcraft.Common.Qi.Techniques.PassiveTechniques.PassiveTechnique;
import DaoOfModding.Cultivationcraft.Common.Qi.Techniques.Technique;
import java.util.HashMap;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.ForgeMod;

public class PlayerStatControl {
    PlayerStatModifications stats = new PlayerStatModifications();
    AttributeModifier healthModifier;
    AttributeModifier movementModifier;
    AttributeModifier armorModifier;
    AttributeModifier armorToughnessModifier;
    AttributeModifier swimModifier;
    AttributeModifier attackModifier;
    AttributeModifier rangeModifier;
    AttributeModifier stepHeightModifier;

    public PlayerStatControl() {
        this.setupStats(this.stats);
    }

    public void setupStats(PlayerStatModifications newStats) {
        newStats.setStat(StatIDs.weight, 1.0f);
        newStats.setStat(StatIDs.maxHP, 20.0f);
        newStats.setStat(StatIDs.maxStamina, 20.0f);
        newStats.setStat(StatIDs.lungCapacity, 300.0f);
        newStats.setStat(StatIDs.qiAbsorbRange, 1.0f);
        newStats.setStat(StatIDs.staminaUse, 1.0f);
        newStats.setStat(StatIDs.healthRegen, 0.1f);
        newStats.setStat(StatIDs.healthStaminaConversion, 1.0f);
        newStats.setStat(StatIDs.movementSpeed, 0.1f);
        newStats.setStat(StatIDs.swimSpeed, 1.0f);
        newStats.setStat(StatIDs.attackRange, 4.5f);
        newStats.setStat(StatIDs.jumpHeight, 1.0f);
        newStats.setStat(StatIDs.fallHeight, 1.5f);
        newStats.setStat(StatIDs.legSupport, 1.5f);
        newStats.setStat(StatIDs.armAttackModifier, 1.0f);
        newStats.setStat(StatIDs.attackRange, 4.5f);
        newStats.setElementalStat(StatIDs.resistanceModifier, Elements.lightningElement, -100.0f);
    }

    public PlayerStatModifications getStats() {
        return this.stats;
    }

    /*
     * WARNING - void declaration
     */
    public void updateStats(Player player) {
        void var4_8;
        PlayerStatModifications newStats = new PlayerStatModifications();
        this.setupStats(newStats);
        newStats.setStat(StatIDs.qiAbsorb, BodyPartQiCostController.calculateQiAbsorb(player));
        newStats.setStat(StatIDs.qiCost, BodyPartQiCostController.calculateQiCost(player));
        for (BodyPart bodyPart : BodyModifications.getBodyModifications(player).getModifications().values()) {
            if (player.f_19853_.m_5776_()) {
                bodyPart.onLoad(player.m_20148_());
            }
            newStats.combine(bodyPart.getStatChanges());
        }
        for (HashMap hashMap : BodyModifications.getBodyModifications(player).getModificationOptions().values()) {
            for (BodyPartOption part : hashMap.values()) {
                if (player.f_19853_.m_5776_()) {
                    part.onLoad(player.m_20148_());
                }
                newStats.combine(part.getStatChanges());
            }
        }
        ICultivatorTechniques techs = CultivatorTechniques.getCultivatorTechniques(player);
        boolean bl = false;
        while (var4_8 < 9) {
            Technique tech = techs.getTechnique((int)var4_8);
            if (tech != null && tech.isActive() && tech.getStats() != null) {
                newStats.combine(tech.getStats());
            }
            ++var4_8;
        }
        for (PassiveTechnique passive : techs.getPassives()) {
            newStats.combine(passive.getStats());
        }
        this.calculateVariantResistances(player, newStats);
        this.calculateSizeStatChanges(newStats);
        BodyPartStatControl.applyCaps(player, newStats);
        this.stats = newStats;
        if (!player.f_19853_.f_46443_) {
            this.applyStats(player);
        }
        PlayerHealthManager.updateFoodStats(player);
        PlayerHealthManager.updateLungs(player);
    }

    protected void calculateSizeStatChanges(PlayerStatModifications newStats) {
        if (newStats.getStats().get(StatIDs.size) == null) {
            return;
        }
        PlayerStatModifications sizeChanges = new PlayerStatModifications();
        float sizeAdjustment = this.getSizeAdjustment(newStats);
        sizeChanges.setStat(StatIDs.attackRange, sizeAdjustment * 4.5f);
        if (sizeAdjustment > 0.0f) {
            sizeChanges.setStat(StatIDs.stepHeight, sizeAdjustment * 0.5f);
        }
        newStats.combine(sizeChanges);
    }

    public float getSizeAdjustment() {
        return this.getSizeAdjustment(this.stats);
    }

    public float getSizeAdjustment(PlayerStatModifications newStats) {
        if (!newStats.getStats().containsKey(StatIDs.size)) {
            return 0.0f;
        }
        return newStats.getStats().get(StatIDs.size).floatValue();
    }

    protected void calculateVariantResistances(Player player, PlayerStatModifications newStats) {
        PlayerStatModifications resistances = new PlayerStatModifications();
        for (ResourceLocation element : Elements.getElements()) {
            float resist = Elements.getElement(element).resistanceModifier(player);
            resistances.setElementalStat(StatIDs.resistanceModifier, element, resist);
        }
        newStats.combine(resistances);
    }

    protected void applyStats(Player player) {
        if (this.healthModifier != null) {
            player.m_21051_(Attributes.f_22276_).m_22130_(this.healthModifier);
        }
        if (this.movementModifier != null) {
            player.m_21051_(Attributes.f_22279_).m_22130_(this.movementModifier);
        }
        if (this.armorModifier != null) {
            player.m_21051_(Attributes.f_22284_).m_22130_(this.armorModifier);
        }
        if (this.armorToughnessModifier != null) {
            player.m_21051_(Attributes.f_22285_).m_22130_(this.armorToughnessModifier);
        }
        if (this.swimModifier != null) {
            player.m_21051_((Attribute)ForgeMod.SWIM_SPEED.get()).m_22130_(this.swimModifier);
        }
        if (this.rangeModifier != null) {
            player.m_21051_((Attribute)ForgeMod.REACH_DISTANCE.get()).m_22130_(this.rangeModifier);
        }
        if (this.attackModifier != null) {
            player.m_21051_(Attributes.f_22281_).m_22130_(this.attackModifier);
        }
        if (this.stepHeightModifier != null) {
            player.m_21051_((Attribute)ForgeMod.STEP_HEIGHT_ADDITION.get()).m_22130_(this.stepHeightModifier);
        }
        this.healthModifier = new AttributeModifier("BodyForgeHealth", (double)(this.stats.getStat(StatIDs.maxHP) - 20.0f), AttributeModifier.Operation.ADDITION);
        this.movementModifier = new AttributeModifier("BodyForgeMove", (double)(this.stats.getStat(StatIDs.movementSpeed) * this.getLegWeightModifier() - 0.1f), AttributeModifier.Operation.ADDITION);
        this.armorModifier = new AttributeModifier("BodyForgeArmor", (double)this.stats.getStat(StatIDs.armor), AttributeModifier.Operation.ADDITION);
        this.armorToughnessModifier = new AttributeModifier("BodyForgeArmorToughness", (double)this.stats.getStat(StatIDs.armorToughness), AttributeModifier.Operation.ADDITION);
        this.swimModifier = new AttributeModifier("BodyForgeSwimSpeed", (double)(this.stats.getStat(StatIDs.swimSpeed) - 1.0f), AttributeModifier.Operation.ADDITION);
        this.rangeModifier = new AttributeModifier("BodyForgeReach", (double)(this.stats.getStat(StatIDs.attackRange) - 4.5f), AttributeModifier.Operation.ADDITION);
        this.attackModifier = new AttributeModifier("BodyForgeAttack", (double)(this.stats.getStat(StatIDs.armAttackModifier) - 1.0f), AttributeModifier.Operation.MULTIPLY_TOTAL);
        this.stepHeightModifier = new AttributeModifier("BodyForgeStepHeight", (double)this.stats.getStat(StatIDs.stepHeight), AttributeModifier.Operation.ADDITION);
        player.m_21051_(Attributes.f_22276_).m_22118_(this.healthModifier);
        player.m_21051_(Attributes.f_22279_).m_22118_(this.movementModifier);
        player.m_21051_(Attributes.f_22284_).m_22118_(this.armorModifier);
        player.m_21051_(Attributes.f_22285_).m_22118_(this.armorToughnessModifier);
        player.m_21051_((Attribute)ForgeMod.SWIM_SPEED.get()).m_22118_(this.swimModifier);
        player.m_21051_((Attribute)ForgeMod.REACH_DISTANCE.get()).m_22118_(this.rangeModifier);
        player.m_21051_(Attributes.f_22281_).m_22118_(this.attackModifier);
        player.m_21051_((Attribute)ForgeMod.STEP_HEIGHT_ADDITION.get()).m_22118_(this.stepHeightModifier);
    }

    public float getFlightWeightModifier() {
        float weight;
        float support = this.stats.getStat(StatIDs.wingSupport);
        if (support >= (weight = this.stats.getStat(StatIDs.weight))) {
            return 1.0f;
        }
        return Math.max(0.1f, 2.0f - weight / support);
    }

    public float getLegWeightModifier() {
        float weight;
        float support = this.stats.getStat(StatIDs.legSupport);
        if (support >= (weight = this.stats.getStat(StatIDs.weight))) {
            return 1.0f;
        }
        return Math.max(0.1f, 2.0f - weight / support);
    }
}

