/*
 * Decompiled with CFR 0.152.
 */
package DaoOfModding.Cultivationcraft.Common.Qi.Stats;

import DaoOfModding.Cultivationcraft.Common.Qi.Elements.Elements;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;

public class PlayerStatModifications {
    protected HashMap<ResourceLocation, Float> stats = new HashMap();
    protected HashMap<ResourceLocation, HashMap<ResourceLocation, Float>> elementalStats = new HashMap();

    public float getStat(ResourceLocation ID) {
        float value = 0.0f;
        if (this.stats.containsKey(ID)) {
            value = this.stats.get(ID).floatValue();
        }
        return value;
    }

    public float getElementalStat(ResourceLocation ID, ResourceLocation element) {
        float value = 0.0f;
        if (this.elementalStats.containsKey(ID) && this.elementalStats.get(ID).containsKey(element)) {
            value = this.elementalStats.get(ID).get(element).floatValue();
        }
        return value;
    }

    public void setStat(ResourceLocation ID, float value) {
        this.stats.put(ID, Float.valueOf(value));
    }

    public void setElementalStat(ResourceLocation ID, ResourceLocation element, float value) {
        if (!this.elementalStats.containsKey(ID)) {
            this.elementalStats.put(ID, new HashMap());
        }
        this.elementalStats.get(ID).put(element, Float.valueOf(value));
    }

    public HashMap<ResourceLocation, Float> getStats() {
        return this.stats;
    }

    public HashMap<ResourceLocation, HashMap<ResourceLocation, Float>> getElementalStats() {
        return this.elementalStats;
    }

    public void combine(PlayerStatModifications newStats) {
        for (Map.Entry<ResourceLocation, Float> stat : newStats.getStats().entrySet()) {
            this.setStat(stat.getKey(), stat.getValue().floatValue() + this.getStat(stat.getKey()));
        }
        for (ResourceLocation eStats : newStats.getElementalStats().keySet()) {
            for (Map.Entry<ResourceLocation, Float> eStat : newStats.getElementalStats().get(eStats).entrySet()) {
                this.setElementalStat(eStats, eStat.getKey(), eStat.getValue().floatValue() + this.getElementalStat(eStats, eStat.getKey()));
            }
        }
    }

    public String toString() {
        Object statString = "";
        for (Map.Entry<ResourceLocation, Float> stat : this.stats.entrySet()) {
            statString = (String)statString + "\n" + Component.m_237115_((String)stat.getKey().m_135815_()).getString() + ": ";
            if (stat.getValue().floatValue() % 1.0f == 0.0f) {
                statString = (String)statString + stat.getValue().intValue();
                continue;
            }
            statString = (String)statString + stat.getValue();
        }
        for (ResourceLocation eStats : this.getElementalStats().keySet()) {
            for (Map.Entry<ResourceLocation, Float> eStat : this.getElementalStats().get(eStats).entrySet()) {
                statString = (String)statString + "\n" + Elements.getElement(eStat.getKey()).getName() + " " + Component.m_237115_((String)eStats.m_135815_()).getString() + ": ";
                if (eStat.getValue().floatValue() % 1.0f == 0.0f) {
                    statString = (String)statString + eStat.getValue().intValue();
                    continue;
                }
                statString = (String)statString + eStat.getValue();
            }
        }
        return statString;
    }
}

