/*
 * Decompiled with CFR 0.152.
 */
package DaoOfModding.Cultivationcraft.Common.Qi.Techniques;

import DaoOfModding.Cultivationcraft.Client.CultivatorAttackLogicClient;
import DaoOfModding.Cultivationcraft.Common.Qi.Techniques.Technique;
import DaoOfModding.Cultivationcraft.Common.Qi.Techniques.TechniqueStats.DefaultTechniqueStatIDs;
import DaoOfModding.Cultivationcraft.Network.ClientPacketHandler;
import DaoOfModding.Cultivationcraft.Server.CultivatorAttackLogic;
import DaoOfModding.mlmanimator.Client.Poses.PlayerPose;
import DaoOfModding.mlmanimator.Client.Poses.PoseHandler;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.player.AttackEntityEvent;

public class AttackTechnique
extends Technique {
    protected SoundEvent attackSound = SoundEvents.f_12316_;
    protected SoundEvent missSound = SoundEvents.f_12318_;
    protected PlayerPose attack = new PlayerPose();
    protected int minePower = 0;

    public AttackTechnique() {
        this.addTechniqueStat(DefaultTechniqueStatIDs.range, 5.0);
        this.addTechniqueStat(DefaultTechniqueStatIDs.damage, 1.0);
    }

    public void attack(Player player, int slot) {
        HitResult.Type result = HitResult.Type.MISS;
        UUID attackUUID = null;
        Entity attackEntity = CultivatorAttackLogicClient.tryAttackEntity(this.getRange(player));
        Vec3 location = new Vec3(0.0, 0.0, 0.0);
        Direction direction = null;
        if (attackEntity != null) {
            attackUUID = attackEntity.m_20148_();
            location = attackEntity.m_20182_();
            result = HitResult.Type.ENTITY;
        } else {
            BlockHitResult blockpos = CultivatorAttackLogicClient.tryAttackBlock(this.getRange(player));
            if (blockpos != null) {
                location = new Vec3((double)blockpos.m_82425_().m_123341_(), (double)blockpos.m_82425_().m_123342_(), (double)blockpos.m_82425_().m_123343_());
                result = HitResult.Type.BLOCK;
                direction = blockpos.m_82434_();
            }
        }
        this.attackAnimation(player, attackEntity);
        ClientPacketHandler.sendAttackToServer(player.m_20148_(), result, location, attackUUID, direction, slot);
    }

    public void attackAnimation(Player player, Entity attackTarget) {
        PoseHandler.addPose((UUID)player.m_20148_(), (PlayerPose)this.attack);
    }

    public double getRange(Player player) {
        return this.getTechniqueStat(DefaultTechniqueStatIDs.range, player);
    }

    public float getAttack(Player player) {
        return (float)this.getTechniqueStat(DefaultTechniqueStatIDs.damage, player);
    }

    protected float getMinePower(BlockGetter p_60801_, BlockPos p_60802_) {
        return this.minePower;
    }

    public void attackNothing(Player player) {
        player.f_19853_.m_6263_((Player)null, player.m_20185_(), player.m_20186_(), player.m_20189_(), this.missSound, player.m_5720_(), 1.0f, 1.0f);
    }

    public void attackBlock(Player player, BlockState block, BlockPos pos, Direction direction) {
        player.f_19853_.m_6263_((Player)null, player.m_20185_(), player.m_20186_(), player.m_20189_(), this.attackSound, player.m_5720_(), 1.0f, 1.0f);
    }

    public void attackEntity(Player player, Entity toAttack) {
        if (this.getAttack(player) == 0.0f) {
            return;
        }
        if (!CultivatorAttackLogic.attackEntity(player, toAttack, this.getRange(player), this.getAttack(player), this.attackSound, this.getElement(), this.langLocation)) {
            return;
        }
        if (toAttack instanceof LivingEntity && !((LivingEntity)toAttack).m_6084_()) {
            this.onKill(player, (LivingEntity)toAttack);
        }
    }

    protected void onKill(Player player, LivingEntity entity) {
    }

    public void onPlayerAttack(AttackEntityEvent event) {
    }

    public boolean cancelAttack(LivingAttackEvent event) {
        return false;
    }
}

