/*
 * Decompiled with CFR 0.152.
 */
package DaoOfModding.Cultivationcraft.Common.Qi.Techniques.BodyForgeTechniques;

import DaoOfModding.Cultivationcraft.Common.Capabilities.BodyModifications.BodyModifications;
import DaoOfModding.Cultivationcraft.Common.Capabilities.CultivatorStats.CultivatorStats;
import DaoOfModding.Cultivationcraft.Common.Capabilities.CultivatorStats.ICultivatorStats;
import DaoOfModding.Cultivationcraft.Common.Qi.BodyParts.Lungs.Breath.Breath;
import DaoOfModding.Cultivationcraft.Common.Qi.BodyParts.PlayerHealthManager;
import DaoOfModding.Cultivationcraft.Common.Qi.Elements.Elements;
import DaoOfModding.Cultivationcraft.Common.Qi.Techniques.ChanneledAttackTechnique;
import DaoOfModding.Cultivationcraft.Common.Qi.Techniques.Technique;
import DaoOfModding.Cultivationcraft.Common.Qi.Techniques.TechniqueStats.DefaultTechniqueStatIDs;
import DaoOfModding.mlmanimator.Client.Poses.PlayerPoseHandler;
import DaoOfModding.mlmanimator.Client.Poses.PoseHandler;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.TickEvent;

public class BeamTechnique
extends ChanneledAttackTechnique {
    Breath breath;

    public BeamTechnique() {
        this.type = Technique.useType.Channel;
        this.multiple = false;
        this.langLocation = "cultivationcraft.technique.beam";
        this.Element = Elements.noElement;
        this.icon = new ResourceLocation("cultivationcraft", "textures/techniques/icons/beam.png");
        this.addTechniqueStat(DefaultTechniqueStatIDs.range, 10.0);
        this.addTechniqueStat(DefaultTechniqueStatIDs.breathCost, 1.0);
    }

    @Override
    public boolean isValid(Player player) {
        ICultivatorStats stats = CultivatorStats.getCultivatorStats(player);
        if (stats.getCultivationType() == 1 && BodyModifications.getBodyModifications(player).hasOption("BODY", "LUNG", "highpressureLung")) {
            this.breath = PlayerHealthManager.getLungs(player).getConnection(0).getLung().getBreath();
            return this.breath.canExpell();
        }
        return false;
    }

    @Override
    public void attackEntity(Player player, Entity toAttack) {
        if (this.breath.tryAttack(player, toAttack)) {
            super.attackEntity(player, toAttack);
        }
    }

    @Override
    public void tickClient(TickEvent.PlayerTickEvent event) {
        if (!PlayerHealthManager.getLungs(event.player).drainBreath(this.breath, (float)this.getTechniqueStat(DefaultTechniqueStatIDs.breathCost, event.player))) {
            return;
        }
        super.tickClient(event);
        this.spawnParticles(event.player);
    }

    @Override
    public void tickServer(TickEvent.PlayerTickEvent event) {
        if (!PlayerHealthManager.getLungs(event.player).drainBreath(this.breath, (float)this.getTechniqueStat(DefaultTechniqueStatIDs.breathCost, event.player))) {
            return;
        }
        this.breath.tick(event.player);
        super.tickServer(event);
    }

    @Override
    protected float getMinePower(BlockGetter p_60801_, BlockPos p_60802_) {
        return this.breath.getDigPower(p_60801_, p_60802_);
    }

    public void spawnParticles(Player player) {
        PlayerPoseHandler handler = PoseHandler.getPlayerPoseHandler((UUID)player.m_20148_());
        Vec3 look = player.m_20154_();
        for (int i = 0; i < 10; ++i) {
            Vec3 random = new Vec3(Math.random() - 0.5, Math.random() - 0.5, Math.random() - 0.5);
            Vec3 endTarget = this.target == null ? random.m_82520_((double)((int)(look.f_82479_ * 10.0)), (double)((int)(look.f_82480_ * 10.0)), (double)((int)(look.f_82481_ * 10.0))) : random.m_82520_((double)this.target.m_123341_(), (double)this.target.m_123342_(), (double)this.target.m_123343_());
            ParticleOptions particle = this.breath.getParticle(endTarget, this.targetEntity);
            if (particle == null) {
                return;
            }
            Minecraft.m_91087_().f_91073_.m_7106_(particle, player.m_20185_() + random.f_82479_ + look.f_82479_, player.m_20186_() - (double)handler.getPlayerModel().getEyeHeight() + random.f_82480_ + look.f_82480_, player.m_20189_() + random.f_82481_ + look.f_82481_, look.f_82479_ * 2.0, look.f_82480_ * 2.0, look.f_82481_ * 2.0);
        }
    }

    @Override
    protected void mine(Player player, BlockPos pos, Direction direction) {
        if (pos == null) {
            return;
        }
        if (this.breath.canBeMined(player, pos, direction, this)) {
            super.mine(player, pos, direction);
        }
    }

    @Override
    public void attackBlock(Player player, BlockState block, BlockPos pos, Direction direction) {
        if (this.breath.doBlockAttack(player, pos, direction)) {
            player.f_19853_.m_46961_(pos, true);
            this.breath.onBlockDestroy(player.f_19853_, pos);
        }
    }

    @Override
    public float getAttack(Player player) {
        this.addTechniqueStat(DefaultTechniqueStatIDs.damage, this.breath.getDamage());
        return this.breath.getDamage();
    }
}

