/*
 * Decompiled with CFR 0.152.
 */
package DaoOfModding.Cultivationcraft.Common.Qi.Techniques.BodyForgeTechniques;

import DaoOfModding.Cultivationcraft.Common.Capabilities.BodyModifications.BodyModifications;
import DaoOfModding.Cultivationcraft.Common.Capabilities.CultivatorStats.CultivatorStats;
import DaoOfModding.Cultivationcraft.Common.Qi.BodyParts.FoodStats.QiFoodStats;
import DaoOfModding.Cultivationcraft.Common.Qi.Stats.BodyPartStatControl;
import DaoOfModding.Cultivationcraft.Common.Qi.Stats.PlayerStatModifications;
import DaoOfModding.Cultivationcraft.Common.Qi.Stats.StatIDs;
import DaoOfModding.Cultivationcraft.Common.Qi.Techniques.AttackOverrideTechnique;
import DaoOfModding.Cultivationcraft.Common.Qi.Techniques.TechniqueStats.DefaultTechniqueStatIDs;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.TickEvent;

public class BiteTechnique
extends AttackOverrideTechnique {
    public static final ResourceLocation biteQuest = new ResourceLocation("cultivationcraft", "cultivationcraft.quest.bite");

    public BiteTechnique() {
        this.langLocation = "cultivationcraft.technique.bite";
        this.Element = null;
        this.icon = new ResourceLocation("cultivationcraft", "textures/techniques/icons/bite.png");
        this.attackSound = SoundEvents.f_11945_;
        this.missSound = SoundEvents.f_11945_;
        this.addTechniqueStat(DefaultTechniqueStatIDs.staminaCost, 0.05);
        this.addTechniqueStat(DefaultTechniqueStatIDs.damage, 8.0);
        this.addTechniqueStat(DefaultTechniqueStatIDs.range, 3.5);
        this.pose.addAngle("JAW_LOWER_MODEL", new Vec3(Math.toRadians(40.0), 0.0, 0.0), 9, Float.valueOf(5.0f), -1);
        this.attack.addAngle("JAW_LOWER_MODEL", new Vec3(Math.toRadians(20.0), 0.0, 0.0), 10, Float.valueOf(0.0f), -1);
        this.pose.addAngle("FP_JAW_MODEL", new Vec3(Math.toRadians(-40.0), 0.0, 0.0), 9, Float.valueOf(5.0f), -1);
        this.pose.addAngle("FP_JAW_LOWER_MODEL", new Vec3(Math.toRadians(60.0), 0.0, 0.0), 9, Float.valueOf(5.0f), -1);
        this.attack.addAngle("FP_JAW_MODEL", new Vec3(Math.toRadians(-10.0), 0.0, 0.0), 10, Float.valueOf(0.0f), -1);
        this.attack.addAngle("FP_JAW_LOWER_MODEL", new Vec3(Math.toRadians(30.0), 0.0, 0.0), 10, Float.valueOf(0.0f), -1);
    }

    @Override
    public boolean isValid(Player player) {
        return CultivatorStats.getCultivatorStats(player).getCultivationType() == 1 && (BodyModifications.getBodyModifications(player).hasOption("HEAD", "MOUTH", "flatteeth") || BodyModifications.getBodyModifications(player).hasOption("HEAD", "MOUTH", "sharpteeth"));
    }

    @Override
    public double getRange(Player player) {
        return this.getTechniqueStat(DefaultTechniqueStatIDs.range, player) * (double)(1.0f + BodyPartStatControl.getPlayerStatControl(player).getSizeAdjustment());
    }

    @Override
    public void tickServer(TickEvent.PlayerTickEvent event) {
        if (this.Element == null) {
            this.Element = BodyModifications.getBodyModifications(event.player).getOption("BODY", "BONE").getElement();
        }
        super.tickServer(event);
    }

    @Override
    public void tickClient(TickEvent.PlayerTickEvent event) {
        if (this.Element == null) {
            this.Element = BodyModifications.getBodyModifications(event.player).getOption("BODY", "BONE").getElement();
        }
        super.tickClient(event);
    }

    @Override
    public float getAttack(Player player) {
        PlayerStatModifications stats = BodyPartStatControl.getPlayerStatControl(player).getStats();
        return (float)this.getTechniqueStat(DefaultTechniqueStatIDs.damage, player) * stats.getStat(StatIDs.boneAttackModifier) * stats.getStat(StatIDs.biteAttackModifier);
    }

    @Override
    public void attackBlock(Player player, BlockState block, BlockPos pos, Direction direction) {
        int nutrition = ((QiFoodStats)player.m_36324_()).getNutrition(block);
        if (nutrition > 0 && BodyModifications.getBodyModifications(player).hasOption("HEAD", "MOUTH", "flatteeth")) {
            player.f_19853_.m_6263_((Player)null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_11912_, player.m_5720_(), 1.0f, 1.0f);
            if (block.m_60767_() == Material.f_76315_) {
                player.f_19853_.m_46796_(2001, pos, Block.m_49956_((BlockState)block));
                player.f_19853_.m_7731_(pos, Blocks.f_50493_.m_49966_(), 2);
            } else {
                player.f_19853_.m_46961_(pos, false);
            }
            player.m_36324_().m_38707_(nutrition, 0.8f);
        } else {
            super.attackBlock(player, block, pos, direction);
        }
    }

    @Override
    protected void onKill(Player player, LivingEntity entity) {
        super.onKill(player, entity);
        if (BodyModifications.getBodyModifications(player).hasOption("HEAD", "MOUTH", "sharpteeth") && ((QiFoodStats)player.m_36324_()).canEatMeat()) {
            float nutrition = entity.m_21233_() / 2.0f;
            player.m_36324_().m_38707_((int)nutrition, nutrition);
            entity.m_6842_(true);
            ((ServerLevel)player.f_19853_).m_8767_((ParticleOptions)ParticleTypes.f_123762_, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), 20, 1.0, 1.0, 1.0, 1.0);
            player.f_19853_.m_6263_((Player)null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_11912_, player.m_5720_(), 1.0f, 1.0f);
        }
    }
}

