/*
 * Decompiled with CFR 0.152.
 */
package DaoOfModding.Cultivationcraft.Common.Qi.Techniques.BodyForgeTechniques;

import DaoOfModding.Cultivationcraft.Client.Physics;
import DaoOfModding.Cultivationcraft.Client.genericClientFunctions;
import DaoOfModding.Cultivationcraft.Common.Capabilities.BodyModifications.BodyModifications;
import DaoOfModding.Cultivationcraft.Common.Capabilities.CultivatorStats.CultivatorStats;
import DaoOfModding.Cultivationcraft.Common.Qi.BodyParts.Quests.QuestHandler;
import DaoOfModding.Cultivationcraft.Common.Qi.Elements.Elements;
import DaoOfModding.Cultivationcraft.Common.Qi.Stats.BodyPartStatControl;
import DaoOfModding.Cultivationcraft.Common.Qi.Techniques.Technique;
import DaoOfModding.Cultivationcraft.Common.Qi.Techniques.TechniqueStats.DefaultTechniqueStatIDs;
import DaoOfModding.Cultivationcraft.Common.Reflection;
import DaoOfModding.Cultivationcraft.Cultivationcraft;
import DaoOfModding.Cultivationcraft.StaminaHandler;
import DaoOfModding.mlmanimator.Client.Poses.PlayerPose;
import DaoOfModding.mlmanimator.Client.Poses.PoseHandler;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.TickEvent;

public class DartTechnique
extends Technique {
    protected PlayerPose flap = new PlayerPose();
    protected float doubledCooldown;
    protected boolean firstDash = false;

    public DartTechnique() {
        this.elytraDisables = true;
        this.langLocation = "cultivationcraft.technique.dart";
        this.Element = Elements.noElement;
        this.type = Technique.useType.Toggle;
        this.multiple = false;
        this.cooldown = 20;
        this.addTechniqueStat(DefaultTechniqueStatIDs.staminaCost, 0.2);
        this.icon = new ResourceLocation("cultivationcraft", "textures/techniques/icons/dart.png");
        this.flap.addAngle("LEFT_INSECT_WING", new Vec3(0.0, Math.toRadians(0.0), Math.toRadians(-60.0)), 5, Float.valueOf(3.0f), -1);
        this.flap.addAngle("RIGHT_INSECT_WING", new Vec3(0.0, Math.toRadians(0.0), Math.toRadians(60.0)), 5, Float.valueOf(3.0f), -1);
        this.flap.addAngle("LEFT_INSECT_WING", new Vec3(0.0, Math.toRadians(0.0), Math.toRadians(-10.0)), 5, Float.valueOf(3.0f), -1);
        this.flap.addAngle("RIGHT_INSECT_WING", new Vec3(0.0, Math.toRadians(0.0), Math.toRadians(10.0)), 5, Float.valueOf(3.0f), -1);
        this.flap.addAngle("Left_Arm", new Vec3(0.0, 0.0, 0.0), 151);
        this.flap.addAngle("Right_Arm", new Vec3(0.0, 0.0, 0.0), 151);
    }

    @Override
    public boolean isValid(Player player) {
        return CultivatorStats.getCultivatorStats(player).getCultivationType() == 1 && BodyModifications.getBodyModifications(player).hasOption("BODY", "BACK", "iwing");
    }

    @Override
    public void tickClient(TickEvent.PlayerTickEvent event) {
        super.tickClient(event);
        this.tickInactiveClient(event);
        if (this.doubledCooldown > 0.0f) {
            this.doubledCooldown -= 1.0f;
        }
        if (this.doubledCooldown == 0.0f) {
            return;
        }
        if (event.player.m_20096_() || event.player.m_20069_()) {
            return;
        }
        PlayerPose flapping = this.flap.clone();
        event.player.f_19789_ = 0.0f;
        double yLook = 1.0 - event.player.m_20154_().f_82480_;
        flapping.addAngle("Body", new Vec3(Math.toRadians(75.0 * yLook), 0.0, 0.0), 10, Float.valueOf(5.0f), -1);
        PoseHandler.addPose((UUID)event.player.m_20148_(), (PlayerPose)flapping);
        if (this.firstDash) {
            this.firstDash = false;
            return;
        }
        float weightModifier = BodyPartStatControl.getPlayerStatControl(event.player).getFlightWeightModifier();
        float slowAmount = this.doubledCooldown * weightModifier / (float)(this.cooldown * 2);
        if (slowAmount > 1.0f) {
            slowAmount = 1.0f;
        } else if (slowAmount < 0.0f) {
            slowAmount = 0.0f;
        }
        Vec3 slowedSpeed = Physics.getDelta(event.player).m_82490_((double)(1.0f - slowAmount));
        event.player.m_20334_(slowedSpeed.f_82479_, slowedSpeed.f_82480_, slowedSpeed.f_82481_);
        QuestHandler.progressQuest(event.player, new Vec3(event.player.m_20184_().f_82479_, 0.0, event.player.m_20184_().f_82481_).m_82553_());
    }

    @Override
    public void tickServer(TickEvent.PlayerTickEvent event) {
        Reflection.allowFlight((ServerPlayer)event.player);
        super.tickServer(event);
        this.tickInactiveServer(event);
        event.player.f_19789_ = 0.0f;
    }

    @Override
    public void onInput() {
        if (this.cooldownCount > 0) {
            return;
        }
        if (Minecraft.m_91087_().f_91066_.f_92089_.m_90857_()) {
            this.sendInfo(1);
            this.dart(genericClientFunctions.getPlayer());
        }
    }

    @Override
    public void processInfo(Player player, int info) {
        if (!this.isValid(player)) {
            Cultivationcraft.LOGGER.error("Player " + player.m_20148_() + " tried to dart when this is not a valid technique for them");
            return;
        }
        if (info == 1) {
            this.dart(player);
        }
    }

    public void dart(Player player) {
        if (!StaminaHandler.consumeStamina(player, (float)this.getTechniqueStat(DefaultTechniqueStatIDs.staminaCost, player))) {
            return;
        }
        float weightModifier = BodyPartStatControl.getPlayerStatControl(player).getFlightWeightModifier();
        float speed = 20.0f * weightModifier;
        Vec3 dash = player.m_20154_().m_82541_().m_82490_((double)speed);
        player.m_20334_(dash.f_82479_, dash.f_82480_, dash.f_82481_);
        QuestHandler.progressQuest(player, dash.m_82553_());
        this.cooldownCount = this.cooldown;
        this.doubledCooldown = this.cooldown * 2;
        this.firstDash = true;
    }
}

