/*
 * Decompiled with CFR 0.152.
 */
package DaoOfModding.Cultivationcraft.Common.Qi.Techniques.BodyForgeTechniques;

import DaoOfModding.Cultivationcraft.Client.Physics;
import DaoOfModding.Cultivationcraft.Common.Capabilities.BodyModifications.BodyModifications;
import DaoOfModding.Cultivationcraft.Common.Capabilities.CultivatorStats.CultivatorStats;
import DaoOfModding.Cultivationcraft.Common.Qi.BodyParts.Quests.Quest;
import DaoOfModding.Cultivationcraft.Common.Qi.BodyParts.Quests.QuestHandler;
import DaoOfModding.Cultivationcraft.Common.Qi.Elements.Elements;
import DaoOfModding.Cultivationcraft.Common.Qi.Stats.BodyPartStatControl;
import DaoOfModding.Cultivationcraft.Common.Qi.Techniques.Technique;
import DaoOfModding.Cultivationcraft.Common.Qi.Techniques.TechniqueStats.DefaultTechniqueStatIDs;
import DaoOfModding.Cultivationcraft.Common.Reflection;
import DaoOfModding.Cultivationcraft.StaminaHandler;
import DaoOfModding.mlmanimator.Client.Poses.PlayerPose;
import DaoOfModding.mlmanimator.Client.Poses.PoseHandler;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.TickEvent;

public class FloatTechnique
extends Technique {
    protected boolean jumpPressed = false;
    protected PlayerPose floating = new PlayerPose();

    public FloatTechnique() {
        this.elytraDisables = true;
        this.langLocation = "cultivationcraft.technique.float";
        this.Element = Elements.noElement;
        this.type = Technique.useType.Toggle;
        this.multiple = false;
        this.cooldown = 0;
        this.addTechniqueStat(DefaultTechniqueStatIDs.staminaCost, 0.01);
        this.icon = new ResourceLocation("cultivationcraft", "textures/techniques/icons/float.png");
        this.floating.addSize("Body", new Vec3(3.0, 2.0, 4.0), 9999, 0.1f);
        this.floating.addAngle("Body", new Vec3(0.0, 0.0, Math.toRadians(-15.0)), 152, Float.valueOf(40.0f), -1);
        this.floating.addAngle("Body", new Vec3(0.0, 0.0, Math.toRadians(15.0)), 152, Float.valueOf(40.0f), -1);
        this.floating.addAngle("Left_Arm", new Vec3(Math.toRadians(0.0), 0.0, Math.toRadians(-130.0)), 155, Float.valueOf(5.0f), -1);
        this.floating.addAngle("Left_Arm", new Vec3(Math.toRadians(0.0), 0.0, Math.toRadians(0.0)), 155, Float.valueOf(5.0f), -1);
        this.floating.addAngle("Right_Arm", new Vec3(Math.toRadians(0.0), 0.0, Math.toRadians(130.0)), 155, Float.valueOf(5.0f), -1);
        this.floating.addAngle("Right_Arm", new Vec3(Math.toRadians(0.0), 0.0, Math.toRadians(0.0)), 155, Float.valueOf(5.0f), -1);
    }

    @Override
    public boolean isValid(Player player) {
        return CultivatorStats.getCultivatorStats(player).getCultivationType() == 1 && BodyModifications.getBodyModifications(player).hasOption("BODY", "LUNG", "floatingLung");
    }

    @Override
    public void tickClient(TickEvent.PlayerTickEvent event) {
        super.tickClient(event);
        if (this.jumpPressed) {
            this.canBreathWhileActive = false;
            StaminaHandler.consumeStamina(event.player, (float)this.getTechniqueStat(DefaultTechniqueStatIDs.staminaCost, event.player));
            this.floatUp(event.player);
        } else {
            this.canBreathWhileActive = true;
        }
    }

    @Override
    public void tickServer(TickEvent.PlayerTickEvent event) {
        Reflection.allowFlight((ServerPlayer)event.player);
        if (this.jumpPressed) {
            this.canBreathWhileActive = false;
            StaminaHandler.consumeStamina(event.player, (float)this.getTechniqueStat(DefaultTechniqueStatIDs.staminaCost, event.player));
        } else {
            this.canBreathWhileActive = true;
        }
        super.tickServer(event);
    }

    public void floatUp(Player player) {
        PoseHandler.getPlayerPoseHandler((UUID)player.m_20148_()).addPose(this.floating);
        Vec3 movement = Physics.getDelta(player);
        float floating = 0.1f - 0.15f * BodyPartStatControl.getPlayerStatControl(player).getFlightWeightModifier();
        player.m_20334_(movement.f_82479_, (double)floating, movement.f_82481_);
        QuestHandler.progressQuest(player, Quest.FLIGHT, player.m_20184_().m_82553_());
    }

    @Override
    public void onInput() {
        boolean newJump = Minecraft.m_91087_().f_91066_.f_92089_.m_90857_();
        if (this.jumpPressed != newJump) {
            this.jumpPressed = newJump;
            if (newJump) {
                this.sendInfo(1);
            } else {
                this.sendInfo(2);
            }
        }
    }

    @Override
    public void processInfo(Player player, int info) {
        if (info == 2) {
            this.jumpPressed = false;
        } else if (info == 1) {
            this.jumpPressed = true;
        }
    }
}

