/*
 * Decompiled with CFR 0.152.
 */
package DaoOfModding.Cultivationcraft.Common.Qi.Techniques.BodyForgeTechniques;

import DaoOfModding.Cultivationcraft.Client.genericClientFunctions;
import DaoOfModding.Cultivationcraft.Common.Capabilities.BodyModifications.BodyModifications;
import DaoOfModding.Cultivationcraft.Common.Capabilities.CultivatorStats.CultivatorStats;
import DaoOfModding.Cultivationcraft.Common.PlayerUtils;
import DaoOfModding.Cultivationcraft.Common.Qi.BodyParts.Lungs.Breath.Breath;
import DaoOfModding.Cultivationcraft.Common.Qi.BodyParts.PlayerHealthManager;
import DaoOfModding.Cultivationcraft.Common.Qi.BodyParts.Quests.Quest;
import DaoOfModding.Cultivationcraft.Common.Qi.BodyParts.Quests.QuestHandler;
import DaoOfModding.Cultivationcraft.Common.Qi.Stats.BodyPartStatControl;
import DaoOfModding.Cultivationcraft.Common.Qi.Stats.PlayerStatControl;
import DaoOfModding.Cultivationcraft.Common.Qi.Stats.StatIDs;
import DaoOfModding.Cultivationcraft.Common.Qi.Techniques.MovementOverrideTechnique;
import DaoOfModding.Cultivationcraft.Common.Qi.Techniques.Technique;
import DaoOfModding.Cultivationcraft.Common.Qi.Techniques.TechniqueStats.DefaultTechniqueStatIDs;
import DaoOfModding.Cultivationcraft.Common.Reflection;
import DaoOfModding.mlmanimator.Client.Models.MultiLimbedModel;
import DaoOfModding.mlmanimator.Client.Poses.PoseHandler;
import java.util.UUID;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.LivingFallEvent;

public class JetLegTechnique
extends MovementOverrideTechnique {
    protected boolean jump = false;
    protected boolean enabled = false;
    protected int enabledTicks = 0;

    public JetLegTechnique() {
        this.langLocation = "cultivationcraft.technique.jetlegs";
        this.type = Technique.useType.Toggle;
        this.multiple = false;
        this.momentum = true;
        this.momentumFactor = 0.2f;
        this.icon = new ResourceLocation("cultivationcraft", "textures/techniques/icons/jetlegs.png");
        this.addTechniqueStat(DefaultTechniqueStatIDs.breathCost, 0.025);
    }

    @Override
    public boolean isValid(Player player) {
        return CultivatorStats.getCultivatorStats(player).getCultivationType() == 1 && BodyModifications.getBodyModifications(player).hasModification("LEG", "jetleg");
    }

    protected void calculateJetPower(Player player) {
        PlayerStatControl stats = BodyPartStatControl.getPlayerStatControl(player);
        float weightModifier = stats.getFlightWeightModifier();
        float upwardsPower = stats.getStats().getStat(StatIDs.flightSpeed);
        double y = upwardsPower * weightModifier;
        this.setMomentum(new Vec3(0.0, y, 0.0));
    }

    @Override
    public void tickClient(TickEvent.PlayerTickEvent event) {
        super.tickClient(event);
        if (event.player.m_20069_()) {
            return;
        }
        if (PlayerUtils.isClientPlayerCharacter(event.player)) {
            if (this.jump) {
                this.enableJets(true, event.player);
            } else {
                this.enableJets(false, event.player);
            }
        } else if (this.enabled) {
            this.enableJets(true, event.player);
        } else {
            this.enableJets(false, event.player);
        }
        if (this.enabled) {
            this.calculateJetPower(event.player);
        } else {
            this.setMomentum(new Vec3(0.0, 0.0, 0.0));
        }
        this.jump = false;
        QuestHandler.progressQuest(event.player, Quest.FLIGHT, this.currentSpeed.m_82553_());
    }

    @Override
    public void tickInactiveClient(TickEvent.PlayerTickEvent event) {
        super.tickInactiveClient(event);
        this.setMomentum(new Vec3(0.0, 0.0, 0.0));
        this.jump = false;
        QuestHandler.progressQuest(event.player, Quest.FLIGHT, this.currentSpeed.m_82553_());
    }

    @Override
    public void tickServer(TickEvent.PlayerTickEvent event) {
        Reflection.allowFlight((ServerPlayer)event.player);
        super.tickServer(event);
        this.tickInactiveServer(event);
        if (this.enabled && !PlayerHealthManager.getLungs(event.player).drainBreath(Breath.FIRE, (float)this.getTechniqueStat(DefaultTechniqueStatIDs.breathCost, event.player))) {
            this.enabled = false;
        }
        this.enabledTicks = this.enabled ? ++this.enabledTicks : --this.enabledTicks;
        this.enabledTicks = Math.min(20, Math.max(0, this.enabledTicks));
    }

    @Override
    public void onFall(LivingFallEvent event) {
        if (this.enabledTicks > 10) {
            event.setCanceled(true);
        } else if (this.enabledTicks > 5) {
            float damageMultiplier = 1.0f - (float)(this.enabledTicks - 5) / 5.0f;
            event.setDamageMultiplier(event.getDamageMultiplier() * damageMultiplier);
        }
    }

    protected void enableJets(Boolean on, Player player) {
        MultiLimbedModel model = PoseHandler.getPlayerPoseHandler((UUID)player.m_20148_()).getPlayerModel();
        if (model == null) {
            return;
        }
        if (on.booleanValue()) {
            model.getLimb((String)"JET_LEG_LEFT_EMITTER").getModelPart().f_104207_ = true;
            model.getLimb((String)"JET_LEG_RIGHT_EMITTER").getModelPart().f_104207_ = true;
            PoseHandler.getPlayerPoseHandler((UUID)player.m_20148_()).disableJumpingAnimationThisTick = true;
        } else {
            model.getLimb((String)"JET_LEG_LEFT_EMITTER").getModelPart().f_104207_ = false;
            model.getLimb((String)"JET_LEG_RIGHT_EMITTER").getModelPart().f_104207_ = false;
        }
        if (this.enabled == on) {
            return;
        }
        this.enabled = on;
        if (PlayerUtils.isClientPlayerCharacter(player)) {
            if (this.enabled) {
                this.sendInfo(1);
            } else {
                this.sendInfo(0);
            }
        }
    }

    @Override
    public boolean overwriteJump() {
        Player player = genericClientFunctions.getPlayer();
        if (player.m_20069_()) {
            return false;
        }
        if (!PlayerHealthManager.getLungs(player).drainBreath(Breath.FIRE, (float)this.getTechniqueStat(DefaultTechniqueStatIDs.breathCost, player))) {
            return false;
        }
        this.jump = true;
        return true;
    }

    @Override
    public void deactivate(Player player) {
        if (player.f_19853_.f_46443_) {
            MultiLimbedModel model = PoseHandler.getPlayerPoseHandler((UUID)player.m_20148_()).getPlayerModel();
            model.getLimb((String)"JET_LEG_LEFT_EMITTER").getModelPart().f_104207_ = false;
            model.getLimb((String)"JET_LEG_RIGHT_EMITTER").getModelPart().f_104207_ = false;
        }
        super.deactivate(player);
    }

    @Override
    public void processInfo(Player player, int info) {
        boolean on = false;
        if (info == 1) {
            on = true;
        }
        if (!player.f_19853_.m_5776_()) {
            this.enabled = on;
        } else {
            this.enableJets(on, player);
        }
    }
}

