/*
 * Decompiled with CFR 0.152.
 */
package DaoOfModding.Cultivationcraft.Common.Qi.Techniques.BodyForgeTechniques;

import DaoOfModding.Cultivationcraft.Common.Capabilities.BodyModifications.BodyModifications;
import DaoOfModding.Cultivationcraft.Common.Capabilities.CultivatorStats.CultivatorStats;
import DaoOfModding.Cultivationcraft.Common.PlayerUtils;
import DaoOfModding.Cultivationcraft.Common.Qi.BodyParts.Lungs.Breath.Breath;
import DaoOfModding.Cultivationcraft.Common.Qi.BodyParts.PlayerHealthManager;
import DaoOfModding.Cultivationcraft.Common.Qi.BodyParts.Quests.QuestHandler;
import DaoOfModding.Cultivationcraft.Common.Qi.Stats.PlayerStatModifications;
import DaoOfModding.Cultivationcraft.Common.Qi.Techniques.MovementOverrideTechnique;
import DaoOfModding.Cultivationcraft.Common.Qi.Techniques.Technique;
import DaoOfModding.Cultivationcraft.Common.Qi.Techniques.TechniqueStats.DefaultTechniqueStatIDs;
import DaoOfModding.mlmanimator.Client.Models.MultiLimbedModel;
import DaoOfModding.mlmanimator.Client.Poses.PoseHandler;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.TickEvent;

public class JetTechnique
extends MovementOverrideTechnique {
    public static final ResourceLocation jetQuest = new ResourceLocation("cultivationcraft", "cultivationcraft.quest.jet");
    boolean enabled = false;
    boolean forward = true;

    public JetTechnique() {
        this.langLocation = "cultivationcraft.technique.jet";
        this.type = Technique.useType.Toggle;
        this.multiple = false;
        this.momentum = true;
        this.icon = new ResourceLocation("cultivationcraft", "textures/techniques/icons/jets.png");
        this.addTechniqueStat(DefaultTechniqueStatIDs.breathCost, 0.025);
        this.addTechniqueStat(DefaultTechniqueStatIDs.movementSpeed, 0.1);
    }

    @Override
    public PlayerStatModifications getStats() {
        return this.stats;
    }

    @Override
    public boolean isValid(Player player) {
        return CultivatorStats.getCultivatorStats(player).getCultivationType() == 1 && BodyModifications.getBodyModifications(player).hasOption("BODY", "BACK", "jet");
    }

    @Override
    public boolean overwriteForward() {
        this.forward = true;
        return false;
    }

    @Override
    public void tickClient(TickEvent.PlayerTickEvent event) {
        super.tickClient(event);
        if (!this.forward || event.player.m_20069_() || !PlayerHealthManager.getLungs(event.player).drainBreath(Breath.FIRE, (float)this.getTechniqueStat(DefaultTechniqueStatIDs.breathCost, event.player))) {
            this.forward = false;
            this.setMomentum(new Vec3(0.0, 0.0, 0.0));
        } else {
            Vec3 forward = event.player.m_20156_();
            this.setMomentum(new Vec3(forward.f_82479_, 0.0, forward.f_82481_).m_82541_().m_82490_(this.getTechniqueStat(DefaultTechniqueStatIDs.movementSpeed, event.player)));
        }
        if (event.player.m_20148_().compareTo(Minecraft.m_91087_().f_91074_.m_20148_()) == 0) {
            if (this.forward) {
                this.enableJets(true, event.player);
            } else {
                this.enableJets(false, event.player);
            }
        }
        this.forward = false;
        QuestHandler.progressQuest(event.player, jetQuest, this.currentSpeed.m_82553_());
    }

    @Override
    public void tickServer(TickEvent.PlayerTickEvent event) {
        super.tickServer(event);
        if (this.enabled) {
            PlayerHealthManager.getLungs(event.player).drainBreath(Breath.FIRE, (float)this.getTechniqueStat(DefaultTechniqueStatIDs.breathCost, event.player));
        }
    }

    @Override
    public void tickInactiveClient(TickEvent.PlayerTickEvent event) {
        super.tickInactiveClient(event);
        this.enableJets(false, event.player);
        this.setMomentum(new Vec3(0.0, 0.0, 0.0));
        this.forward = false;
        QuestHandler.progressQuest(event.player, jetQuest, this.currentSpeed.m_82553_());
    }

    @Override
    public void deactivate(Player player) {
        this.forward = false;
        if (player.f_19853_.f_46443_) {
            this.enableJets(false, player);
        }
        super.deactivate(player);
    }

    protected void enableJets(Boolean on, Player player) {
        MultiLimbedModel model = PoseHandler.getPlayerPoseHandler((UUID)player.m_20148_()).getPlayerModel();
        if (model == null) {
            return;
        }
        if (on.booleanValue()) {
            model.getLimb((String)"JET_LEFT_FLAME").getModelPart().f_104207_ = true;
            model.getLimb((String)"JET_RIGHT_FLAME").getModelPart().f_104207_ = true;
            model.getLimb((String)"JET_LEFT_SMOKE").getModelPart().f_104207_ = false;
            model.getLimb((String)"JET_RIGHT_SMOKE").getModelPart().f_104207_ = false;
        } else {
            model.getLimb((String)"JET_LEFT_FLAME").getModelPart().f_104207_ = false;
            model.getLimb((String)"JET_RIGHT_FLAME").getModelPart().f_104207_ = false;
            model.getLimb((String)"JET_LEFT_SMOKE").getModelPart().f_104207_ = true;
            model.getLimb((String)"JET_RIGHT_SMOKE").getModelPart().f_104207_ = true;
        }
        if (this.enabled == on) {
            return;
        }
        this.enabled = on;
        if (PlayerUtils.isClientPlayerCharacter(player)) {
            if (this.enabled) {
                this.sendInfo(1);
            } else {
                this.sendInfo(0);
            }
        }
    }

    @Override
    public void processInfo(Player player, int info) {
        boolean on = false;
        if (info == 1) {
            on = true;
        }
        if (!player.f_19853_.m_5776_()) {
            this.enabled = on;
        } else {
            this.enableJets(on, player);
        }
    }
}

