/*
 * Decompiled with CFR 0.152.
 */
package DaoOfModding.Cultivationcraft.Common.Qi.Techniques.BodyForgeTechniques;

import DaoOfModding.Cultivationcraft.Client.Physics;
import DaoOfModding.Cultivationcraft.Common.Capabilities.BodyModifications.BodyModifications;
import DaoOfModding.Cultivationcraft.Common.Capabilities.CultivatorStats.CultivatorStats;
import DaoOfModding.Cultivationcraft.Common.Qi.Elements.Elements;
import DaoOfModding.Cultivationcraft.Common.Qi.Stats.BodyPartStatControl;
import DaoOfModding.Cultivationcraft.Common.Qi.Stats.StatIDs;
import DaoOfModding.Cultivationcraft.Common.Qi.Techniques.Technique;
import DaoOfModding.Cultivationcraft.Common.Qi.Techniques.TechniqueStats.DefaultTechniqueStatIDs;
import DaoOfModding.Cultivationcraft.StaminaHandler;
import DaoOfModding.mlmanimator.Client.Poses.PlayerPose;
import DaoOfModding.mlmanimator.Client.Poses.PlayerPoseHandler;
import DaoOfModding.mlmanimator.Client.Poses.PoseHandler;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.TickEvent;

public class LeapTechnique
extends Technique {
    protected PlayerPose defaultLeapLegs = new PlayerPose();
    protected boolean leaping = false;

    public LeapTechnique() {
        this.langLocation = "cultivationcraft.technique.leap";
        this.Element = Elements.noElement;
        this.multiple = true;
        this.icon = new ResourceLocation("cultivationcraft", "textures/techniques/icons/leap.png");
        this.pose.addAngle("Body", new Vec3(Math.toRadians(90.0), 0.0, 0.0), 10);
        this.defaultLeapLegs.addAngle("RJL_LEFT_MODEL", new Vec3(Math.toRadians(0.0), Math.toRadians(0.0), 0.0), 203, Float.valueOf(1.0f), -1);
        this.defaultLeapLegs.addAngle("RJL_RIGHT_MODEL", new Vec3(Math.toRadians(0.0), Math.toRadians(0.0), 0.0), 203, Float.valueOf(1.0f), -1);
        this.defaultLeapLegs.addAngle("RJL_LEFT_LOWER_MODEL", new Vec3(Math.toRadians(0.0), Math.toRadians(0.0), 0.0), 203, Float.valueOf(1.0f), -1);
        this.defaultLeapLegs.addAngle("RJL_RIGHT_LOWER_MODEL", new Vec3(Math.toRadians(0.0), Math.toRadians(0.0), 0.0), 203, Float.valueOf(1.0f), -1);
        this.defaultLeapLegs.addAngle("RJL_LEFT_FOOT_MODEL", new Vec3(Math.toRadians(0.0), Math.toRadians(0.0), 0.0), 203, Float.valueOf(1.0f), -1);
        this.defaultLeapLegs.addAngle("RJL_RIGHT_FOOT_MODEL", new Vec3(Math.toRadians(0.0), Math.toRadians(0.0), 0.0), 203, Float.valueOf(1.0f), -1);
        this.defaultLeapLegs.disableHeadLook(false, 8);
        this.addTechniqueStat(DefaultTechniqueStatIDs.staminaCost, 0.5);
    }

    @Override
    public boolean isValid(Player player) {
        return CultivatorStats.getCultivatorStats(player).getCultivationType() == 1 && BodyModifications.getBodyModifications(player).hasModification("LEG", "rjleg");
    }

    @Override
    public void useKeyPressed(boolean keyDown, Player player) {
        if (this.active || this.leaping || !keyDown || !player.m_20096_() || player.m_20069_()) {
            return;
        }
        if (StaminaHandler.consumeStamina(player, (float)this.getTechniqueStat(DefaultTechniqueStatIDs.staminaCost, player))) {
            this.active = true;
        }
    }

    @Override
    public void tickServer(TickEvent.PlayerTickEvent event) {
        super.tickServer(event);
        this.continueTech(event);
    }

    @Override
    public void tickClient(TickEvent.PlayerTickEvent event) {
        super.tickClient(event);
        this.continueTechClient(event);
    }

    protected void continueTech(TickEvent.PlayerTickEvent event) {
        if (!this.leaping) {
            this.doLeap(event.player);
        } else {
            this.continueLeap(event.player);
        }
    }

    protected void continueTechClient(TickEvent.PlayerTickEvent event) {
        if (!this.leaping) {
            this.doLeapClient(event.player);
        } else {
            this.continueLeapClient(event.player);
        }
    }

    protected void continueLeap(Player player) {
        if (player.m_20096_() || player.m_20069_()) {
            this.active = false;
            this.leaping = false;
        }
    }

    protected void continueLeapClient(Player player) {
        PlayerPoseHandler handler = PoseHandler.getPlayerPoseHandler((UUID)player.m_20148_());
        if (player.m_20069_() || handler == null || !handler.isJumping()) {
            this.active = false;
            this.leaping = false;
        } else {
            Vec3 currentMotion = Physics.getDelta(player).m_82541_();
            PlayerPose newPose = this.defaultLeapLegs.clone();
            newPose.addAngle("Body", new Vec3(Math.toRadians((currentMotion.f_82480_ - 1.0) * -90.0), 0.0, 0.0), 10);
            this.pose = newPose;
        }
    }

    protected void doLeapClient(Player player) {
        this.leaping = true;
        player.m_6853_(false);
        PlayerPoseHandler handler = PoseHandler.getPlayerPoseHandler((UUID)player.m_20148_());
        if (handler == null || handler.isJumping()) {
            return;
        }
        handler.setJumping(true);
        Vec3 currentMotion = Physics.getDelta(player);
        Vec3 forward = player.m_20156_().m_82541_();
        float jumpPower = BodyPartStatControl.getStats(player).getStat(StatIDs.jumpHeight);
        player.m_20256_(currentMotion.m_82520_(forward.f_82479_ * (double)jumpPower * (double)0.4f, (double)0.52f, forward.f_82481_ * (double)jumpPower * (double)0.4f));
    }

    protected void doLeap(Player player) {
        StaminaHandler.consumeStamina(player, (float)this.getTechniqueStat(DefaultTechniqueStatIDs.staminaCost, player));
        this.leaping = true;
        player.m_6853_(false);
    }

    @Override
    public void readNBTData(CompoundTag nbt) {
        super.readNBTData(nbt);
        this.leaping = nbt.m_128471_("leaping");
    }

    @Override
    public CompoundTag writeNBT() {
        CompoundTag nbt = super.writeNBT();
        nbt.m_128379_("leaping", this.leaping);
        return nbt;
    }
}

