/*
 * Decompiled with CFR 0.152.
 */
package DaoOfModding.Cultivationcraft.Common.Qi.Techniques.BodyForgeTechniques;

import DaoOfModding.Cultivationcraft.Common.Capabilities.BodyModifications.BodyModifications;
import DaoOfModding.Cultivationcraft.Common.Capabilities.CultivatorStats.CultivatorStats;
import DaoOfModding.Cultivationcraft.Common.Qi.BodyParts.Quests.QuestHandler;
import DaoOfModding.Cultivationcraft.Common.Qi.Elements.Elements;
import DaoOfModding.Cultivationcraft.Common.Qi.Stats.BodyPartStatControl;
import DaoOfModding.Cultivationcraft.Common.Qi.Techniques.MovementOverrideTechnique;
import DaoOfModding.Cultivationcraft.Common.Qi.Techniques.Technique;
import DaoOfModding.Cultivationcraft.Common.Qi.Techniques.TechniqueStats.DefaultTechniqueStatIDs;
import DaoOfModding.Cultivationcraft.Common.Reflection;
import DaoOfModding.Cultivationcraft.StaminaHandler;
import DaoOfModding.mlmanimator.Client.Poses.PlayerPose;
import DaoOfModding.mlmanimator.Client.Poses.PoseHandler;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.TickEvent;

public class SpinPetalTechnique
extends MovementOverrideTechnique {
    protected boolean jumpPressed = false;
    protected Vec3 spinVector = new Vec3(0.0, 0.15, 0.0);
    protected PlayerPose spinUp = new PlayerPose();

    public SpinPetalTechnique() {
        this.elytraDisables = true;
        this.langLocation = "cultivationcraft.technique.spinpetal";
        this.Element = Elements.noElement;
        this.type = Technique.useType.Toggle;
        this.multiple = false;
        this.icon = new ResourceLocation("cultivationcraft", "textures/techniques/icons/spinpetal.png");
        this.spinUp.addAngle("HEAD_FLOWER_MODEL", new Vec3(0.0, Math.toRadians(91.0), 0.0), 5);
        this.spinUp.addAngle("HEAD_FLOWER_MODEL", new Vec3(0.0, Math.toRadians(1.0), 0.0), 5);
        this.spinUp.addAngle("HEAD_FLOWER_MODEL", new Vec3(0.0, Math.toRadians(-89.0), 0.0), 5);
        this.spinUp.addAngle("HEAD_FLOWER_MODEL", new Vec3(0.0, Math.toRadians(-179.0), 0.0), 5);
        this.addTechniqueStat(DefaultTechniqueStatIDs.staminaCost, 0.02f);
    }

    @Override
    public boolean isValid(Player player) {
        return CultivatorStats.getCultivatorStats(player).getCultivationType() == 1 && BodyModifications.getBodyModifications(player).hasOption("HEAD", "PETAL", "rotatingPetal");
    }

    @Override
    public void tickClient(TickEvent.PlayerTickEvent event) {
        super.tickClient(event);
        this.tickInactiveClient(event);
        if (this.jumpPressed) {
            this.spin(event.player);
        }
    }

    public void spin(Player player) {
        PoseHandler.addPose((UUID)player.m_20148_(), (PlayerPose)this.spinUp);
        player.m_20256_(player.m_20184_().m_82549_(this.spinVector.m_82490_((double)BodyPartStatControl.getPlayerStatControl(player).getFlightWeightModifier())));
        QuestHandler.progressQuest(player, player.m_20184_().m_82553_());
    }

    @Override
    public void tickServer(TickEvent.PlayerTickEvent event) {
        super.tickServer(event);
        this.tickInactiveServer(event);
        if (this.jumpPressed) {
            Reflection.allowFlight((ServerPlayer)event.player);
            event.player.f_19789_ = 0.0f;
            StaminaHandler.consumeStamina(event.player, (float)this.getTechniqueStat(DefaultTechniqueStatIDs.staminaCost, event.player));
        }
    }

    @Override
    public void onInput() {
        if (this.jumpPressed && !Minecraft.m_91087_().f_91066_.f_92089_.m_90857_()) {
            this.sendInfo(2);
            this.spinDown();
        }
    }

    protected void spinUp() {
        this.jumpPressed = true;
    }

    protected void spinDown() {
        this.jumpPressed = false;
    }

    @Override
    public void processInfo(Player player, int info) {
        if (info == 2) {
            this.spinDown();
        } else if (info == 1) {
            this.spinUp();
        }
    }

    @Override
    public boolean overwriteJump() {
        this.sendInfo(1);
        this.spinUp();
        return true;
    }
}

