/*
 * Decompiled with CFR 0.152.
 */
package DaoOfModding.Cultivationcraft.Common.Qi.Techniques.BodyForgeTechniques;

import DaoOfModding.Cultivationcraft.Client.Physics;
import DaoOfModding.Cultivationcraft.Client.genericClientFunctions;
import DaoOfModding.Cultivationcraft.Common.Capabilities.BodyModifications.BodyModifications;
import DaoOfModding.Cultivationcraft.Common.Capabilities.CultivatorStats.CultivatorStats;
import DaoOfModding.Cultivationcraft.Common.Qi.BodyParts.Quests.Quest;
import DaoOfModding.Cultivationcraft.Common.Qi.BodyParts.Quests.QuestHandler;
import DaoOfModding.Cultivationcraft.Common.Qi.Elements.Elements;
import DaoOfModding.Cultivationcraft.Common.Qi.Stats.BodyPartStatControl;
import DaoOfModding.Cultivationcraft.Common.Qi.Techniques.Technique;
import DaoOfModding.Cultivationcraft.Common.Qi.Techniques.TechniqueStats.DefaultTechniqueStatIDs;
import DaoOfModding.Cultivationcraft.Common.Reflection;
import DaoOfModding.Cultivationcraft.StaminaHandler;
import DaoOfModding.mlmanimator.Client.Poses.PlayerPose;
import DaoOfModding.mlmanimator.Client.Poses.PoseHandler;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.TickEvent;

public class SpreadTechnique
extends Technique {
    protected boolean jumpPressed = false;
    protected boolean groundCheck = false;
    protected PlayerPose flapUp = new PlayerPose();
    protected PlayerPose flapDown = new PlayerPose();
    protected PlayerPose inAir = new PlayerPose();

    public SpreadTechnique() {
        this.elytraDisables = true;
        this.langLocation = "cultivationcraft.technique.spread";
        this.Element = Elements.noElement;
        this.type = Technique.useType.Toggle;
        this.multiple = false;
        this.cooldown = 20;
        this.icon = new ResourceLocation("cultivationcraft", "textures/techniques/icons/wingspread.png");
        this.pose.addAngle("RIGHT_WING_UPPER_ARM_MODEL", new Vec3(Math.toRadians(45.0), Math.toRadians(-35.0), Math.toRadians(-25.0)), 1);
        this.pose.addAngle("LEFT_WING_UPPER_ARM_MODEL", new Vec3(Math.toRadians(45.0), Math.toRadians(35.0), Math.toRadians(25.0)), 1);
        this.pose.addAngle("RIGHT_WING_STRAND_1_MODEL", new Vec3(0.0, 0.0, Math.toRadians(-70.0)), 1);
        this.pose.addAngle("RIGHT_WING_STRAND_2_MODEL", new Vec3(0.0, 0.0, Math.toRadians(-20.0)), 1);
        this.pose.addAngle("RIGHT_WING_STRAND_3_MODEL", new Vec3(0.0, 0.0, Math.toRadians(20.0)), 1);
        this.pose.addAngle("RIGHT_WING_STRAND_4_MODEL", new Vec3(0.0, 0.0, Math.toRadians(60.0)), 1);
        this.pose.addAngle("LEFT_WING_STRAND_1_MODEL", new Vec3(0.0, 0.0, Math.toRadians(70.0)), 1);
        this.pose.addAngle("LEFT_WING_STRAND_2_MODEL", new Vec3(0.0, 0.0, Math.toRadians(20.0)), 1);
        this.pose.addAngle("LEFT_WING_STRAND_3_MODEL", new Vec3(0.0, 0.0, Math.toRadians(-20.0)), 1);
        this.pose.addAngle("LEFT_WING_STRAND_4_MODEL", new Vec3(0.0, 0.0, Math.toRadians(-60.0)), 1);
        this.flapUp.addAngle("RIGHT_WING_UPPER_ARM_MODEL", new Vec3(Math.toRadians(45.0), Math.toRadians(-75.0), Math.toRadians(-25.0)), 5, Float.valueOf(3.0f), -1);
        this.flapUp.addAngle("LEFT_WING_UPPER_ARM_MODEL", new Vec3(Math.toRadians(45.0), Math.toRadians(75.0), Math.toRadians(25.0)), 5, Float.valueOf(3.0f), -1);
        this.flapDown.addAngle("RIGHT_WING_UPPER_ARM_MODEL", new Vec3(Math.toRadians(45.0), Math.toRadians(0.0), Math.toRadians(-15.0)), 5);
        this.flapDown.addAngle("LEFT_WING_UPPER_ARM_MODEL", new Vec3(Math.toRadians(45.0), Math.toRadians(0.0), Math.toRadians(15.0)), 5);
        this.flapUp.addAngle("RIGHT_WING_STRAND_1_MODEL", new Vec3(Math.toRadians(-45.0), 0.0, Math.toRadians(-70.0)), 5);
        this.flapUp.addAngle("RIGHT_WING_STRAND_2_MODEL", new Vec3(Math.toRadians(-35.0), 0.0, Math.toRadians(-20.0)), 5);
        this.flapUp.addAngle("RIGHT_WING_STRAND_3_MODEL", new Vec3(Math.toRadians(-25.0), 0.0, Math.toRadians(20.0)), 5);
        this.flapUp.addAngle("RIGHT_WING_STRAND_4_MODEL", new Vec3(Math.toRadians(-15.0), 0.0, Math.toRadians(60.0)), 5);
        this.flapDown.addAngle("RIGHT_WING_STRAND_1_MODEL", new Vec3(Math.toRadians(-20.0), 0.0, Math.toRadians(-70.0)), 5);
        this.flapDown.addAngle("RIGHT_WING_STRAND_2_MODEL", new Vec3(Math.toRadians(-15.0), 0.0, Math.toRadians(-20.0)), 5);
        this.flapDown.addAngle("RIGHT_WING_STRAND_3_MODEL", new Vec3(Math.toRadians(-10.0), 0.0, Math.toRadians(20.0)), 5);
        this.flapDown.addAngle("RIGHT_WING_STRAND_4_MODEL", new Vec3(Math.toRadians(-5.0), 0.0, Math.toRadians(60.0)), 5);
        this.flapUp.addAngle("LEFT_WING_STRAND_1_MODEL", new Vec3(Math.toRadians(-45.0), 0.0, Math.toRadians(70.0)), 5);
        this.flapUp.addAngle("LEFT_WING_STRAND_2_MODEL", new Vec3(Math.toRadians(-35.0), 0.0, Math.toRadians(20.0)), 5);
        this.flapUp.addAngle("LEFT_WING_STRAND_3_MODEL", new Vec3(Math.toRadians(-25.0), 0.0, Math.toRadians(-20.0)), 5);
        this.flapUp.addAngle("LEFT_WING_STRAND_4_MODEL", new Vec3(Math.toRadians(-15.0), 0.0, Math.toRadians(-60.0)), 5);
        this.flapDown.addAngle("LEFT_WING_STRAND_1_MODEL", new Vec3(Math.toRadians(-20.0), 0.0, Math.toRadians(70.0)), 5);
        this.flapDown.addAngle("LEFT_WING_STRAND_2_MODEL", new Vec3(Math.toRadians(-15.0), 0.0, Math.toRadians(20.0)), 5);
        this.flapDown.addAngle("LEFT_WING_STRAND_3_MODEL", new Vec3(Math.toRadians(-10.0), 0.0, Math.toRadians(-20.0)), 5);
        this.flapDown.addAngle("LEFT_WING_STRAND_4_MODEL", new Vec3(Math.toRadians(-5.0), 0.0, Math.toRadians(-60.0)), 5);
        this.inAir.addAngle("Left_Arm", new Vec3(Math.toRadians(0.0), Math.toRadians(0.0), Math.toRadians(-30.0)), 11, Float.valueOf(5.0f), -1);
        this.inAir.addAngle("Right_Arm", new Vec3(Math.toRadians(0.0), Math.toRadians(0.0), Math.toRadians(30.0)), 11, Float.valueOf(5.0f), -1);
        this.inAir.addAngle("Body", new Vec3(Math.toRadians(30.0), Math.toRadians(0.0), Math.toRadians(0.0)), 11, Float.valueOf(5.0f), -1);
        this.addTechniqueStat(DefaultTechniqueStatIDs.staminaCost, 0.2);
    }

    @Override
    public boolean isValid(Player player) {
        return CultivatorStats.getCultivatorStats(player).getCultivationType() == 1 && BodyModifications.getBodyModifications(player).hasOption("BODY", "BACK", "wing");
    }

    @Override
    public void tickClient(TickEvent.PlayerTickEvent event) {
        super.tickClient(event);
        this.tickInactiveClient(event);
        if (event.player.m_20096_() || event.player.m_20069_()) {
            this.cooldownCount = 0;
            this.jumpPressed = false;
            this.groundCheck = false;
            return;
        }
        PoseHandler.addPose((UUID)event.player.m_20148_(), (PlayerPose)this.inAir);
        if ((double)this.cooldownCount > (double)this.cooldown * 0.5) {
            PoseHandler.addPose((UUID)event.player.m_20148_(), (PlayerPose)this.flapDown);
        } else if (this.jumpPressed && !this.groundCheck && this.cooldownCount == 0) {
            PoseHandler.addPose((UUID)event.player.m_20148_(), (PlayerPose)this.flapUp);
        }
        this.glide(event.player);
    }

    @Override
    public void tickServer(TickEvent.PlayerTickEvent event) {
        Reflection.allowFlight((ServerPlayer)event.player);
        super.tickServer(event);
        this.tickInactiveServer(event);
        event.player.f_19789_ = 0.0f;
    }

    @Override
    public void onInput() {
        if (Minecraft.m_91087_().f_91066_.f_92089_.m_90857_()) {
            if (!this.jumpPressed) {
                this.sendInfo(1);
            }
            this.flapUp(genericClientFunctions.getPlayer());
        } else if (this.jumpPressed) {
            this.sendInfo(2);
            this.jumpPressed = false;
            this.flapDown(genericClientFunctions.getPlayer());
        }
    }

    protected void flapUp(Player player) {
        if (player.m_20096_() || player.m_20069_()) {
            this.groundCheck = true;
        }
        this.jumpPressed = true;
    }

    protected void flapDown(Player player) {
        if (this.groundCheck) {
            this.groundCheck = false;
        } else if (!player.m_20096_() && this.cooldownCount == 0 && StaminaHandler.consumeStamina(player, (float)this.getTechniqueStat(DefaultTechniqueStatIDs.staminaCost, player))) {
            this.cooldownCount = this.cooldown;
        }
    }

    @Override
    public void processInfo(Player player, int info) {
        if (info == 2) {
            this.flapDown(player);
        } else if (info == 1) {
            this.flapUp(player);
        }
    }

    protected void glide(Player player) {
        player.f_19789_ = 0.0f;
        Vec3 motion = Physics.getDelta(player);
        float weightModifier = BodyPartStatControl.getPlayerStatControl(player).getFlightWeightModifier();
        float maxFallSpeed = -0.4f * (1.0f / weightModifier);
        float FlapSpeed = 0.4f * weightModifier;
        if (motion.f_82480_ < (double)maxFallSpeed) {
            player.m_20334_(motion.f_82479_, (double)maxFallSpeed, motion.f_82481_);
        }
        Vec3 dir = player.m_20154_();
        dir.m_82559_(new Vec3(1.0, 0.0, 1.0));
        dir.m_82541_();
        if (this.cooldownCount > this.cooldown / 2) {
            double xMotion = motion.f_82479_ + (double)(FlapSpeed / 4.0f) * dir.f_82479_;
            double zMotion = motion.f_82481_ + (double)(FlapSpeed / 4.0f) * dir.f_82481_;
            double upMotion = motion.f_82480_ > (double)FlapSpeed ? motion.f_82480_ : (motion.f_82480_ > 0.0 ? (double)FlapSpeed : motion.f_82480_ + (double)FlapSpeed);
            player.m_20334_(xMotion, upMotion, zMotion);
        }
        QuestHandler.progressQuest(player, Quest.FLIGHT, new Vec3(player.m_20184_().f_82479_, 0.0, player.m_20184_().f_82481_).m_82553_());
    }
}

