/*
 * Decompiled with CFR 0.152.
 */
package DaoOfModding.Cultivationcraft.Common.Qi.Techniques;

import DaoOfModding.Cultivationcraft.Client.CultivatorAttackLogicClient;
import DaoOfModding.Cultivationcraft.Common.Qi.CultivatorControl;
import DaoOfModding.Cultivationcraft.Common.Qi.Techniques.AttackTechnique;
import DaoOfModding.Cultivationcraft.Common.Qi.Techniques.Technique;
import DaoOfModding.Cultivationcraft.Network.ClientPacketHandler;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.TickEvent;

public class ChanneledAttackTechnique
extends AttackTechnique {
    protected float ticksSinceHit = 0.0f;
    protected Entity targetEntity = null;
    protected BlockPos target = null;
    protected float progress = 0.0f;
    protected boolean destroyed = false;
    float hitInterval = 10.0f;

    public ChanneledAttackTechnique() {
        this.type = Technique.useType.Channel;
    }

    @Override
    public void tickClient(TickEvent.PlayerTickEvent event) {
        BlockHitResult result;
        super.tickClient(event);
        this.attack(event.player, CultivatorControl.getTechnique(event.player, this));
        if (this.targetEntity == null && (result = CultivatorAttackLogicClient.tryAttackBlock(this.getRange(event.player))) != null) {
            this.mine(event.player, result.m_82425_(), result.m_82434_());
        }
    }

    @Override
    public void deactivate(Player player) {
        super.deactivate(player);
        if (player.f_19853_.f_46443_) {
            this.unmine(player);
        }
        this.targetEntity = null;
    }

    @Override
    public void attack(Player player, int slot) {
        this.targetEntity = CultivatorAttackLogicClient.tryAttackEntity(this.getRange(player));
        if (this.targetEntity == null) {
            return;
        }
        if (this.ticksSinceHit == 0.0f) {
            ClientPacketHandler.sendAttackToServer(player.m_20148_(), HitResult.Type.ENTITY, this.targetEntity.m_20182_(), this.targetEntity.m_20148_(), null, slot);
        } else {
            this.ticksSinceHit = (this.ticksSinceHit + 1.0f) % this.hitInterval;
        }
        this.target = null;
        this.unmine(player);
    }

    @Override
    public void attackEntity(Player player, Entity toAttack) {
        super.attackEntity(player, toAttack);
        this.ticksSinceHit = this.hitInterval * 1.25f;
    }

    public void attackBlock(Player player, BlockState block, BlockPos pos) {
        player.f_19853_.m_46961_(pos, true);
    }

    protected void mine(Player player, BlockPos pos, Direction direction) {
        if (this.target == null || pos == null || pos.compareTo((Vec3i)this.target) != 0) {
            this.progress = 0.0f;
            this.destroyed = false;
        }
        this.target = pos;
        if (this.target == null) {
            this.unmine(player);
            return;
        }
        float destroySpeed = player.f_19853_.m_8055_(pos).m_60800_((BlockGetter)player.f_19853_, pos);
        if (destroySpeed == -1.0f) {
            this.progress = 0.0f;
            return;
        }
        this.progress += this.getMinePower((BlockGetter)player.f_19853_, this.target) / destroySpeed / 3.0f;
        if (this.progress < 10.0f) {
            player.f_19853_.m_6801_(player.m_19879_(), pos, (int)this.progress);
        } else if (this.destroyed) {
            player.f_19853_.m_6801_(player.m_19879_(), pos, 9);
        } else if (player.f_19853_.f_46443_) {
            ClientPacketHandler.sendAttackToServer(player.m_20148_(), HitResult.Type.BLOCK, new Vec3((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_()), player.m_20148_(), direction, CultivatorControl.getTechnique(player, this));
        }
    }

    protected void unmine(Player player) {
        player.f_19853_.m_6801_(player.m_19879_(), null, -1);
        this.target = null;
    }
}

