/*
 * Decompiled with CFR 0.152.
 */
package DaoOfModding.Cultivationcraft.Common.Qi.Techniques;

import DaoOfModding.Cultivationcraft.Client.Renderer;
import DaoOfModding.Cultivationcraft.Common.Capabilities.BodyModifications.BodyModifications;
import DaoOfModding.Cultivationcraft.Common.Capabilities.BodyModifications.IBodyModifications;
import DaoOfModding.Cultivationcraft.Common.Capabilities.CultivatorStats.CultivatorStats;
import DaoOfModding.Cultivationcraft.Common.Capabilities.CultivatorStats.ICultivatorStats;
import DaoOfModding.Cultivationcraft.Common.PlayerUtils;
import DaoOfModding.Cultivationcraft.Common.Qi.BodyParts.BodyPartNames;
import DaoOfModding.Cultivationcraft.Common.Qi.BodyParts.BodyPartOption;
import DaoOfModding.Cultivationcraft.Common.Qi.Elements.Elements;
import DaoOfModding.Cultivationcraft.Common.Qi.Stats.StatIDs;
import DaoOfModding.Cultivationcraft.Common.Qi.Techniques.Technique;
import DaoOfModding.Cultivationcraft.Common.Qi.Techniques.TechniqueStats.DefaultTechniqueStatIDs;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.event.TickEvent;

public class DivineSenseTechnique
extends Technique {
    public DivineSenseTechnique() {
        this.langLocation = "cultivationcraft.technique.divinesense";
        this.Element = Elements.noElement;
        this.type = Technique.useType.Toggle;
        this.multiple = false;
        this.icon = new ResourceLocation("cultivationcraft", "textures/techniques/icons/divinesense.png");
        this.stats.setStat(StatIDs.staminaDrain, 0.05f);
        this.addTechniqueStat(DefaultTechniqueStatIDs.qiCost, 1.0);
        this.effects.add(MobEffects.f_19611_);
    }

    @Override
    public void tickClient(TickEvent.PlayerTickEvent event) {
        if (PlayerUtils.isClientPlayerCharacter(event.player)) {
            Renderer.QiSourcesVisible = true;
        }
        if (event.player.m_36324_().m_38702_() == 0) {
            this.deactivate(event.player);
        }
    }

    @Override
    public void tickServer(TickEvent.PlayerTickEvent event) {
        super.tickServer(event);
        if (CultivatorStats.getCultivatorStats(event.player).getCultivationType() == 0) {
            if (!CultivatorStats.getCultivatorStats(event.player).getCultivation().consumeQi(event.player, this.getTechniqueStat(DefaultTechniqueStatIDs.qiCost, event.player) / 20.0)) {
                this.deactivate(event.player);
            }
        } else if (event.player.m_36324_().m_38702_() == 0) {
            this.deactivate(event.player);
        }
    }

    @Override
    public void deactivate(Player player) {
        super.deactivate(player);
        if (PlayerUtils.isClientPlayerCharacter(player)) {
            Renderer.QiSourcesVisible = false;
        }
    }

    @Override
    public boolean isValid(Player player) {
        ICultivatorStats stats = CultivatorStats.getCultivatorStats(player);
        if (stats.getCultivationType() == 1) {
            BodyPartOption eyes;
            IBodyModifications modifications = BodyModifications.getBodyModifications(player);
            if (!modifications.hasOption((eyes = BodyPartNames.getOption("qisight")).getPosition(), eyes.getSubPosition())) {
                return false;
            }
            if (modifications.getOption(eyes.getPosition(), eyes.getSubPosition()) == eyes) {
                return true;
            }
        } else if (stats.getCultivationType() == 0) {
            return true;
        }
        return false;
    }
}

