/*
 * Decompiled with CFR 0.152.
 */
package DaoOfModding.Cultivationcraft.Common.Qi.Techniques;

import DaoOfModding.Cultivationcraft.Client.Animations.GenericQiPoses;
import DaoOfModding.Cultivationcraft.Common.Capabilities.BodyModifications.BodyModifications;
import DaoOfModding.Cultivationcraft.Common.Capabilities.BodyModifications.IBodyModifications;
import DaoOfModding.Cultivationcraft.Common.Capabilities.ChunkQiSources.ChunkQiSources;
import DaoOfModding.Cultivationcraft.Common.Capabilities.CultivatorStats.CultivatorStats;
import DaoOfModding.Cultivationcraft.Common.Capabilities.CultivatorStats.ICultivatorStats;
import DaoOfModding.Cultivationcraft.Common.Qi.BodyParts.BodyPartNames;
import DaoOfModding.Cultivationcraft.Common.Qi.BodyParts.FoodStats.QiFoodStats;
import DaoOfModding.Cultivationcraft.Common.Qi.BodyParts.PlayerHealthManager;
import DaoOfModding.Cultivationcraft.Common.Qi.BodyParts.Quests.Quest;
import DaoOfModding.Cultivationcraft.Common.Qi.BodyParts.Quests.QuestHandler;
import DaoOfModding.Cultivationcraft.Common.Qi.Cultivation.CultivationType;
import DaoOfModding.Cultivationcraft.Common.Qi.Elements.Elements;
import DaoOfModding.Cultivationcraft.Common.Qi.QiSource;
import DaoOfModding.Cultivationcraft.Common.Qi.Stats.BodyPartStatControl;
import DaoOfModding.Cultivationcraft.Common.Qi.Stats.StatIDs;
import DaoOfModding.Cultivationcraft.Common.Qi.Techniques.MovementOverrideTechnique;
import DaoOfModding.Cultivationcraft.Common.Qi.Techniques.Technique;
import DaoOfModding.Cultivationcraft.Common.Qi.Techniques.TechniqueStats.DefaultCultivationStatIDs;
import DaoOfModding.Cultivationcraft.Network.PacketHandler;
import DaoOfModding.Cultivationcraft.Server.BodyPartControl;
import DaoOfModding.Cultivationcraft.debug;
import java.util.List;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.event.TickEvent;

public class MeditateTechnique
extends MovementOverrideTechnique {
    public MeditateTechnique() {
        this.langLocation = "cultivationcraft.technique.meditate";
        this.Element = Elements.noElement;
        this.type = Technique.useType.Toggle;
        this.multiple = false;
        this.icon = new ResourceLocation("cultivationcraft", "textures/techniques/icons/meditate.png");
        this.pose = GenericQiPoses.CrossLegs.clone();
        this.stopMovement = true;
        this.setLegAnimationLockOffWhileActive(20);
    }

    @Override
    public void tickServer(TickEvent.PlayerTickEvent event) {
        this.increaseProgress(event);
        BodyPartControl.checkForgeProgress(event.player);
        super.tickServer(event);
    }

    @Override
    public void tickClient(TickEvent.PlayerTickEvent event) {
        super.tickClient(event);
    }

    protected void increaseProgress(TickEvent.PlayerTickEvent event) {
        ICultivatorStats stats = CultivatorStats.getCultivatorStats(event.player);
        if (stats.getCultivationType() == 0) {
            CultivationType cultivation = stats.getCultivation();
            List<QiSource> sources = ChunkQiSources.getQiSourcesInRange(event.player.f_19853_, event.player.m_20182_(), (int)cultivation.getCultivationStat(event.player, DefaultCultivationStatIDs.qiAbsorbRange));
            double remaining = cultivation.getCultivationStat(event.player, DefaultCultivationStatIDs.qiAbsorbSpeed) / 20.0;
            remaining = PlayerHealthManager.getBlood(event.player).meditation(remaining, sources, event.player);
            if (event.player.m_36324_() instanceof QiFoodStats) {
                remaining = ((QiFoodStats)event.player.m_36324_()).meditation(remaining, event.player);
            }
            for (QiSource source : sources) {
                remaining -= (double)cultivation.progressCultivation(event.player, (float)remaining, source.getElement());
            }
            if (event.player.m_36324_().m_38702_() == ((QiFoodStats)event.player.m_36324_()).getMaxFood()) {
                cultivation.progressCultivation(event.player, (float)cultivation.getCultivationStat(event.player, DefaultCultivationStatIDs.qiPassiveAbsorbSpeed) / 20.0f, Elements.anyElement);
            }
            PacketHandler.sendCultivatorStatsToClient(event.player);
        } else if (stats.getCultivationType() == 1) {
            List<QiSource> sources = ChunkQiSources.getQiSourcesInRange(event.player.f_19853_, event.player.m_20182_(), (int)BodyPartStatControl.getPlayerStatControl(event.player).getStats().getStat(StatIDs.qiAbsorbRange));
            if (sources.size() > 0) {
                QuestHandler.progressQuest(event.player, Quest.QI_SOURCE_MEDITATION, 0.05);
            }
            double remaining = (int)BodyPartStatControl.getPlayerStatControl(event.player).getStats().getStat(StatIDs.qiAbsorb);
            remaining = PlayerHealthManager.getBlood(event.player).meditation(remaining, sources, event.player);
            IBodyModifications modifications = BodyModifications.getBodyModifications(event.player);
            if (modifications.getSelection().compareTo("") != 0) {
                ResourceLocation element = BodyPartNames.getPartOrOption(modifications.getSelection()).getElement();
                int toAdd = 0;
                if (element == null || event.player.m_7500_()) {
                    toAdd = QiSource.getDefaultQi();
                }
                for (QiSource source : sources) {
                    if (element != null && element.compareTo(source.getElement()) != 0 || !(remaining > 0.0)) continue;
                    double absorbed = source.absorbQi(remaining, event.player);
                    remaining -= absorbed;
                    toAdd = (int)((double)toAdd + absorbed);
                }
                toAdd = (int)((float)toAdd * debug.qiCollectingSpeed);
                modifications.addProgress(toAdd);
                PacketHandler.sendBodyModificationsToClient(event.player);
            }
        }
    }

    @Override
    public boolean isValid(Player player) {
        ICultivatorStats stats = CultivatorStats.getCultivatorStats(player);
        return stats.getCultivationType() == 1 || stats.getCultivationType() == 0;
    }
}

